/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class LogWatcher
extends Thread {
    private volatile boolean keepRunning = true;
    private final Path storageLocation;
    private final Path logFile;
    private final FSILogger logger;

    public LogWatcher(RequestProcessorSettings settings) {
        this.logger = settings.getFSILogger();
        this.storageLocation = settings.getStorageLocation();
        this.setPriority(1);
        this.setName("PoolLogWatcher");
        this.setDaemon(true);
        this.logFile = this.storageLocation.resolve(".log").resolve("log");
    }

    private boolean waitForLogfileToAppear() throws InterruptedException {
        boolean isNewFile = false;
        while (Files.notExists(this.logFile, new LinkOption[0])) {
            isNewFile = true;
            LogWatcher.sleep(1000L);
        }
        return isNewFile;
    }

    @Override
    public void run() {
        try {
            boolean isNewFile = this.waitForLogfileToAppear();
            try (BufferedReader input = Files.newBufferedReader(this.logFile, FileOperations.charsetUTF8);){
                if (!isNewFile) {
                    this.skipExistingEntries(input);
                }
                while (this.keepRunning) {
                    try {
                        String line = input.readLine();
                        if (line != null) {
                            this.processEntry(line);
                            continue;
                        }
                        LogWatcher.sleep(10L);
                    }
                    catch (IOException e) {
                        this.logger.log(3242, this.logFile, e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                this.keepRunning = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void skipExistingEntries(BufferedReader input) {
        try {
            String line;
            while ((line = input.readLine()) != null) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processEntry(String entry) {
    }

    public Path getStorageLocation() {
        return this.storageLocation;
    }

    public void halt() {
        this.keepRunning = false;
        this.interrupt();
    }
}

