/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.URLDecoderFast;
import com.neptunelabs.fsiframework.helpers.deletepool.DeletePool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.licensing.LicenceManager;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.JavaInformation;
import com.neptunelabs.fsiframework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiframework.systeminformation.VMVendor;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.MetaDataSource;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.GIFCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.JPEGCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.PNGCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.SWFCompressor;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.StaticFileRequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.processors.DefaultSearchProcessor;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.processors.SimpleSearchProcessor;
import com.neptunelabs.fsiserver.sourcemanager.guru.GuruMeditationHook;
import com.neptunelabs.fsiserver.utils.ETag;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import com.neptunelabs.fsiservletframework.ExtendedServlet;
import com.neptunelabs.fsiservletframework.HTTPDisposition;
import com.neptunelabs.fsiservletframework.UncaughtExceptionLogger;
import com.neptunelabs.fsiservletframework.freemarker.TemplateCache;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.prerequisites.JavaEEServer;
import com.neptunelabs.fsiservletframework.prerequisites.Prerequisites;
import com.neptunelabs.fsiservletframework.utils.MockHttpServletRequest;
import com.neptunelabs.fsiservletframework.utils.MockHttpServletResponse;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletOutputStreamWrapper;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.imagemanipulator.area.CheckerMatte;
import com.neptunelabs.imagemanipulator.area.FSIServerWatermark;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.image.FSIImage;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@WebServlet(name="RequestProcessor", loadOnStartup=4, urlPatterns={"/server", "/static/*"}, initParams={@WebInitParam(name="autorestart", value="true")})
public final class MainProcessor
extends HttpServlet
implements ExtendedServlet {
    private static final long serialVersionUID = 680864902360939021L;
    private static final int CHUNKLENGTH = 8192;
    private final SystemInformation sysinfo = new SystemInformation();
    private long startTime;
    private final AtomicInteger currentPriority = new AtomicInteger(0);
    private final AtomicInteger concurrentProcessing = new AtomicInteger(0);
    private ServletContext servletContext = null;
    private RequestProcessorSettings settings;
    private ExecutorPool executorPool;
    private boolean usesOwnExecutorPool = false;
    private boolean servletInitError;
    private String servletInitErrorMessage;
    private boolean servletInitWarning;
    private String servletInitWarningMessage;
    private UncaughtExceptionLogger uncaughtExceptionLogger;
    private String servletStatus;
    private SystemMonitor systemMonitor = null;
    private int prereqErrorCode = 0;
    private volatile boolean acceptRequests = false;
    private Map<Parameters.Type, SearchProcessor> searchprocessors;
    private DeletePool deletePool = null;
    private ServletFileEventCursor fileEventCursor;
    private SwapPool swapPool;
    private final Map<OutputFormat, OutputCompressor> outputCompressors = new HashMap<OutputFormat, OutputCompressor>();
    private StaticFileRequestHandler staticFileRequestHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletStatus = "initializing";
        this.startTime = 0L;
        this.servletInitError = false;
        this.servletInitErrorMessage = "";
        this.servletInitWarning = false;
        this.servletInitWarningMessage = "";
        this.uncaughtExceptionLogger = new GuruMeditationHook((GenericServlet)this);
        try {
            this.servletContext = config.getServletContext();
            Path configHome = this.setupConfigHome();
            FSILogger mainLogger = this.initMainLogger(configHome);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor", (Object)this);
            String javaVersion = this.sysinfo.getJVMVersionDetailed();
            javaVersion = this.sysinfo.is64() ? javaVersion + " 64 Bit" : javaVersion + " 32 Bit";
            mainLogger.log(2001, SoftwareVersion.getSoftware(true), this.servletContext.getServerInfo(), javaVersion);
            mainLogger.log(2935, "Vendor", this.sysinfo.getJVMInformation());
            JavaInformation ji = new JavaInformation();
            List<String> aList = ji.getStartOptions();
            StringBuilder jvmSb = new StringBuilder();
            for (int i = 0; i < aList.size(); ++i) {
                jvmSb.append(aList.get(i));
                if (i >= aList.size() - 1) continue;
                jvmSb.append(' ');
            }
            mainLogger.log(2935, "Start Options", jvmSb.toString());
            MemoryManager memManager = MemoryManager.getInstance();
            long maxYoungGen = memManager.getMaxYoungGen();
            if (maxYoungGen > 0L) {
                mainLogger.log(2935, "Max Old/Young Gen", FormatBytes.byteToString(memManager.getMaxOldGen(), 3, 1) + "/" + FormatBytes.byteToString(memManager.getMaxYoungGen(), 3, 1));
            } else {
                mainLogger.log(2935, "Max Old Gen", FormatBytes.byteToString(memManager.getMaxOldGen(), 3, 1));
            }
            if (memManager.usesG1GC()) {
                mainLogger.log(2935, "Using G1", "true");
            }
            mainLogger.log(2935, "Encoding", this.sysinfo.getFileEncoding() + "/" + this.sysinfo.getJNUEncoding());
            Object lh = this.servletContext.getAttribute("com.neptunelabs.fsiserver.utils.FileLockHandler");
            boolean useOwnLockHandler = lh == null;
            IOController ioController = null;
            Object ioc = this.servletContext.getAttribute("IOController");
            ioController = ioc != null ? (IOController)ioc : new IOController();
            Object fecObj = this.servletContext.getAttribute("fileEventCursor");
            if (fecObj != null) {
                this.fileEventCursor = (ServletFileEventCursor)fecObj;
            } else {
                this.fileEventCursor = new ServletFileEventCursor(mainLogger);
                this.fileEventCursor.start();
            }
            this.settings = new RequestProcessorSettings(this, mainLogger, useOwnLockHandler, this.fileEventCursor);
            this.settings.setIOController(ioController);
            this.settings.addRestartableServlet(this);
            this.servletContext.setAttribute("fsiSoftwareID", (Object)SoftwareVersion.getSoftwareID());
            this.settings.evalutateSettings();
            if (this.settings.hasSectionEnabled("application")) {
                if (this.checkPrerequisites(config, mainLogger)) {
                    this.initRenderersMonitor();
                    this.start();
                } else {
                    this.destroy();
                }
            } else {
                this.settings.getFSILogger().log(2006, new Object[0]);
                this.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.uncaughtExceptionLogger.uncaughtException(null, e);
        }
    }

    private boolean checkPrerequisites(ServletConfig config, FSILogger mainLogger) {
        Prerequisites prerequisites = new Prerequisites(this.settings.getFSILogger(), config.getServletContext(), this.settings.getSystemInformation(), true);
        if (!mainLogger.hasNeLaDebug()) {
            prerequisites.setDisallow32bit(Prerequisites.Type.WARN, true);
            prerequisites.setThreadSettings(Prerequisites.Type.WARN, 4, -1);
            prerequisites.setServletAPIVersion(Prerequisites.Type.ERROR, 3.0, 3.1);
            prerequisites.setCheckMissingAllowEncodedSlash(Prerequisites.Type.WARN, true);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.ERROR, 0x10000000L);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.WARN, 0x40000000L);
            prerequisites.setCheckLogHome(Prerequisites.Type.ERROR, true);
            prerequisites.setAllowSecureMode(Prerequisites.Type.ERROR, false);
            prerequisites.setAllowedFileEncoding(Prerequisites.Type.WARN, FileOperations.charsetUTF8);
            prerequisites.addPositiveJavaServletContainer(JavaEEServer.Tomcat, "7.0.6", "9.0.0");
            prerequisites.addPositiveJavaServletContainer(JavaEEServer.GlassFish, "3.0.0", "5.0.0");
            prerequisites.addErrorJavaServletContainer(JavaEEServer.Websphere);
            prerequisites.addPositiveVMVendor(VMVendor.Sun, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.Apple, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.Oracle, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.OpenJDK, "1.7.0_0", "1.9.0_0");
            prerequisites.addErrorVMVendor(VMVendor.IBM, null, null);
            prerequisites.addErrorVMVendor(VMVendor.JRockit, null, null);
            prerequisites.addErrorVMVendor(VMVendor.OpenJDK, "1.7.0_21", "1.7.0_40");
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2003);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2008);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2012);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows7);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows8);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows10);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.WindowsVista);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Linux);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.MacOSX);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Solaris);
        }
        if (!mainLogger.hasNeLaDebug()) {
            int warnCode = prerequisites.check(Prerequisites.Type.WARN);
            if (warnCode != 0) {
                mainLogger.log(2009, warnCode);
                this.servletInitWarning = true;
            }
            this.prereqErrorCode = prerequisites.check(Prerequisites.Type.ERROR);
        }
        if (this.prereqErrorCode != 0) {
            this.servletInitErrorMessage = "Minimum System Requirements not accomplished (" + this.prereqErrorCode + "). Please check the server log.";
            mainLogger.log(2008, this.prereqErrorCode);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.startError", (Object)this.servletInitErrorMessage);
            this.servletStatus = "stopped";
            this.servletInitError = true;
            return false;
        }
        return true;
    }

    private FSILogger initMainLogger(Path configHome) {
        FSILogger mainLogger = new FSILogger(configHome, "RequestProcessor", "com/neptunelabs/fsiserver/resources/log4j_codes.properties", "log4j");
        mainLogger.addCodes("com/neptunelabs/fsiframework/resources/log4j_codes.properties");
        mainLogger.addCodes("com/neptunelabs/fsiservletframework/resources/log4j_codes.properties");
        mainLogger.addCodes("com/neptunelabs/imagereader/resources/log4j_codes.properties");
        mainLogger.addCodes("com/neptunelabs/imagemanipulator/resources/log4j_codes.properties");
        mainLogger.start();
        this.uncaughtExceptionLogger.setLogger(mainLogger);
        return mainLogger;
    }

    private Path setupConfigHome() {
        String configHomeStr = System.getProperty("com.neptunelabs.fsiserver.config.home");
        Path configHome = configHomeStr == null ? ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("config") : Paths.get(configHomeStr, new String[0]);
        this.servletContext.setAttribute("com.neptunelabs.fsiserver.config.home", (Object)configHome);
        return configHome;
    }

    private Renderer determineRenderer(Parameters parameters, HttpServletResponse resp) throws ServletException, IOException {
        String rendererName;
        Renderer result = null;
        String string = rendererName = parameters.contains(Parameters.General.renderer) ? parameters.get(Parameters.General.renderer) : this.settings.getPrefsString("limits", "defaultrenderer");
        if (!this.settings.hasEnabledRenderer(rendererName)) {
            if (parameters.contains(Parameters.General.renderer)) {
                this.sendInvalidParameterValueResponse(resp, "renderer", parameters.get(Parameters.General.renderer));
            } else {
                this.sendInternalServerErrorResponse(resp, "Configuration Error: Missing default renderer");
            }
        } else {
            if (rendererName.equals("_private") && parameters.contains(Parameters.FileImage.cmd)) {
                rendererName = "_licence";
            }
            result = this.settings.getEnabledRenderer(rendererName);
        }
        return result;
    }

    private boolean checkRendererProtection(RendererAbstract renderer, String assetURLPath, HttpSession session) throws NotConfiguredException {
        Set<String> allowedGroups;
        if (renderer != null && (allowedGroups = renderer.getAllowedGroups()) != null) {
            if (allowedGroups.contains("public")) {
                return true;
            }
            if (session == null) {
                return false;
            }
            UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
            String sessionid = (String)session.getAttribute("id");
            Set<String> groupnames = uai.getGroupNamesForUser(uai.getUser(sessionid));
            for (String groupname : groupnames) {
                if (!allowedGroups.contains(groupname)) continue;
                return true;
            }
        }
        return false;
    }

    private String getCopyrightNoticeForAsset(String assetURLPath) {
        String copyrightNotice = null;
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        if (connector != null) {
            copyrightNotice = connector.getImageCopyright();
        }
        if (copyrightNotice == null || copyrightNotice.trim().length() == 0) {
            copyrightNotice = this.settings.getImageCopyright();
        }
        return copyrightNotice;
    }

    private void handleImageRequest(HttpServletRequest req, CacheableHttpServletResponse hsrc, int priority) throws ServletException, IOException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        long t0 = System.currentTimeMillis();
        Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)hsrc);
        if (renderer == null) {
            return;
        }
        try {
            if (!this.checkRendererProtection(renderer.getImageRenderer(), assetURLPath, req.getSession(false))) {
                hsrc.setStatus(403);
                hsrc.setCachable(false);
                return;
            }
        }
        catch (NotConfiguredException e) {
            hsrc.setCachable(false);
            hsrc.sendError(503, e.getLocalizedMessage());
            return;
        }
        RendererAbstract imageRenderer = renderer.getImageRenderer();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Set<String> requiredMetaData = imageRenderer.getRequiredMetaData();
        List<MetaDataSource> metadatasources = renderer.getMetaDataSources();
        for (MetaDataSource mds : metadatasources) {
            Map<String, Object> md = mds.getMetaData(assetURLPath, requiredMetaData);
            for (Map.Entry<String, Object> e : md.entrySet()) {
                metadata.put(e.getKey(), e.getValue());
            }
        }
        if (!this.isMetadataComplete(requiredMetaData, metadata)) {
            this.sendIncompleteMetaDataResponse((HttpServletResponse)hsrc);
            hsrc.setCachable(false);
            this.settings.getFSILogger().log(4001, req.getMethod() + " " + req.getRequestURI());
            return;
        }
        try {
            RendererResponse rr = imageRenderer.processRequest(priority, req, metadata);
            hsrc.setCachable(rr.isCacheable());
            hsrc.setPixels(rr.getPixels());
            long t1 = System.currentTimeMillis();
            int status = rr.getStatus();
            if (status >= 200 && status < 300) {
                hsrc.setStatus(status);
            } else {
                hsrc.setStatus(status, rr.getStatusMessage());
            }
            this.transferRendererResponseHeaders(hsrc, rr);
            long lastModified = rr.getDateHeader("Last-Modified");
            hsrc.setLastModified(lastModified);
            this.setPredefinedResponseHeaders(req, hsrc, "image.default");
            if (status >= 200 && status < 300) {
                if (rr instanceof RendererImageResponse) {
                    OutputCompressorResponse ocr;
                    long t3;
                    FSIImage[] renderMatte;
                    FSIServerSettings.LicenceState ls;
                    long t2;
                    boolean supportAlpha = false;
                    OutputFormat compressorType = this.getOutputFormat(parameters, renderer);
                    if (compressorType == OutputFormat.PNG || compressorType == OutputFormat.SWF || compressorType == OutputFormat.GIF) {
                        supportAlpha = true;
                    }
                    RendererImageResponse rir = (RendererImageResponse)rr;
                    OutputCompressor oc = this.outputCompressors.get((Object)compressorType);
                    String copyrightNotice = this.getCopyrightNoticeForAsset(assetURLPath);
                    if (rir.isMultiImageResponse() && oc.hasMultiImageSupport()) {
                        FSIImage[] images = rir.getImageList();
                        t2 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            images = this.applyRendererEffects(priority, images, rir.getSelectionsRaws(), renderer.getOutputEffects(), parameters);
                            hsrc.getETag().addModifier(renderer.getOutputEffectsChecksum());
                        }
                        if (parameters.contains(Parameters.GeneralImage.effects)) {
                            images = this.applyQueryEffects(priority, images, rir.getSelectionsRaws(), parameters, parameters.get(Parameters.GeneralImage.effects));
                        }
                        if ((ls = this.settings.isLicensed()) != FSIServerSettings.LicenceState.VALID && !rr.isLicenceImage()) {
                            FSIImage[] fSIImageArray = images;
                            int n = fSIImageArray.length;
                            for (int i = 0; i < n; ++i) {
                                FSIImage image = fSIImageArray[i];
                                FSIServerWatermark.transform(image, this.settings.getWatermarkBytes());
                            }
                            this.setLicenceCommentHeader(hsrc, ls);
                            hsrc.getETag().addModifier("unlic");
                        } else {
                            hsrc.getETag().addModifier("lic");
                        }
                        if (!supportAlpha) {
                            renderMatte = new CheckerMatte(this.settings.getFSILogger(), this.executorPool, priority);
                            for (int i = 0; i < images.length; ++i) {
                                if (!images[i].hasAlpha()) continue;
                                images[i] = renderMatte.transform(images[i], 8, 0xC8C8C8, 0xFFFFFF, false);
                            }
                        }
                        t3 = System.currentTimeMillis();
                        ocr = oc.compressImageData(priority, images, renderer, parameters, copyrightNotice);
                        for (FSIImage image : images) {
                            image.dispose();
                        }
                    } else {
                        FSIImage body = rir.getImage();
                        t2 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            body = this.applyRendererEffects(priority, body, rir.getSelectionsRaw(), renderer.getOutputEffects(), parameters);
                        }
                        if (parameters.contains(Parameters.GeneralImage.effects)) {
                            body = this.applyQueryEffects(priority, body, rir.getSelectionsRaw(), parameters, parameters.get(Parameters.GeneralImage.effects));
                        }
                        if ((ls = this.settings.isLicensed()) != FSIServerSettings.LicenceState.VALID && !rr.isLicenceImage()) {
                            FSIServerWatermark.transform(body, this.settings.getWatermarkBytes());
                            this.setLicenceCommentHeader(hsrc, ls);
                            hsrc.getETag().addModifier(ls.name());
                        }
                        if (body.hasAlpha() && !supportAlpha) {
                            renderMatte = new CheckerMatte(this.settings.getFSILogger(), this.executorPool, priority);
                            body = renderMatte.transform(body, 8, 0xC8C8C8, 0xFFFFFF, false);
                        }
                        t3 = System.currentTimeMillis();
                        ocr = oc.compressImageData(priority, body, renderer, parameters, copyrightNotice);
                        body.dispose();
                    }
                    long t4 = System.currentTimeMillis();
                    this.settings.getFSILogger().log(3000, priority, t1 - t0, t3 - t2, t4 - t3);
                    if (ocr.getImageData() != null) {
                        hsrc.setContentType(ocr.getMimeType());
                        hsrc.setContentLength(ocr.getImageData().length);
                        hsrc.getETag().addModifier(ocr.getETagModifier());
                    }
                    if (req.getAttribute("headrequest") == null || !((Boolean)req.getAttribute("headrequest")).booleanValue()) {
                        String dispos = null;
                        if (parameters.contains(Parameters.GeneralImage.disposition)) {
                            dispos = parameters.get(Parameters.GeneralImage.disposition);
                        } else if (parameters.contains(Parameters.GeneralImage.save)) {
                            dispos = parameters.get(Parameters.GeneralImage.save);
                        }
                        if (dispos != null && (Boolean.parseBoolean(dispos) || dispos.equals("1"))) {
                            HTTPDisposition hd = new HTTPDisposition();
                            String forceSavename = parameters.get(Parameters.GeneralImage.savename);
                            String savename = forceSavename != null ? forceSavename : (assetURLPath != null ? assetURLPath.substring(assetURLPath.lastIndexOf("/") + 1) : "download.bin");
                            HashMap<String, String> dispositionHeaders = hd.getHeader(req.getHeader("User-Agent"), savename, ocr.getImageData().length, ocr.getMimeType());
                            for (Map.Entry dh : dispositionHeaders.entrySet()) {
                                hsrc.addHeader((String)dh.getKey(), (String)dh.getValue());
                            }
                        }
                    }
                    hsrc.setETag();
                    this.checkForNotModified(parameters, req, hsrc);
                    if (hsrc.isNotModifiedSent()) {
                        this.writeChunkedNG(hsrc, ocr.getImageData(), true);
                    } else {
                        long ttfbLong = System.currentTimeMillis() - hsrc.getRequestStartTime();
                        this.systemMonitor.setTTFB(ttfbLong);
                        if (this.settings.getFSILogger().hasNeLaDebug()) {
                            hsrc.addHeader("X-TTFB", Long.toString(ttfbLong) + "ms");
                        }
                        this.writeChunkedNG(hsrc, ocr.getImageData(), false);
                    }
                }
            } else if (status != 304) {
                hsrc.setCachable(false);
            }
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(400, e.getLocalizedMessage());
        }
        catch (ImageManipulatorException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(500, e.getLocalizedMessage());
        }
        catch (ProcessingException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(503, e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            hsrc.sendError(503, e.getLocalizedMessage());
        }
    }

    private OutputFormat getOutputFormat(Parameters parameters, Renderer renderer) {
        OutputFormat compressorType = null;
        String queryFormatStr = parameters.get(Parameters.GeneralImage.format);
        if (queryFormatStr != null) {
            compressorType = OutputFormat.valueOf(queryFormatStr.toUpperCase());
        }
        if (compressorType == null) {
            compressorType = renderer.getOutputFormat();
        }
        return compressorType;
    }

    private void handleDirectoryRequest(HttpServletRequest req, CacheableHttpServletResponse hsrc, int priority) throws ServletException, IOException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        long t0 = System.currentTimeMillis();
        Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)hsrc);
        if (renderer == null) {
            return;
        }
        RendererAbstract directoryImageRenderer = renderer.getDirectoryImageRenderer();
        if (directoryImageRenderer == null) {
            hsrc.setCachable(false);
            hsrc.sendError(404);
            return;
        }
        try {
            HttpSession session = req.getSession(false);
            if (!this.checkRendererProtection(directoryImageRenderer, assetURLPath, session)) {
                hsrc.setStatus(403);
                hsrc.setCachable(false);
                return;
            }
        }
        catch (NotConfiguredException e) {
            hsrc.setCachable(false);
            hsrc.sendError(503, e.getLocalizedMessage());
            return;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Set<String> requiredMetaData = directoryImageRenderer.getRequiredMetaData();
        List<MetaDataSource> metadatasources = renderer.getMetaDataSources();
        for (MetaDataSource mds : metadatasources) {
            Map<String, Object> md = mds.getMetaData(assetURLPath, requiredMetaData);
            for (Map.Entry<String, Object> e : md.entrySet()) {
                metadata.put(e.getKey(), e.getValue());
            }
        }
        if (!this.isMetadataComplete(requiredMetaData, metadata)) {
            this.sendIncompleteMetaDataResponse((HttpServletResponse)hsrc);
            hsrc.setCachable(false);
            this.settings.getFSILogger().log(4001, req.getMethod() + " " + req.getRequestURI());
            return;
        }
        try {
            RendererResponse rr = directoryImageRenderer.processRequest(priority, req, metadata);
            hsrc.setCachable(rr.isCacheable());
            hsrc.setPixels(rr.getPixels());
            long t1 = System.currentTimeMillis();
            int status = rr.getStatus();
            if (status >= 200 && status < 300) {
                hsrc.setStatus(status);
            } else {
                hsrc.setStatus(status, rr.getStatusMessage());
            }
            this.transferRendererResponseHeaders(hsrc, rr);
            long lastModified = rr.getDateHeader("Last-Modified");
            hsrc.setLastModified(lastModified);
            this.setPredefinedResponseHeaders(req, hsrc, "image.default");
            if (status >= 200 && status < 300) {
                if (rr instanceof RendererImageResponse) {
                    OutputCompressorResponse ocr;
                    long t3;
                    long t2;
                    RendererImageResponse rir = (RendererImageResponse)rr;
                    OutputFormat compressorType = this.getOutputFormat(parameters, renderer);
                    OutputCompressor oc = this.outputCompressors.get((Object)compressorType);
                    String copyrightNotice = this.getCopyrightNoticeForAsset(assetURLPath);
                    if (rir.isMultiImageResponse() && oc.hasMultiImageSupport()) {
                        FSIServerSettings.LicenceState ls;
                        FSIImage[] images = rir.getImageList();
                        t2 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            images = this.applyRendererEffects(priority, images, rir.getSelectionsRaws(), renderer.getOutputEffects(), parameters);
                            hsrc.getETag().addModifier(renderer.getOutputEffectsChecksum());
                        }
                        if (parameters.contains(Parameters.GeneralImage.effects)) {
                            images = this.applyQueryEffects(priority, images, rir.getSelectionsRaws(), parameters, parameters.get(Parameters.GeneralImage.effects));
                        }
                        if ((ls = this.settings.isLicensed()) != FSIServerSettings.LicenceState.VALID && !rr.isLicenceImage()) {
                            for (FSIImage image : images) {
                                FSIServerWatermark.transform(image, this.settings.getWatermarkBytes());
                            }
                            this.setLicenceCommentHeader(hsrc, ls);
                            hsrc.getETag().addModifier("unlic");
                        } else {
                            hsrc.getETag().addModifier("lic");
                        }
                        t3 = System.currentTimeMillis();
                        ocr = oc.compressImageData(priority, images, renderer, parameters, copyrightNotice);
                        for (FSIImage image : images) {
                            image.dispose();
                        }
                    } else {
                        FSIServerSettings.LicenceState ls;
                        FSIImage body = rir.getImage();
                        t2 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            body = this.applyRendererEffects(priority, body, rir.getSelectionsRaw(), renderer.getOutputEffects(), parameters);
                        }
                        if (parameters.contains(Parameters.GeneralImage.effects)) {
                            body = this.applyQueryEffects(priority, body, rir.getSelectionsRaw(), parameters, parameters.get(Parameters.GeneralImage.effects));
                        }
                        if ((ls = this.settings.isLicensed()) != FSIServerSettings.LicenceState.VALID && !rr.isLicenceImage()) {
                            this.setLicenceCommentHeader(hsrc, ls);
                            hsrc.getETag().addModifier("unlic");
                        } else {
                            hsrc.getETag().addModifier("lic");
                        }
                        t3 = System.currentTimeMillis();
                        ocr = oc.compressImageData(priority, body, renderer, parameters, copyrightNotice);
                        body.dispose();
                    }
                    long t4 = System.currentTimeMillis();
                    this.settings.getFSILogger().log(3000, priority, t1 - t0, t3 - t2, t4 - t3);
                    if (ocr.getImageData() != null) {
                        hsrc.setContentType(ocr.getMimeType());
                        hsrc.setContentLength(ocr.getImageData().length);
                        hsrc.getETag().addModifier(ocr.getETagModifier());
                        hsrc.setETag();
                        this.checkForNotModified(parameters, req, hsrc);
                        if (hsrc.isNotModifiedSent()) {
                            this.writeChunkedNG(hsrc, ocr.getImageData(), true);
                        } else {
                            this.systemMonitor.setTTFB(System.currentTimeMillis() - hsrc.getRequestStartTime());
                            this.writeChunkedNG(hsrc, ocr.getImageData(), false);
                        }
                    }
                }
            } else if (status != 304) {
                hsrc.setCachable(false);
            }
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(400, e.getLocalizedMessage());
        }
        catch (ImageManipulatorException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(500, e.getLocalizedMessage());
        }
        catch (ProcessingException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(503, e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            hsrc.sendError(503, e.getLocalizedMessage());
        }
    }

    private void checkForNotModified(Parameters parameters, HttpServletRequest req, CacheableHttpServletResponse hsrc) throws IOException {
        long imsRound;
        boolean imsMatch = false;
        boolean imsSet = false;
        try {
            imsRound = req.getDateHeader("If-Modified-Since") / 1000L * 1000L;
        }
        catch (IllegalArgumentException e) {
            imsRound = 0L;
        }
        if (imsRound > 0L) {
            imsSet = true;
            if (imsRound == hsrc.getLastModified()) {
                imsMatch = true;
            }
        }
        boolean inmSet = false;
        boolean inmMatch = false;
        String inmTag = req.getHeader("If-None-Match");
        if (inmTag != null) {
            inmSet = true;
            if (inmTag.equals(hsrc.getETag().getStrongTag(parameters.getAssetURLHash(), parameters.hashCode64()))) {
                inmMatch = true;
            }
        }
        if (!(!imsSet && !inmSet || imsSet && !imsMatch || inmSet && !inmMatch)) {
            hsrc.sendError(304);
        }
    }

    private void setLicenceCommentHeader(CacheableHttpServletResponse hsrc, FSIServerSettings.LicenceState ls) {
        switch (ls) {
            case EXPIRED: {
                hsrc.addHeader("X-Comment", "Licence expired");
                break;
            }
            case IMAGES_EXCEEDED: {
                hsrc.addHeader("X-Comment", "Max Images exceeded");
                break;
            }
            case CONNECTORS_EXCEEDED: {
                hsrc.addHeader("X-Comment", "Max Source Connectors exceeded");
                break;
            }
            case GROUPS_EXCEEDED: {
                hsrc.addHeader("X-Comment", "Max User Groups exceeded");
                break;
            }
            case NO_LICENCE: {
                hsrc.addHeader("X-Comment", "No Licence installed");
                break;
            }
            case WRONG_MAJOR: {
                hsrc.addHeader("X-Comment", "Invalid Licence installed");
                break;
            }
            case HARDWARE_ID_NOT_MATCHING: {
                hsrc.addHeader("X-Comment", "Invalid Hardware ID");
            }
        }
    }

    private boolean isMetadataComplete(Set<String> requiredMetaData, Map<String, Object> metadata) {
        boolean dataComplete = true;
        for (String reqkey : requiredMetaData) {
            if (metadata.containsKey(reqkey)) continue;
            dataComplete = false;
            break;
        }
        return dataComplete;
    }

    private FSIImage applyRendererEffects(int priority, FSIImage image, byte[] selectionsRaw, List<String> effects, Parameters parameters) throws ProcessingException {
        try {
            for (String effectString : effects) {
                if (effectString == null) continue;
                image = this.settings.getEffectsManager().applyEffects(priority, image, selectionsRaw, effectString, parameters);
            }
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(3153, null, e.getLocalizedMessage(), "");
        }
        return image;
    }

    private FSIImage[] applyRendererEffects(int priority, FSIImage[] images, byte[][] selectionsRaw, List<String> effects, Parameters parameters) throws ProcessingException {
        for (int i = 0; i < images.length; ++i) {
            if (images[i] == null) continue;
            images[i] = this.applyRendererEffects(priority, images[i], selectionsRaw[i], effects, parameters);
        }
        return images;
    }

    private FSIImage applyQueryEffects(int priority, FSIImage image, byte[] selectionsRaw, Parameters parameters, String effectsString) throws ProcessingException {
        try {
            image = this.settings.getEffectsManager().applyEffects(priority, image, selectionsRaw, effectsString, parameters);
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(3153, null, e.getLocalizedMessage(), "");
        }
        return image;
    }

    private FSIImage[] applyQueryEffects(int priority, FSIImage[] images, byte[][] selectionsRaw, Parameters parameters, String effectsString) throws ProcessingException {
        for (int i = 0; i < images.length; ++i) {
            images[i] = selectionsRaw != null ? this.applyQueryEffects(priority, images[i], selectionsRaw[i], parameters, effectsString) : this.applyQueryEffects(priority, images[i], null, parameters, effectsString);
        }
        return images;
    }

    private void handleTextRequest(HttpServletRequest req, CacheableHttpServletResponse hsrc, int priority) throws ServletException, IOException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        Parameters.Type requestType = parameters.getType();
        hsrc.setCharacterEncoding("UTF-8");
        if (requestType == Parameters.Type.INFO) {
            Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)hsrc);
            if (renderer != null) {
                try {
                    if (!this.checkRendererProtection(renderer.getInfoRenderer(), parameters.getAssetURLPath(), req.getSession(false))) {
                        hsrc.setStatus(403);
                        hsrc.setCachable(false);
                        return;
                    }
                }
                catch (NotConfiguredException e) {
                    hsrc.setCachable(false);
                    hsrc.sendError(503, e.getLocalizedMessage());
                }
                this.setPredefinedResponseHeaders(req, hsrc, parameters.getType().name() + ".default");
                this.processInfoAndListRequest(req, parameters, hsrc, renderer, priority);
            }
        } else if (requestType == Parameters.Type.LIST) {
            Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)hsrc);
            if (renderer != null) {
                try {
                    if (!this.checkRendererProtection(renderer.getListRenderer(), parameters.getAssetURLPath(), req.getSession(false))) {
                        hsrc.setStatus(403);
                        hsrc.setCachable(false);
                        return;
                    }
                }
                catch (NotConfiguredException e) {
                    hsrc.setCachable(false);
                    hsrc.sendError(503, e.getLocalizedMessage());
                }
                this.setPredefinedResponseHeaders(req, hsrc, parameters.getType().name() + ".default");
                this.processInfoAndListRequest(req, parameters, hsrc, renderer, priority);
            }
        } else if (requestType == Parameters.Type.SEARCH || requestType == Parameters.Type.SIMPLESEARCH) {
            this.setPredefinedResponseHeaders(req, hsrc, "list.default");
            this.processSearchRequest(req, parameters, hsrc);
        } else if (requestType == Parameters.Type.APPINFO) {
            this.setPredefinedResponseHeaders(req, hsrc, parameters.getType().name() + ".default");
            this.processAppInfoRequest(req, hsrc);
        } else if (requestType == Parameters.Type.LICENCEINFO) {
            this.setPredefinedResponseHeaders(req, hsrc, parameters.getType().name() + ".default");
            this.processLicenceInfoRequest(req, hsrc);
        }
    }

    private void setPredefinedResponseHeaders(HttpServletRequest request, CacheableHttpServletResponse hsrc, String defaultHeadersname) {
        Parameters parameters = (Parameters)request.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        SourceConnectorReader connector = null;
        if (assetURLPath != null) {
            connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        }
        if (connector == null) {
            if (parameters.contains(Parameters.General.headers)) {
                Map<String, String> requestedHeaders = this.settings.getHeaderSet(parameters.get(Parameters.General.headers));
                this.transferHeaders(requestedHeaders, (HttpServletResponse)hsrc);
            } else {
                Map<String, String> headers = this.settings.getHeaderSet(defaultHeadersname);
                this.transferHeaders(headers, (HttpServletResponse)hsrc);
            }
            return;
        }
        Map<String, String> forceHeaders = this.settings.getHeaderSet(connector.getForceHeadersName());
        if (forceHeaders != null) {
            this.transferHeaders(forceHeaders, (HttpServletResponse)hsrc);
        } else if (parameters.contains(Parameters.General.headers)) {
            Map<String, String> requestedHeaders = this.settings.getHeaderSet(parameters.get(Parameters.General.headers));
            this.transferHeaders(requestedHeaders, (HttpServletResponse)hsrc);
        } else {
            String connectorHeadersName = connector.getHeadersName();
            if (connectorHeadersName == null && defaultHeadersname != null) {
                connectorHeadersName = defaultHeadersname;
            }
            Map<String, String> headers = this.settings.getHeaderSet(connectorHeadersName);
            this.transferHeaders(headers, (HttpServletResponse)hsrc);
        }
    }

    private void transferHeaders(Map<String, String> headerSet, HttpServletResponse hsrc) {
        if (headerSet != null) {
            for (Map.Entry<String, String> header : headerSet.entrySet()) {
                hsrc.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    private void processLicenceInfoRequest(HttpServletRequest req, CacheableHttpServletResponse hsrc) {
        try {
            UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
            HttpSession session = req.getSession(false);
            PermissionSet permissions = uai.getPermissions((SourceConnectorReader)null, session, true);
            if (permissions == null || !permissions.general.readLicence.booleanValue()) {
                hsrc.setStatus(403);
                return;
            }
            JSONObject licenceInfoJSON = this.settings.getLicenceInfoAsJSON(this.settings.getLicence(), this.settings.getLicenceContainerHash());
            String licenceInfoString = licenceInfoJSON.toString(1);
            byte[] licBytes = licenceInfoString.getBytes(FileOperations.charsetUTF8);
            hsrc.setStatus(200);
            hsrc.setContentType("application/json");
            hsrc.setContentLength(licBytes.length);
            this.writeChunkedNG(hsrc, licBytes, false);
        }
        catch (NotConfiguredException e) {
            hsrc.setStatus(503);
        }
        catch (JSONException e) {
            hsrc.setStatus(500);
        }
    }

    private void processAppInfoRequest(HttpServletRequest req, CacheableHttpServletResponse hsrc) throws IOException {
        RawLicence rl;
        FSIServerSettings.LicenceState ls = this.settings.isLicensed();
        LicenceManager lm = this.settings.getLicenceManager();
        Integer appID = -1;
        Integer appVersion = -1;
        if (ls != FSIServerSettings.LicenceState.VALID || lm == null) {
            rl = null;
        } else {
            try {
                appID = Integer.valueOf(req.getParameter("appid"));
                appVersion = Integer.valueOf(req.getParameter("version"));
                rl = appVersion == -1 || appID < 100 || appID > 199 ? null : lm.getRawLicence(appID, appVersion);
            }
            catch (NumberFormatException e) {
                rl = null;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        sb.append("<fsi_parameter>");
        String lcID = req.getParameter("lcid");
        if (lcID != null) {
            lcID = lcID.substring(0, Math.min(64, lcID.length()));
        }
        String fsiLCID = this.settings.getLicence().getFSIViewerLCID();
        if (rl != null && lcID != null && fsiLCID != null && appID == 101 && appVersion >= 6) {
            sb.append("<licence lcid=\"");
            sb.append(this.hashCodeFSIViewer(lcID + fsiLCID));
            sb.append("\">");
        } else {
            int keyMsg = rl == null ? 1001 : (lcID == null ? 1002 : (fsiLCID == null ? 1003 : (appID != 101 ? 1004 : (appVersion < 6 ? 1005 : 1100))));
            sb.append("<licence keymsg=\"" + keyMsg + "\">");
        }
        if (rl != null && rl.lastModified > 0L) {
            sb.append(rl.licence);
            hsrc.setHeader("Cache-Control", "must-revalidate");
            hsrc.setDateHeader("Last-Modified", rl.lastModified);
            hsrc.setLastModified(rl.lastModified);
        } else {
            hsrc.setDateHeader("Expires", 0L);
            hsrc.setHeader("Cache-Control", "no-cache");
            hsrc.setHeader("Pragma", "no-cache");
        }
        sb.append("</licence>");
        sb.append("</fsi_parameter>");
        String licenceXML = sb.toString();
        hsrc.setStatus(200);
        hsrc.setContentType("application/xml");
        hsrc.setContentLength(licenceXML.length());
        this.systemMonitor.setTTFB(System.currentTimeMillis() - hsrc.getRequestStartTime());
        this.writeChunkedNG(hsrc, licenceXML.getBytes(FileOperations.charsetUTF8), false);
    }

    private long hashCodeFSIViewer(String str) {
        long h = 0L;
        for (int i = 0; i < str.length(); ++i) {
            h = 31L * h + (long)str.charAt(i) & Integer.MAX_VALUE;
        }
        return h;
    }

    private void processInfoAndListRequest(HttpServletRequest req, Parameters parameters, CacheableHttpServletResponse hsrc, Renderer profile, int priority) throws IOException {
        String assetURLPath = parameters.getAssetURLPath();
        ETag eTag = hsrc.getETag();
        RendererAbstract renderer = parameters.getType() == Parameters.Type.INFO ? profile.getInfoRenderer() : profile.getListRenderer();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Set<String> requiredMetaData = renderer.getRequiredMetaData();
        List<MetaDataSource> metadatasources = profile.getMetaDataSources();
        for (MetaDataSource mds : metadatasources) {
            Map<String, Object> md = mds.getMetaData(assetURLPath, requiredMetaData);
            for (Map.Entry<String, Object> entry : md.entrySet()) {
                metadata.put(entry.getKey(), entry.getValue());
            }
        }
        eTag.addModifier(parameters.getType().name() + metadata.hashCode());
        boolean isHeadRequest = req.getAttribute("headrequest") != null && (Boolean)req.getAttribute("headrequest") != false;
        try {
            FSIServerSettings.LicenceState ls;
            RendererResponse rr = renderer.processRequest(priority, req, metadata);
            int status = rr.getStatus();
            hsrc.setStatus(status);
            hsrc.setCachable(status == 200 && rr.isCacheable());
            this.transferRendererResponseHeaders(hsrc, rr);
            long lastModified = rr.getDateHeader("Last-Modified");
            if (lastModified > 0L) {
                hsrc.setLastModified(lastModified);
            }
            if ((ls = this.settings.isLicensed()) != FSIServerSettings.LicenceState.VALID) {
                this.setLicenceCommentHeader(hsrc, ls);
                eTag.addModifier("lic");
            } else {
                eTag.addModifier("unlic");
            }
            this.checkForNotModified(parameters, req, hsrc);
            if (hsrc.isNotModifiedSent()) {
                String text = ((RendererTextResponse)rr).getBody();
                if (text != null) {
                    byte[] content = text.getBytes(FileOperations.charsetUTF8);
                    hsrc.setContentType(rr.getContentType());
                    hsrc.setContentLength(content.length);
                    hsrc.setETag();
                    this.systemMonitor.setTTFB(System.currentTimeMillis() - hsrc.getRequestStartTime());
                    this.writeChunkedNG(hsrc, content, true);
                }
            } else {
                String text = ((RendererTextResponse)rr).getBody();
                if (!isHeadRequest && text != null) {
                    byte[] content = text.getBytes(FileOperations.charsetUTF8);
                    hsrc.setContentType(rr.getContentType());
                    if (content != null) {
                        hsrc.setContentLength(content.length);
                        hsrc.setETag();
                        this.systemMonitor.setTTFB(System.currentTimeMillis() - hsrc.getRequestStartTime());
                        this.writeChunkedNG(hsrc, content, false);
                    }
                }
            }
        }
        catch (ProcessingException e) {
            this.settings.getFSILogger().logException(e, 4000, e.getLocalizedMessage(), req.getMethod() + " " + req.getQueryString());
            hsrc.sendError(503, e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            hsrc.sendError(503, e.getLocalizedMessage());
        }
    }

    private void processSearchRequest(HttpServletRequest req, Parameters parameters, CacheableHttpServletResponse hsrc) throws IOException {
        SearchProcessor processor = this.searchprocessors.get((Object)parameters.getType());
        RendererTextResponse rr = processor.search(parameters, req.getSession(false));
        int status = rr.getStatus();
        hsrc.setCachable(rr.isCacheable());
        hsrc.getETag().addModifier(rr.getETagModifier());
        this.transferRendererResponseHeaders(hsrc, rr);
        hsrc.setStatus(status);
        FSIServerSettings.LicenceState ls = this.settings.isLicensed();
        if (ls != FSIServerSettings.LicenceState.VALID) {
            this.setLicenceCommentHeader(hsrc, ls);
            hsrc.getETag().addModifier("unlic");
        } else {
            hsrc.getETag().addModifier("lic");
        }
        this.checkForNotModified(parameters, req, hsrc);
        if (hsrc.getStatus() >= 200 && hsrc.getStatus() < 300) {
            if (req.getAttribute("headrequest") == null || !((Boolean)req.getAttribute("headrequest")).booleanValue()) {
                String text = rr.getBody();
                byte[] content = text.getBytes(FileOperations.charsetUTF8);
                hsrc.setContentType(rr.getContentType());
                hsrc.setETag();
                if (content != null) {
                    hsrc.setContentLength(content.length);
                    this.systemMonitor.setTTFB(System.currentTimeMillis() - hsrc.getRequestStartTime());
                    this.writeChunkedNG(hsrc, content, false);
                }
            }
        } else {
            hsrc.setContentType("application/json");
            if (rr.getBody() != null) {
                byte[] messageBytes = rr.getBody().getBytes(FileOperations.charsetUTF8);
                hsrc.setContentLength(messageBytes.length);
                this.writeChunkedNG(hsrc, messageBytes, false);
            }
        }
    }

    private void transferRendererResponseHeaders(CacheableHttpServletResponse response, RendererResponse rr) {
        Map<String, Object> headers = rr.getHeaders();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String string = entry.getKey();
            Object value = entry.getValue();
            if (string.equals("Last-Modified") && value instanceof Long) {
                response.addDateHeader(string, (Long)value);
                continue;
            }
            response.addHeader(string, value.toString());
        }
        Map<String, Long> dateheaders = rr.getDateHeaders();
        for (Map.Entry<String, Long> entry : dateheaders.entrySet()) {
            response.addDateHeader(entry.getKey(), entry.getValue());
        }
        String string = rr.getETagModifier();
        if (string != null) {
            ETag eTag = response.getETag();
            eTag.addModifier(string);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("headrequest", (Object)true);
        if (this.systemMonitor != null) {
            this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_HEAD);
        }
        this.doGet(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("cacheable", (Object)true);
        if (this.systemMonitor != null) {
            this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_POST);
        }
        this.doRequest(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.systemMonitor != null) {
            this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_GET);
        }
        try {
            this.doRequest(req, resp);
        }
        catch (IllegalArgumentException e) {
            this.sendInvalidParameterValueResponse(resp, "url", "");
        }
    }

    public String handleBatchRequest(Parameters parameters, OutputStream stream) throws ServletException, IOException {
        MockHttpServletRequest request = new MockHttpServletRequest("GET");
        request.setServletPath("server");
        for (Map.Entry<Parameters.Parameter, String> parameter : parameters.entrySet()) {
            request.addParameter(parameter.getKey().toString(), parameter.getValue());
        }
        request.setAttribute("parameters", parameters);
        request.setAttribute("cacheable", false);
        MockHttpServletResponse response = null;
        try (ServletOutputStreamWrapper sos = new ServletOutputStreamWrapper(stream);){
            response = new MockHttpServletResponse(sos);
            this.doRequest(request, response);
        }
        return response.getContentType();
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Charset charset;
        String decodedPath;
        String defaultHeaderSet;
        String path = req.getServletPath();
        String assetURLPath = null;
        if (path.startsWith("/static")) {
            assetURLPath = req.getPathInfo();
            defaultHeaderSet = "static.default";
        } else {
            assetURLPath = req.getParameter("source");
            defaultHeaderSet = req.getParameter("type") + ".default";
        }
        String cEnc = req.getCharacterEncoding();
        if (cEnc == null) {
            cEnc = "UTF-8";
        }
        if ((decodedPath = URLDecoderFast.decode(assetURLPath, charset = Charset.forName(cEnc))) == null) {
            return;
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(decodedPath);
        if (connector == null) {
            return;
        }
        Map<String, String> forceHeaders = this.settings.getHeaderSet(connector.getForceHeadersName());
        if (forceHeaders != null) {
            this.transferHeaders(forceHeaders, resp);
        } else {
            String connectorHeadersName = connector.getHeadersName();
            if (connectorHeadersName == null) {
                connectorHeadersName = defaultHeaderSet;
            }
            Map<String, String> headers = this.settings.getHeaderSet(connectorHeadersName);
            this.transferHeaders(headers, resp);
        }
        resp.setStatus(200);
    }

    public boolean acceptsRequests() {
        return this.acceptRequests;
    }

    public void writeInitErrorResponse(HttpServletResponse response) throws IOException {
        response.setStatus(503);
        try (PrintWriter p = response.getWriter();){
            new Version();
            p.write(SoftwareVersion.getSoftware(true) + " not started");
            if (this.servletInitError) {
                p.write("\n");
                p.write(this.servletInitErrorMessage);
            }
            p.flush();
        }
    }

    private void doRequest(HttpServletRequest req, HttpServletResponse respOrigin) throws ServletException, IOException {
        if (this.acceptRequests) {
            this.handleAcceptedRequest(req, respOrigin);
        } else {
            this.writeInitErrorResponse(respOrigin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAcceptedRequest(HttpServletRequest req, HttpServletResponse respOrigin) throws ServletException, IOException {
        CacheableHttpServletResponse hsrc = null;
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        CacheManager cacheManager = this.settings.getCacheManager();
        String assetURLPath = null;
        if (parameters != null) {
            assetURLPath = parameters.getAssetURLPath();
        }
        try {
            int status;
            long queryHash;
            long assetURLHash;
            this.currentPriority.incrementAndGet();
            this.systemMonitor.setConcurrentProcessing(this.concurrentProcessing.incrementAndGet());
            long requestStartTime = System.currentTimeMillis();
            String path = req.getServletPath();
            if (parameters != null) {
                assetURLHash = parameters.getAssetURLHash();
                queryHash = parameters.hashCode64();
            } else {
                assetURLHash = 0L;
                queryHash = 0L;
            }
            hsrc = new CacheableHttpServletResponse(respOrigin, assetURLHash, queryHash);
            hsrc.setRequestStartTime(requestStartTime);
            if (path.startsWith("/static")) {
                this.staticFileRequestHandler.handleRequest(req, hsrc);
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_STATIC);
                if (req.getAttribute("headrequest") == null) {
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_STATIC, hsrc.getContentLength());
                }
            } else if (parameters != null) {
                if (parameters.getType() == Parameters.Type.IMAGE) {
                    long pixel;
                    this.handleImageRequest(req, hsrc, this.currentPriority.get());
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_IMAGE);
                    if (req.getAttribute("headrequest") == null) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_IMAGE, hsrc.getContentLength());
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    }
                    if ((pixel = hsrc.getPixels()) != 0L) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_PIXEL_ALL, pixel);
                    }
                } else if (parameters.getType() == Parameters.Type.DIRECTORYIMAGE) {
                    this.handleDirectoryRequest(req, hsrc, this.currentPriority.get());
                } else if (parameters.getType() == Parameters.Type.INFO) {
                    this.handleTextRequest(req, hsrc, this.currentPriority.get());
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_INFO);
                    if (req.getAttribute("headrequest") == null) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_INFO, hsrc.getContentLength());
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.LIST) {
                    this.handleTextRequest(req, hsrc, this.currentPriority.get());
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_LIST);
                    if (req.getAttribute("headrequest") == null) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_LIST, hsrc.getContentLength());
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.SEARCH || parameters.getType() == Parameters.Type.SIMPLESEARCH) {
                    hsrc.setCachable(false);
                    this.handleTextRequest(req, hsrc, this.currentPriority.get());
                    this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_SEARCH);
                    if (req.getAttribute("headrequest") == null) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_SEARCH, hsrc.getContentLength());
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.APPINFO || parameters.getType() == Parameters.Type.LICENCEINFO) {
                    hsrc.setCachable(false);
                    this.handleTextRequest(req, hsrc, this.currentPriority.get());
                    if (req.getAttribute("headrequest") == null) {
                        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, hsrc.getContentLength());
                    }
                } else {
                    this.sendInvalidParameterValueResponse((HttpServletResponse)hsrc, "type", parameters.getType().name());
                    hsrc.setCachable(false);
                }
            }
            if ((status = hsrc.getStatus()) == 200) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_200);
            } else if (status == 302) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_302);
            } else if (status == 304) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_304);
            } else if (status == 403) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_403);
            } else if (status == 404) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_404);
            } else if (status == 500) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_500);
            } else if (status == 503) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_503);
            }
            this.systemMonitor.setConcurrentProcessing(this.concurrentProcessing.decrementAndGet());
            if (this.concurrentProcessing.get() == 0) {
                this.currentPriority.set(0);
            }
            if (hsrc == null) return;
        }
        catch (Throwable throwable) {
            this.systemMonitor.setConcurrentProcessing(this.concurrentProcessing.decrementAndGet());
            if (this.concurrentProcessing.get() == 0) {
                this.currentPriority.set(0);
            }
            if (hsrc == null) throw throwable;
            hsrc.close();
            if (req.getAttribute("cacheable") != null) {
                boolean cb = (Boolean)req.getAttribute("cacheable");
                hsrc.setCachable(hsrc.isCachable() && cb);
            }
            if (!hsrc.isCachable() || hsrc.getStatus() != 200) throw throwable;
            String method = req.getMethod();
            if (assetURLPath == null || !method.equals("GET")) throw throwable;
            CacheKey cacheKey = this.calculateRequestCacheKey(assetURLPath, parameters, req.getSession(false), method);
            cacheManager.put(cacheKey, hsrc, true);
            throw throwable;
        }
        hsrc.close();
        if (req.getAttribute("cacheable") != null) {
            boolean cb = (Boolean)req.getAttribute("cacheable");
            hsrc.setCachable(hsrc.isCachable() && cb);
        }
        if (!hsrc.isCachable() || hsrc.getStatus() != 200) return;
        String method = req.getMethod();
        if (assetURLPath == null || !method.equals("GET")) return;
        CacheKey cacheKey = this.calculateRequestCacheKey(assetURLPath, parameters, req.getSession(false), method);
        cacheManager.put(cacheKey, hsrc, true);
    }

    @Override
    public void destroy() {
        this.stop();
        if (!this.settings.getSecured()) {
            super.destroy();
        }
    }

    @Override
    public void start() {
        this.servletStatus = "starting";
        this.settings.evalutateSettings();
        if (!this.settings.hasSectionEnabled("application")) {
            this.settings.getFSILogger().log(2006, new Object[0]);
            this.destroy();
        }
        this.startTime = System.currentTimeMillis();
        Path storageLocation = this.settings.getStorageLocation();
        if (storageLocation == null || !Files.exists(storageLocation, new LinkOption[0])) {
            this.settings.getFSILogger().log(2043, storageLocation);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.startError", (Object)"FSIServer start failed due to an invalid storage location.");
            this.servletStatus = "stopped";
        } else if (!Files.isReadable(storageLocation)) {
            this.settings.getFSILogger().log(2045, storageLocation);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.startError", (Object)"FSIServer start failed due to an invalid storage location.");
            this.servletStatus = "stopped";
        } else {
            boolean packAsync;
            boolean cacheResponse;
            boolean useL2;
            CacheManager cacheManager;
            Path pluginBaseDir;
            long startMTime = System.currentTimeMillis();
            String pluginBaseDirStr = System.getProperty("com.neptunelabs.fsiserver.plugin.home");
            if (pluginBaseDirStr != null) {
                pluginBaseDir = Paths.get(pluginBaseDirStr, new String[0]);
                if (!Files.isDirectory(pluginBaseDir, new LinkOption[0])) {
                    pluginBaseDir = null;
                }
            } else {
                pluginBaseDir = null;
            }
            if (pluginBaseDir == null) {
                pluginBaseDir = ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("internal").resolve("plugins");
            }
            ClassLoader cl = this.servletContext.getClass().getClassLoader();
            PluginLoader pluginLoader = new PluginLoader(this.settings.getFSILogger(), cl, this.sysinfo);
            List<String> pluginList = PluginLoader.scanForPlugins(pluginBaseDir);
            for (String plugin : pluginList) {
                pluginLoader.loadPlugin(pluginBaseDir, plugin, "RequestProcessor");
            }
            this.settings.setPluginLoader(pluginLoader);
            this.settings.getFSILogger().log(3204, "Plugins", System.currentTimeMillis() - startMTime);
            String hasherStr = this.settings.getPrefsString("application", "storagehasher");
            StorageHelperV1002.Hasher hasher = null;
            try {
                if (hasherStr != null) {
                    hasherStr = hasherStr.toUpperCase();
                    hasher = StorageHelperV1002.Hasher.valueOf(hasherStr);
                }
            }
            catch (IllegalArgumentException e) {
                hasher = StorageHelperV1002.Hasher.HASH32;
            }
            startMTime = System.currentTimeMillis();
            this.settings.setupStorageHelper(hasher, storageLocation);
            try {
                this.settings.evaluateStorageID();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.settings.init();
            this.settings.getFSILogger().log(3204, "Settings", System.currentTimeMillis() - startMTime);
            startMTime = System.currentTimeMillis();
            boolean cacheEnabled = this.settings.hasSectionEnabled("cache");
            startMTime = System.currentTimeMillis();
            this.setupSwapPool();
            this.settings.getFSILogger().log(3204, "SwapPool", System.currentTimeMillis() - startMTime);
            long maxBlockCache = this.settings.evaluateMaxBlockCache(this.settings.getPrefsString("cache", "maxmemory"));
            boolean useDirectMemoryForCaching = this.settings.getPrefsBoolean("cache", "directmemory");
            boolean useL1 = this.settings.getPrefsBoolean("cache", "l1");
            int l1Size = this.settings.getPrefsInt("cache", "l1size");
            if (l1Size <= 0) {
                l1Size = 0;
            }
            if ((cacheManager = this.settings.initCacheManager(cacheEnabled, maxBlockCache, useDirectMemoryForCaching, useL1, l1Size, useL2 = this.settings.getPrefsBoolean("cache", "l2"), cacheResponse = this.settings.getPrefsBoolean("cache", "response"), packAsync = this.settings.getPrefsBoolean("cache", "packasync"))) != null && !this.settings.useOwnCacheManager()) {
                long size = cacheManager.getAllocatedCacheSize();
                long max = cacheManager.getMaximumCacheSize();
                String sharedCacheSize = size == 0L ? "disabled" : FormatBytes.byteToString(size, 3, 1);
                this.settings.getFSILogger().log(3204, "CacheManager (shared: " + sharedCacheSize + "/" + FormatBytes.byteToString(max, 3, 1) + ")", System.currentTimeMillis() - startMTime);
            } else if (cacheManager != null) {
                long size = cacheManager.getAllocatedCacheSize();
                long max = cacheManager.getMaximumCacheSize();
                this.settings.getFSILogger().log(3204, "CacheManager (" + FormatBytes.byteToString(size, 3, 1) + "/" + FormatBytes.byteToString(max, 3, 1) + ")", System.currentTimeMillis() - startMTime);
            } else {
                this.settings.getFSILogger().log(3204, "CacheManager (disabled)", System.currentTimeMillis() - startMTime);
            }
            this.initExecutorPool();
            boolean successInitMimes = this.settings.initMimeTypes(true);
            if (!successInitMimes) {
                // empty if block
            }
            this.settings.initImageBuilders();
            Path workdir = this.settings.getWorkDirectory();
            this.deletePool = new DeletePool(this.settings.getFSILogger(), workdir, this.settings.getIOController());
            this.deletePool.start();
            if (Boolean.valueOf(System.getProperty("com.neptunelabs.useImageIOCache", "false")).booleanValue()) {
                ImageIO.setUseCache(true);
                ImageIO.setCacheDirectory(workdir.toFile());
            } else {
                ImageIO.setUseCache(false);
            }
            this.startEffectsManager();
            this.initOutputCompressors();
            startMTime = System.currentTimeMillis();
            this.settings.readHeadersDefinition();
            this.settings.initHeadersMonitor();
            this.settings.readRenderers();
            this.settings.readSourceConnectors();
            this.settings.getFSILogger().log(3204, "Renderers", System.currentTimeMillis() - startMTime);
            Path configHome = (Path)this.servletContext.getAttribute("com.neptunelabs.fsiserver.config.home");
            startMTime = System.currentTimeMillis();
            this.initFreeMarker(configHome);
            this.settings.getFSILogger().log(3204, "Template Engine", System.currentTimeMillis() - startMTime);
            this.initRequestProcessorTokens();
            startMTime = System.currentTimeMillis();
            this.initSystemMonitor();
            this.settings.configureJMXSupport();
            this.settings.getFSILogger().log(3204, "SystemMonitor", System.currentTimeMillis() - startMTime);
            this.initStaticFileHandler();
            this.searchprocessors = new HashMap<Parameters.Type, SearchProcessor>();
            this.searchprocessors.put(Parameters.Type.SEARCH, new DefaultSearchProcessor(this.settings));
            this.searchprocessors.put(Parameters.Type.SIMPLESEARCH, new SimpleSearchProcessor(this.settings));
            this.servletStatus = "running";
            this.acceptRequests = true;
            this.settings.getFSILogger().log(3204, "RequestProcessor", System.currentTimeMillis() - this.startTime);
            this.settings.getFSILogger().log(2019, new Object[0]);
        }
    }

    private void initStaticFileHandler() {
        this.staticFileRequestHandler = new StaticFileRequestHandler(this.settings);
    }

    private void initExecutorPool() {
        Object lh = this.servletContext.getAttribute("com.neptunelabs.fsiserver.ExecutorPool");
        if (lh != null) {
            this.executorPool = (ExecutorPool)lh;
            this.usesOwnExecutorPool = false;
            this.settings.getFSILogger().log(2024, this.executorPool.getMaxThreads(ExecutorPool.Type.RENDERER_CPU), this.executorPool.getMaxThreads(ExecutorPool.Type.RENDERER_IO), this.executorPool.getMaxThreadsPerCPUJob());
        } else {
            int[] res = this.settings.evaluateExecutorPoolThreads(1);
            int numberCruncherThreads = res[0];
            int ioThreads = res[1];
            int maxThreadsPerJobs = res[2];
            this.executorPool = new ExecutorPool(numberCruncherThreads, ioThreads, maxThreadsPerJobs);
            this.settings.getFSILogger().log(2023, this.executorPool.getMaxThreads(ExecutorPool.Type.RENDERER_CPU), this.executorPool.getMaxThreads(ExecutorPool.Type.RENDERER_IO), this.executorPool.getMaxThreadsPerCPUJob());
            this.usesOwnExecutorPool = true;
        }
        this.settings.setExecutorPool(this.executorPool);
    }

    private void initOutputCompressors() {
        this.outputCompressors.clear();
        this.settings.getFSILogger().log(2020, "jpg");
        JPEGCompressor o1 = new JPEGCompressor(this.settings);
        this.outputCompressors.put(OutputFormat.JPEG, o1);
        this.settings.getFSILogger().log(2020, "png");
        PNGCompressor o2 = new PNGCompressor(this.settings);
        this.outputCompressors.put(OutputFormat.PNG, o2);
        this.settings.getFSILogger().log(2020, "swf");
        SWFCompressor o3 = new SWFCompressor(this.settings);
        this.outputCompressors.put(OutputFormat.SWF, o3);
        this.settings.getFSILogger().log(2020, "gif");
        GIFCompressor o4 = new GIFCompressor(this.settings);
        this.outputCompressors.put(OutputFormat.GIF, o4);
    }

    @Override
    public void stop() {
        this.servletStatus = "stopping";
        this.settings.getFSILogger().log(2002, SoftwareVersion.getSoftware(true));
        this.acceptRequests = false;
        if (!this.settings.isRestarting() && this.fileEventCursor != null) {
            this.fileEventCursor.halt();
        }
        if (this.systemMonitor != null) {
            this.systemMonitor.halt();
        }
        try {
            if (this.settings.getSystemMonitor() != null) {
                this.settings.getSystemMonitor().halt();
                this.settings.getSystemMonitor().join();
            }
            if (this.executorPool != null && this.usesOwnExecutorPool) {
                this.executorPool.shutdownNow();
            }
            if (this.deletePool != null) {
                this.deletePool.halt();
                this.deletePool.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.settings.useOwnCacheManager()) {
            this.settings.getCacheManager().dispose();
        }
        this.shutdownFreeMarker();
        if (!this.settings.isRestarting()) {
            this.settings.getFSILogger().log(2018, new Object[0]);
            this.settings.dispose();
            this.settings.getFSILogger().shutdown();
        }
        this.servletStatus = "stopped";
    }

    private void setupSwapPool() {
        this.swapPool = new SwapPool(this.settings.getFSILogger(), this.settings.getWorkDirectory());
        this.settings.setSwapPool(this.swapPool);
    }

    private boolean initFreeMarker(Path configHome) {
        boolean result = true;
        this.settings.getFSILogger().log(2021, new Object[0]);
        Configuration cfg = new Configuration();
        cfg.setNumberFormat("0.######");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setEncoding(Locale.ENGLISH, "UTF-8");
        cfg.setOutputEncoding("UTF-8");
        cfg.setLocale(Locale.ENGLISH);
        cfg.setWhitespaceStripping(false);
        TemplateCache templateCache = new TemplateCache(this.settings.getFSILogger(), cfg, this.fileEventCursor);
        try {
            templateCache.registerTemplates(TemplateType.INFO, this.settings.getWebInfPath().resolve("internal/templates").resolve("info"), this.settings.getFSILogger().hasNeLaDebug());
            Path customInfoTemplateDir = configHome.resolve("templates").resolve("info");
            if (Files.exists(customInfoTemplateDir, new LinkOption[0])) {
                templateCache.registerTemplates(TemplateType.INFO, customInfoTemplateDir, true);
            }
            templateCache.registerTemplates(TemplateType.LIST, this.settings.getWebInfPath().resolve("internal/templates").resolve("list"), this.settings.getFSILogger().hasNeLaDebug());
            Path customListTemplateDir = configHome.resolve("templates").resolve("list");
            if (Files.exists(customListTemplateDir, new LinkOption[0])) {
                templateCache.registerTemplates(TemplateType.LIST, customListTemplateDir, true);
            }
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().log(2022, ioe.getLocalizedMessage());
            result = false;
        }
        this.settings.setTemplateCache(templateCache);
        return result;
    }

    private void initSystemMonitor() {
        Object lh = this.servletContext.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
        if (lh != null) {
            this.systemMonitor = (SystemMonitor)lh;
        } else {
            this.systemMonitor = new SystemMonitor(this.settings.getLicence(), this.settings.getStorageLocation(), this.executorPool);
            this.systemMonitor.start();
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.SystemMonitor", (Object)this.systemMonitor);
        }
        try {
            UserAuthenticationInterface uam = this.settings.getUserAuthenticationInterface();
            if (uam != null) {
                this.systemMonitor.setGroupCount(uam.getGroupCount());
            }
        }
        catch (NotConfiguredException notConfiguredException) {
            // empty catch block
        }
        this.settings.setSystemMonitor(this.systemMonitor);
    }

    private void shutdownFreeMarker() {
        if (this.settings.getTemplateCache() != null) {
            Configuration cfg = this.settings.getTemplateCache().getConfiguration();
            cfg.clearTemplateCache();
            cfg.clearSharedVariables();
            cfg.clearEncodingMap();
            this.settings.getTemplateCache().dispose();
        }
    }

    private void sendIncompleteMetaDataResponse(HttpServletResponse resp) throws IOException {
        resp.sendError(400, "Not enough data to process request");
        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    private void sendInvalidParameterValueResponse(HttpServletResponse resp, String parameter, String value) throws IOException {
        resp.sendError(400, "Invalid Parameter value " + value + " for parameter " + parameter);
        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    private void sendInternalServerErrorResponse(HttpServletResponse resp, String reason) throws IOException {
        resp.sendError(400, "Internal Server Error " + reason);
        this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    public boolean hasServletInitError() {
        return this.servletInitError;
    }

    public boolean hasServletInitWarning() {
        return this.servletInitWarning;
    }

    public String getServletInitErrorMessage() {
        return this.servletInitErrorMessage;
    }

    public String getServletInitWarningMessage() {
        return this.servletInitWarningMessage;
    }

    public String getStatus() {
        return this.servletStatus;
    }

    private void initRequestProcessorTokens() {
        String requestprocessortoken = "";
        String requestprocessortokens = this.settings.getPrefsString("application", "requestprocessortokens");
        if (requestprocessortokens != null && !requestprocessortokens.equals("")) {
            if ((requestprocessortokens = requestprocessortokens.trim().toLowerCase()).equals("full") || requestprocessortokens.equals("debug")) {
                requestprocessortoken = this.settings.getPrefsString(null, "vendor") + " " + SoftwareVersion.getSoftware(true);
                if (requestprocessortokens.equals("debug")) {
                    try {
                        InetAddress addr = InetAddress.getLocalHost();
                        this.servletContext.setAttribute("serverhostname", (Object)addr.getHostName());
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else if (requestprocessortokens.equals("prod")) {
                requestprocessortoken = this.settings.getPrefsString(null, "vendor") + " " + SoftwareVersion.getSoftware(false);
            } else if (requestprocessortokens.equals("none")) {
                requestprocessortoken = null;
            }
        }
        this.servletContext.setAttribute("requestprocessortoken", (Object)requestprocessortoken);
    }

    public CacheKey calculateRequestCacheKey(String assetURLPath, Parameters parameters, HttpSession session, String httpMethod) {
        StringBuilder suffix = new StringBuilder(32);
        suffix.append(httpMethod);
        suffix.append('/');
        suffix.append(parameters.hashCode64());
        if (session != null) {
            suffix.append(session.getId());
            try {
                String sessionid = (String)session.getAttribute("id");
                suffix.append(this.settings.getUserAuthenticationInterface().getUser(sessionid));
            }
            catch (NotConfiguredException notConfiguredException) {
                // empty catch block
            }
        }
        return CacheKey.getInstance(assetURLPath, '*', suffix.toString());
    }

    public int getUptime() {
        return this.startTime != 0L ? (int)((System.currentTimeMillis() - this.startTime) / 1000L) : 0;
    }

    public RequestProcessorSettings getRequestProcessorSettings() {
        return this.settings;
    }

    private void startEffectsManager() {
        EffectsManager effectsManager = new EffectsManager(this.settings.getFSILogger(), this.executorPool);
        this.settings.setEffectsManager(effectsManager);
    }

    private void initRenderersMonitor() {
        FileEventCallback callback = new FileEventCallback(this.settings, "readRenderers", null);
        ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
        cL.add(callback);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) {
                return Files.isDirectory(file, new LinkOption[0]) || file.getFileName().toString().endsWith(".xml");
            }
        };
        try {
            this.fileEventCursor.addPathMonitor(this.settings.getRendererDirectory(), filter, false, cL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int writeChunkedNG(CacheableHttpServletResponse hsrc, byte[] content, boolean cacheOnly) {
        int transferedBytes = 0;
        int chunkes = (int)Math.ceil((float)content.length / 8192.0f);
        for (int c = 0; c < chunkes; ++c) {
            int len = c + 1 == chunkes ? content.length - c * 8192 : 8192;
            try {
                hsrc.write(content, c * 8192, len, cacheOnly);
            }
            catch (IOException e) {
                hsrc.setCachable(false);
                break;
            }
            transferedBytes += len;
        }
        return transferedBytes;
    }
}

