/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiserver.requestprocessor.filters.CorsFilter;
import com.neptunelabs.fsiserver.requestprocessor.filters.InterfaceFilter;
import com.neptunelabs.fsiserver.requestprocessor.filters.RequestFilter;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

@WebListener
public class MainProcessorContextListener
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger("FSIServer");

    public void contextInitialized(ServletContextEvent sce) {
        CorsFilter corsFilter;
        ServletContext servletContext = sce.getServletContext();
        FilterRegistration.Dynamic dynamicCF = servletContext.addFilter("CorsFilter", (Filter)(corsFilter = new CorsFilter()));
        if (dynamicCF != null) {
            dynamicCF.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        } else {
            LOGGER.log(Level.SEVERE, "CorsFilter not initiated");
        }
        RequestFilter requestFilter = new RequestFilter();
        FilterRegistration.Dynamic dynamicRF = servletContext.addFilter("RequestFilter", (Filter)requestFilter);
        if (dynamicRF != null) {
            dynamicRF.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/server"});
        } else {
            LOGGER.log(Level.SEVERE, "RequestFilter not initiated");
        }
        InterfaceFilter interfaceFilter = new InterfaceFilter(servletContext);
        FilterRegistration.Dynamic dynamicIF = servletContext.addFilter("InterfaceFilter", (Filter)interfaceFilter);
        if (dynamicIF != null) {
            dynamicIF.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/interface/*"});
        } else {
            LOGGER.log(Level.SEVERE, "InterfaceFilter not initiated");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

