/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.security.CityHash;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class Parameters {
    private final Map<Parameter, String> passedParameter;
    private Type type = null;
    private String assetURLPath = null;
    private long assetURLHash = 0L;
    private long hashCode = -1L;

    private static Map<String, String[]> parseServletRequest(HttpServletRequest request) {
        Map<String, String[]> parameters = request.getParameterMap();
        if (parameters.size() == 0 && request.getMethod().equalsIgnoreCase("POST") && request.getContentLength() > 0) {
            byte[] data;
            try {
                data = URL.getContent(request);
            }
            catch (IOException e) {
                data = null;
            }
            if (data != null) {
                Charset charset;
                String cEnc = request.getCharacterEncoding();
                if (cEnc == null) {
                    charset = FileOperations.charsetASCII;
                } else if (cEnc.equalsIgnoreCase("UTF-8")) {
                    charset = FileOperations.charsetUTF8;
                } else if (cEnc.equalsIgnoreCase("ISO-8859-1") || cEnc.equalsIgnoreCase("ISO-8859-15")) {
                    charset = FileOperations.charsetISO8859_15;
                } else {
                    try {
                        charset = Charset.forName(cEnc);
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                        charset = FileOperations.charsetASCII;
                    }
                }
                parameters = URL.parseParameters(data, charset);
            }
        }
        return parameters;
    }

    public Parameters(HttpServletRequest request) {
        this(Parameters.parseServletRequest(request));
    }

    public Parameters(String query) {
        this(URL.parseParameters(query.getBytes(FileOperations.charsetASCII), FileOperations.charsetASCII));
    }

    public Parameters(Map<String, String[]> parameters) {
        String sourceStr;
        if (parameters.get("type") != null) {
            String typeStr = parameters.get("type")[0];
            if (typeStr == null) {
                typeStr = "IMAGE";
            }
            this.type = Type.valueOf(typeStr.toUpperCase());
        } else {
            this.type = Type.NONE;
        }
        this.passedParameter = new LinkedHashMap<Parameter, String>();
        Parameters.fillParameterMap(parameters, this.passedParameter, General.values());
        if (this.type == Type.IMAGE) {
            Parameters.fillParameterMap(parameters, this.passedParameter, GeneralImage.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, FileImage.values());
        } else if (this.type == Type.DIRECTORYIMAGE) {
            Parameters.fillParameterMap(parameters, this.passedParameter, GeneralImage.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, DirectoryImage.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, Sorting.values());
        } else if (this.type == Type.INFO) {
            Parameters.fillParameterMap(parameters, this.passedParameter, Info.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, Sorting.values());
        } else if (this.type == Type.LIST) {
            Parameters.fillParameterMap(parameters, this.passedParameter, List.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, Sorting.values());
        } else if (this.type == Type.SEARCH || this.type == Type.SIMPLESEARCH) {
            Parameters.fillParameterMap(parameters, this.passedParameter, Search.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, List.values());
            Parameters.fillParameterMap(parameters, this.passedParameter, Sorting.values());
        } else if (this.type == Type.APPINFO) {
            Parameters.fillParameterMap(parameters, this.passedParameter, AppInfo.values());
        }
        Parameters.fillParameterMap(parameters, this.passedParameter, Deprecated.values());
        if (this.passedParameter.containsKey(Deprecated.tpl)) {
            this.passedParameter.put(General.template, this.passedParameter.remove(Deprecated.tpl));
        }
        if (this.passedParameter.containsKey(Deprecated.sort)) {
            this.passedParameter.put(Sorting.sortfield, this.passedParameter.remove(Deprecated.sort));
        }
        if (this.passedParameter.containsKey(Deprecated.profile)) {
            this.passedParameter.put(General.renderer, this.passedParameter.remove(Deprecated.profile));
        }
        if ((sourceStr = this.passedParameter.get(General.source)) != null) {
            this.assetURLPath = URL.cleanUpSourceParameter(sourceStr);
            byte[] dataAsset = this.assetURLPath.getBytes(FileOperations.charsetUTF8);
            this.assetURLHash = CityHash.cityHash64(dataAsset, 0, dataAsset.length);
        }
        this.hashCode64();
    }

    public Set<Map.Entry<Parameter, String>> entrySet() {
        return this.passedParameter.entrySet();
    }

    public Type getType() {
        return this.type;
    }

    public String getAssetURLPath() {
        return this.assetURLPath;
    }

    public long getAssetURLHash() {
        return this.assetURLHash;
    }

    public boolean contains(Parameter key) {
        return this.passedParameter.containsKey(key);
    }

    public String get(Parameter key) {
        return this.passedParameter.get(key);
    }

    public String put(Parameter key, String value) {
        if (key == General.source) {
            this.assetURLPath = value = URL.cleanUpSourceParameter(value);
        }
        return this.passedParameter.put(key, value);
    }

    public long hashCode64() {
        if (this.hashCode == -1L) {
            StringBuffer sb = new StringBuffer();
            sb.append((Object)this.type);
            for (Map.Entry<Parameter, String> entry : this.passedParameter.entrySet()) {
                sb.append(entry.getKey().toString());
                sb.append(entry.getValue());
            }
            byte[] bytes = sb.toString().getBytes(FileOperations.charsetUTF8);
            this.hashCode = CityHash.cityHash64(bytes, 0, bytes.length);
        }
        return this.hashCode;
    }

    private static void fillParameterMapOld(Map<String, String[]> sourceMap, Map<Parameter, String> targetMap, Parameter[] validParameters) {
        if (sourceMap != null) {
            for (Parameter key : validParameters) {
                String value;
                String[] vals;
                String keyStr = key.toString();
                if (keyStr == null || (vals = sourceMap.get(keyStr)) == null || (value = vals[0]) == null) continue;
                targetMap.put(key, value);
            }
        }
    }

    private static void fillParameterMap(Map<String, String[]> sourceMap, Map<Parameter, String> targetMap, Parameter[] validParameters) {
        if (sourceMap != null) {
            block0: for (String sourceKey : sourceMap.keySet()) {
                String sourceKeyLower = sourceKey.toLowerCase();
                for (Parameter validKey : validParameters) {
                    if (!validKey.toString().equals(sourceKeyLower)) continue;
                    String[] vals = sourceMap.get(sourceKey);
                    String value = vals[0];
                    if (value == null) continue block0;
                    targetMap.put(validKey, value);
                    continue block0;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Parameter, String> entry : this.passedParameter.entrySet()) {
            sb.append(entry.getKey().toString());
            sb.append('=');
            sb.append(entry.getValue().toString());
            sb.append(';');
        }
        return sb.toString();
    }

    public static enum Search implements Parameter
    {
        limit,
        query,
        context;

    }

    public static enum AppInfo implements Parameter
    {
        version,
        appid;

    }

    public static enum List implements Parameter
    {
        limit,
        items,
        range,
        typefilter;

    }

    public static enum Info implements Parameter
    {

    }

    public static enum DirectoryImage implements Parameter
    {
        limit,
        delay,
        loop;

    }

    public static enum FileImage implements Parameter
    {
        dpi,
        colorspace,
        cmd,
        channel,
        initialrect,
        initialrectpix,
        preeffects,
        lefteffects,
        righteffects,
        colormode,
        overlays,
        position,
        align,
        leftinnergap,
        rightinnergap,
        leftalignment,
        rightalignment,
        leftimagecrop,
        rightimagecrop,
        color,
        mode,
        distance;

    }

    public static enum GeneralImage implements Parameter
    {
        format,
        quality,
        encoding,
        width,
        height,
        ditherer,
        quantizer,
        rect,
        top,
        left,
        right,
        bottom,
        pixelrange,
        pixeltop,
        pixelleft,
        pixelright,
        pixelbottom,
        referencewidth,
        referenceheight,
        backgroundcolor,
        maxcolors,
        effects,
        padding,
        spacing,
        rows,
        columns,
        disposition,
        save,
        savename;

    }

    public static enum Sorting implements Parameter
    {
        sortorder,
        sortcasesensitive,
        sortcountry,
        sortlanguage,
        sortmethod,
        sortfield;

    }

    private static enum Deprecated implements Parameter
    {
        tpl,
        sort,
        profile;

    }

    public static enum General implements Parameter
    {
        type,
        source,
        renderer,
        template,
        headers;

    }

    public static interface Parameter {
    }

    public static enum Type {
        IMAGE,
        DIRECTORYIMAGE,
        INFO,
        LIST,
        APPINFO,
        LICENCEINFO,
        SEARCH,
        SIMPLESEARCH,
        NONE;

    }
}

