/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import freemarker.template.Template;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TemplateAttributes {
    private final FSILogger logger;
    private String staticTypeFilter = "";
    private String staticXmlDeclaration = null;
    private String staticXmlRootNode = null;
    private String staticXmlRootNodeNS = null;
    private Escaper.EscaperType staticEscape = Escaper.EscaperType.NONE;
    private String contentType = null;
    private int readFlag = 1;
    private Set<String> allowedGroups = null;

    public TemplateAttributes(FSILogger logger, Template template) {
        this.logger = logger;
        String[] attributeNames = template.getCustomAttributeNames();
        this.extractDefinesFilter(template, attributeNames);
        this.extractAccessRestriction(template, attributeNames);
        this.extractDataSourceFlag(template, attributeNames);
    }

    private void extractDefinesFilter(Template template, String[] attributeNames) {
        for (String attrname : attributeNames) {
            Object values;
            String lowattr = attrname.trim().toLowerCase();
            if (!lowattr.equals("define") || !((values = template.getCustomAttribute(attrname)) instanceof Map)) continue;
            Map headers = (Map)values;
            for (Map.Entry header : headers.entrySet()) {
                String key = (String)header.getKey();
                if (key.equalsIgnoreCase("TypeFilter")) {
                    this.staticTypeFilter = (String)header.getValue();
                    continue;
                }
                if (key.equalsIgnoreCase("XmlDeclaration")) {
                    this.staticXmlDeclaration = (String)header.getValue();
                    continue;
                }
                if (key.equalsIgnoreCase("XmlRootNode")) {
                    this.staticXmlRootNode = (String)header.getValue();
                    continue;
                }
                if (key.equalsIgnoreCase("XmlRootNodeNS")) {
                    this.staticXmlRootNodeNS = (String)header.getValue();
                    continue;
                }
                if (key.equalsIgnoreCase("Content-Type")) {
                    this.contentType = (String)header.getValue();
                    continue;
                }
                if (!key.equalsIgnoreCase("Escape")) continue;
                try {
                    this.staticEscape = Escaper.EscaperType.valueOf(((String)header.getValue()).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(3174, header.getValue(), template.getName());
                }
            }
        }
    }

    private void extractAccessRestriction(Template template, String[] attributeNames) {
        for (String attrname : attributeNames) {
            Object values;
            String lowattr = attrname.trim().toLowerCase();
            if (!lowattr.equals("access") || !((values = template.getCustomAttribute(attrname)) instanceof Map)) continue;
            Map headers = (Map)values;
            for (Map.Entry header : headers.entrySet()) {
                String[] groups;
                if (!((String)header.getKey()).equalsIgnoreCase("allowedGroups")) continue;
                if (this.allowedGroups == null) {
                    this.allowedGroups = new HashSet<String>();
                }
                for (String group : groups = ((String)header.getValue()).split(",")) {
                    this.allowedGroups.add(group.trim());
                }
            }
        }
    }

    private void extractDataSourceFlag(Template template, String[] attributeNames) {
        for (String attrname : attributeNames) {
            Object values;
            String lowattr = attrname.trim().toLowerCase();
            if (!lowattr.equals("datasources") || !((values = template.getCustomAttribute(attrname)) instanceof Map)) continue;
            Map headers = (Map)values;
            for (Map.Entry header : headers.entrySet()) {
                String key = (String)header.getKey();
                if (key.equalsIgnoreCase("iptc")) {
                    this.readFlag |= 4;
                    continue;
                }
                if (key.equalsIgnoreCase("xmp")) {
                    this.readFlag |= 0x10;
                    continue;
                }
                if (key.equalsIgnoreCase("exif")) {
                    this.readFlag |= 8;
                    continue;
                }
                if (!key.equalsIgnoreCase("selections")) continue;
                this.readFlag |= 0x40;
            }
        }
    }

    public String getStaticTypeFilter() {
        return this.staticTypeFilter;
    }

    public Escaper.EscaperType getStaticEscape() {
        return this.staticEscape;
    }

    public String getStaticXmlDeclaration() {
        return this.staticXmlDeclaration;
    }

    public String getStaticXmlRootNode() {
        return this.staticXmlRootNode;
    }

    public String getStaticXmlRootNodeNS() {
        return this.staticXmlRootNodeNS;
    }

    public Set<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    public int getReadFlag() {
        return this.readFlag;
    }

    public void setRendererResponseContentType(RendererResponse response) {
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
    }
}

