/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.effects;

import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.imagemanipulator.area.Crop;
import com.neptunelabs.imagemanipulator.area.Emboss;
import com.neptunelabs.imagemanipulator.area.Flip;
import com.neptunelabs.imagemanipulator.area.Gaussian;
import com.neptunelabs.imagemanipulator.area.LinearGradient;
import com.neptunelabs.imagemanipulator.area.Pixelize;
import com.neptunelabs.imagemanipulator.area.perspective.PerspectiveDistortion;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.Brightness;
import com.neptunelabs.imagemanipulator.color.ChannelExchange;
import com.neptunelabs.imagemanipulator.color.ChannelLevel;
import com.neptunelabs.imagemanipulator.color.ChannelLevelTrunk;
import com.neptunelabs.imagemanipulator.color.ChannelRGBFilter;
import com.neptunelabs.imagemanipulator.color.ChannelSelect;
import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.color.ColorOverlay;
import com.neptunelabs.imagemanipulator.color.Colorize;
import com.neptunelabs.imagemanipulator.color.Desaturate;
import com.neptunelabs.imagemanipulator.color.Fill;
import com.neptunelabs.imagemanipulator.color.Gamma;
import com.neptunelabs.imagemanipulator.color.GradientMap;
import com.neptunelabs.imagemanipulator.color.HueSaturation;
import com.neptunelabs.imagemanipulator.color.Invert;
import com.neptunelabs.imagemanipulator.color.MatteColor;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.Noise;
import com.neptunelabs.imagemanipulator.color.Opaque;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.color.Posterize;
import com.neptunelabs.imagemanipulator.color.RGBMatrix;
import com.neptunelabs.imagemanipulator.color.Saturation;
import com.neptunelabs.imagemanipulator.color.Solarize;
import com.neptunelabs.imagemanipulator.color.Temperature;
import com.neptunelabs.imagemanipulator.color.Threshold;
import com.neptunelabs.imagemanipulator.color.Transparency;
import com.neptunelabs.imagemanipulator.color.WhiteBalance;
import com.neptunelabs.imagemanipulator.helper.Gradient;
import com.neptunelabs.imagemanipulator.helper.SmoothGradient;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.helper.Decode8BIM;
import com.neptunelabs.imagereader.helper.RangePixel;
import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EffectsManager {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private final Pattern effectsStringSyntax = Pattern.compile("(\\w+\\([a-zA-Z0-9,\\+\\-\\.\\:]*?\\),?)+");
    private final Pattern effectsStringPattern = Pattern.compile("(\\w+)\\(([a-zA-Z0-9,\\+\\-\\.\\:]*?)\\),?");

    public EffectsManager(FSILogger logger, ExecutorPool executorPool) {
        this.logger = logger;
        this.executorPool = executorPool;
    }

    public FSIImage applyEffects(int priority, FSIImage inputImage, byte[] selectionsRaw, String effectsString, Parameters parameters) throws IllegalArgumentException, ProcessingException {
        FSIImage result = null;
        Matcher m = this.effectsStringSyntax.matcher(effectsString);
        if (m.matches()) {
            Matcher effectsStringMatcher = this.effectsStringPattern.matcher(effectsString);
            Selection selection = null;
            while (effectsStringMatcher.find()) {
                String effectKey = effectsStringMatcher.group(1);
                String effectValue = effectsStringMatcher.group(2);
                if (effectKey.equalsIgnoreCase("Select")) {
                    selection = this.evalSelection(selection, effectValue, inputImage, selectionsRaw, parameters);
                    continue;
                }
                FSIImage currentImage = result != null ? result : inputImage;
                try {
                    result = this.applyEffect(priority, currentImage, effectKey, effectValue, parameters, selection);
                }
                catch (ProcessingException e) {
                    if (result != null) {
                        result.dispose();
                    }
                    throw e;
                }
                if (currentImage == result || currentImage == inputImage) continue;
                currentImage.dispose();
            }
        } else {
            throw new IllegalArgumentException(effectsString);
        }
        if (result == null) {
            result = inputImage;
        } else if (result != inputImage) {
            inputImage.dispose();
        }
        return result;
    }

    private Selection evalSelection(Selection prevSelection, String effectValue, FSIImage inputImage, byte[] selectionsRaw, Parameters parameters) throws NumberFormatException {
        Selection resultSelection = null;
        String[] actionSplit = effectValue.split(",", 2);
        String action = actionSplit[0];
        String cmd = actionSplit.length > 1 ? actionSplit[1] : null;
        if (action.equalsIgnoreCase("new") || action.equalsIgnoreCase("add") || action.equalsIgnoreCase("sub")) {
            if (cmd != null) {
                String[] commandPar = cmd.split(",", 2);
                String command = commandPar[0];
                if (command.equalsIgnoreCase("alpha") && commandPar.length > 0) {
                    int bankID = Integer.parseInt(commandPar[1]);
                    if (bankID < inputImage.getExtraAlphaCount()) {
                        byte[] alphaChannel = new byte[inputImage.getWidth() * inputImage.getHeight()];
                        inputImage.setPositionExtraAlpha(bankID, 0L);
                        inputImage.getSamplesExtraAlpha(bankID, alphaChannel, 0, alphaChannel.length);
                        resultSelection = new Selection(alphaChannel);
                    }
                } else if (command.equalsIgnoreCase("path") && selectionsRaw != null && commandPar.length > 0) {
                    byte[] alphaSelection;
                    int selectionID = Integer.parseInt(commandPar[1]);
                    if (parameters.contains(Parameters.GeneralImage.rect)) {
                        int targetWidth = inputImage.getWidth();
                        int targetHeight = inputImage.getHeight();
                        int fullWidth = inputImage.getWidth();
                        int fullHeight = inputImage.getHeight();
                        float[] rect = this.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.rect));
                        float offSetX = -rect[0];
                        float offSetY = -rect[1];
                        fullWidth = FastMath.ceil((float)targetWidth / rect[2]);
                        fullHeight = FastMath.ceil((float)targetHeight / rect[3]);
                        alphaSelection = Decode8BIM.drawSelection(selectionsRaw, selectionID, targetWidth, targetHeight, fullWidth, fullHeight, offSetX, offSetY);
                    } else if (parameters.contains(Parameters.GeneralImage.pixelrange)) {
                        int targetWidth = inputImage.getWidth();
                        int targetHeight = inputImage.getHeight();
                        int fullWidth = Integer.parseInt(parameters.get(Parameters.GeneralImage.referencewidth));
                        int fullHeight = Integer.parseInt(parameters.get(Parameters.GeneralImage.referenceheight));
                        String[] parts = parameters.get(Parameters.GeneralImage.pixelrange).split(",", 5);
                        float offSetX = (float)(-Integer.parseInt(parts[0])) / (float)fullWidth;
                        float offSetY = (float)(-Integer.parseInt(parts[1])) / (float)fullHeight;
                        alphaSelection = Decode8BIM.drawSelection(selectionsRaw, selectionID, targetWidth, targetHeight, fullWidth, fullHeight, offSetX, offSetY);
                    } else {
                        alphaSelection = Decode8BIM.drawSelection(selectionsRaw, selectionID, inputImage.getWidth(), inputImage.getHeight());
                    }
                    if (alphaSelection != null) {
                        resultSelection = new Selection(alphaSelection);
                    }
                } else if (command.equalsIgnoreCase("rect") && commandPar.length > 0) {
                    RangePixel effectRange;
                    String[] rangeParams = commandPar[1].split(",", 4);
                    RangeRelative rr = new RangeRelative(rangeParams);
                    if (parameters.contains(Parameters.GeneralImage.rect)) {
                        float[] rect = this.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.rect));
                        int targetWidth = inputImage.getWidth();
                        int targetHeight = inputImage.getHeight();
                        int fullWidth = FastMath.ceil((float)targetWidth / rect[2]);
                        int fullHeight = FastMath.ceil((float)targetHeight / rect[3]);
                        int targetOffsetX = FastMath.floor((float)fullWidth * rect[0]);
                        int targetOffsetY = FastMath.floor((float)fullHeight * rect[1]);
                        effectRange = RangePixel.create(rr, fullWidth, fullHeight, targetOffsetX, targetOffsetY, targetWidth, targetHeight);
                    } else if (parameters.contains(Parameters.GeneralImage.pixelrange)) {
                        int targetWidth = inputImage.getWidth();
                        int targetHeight = inputImage.getHeight();
                        int fullWidth = Integer.parseInt(parameters.get(Parameters.GeneralImage.referencewidth));
                        int fullHeight = Integer.parseInt(parameters.get(Parameters.GeneralImage.referenceheight));
                        String[] parts = parameters.get(Parameters.GeneralImage.pixelrange).split(",", 5);
                        int targetOffsetX = Integer.parseInt(parts[0]);
                        int targetOffsetY = Integer.parseInt(parts[1]);
                        effectRange = RangePixel.create(rr, fullWidth, fullHeight, targetOffsetX, targetOffsetY, targetWidth, targetHeight);
                    } else {
                        effectRange = RangePixel.create(rr, inputImage.getWidth(), inputImage.getHeight());
                    }
                    resultSelection = new Selection(effectRange);
                } else if (command.equalsIgnoreCase("pixelrange") && commandPar.length > 0) {
                    String[] rangeParams = commandPar[1].split(",", 4);
                    RangePixel effectRange = RangePixel.create(rangeParams, inputImage.getWidth(), inputImage.getHeight());
                    resultSelection = new Selection(effectRange);
                }
                if (!action.equalsIgnoreCase("new") && prevSelection != null && resultSelection != null) {
                    if (action.equalsIgnoreCase("add")) {
                        prevSelection.addSelection(resultSelection);
                    } else if (action.equalsIgnoreCase("sub")) {
                        prevSelection.subtractSelection(resultSelection);
                    }
                    resultSelection = prevSelection;
                } else if (prevSelection == null && action.equalsIgnoreCase("sub")) {
                    resultSelection = new Selection();
                }
            }
        } else if (action.equalsIgnoreCase("clear")) {
            resultSelection = new Selection();
        } else if (action.equalsIgnoreCase("invert")) {
            if (prevSelection != null) {
                prevSelection.invert();
                resultSelection = prevSelection;
            } else {
                resultSelection = new Selection();
                resultSelection.invert();
            }
        }
        return resultSelection;
    }

    private FSIImage applyEffect(int priority, FSIImage inputImage, String effectname, String parameterValue, Parameters parameters, Selection selection) throws ProcessingException {
        FSIImage outputImage = null;
        try {
            Effect effect = Effect.valueOf(effectname.toUpperCase());
            switch (effect) {
                case PIXELIZE: {
                    Pixelize pixelize = new Pixelize(this.logger, this.executorPool, priority);
                    pixelize.setSelection(selection);
                    outputImage = pixelize.transform(inputImage, Integer.parseInt(parameterValue), true);
                    break;
                }
                case BLUR: {
                    outputImage = this.applyBlurEffect(inputImage, parameterValue, priority, selection);
                    break;
                }
                case SHARPEN: {
                    outputImage = this.applySharpenEffect(inputImage, parameterValue, priority, selection);
                    break;
                }
                case GLOW: {
                    outputImage = this.applyGlowEffect(inputImage, parameterValue, priority, selection);
                    break;
                }
                case FLIP: {
                    outputImage = this.applyFlipEffect(inputImage, parameterValue, priority);
                    break;
                }
                case DISTORT: {
                    outputImage = this.applyDistortEffect(inputImage, parameterValue, priority);
                    break;
                }
                case PAD: {
                    outputImage = this.applyPadEffect(inputImage, parameterValue, parameters);
                    break;
                }
                case EMBOSS: {
                    Emboss emboss = new Emboss(this.logger, this.executorPool, priority);
                    emboss.setSelection(selection);
                    outputImage = emboss.transform(inputImage, true);
                    break;
                }
                case LINEARGRADIENT: {
                    outputImage = this.applyLinearGradient(priority, inputImage, parameterValue);
                    break;
                }
                default: {
                    outputImage = this.applyColorOperation(priority, effect, parameterValue, inputImage, selection);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            this.logger.logException(e, 3152, effectname, parameters, e.getLocalizedMessage());
            outputImage = inputImage;
        }
        catch (IllegalArgumentException e) {
            this.logger.logException(e, 3153, effectname, parameters, e.getLocalizedMessage());
            outputImage = inputImage;
        }
        catch (ImageManipulatorException e) {
            this.logger.logException(e, 3153, effectname, parameters, e.getLocalizedMessage());
            outputImage = inputImage;
        }
        return outputImage;
    }

    private FSIImage applyBlurEffect(FSIImage inputImage, String parameterValue, int priority, Selection selection) throws ProcessingException {
        int blurValue = Integer.parseInt(parameterValue);
        if (blurValue <= 0 || blurValue > 100) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.logger, this.executorPool, priority);
        gaussian.setSelection(selection);
        return gaussian.transform(inputImage, blurValue, 0.0f, -20, 0.0f, true);
    }

    private FSIImage applySharpenEffect(FSIImage inputImage, String parameterValue, int priority, Selection selection) throws ProcessingException {
        float sharpenValue = Float.parseFloat(parameterValue);
        if (sharpenValue <= 0.0f || sharpenValue > 100.0f) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.logger, this.executorPool, priority);
        gaussian.setSelection(selection);
        return gaussian.transform(inputImage, 5, sharpenValue, 0, 0.0f, true);
    }

    private FSIImage applyColorOperation(int priority, Effect effect, String parameters, FSIImage input, Selection selection) throws IllegalArgumentException, ProcessingException {
        ColorOperatorImpl operator;
        switch (effect) {
            case SEPIA: {
                operator = this.getRGBMatrixOperator("0.393,0.769,0.189,0.349,0.686,0.168,0.272,0.534,0.131");
                break;
            }
            case SOLARIZE: {
                operator = new Solarize();
                break;
            }
            case POSTERIZE: {
                operator = new Posterize(Integer.parseInt(parameters));
                break;
            }
            case SATURATION: {
                operator = new Saturation(parameters);
                break;
            }
            case TEMPERATURE: {
                operator = new Temperature(Integer.parseInt(parameters));
                break;
            }
            case UNFINISHED_WHITEBALANCE: {
                operator = this.getWhiteBalanceOperator(parameters);
                break;
            }
            case CHANNELSELECT: {
                operator = new ChannelSelect(parameters);
                break;
            }
            case CHANNELLEVELTRUNK: {
                operator = this.getChannelLevelTrunkOperator(parameters);
                break;
            }
            case DESATURATE: {
                operator = new Desaturate(parameters);
                break;
            }
            case GAMMA: {
                operator = this.getGammaOperator(parameters);
                break;
            }
            case INVERT: {
                operator = new Invert(parameters);
                break;
            }
            case BRIGHTNESS: {
                operator = new Brightness(Integer.parseInt(parameters), 0);
                break;
            }
            case CONTRAST: {
                operator = new Brightness(0, Integer.parseInt(parameters));
                break;
            }
            case CHANNELEXCHANGE: {
                operator = new ChannelExchange(parameters);
                break;
            }
            case GRADIENTMAP: {
                operator = this.getGradientMapOperator(parameters);
                break;
            }
            case HSL: {
                operator = this.getHSLOperator(parameters);
                break;
            }
            case COLORIZE: {
                operator = this.getColorizeOperator(parameters);
                break;
            }
            case COLOROVERLAY: {
                operator = this.getColorOverlayOperator(parameters);
                break;
            }
            case CHANNELLEVEL: {
                operator = this.getChannelLevelOperator(parameters);
                break;
            }
            case CHANNELRGBFILTER: {
                operator = this.getChannelRGBFilterOperator(parameters);
                break;
            }
            case THRESHOLD: {
                operator = this.getThresholdOperator(parameters);
                break;
            }
            case NOISE: {
                operator = this.getNoiseOperator(parameters);
                break;
            }
            case RGBMATRIX: {
                operator = this.getRGBMatrixOperator(parameters);
                break;
            }
            case FILL: {
                operator = this.getFillOperator(parameters);
                break;
            }
            case MATTE: {
                operator = this.getMatteOperator(parameters);
                break;
            }
            case MATTECOLOR: {
                operator = this.getMatteColorOperator(parameters);
                break;
            }
            case TRANSPARENCY: {
                if (!input.hasAlpha()) {
                    input.addAlpha();
                }
                operator = this.getTransparencyEffect(parameters);
                break;
            }
            case OPAQUE: {
                operator = new Opaque();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Effect");
            }
        }
        ParallelColorOperation coloroperation = new ParallelColorOperation(this.logger, this.executorPool, priority);
        coloroperation.setSelection(selection);
        return coloroperation.transform(input, operator, true);
    }

    private Noise getNoiseOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for noise effect.");
        }
        return new Noise(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Boolean.parseBoolean(p[2]));
    }

    private RGBMatrix getRGBMatrixOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 9) {
            throw new IllegalArgumentException("Invalid parameter count for rgbmatrix effect.");
        }
        float[] matrix = new float[9];
        for (int c = 0; c < 9; ++c) {
            matrix[c] = Float.parseFloat(p[c]);
        }
        return new RGBMatrix(matrix);
    }

    private Fill getFillOperator(String parameters) {
        int argb = ColorParser.parseColor(parameters);
        boolean hasAlpha = ColorParser.hasAlpha(parameters);
        return new Fill(argb, hasAlpha);
    }

    private WhiteBalance getWhiteBalanceOperator(String parameters) {
        int argb = ColorParser.parseColor(parameters);
        return new WhiteBalance(argb);
    }

    private MatteTransparent getMatteOperator(String parameters) {
        boolean cut;
        String color;
        String[] p = parameters.split(",");
        if (p.length == 2) {
            color = p[0];
            cut = Boolean.parseBoolean(p[1]);
        } else if (p.length == 1) {
            color = parameters;
            cut = false;
        } else {
            throw new IllegalArgumentException("Invalid parameter count for matteTransparent effect.");
        }
        int argb = ColorParser.parseColor(color);
        return new MatteTransparent(argb, cut);
    }

    private MatteColor getMatteColorOperator(String parameters) {
        int argb = ColorParser.parseColor(parameters);
        return new MatteColor(argb);
    }

    private Gamma getGammaOperator(String parameters) {
        String channel;
        float gammaValue;
        String[] p = parameters.split(",");
        if (p.length > 2) {
            throw new IllegalArgumentException("Invalid parameter count for gamma effect.");
        }
        if (p.length == 1) {
            gammaValue = Float.parseFloat(parameters);
            channel = "all";
        } else {
            gammaValue = Float.parseFloat(p[0]);
            channel = p[1];
        }
        return new Gamma(gammaValue, channel);
    }

    private Threshold getThresholdOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 4) {
            throw new IllegalArgumentException("Invalid parameter count for threshold effect.");
        }
        return new Threshold(Integer.parseInt(p[0]), Integer.parseInt(p[1]), ColorParser.parseColor(p[2]), ColorParser.parseColor(p[3]));
    }

    private ColorOverlay getColorOverlayOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for color overlay effect.");
        }
        return new ColorOverlay(BlendMode.valueOf(p[0].toUpperCase()), ColorParser.parseColor(p[1]), Float.parseFloat(p[2]));
    }

    private Colorize getColorizeOperator(String parameters) {
        String[] parts = parameters.split(",");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for colorize effect.");
        }
        return new Colorize(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]), Float.parseFloat(parts[2]));
    }

    private ChannelLevel getChannelLevelOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for channel level effect.");
        }
        return new ChannelLevel(p[0], Integer.parseInt(p[1]), Integer.parseInt(p[2]));
    }

    private ChannelLevelTrunk getChannelLevelTrunkOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length != 4) {
            throw new IllegalArgumentException("Invalid parameter count for channel level trunk effect.");
        }
        return new ChannelLevelTrunk(p[0], Integer.parseInt(p[1]), Integer.parseInt(p[2]), Integer.parseInt(p[3]));
    }

    private ChannelRGBFilter getChannelRGBFilterOperator(String parameters) {
        int rgbFilter = 0;
        try {
            rgbFilter = ColorParser.parseColor(parameters);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid color parameter for channel rgb filter effect.");
        }
        return new ChannelRGBFilter(rgbFilter);
    }

    private HueSaturation getHSLOperator(String parameters) {
        String[] p = parameters.split(",");
        if (p.length < 4) {
            throw new IllegalArgumentException("Invalid parameter count for hsl effect.");
        }
        float overlap = 0.0f;
        int parLen = p.length;
        if (p.length > 4) {
            try {
                overlap = Float.parseFloat(p[p.length - 1]);
                --parLen;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] ranges = Arrays.copyOfRange(p, 3, parLen);
        return new HueSaturation(Float.parseFloat(p[0]), Float.parseFloat(p[1]), Float.parseFloat(p[2]), ranges, overlap);
    }

    private GradientMap getGradientMapOperator(String parameters) {
        String[] parts = parameters.split(",");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid parameter count for gradientmap effect.");
        }
        String mode = parts[0];
        Gradient gradient = new Gradient(this.logger);
        for (int i = 1; i < parts.length; ++i) {
            gradient.addGradientValue(ColorParser.parseColor(parts[i]));
        }
        return new GradientMap(gradient, mode);
    }

    private FSIImage applyDistortEffect(FSIImage input, String parameters, int priority) throws ProcessingException {
        String[] p = parameters.split(",");
        if (p.length != 8) {
            throw new IllegalArgumentException("Invalid parameter count for distortion effect.");
        }
        PerspectiveDistortion.FILTER filter = input.getWidth() * input.getHeight() > 250000 ? PerspectiveDistortion.FILTER.BILINEAR : PerspectiveDistortion.FILTER.BICUBIC;
        PerspectiveDistortion distortion = new PerspectiveDistortion(this.logger, this.executorPool, priority);
        return distortion.transform(input, filter, new Point2D.Float(Float.parseFloat(p[0]), Float.parseFloat(p[1])), new Point2D.Float(Float.parseFloat(p[2]), Float.parseFloat(p[3])), new Point2D.Float(Float.parseFloat(p[4]), Float.parseFloat(p[5])), new Point2D.Float(Float.parseFloat(p[6]), Float.parseFloat(p[7])), true);
    }

    private FSIImage applyGlowEffect(FSIImage input, String parameters, int priority, Selection selection) throws ProcessingException {
        int f;
        try {
            f = Integer.parseInt(parameters);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Effect parameter value invalid.");
        }
        if (f < 0 || f > 100) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.logger, this.executorPool, priority);
        gaussian.setSelection(selection);
        return gaussian.transform(input, f / 2, 0.0f, 0, (float)f * 2.5f, true);
    }

    private FSIImage applyFlipEffect(FSIImage input, String parameters, int priority) {
        int direction = -1;
        if (parameters.equalsIgnoreCase("horizontal")) {
            direction = 0;
        } else if (parameters.equalsIgnoreCase("vertical")) {
            direction = 1;
        } else {
            throw new IllegalArgumentException("Invalid parameter for flip.");
        }
        Flip flip = new Flip(this.logger, this.executorPool, priority);
        return flip.transform(input, direction, true);
    }

    private FSIImage applyPadEffect(FSIImage input, String parameterValue, Parameters parameters) {
        FSIImage result;
        String[] p = parameterValue.split(",");
        if (p.length < 2) {
            throw new IllegalArgumentException("Invalid parameter count for distortion effect.");
        }
        Crop.CropPadPosition position = Crop.CropPadPosition.valueOf(p[0].toUpperCase());
        int padcolor = ColorParser.parseColor(p[1]);
        if (parameters.contains(Parameters.GeneralImage.width) && parameters.contains(Parameters.GeneralImage.height)) {
            int requestedWidth = Integer.parseInt(parameters.get(Parameters.GeneralImage.width));
            int requestedHeight = Integer.parseInt(parameters.get(Parameters.GeneralImage.height));
            result = input.getWidth() != requestedWidth || input.getHeight() != requestedHeight ? Crop.transform(input, 0, 0, requestedWidth, requestedHeight, padcolor, position, 0.0f, 0.0f, true) : input;
        } else {
            result = input;
        }
        return result;
    }

    private FSIImage applyLinearGradient(int priority, FSIImage input, String parameters) throws ProcessingException {
        FSIImage result = null;
        String[] p = parameters.split(",");
        if (p.length < 7) {
            throw new IllegalArgumentException("Invalid parameter count for linear gradient effect.");
        }
        try {
            Float startX = Float.valueOf(p[0]);
            Float startY = Float.valueOf(p[1]);
            Float stopX = Float.valueOf(p[2]);
            Float stopY = Float.valueOf(p[3]);
            if (startX.floatValue() < 0.0f || startX.floatValue() > 1.0f || startY.floatValue() < 0.0f || startY.floatValue() > 1.0f || stopX.floatValue() < 0.0f || stopX.floatValue() > 1.0f || stopY.floatValue() < 0.0f || stopY.floatValue() > 1.0f) {
                throw new IllegalArgumentException("Parameter start|stop out of range for linear gradient effect.");
            }
            Point2D.Float start = new Point2D.Float(startX.floatValue(), startY.floatValue());
            Point2D.Float stop = new Point2D.Float(stopX.floatValue(), stopY.floatValue());
            BlendMode blendmode = BlendMode.valueOf(p[4].toUpperCase());
            Float opacity = Float.valueOf(p[5]);
            if (opacity.floatValue() < 0.0f || opacity.floatValue() > 100.0f) {
                throw new IllegalArgumentException("Parameter opacity out of range for linear gradient effect.");
            }
            SmoothGradient gradient = new SmoothGradient(this.logger);
            for (int c = 6; c < p.length; ++c) {
                String[] q = p[c].split(":", 2);
                Float gPos = Float.valueOf(q[0]);
                if (gPos.floatValue() < 0.0f || gPos.floatValue() > 1.0f) {
                    throw new IllegalArgumentException("Parameter for gradient position out of range for linear gradient effect.");
                }
                int gColor = ColorParser.parseColor(q[1]);
                gradient.putGradientValue(gPos.floatValue(), gColor);
            }
            LinearGradient linearGradient = new LinearGradient(this.logger, this.executorPool, priority);
            result = linearGradient.transform(input, gradient, start, stop, blendmode, AlphaMode.NORMAL, opacity.floatValue(), true);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid parameter value for linear gradient effect.");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid parameter value for linear gradient effect.");
        }
        return result;
    }

    private ColorOperatorImpl getTransparencyEffect(String parameters) {
        Transparency t = new Transparency(Integer.parseInt(parameters));
        return t;
    }

    private float[] parseRangeParameterValue(String parameterValue) {
        float[] result = new float[4];
        if (parameterValue != null) {
            String[] parts = parameterValue.split(",", 5);
            result[0] = FloatingParser.parseFloat(parts[0]);
            result[1] = FloatingParser.parseFloat(parts[1]);
            result[2] = FloatingParser.parseFloat(parts[2]);
            result[3] = FloatingParser.parseFloat(parts[3]);
        } else {
            result[0] = 0.0f;
            result[1] = 0.0f;
            result[2] = 1.0f;
            result[3] = 1.0f;
        }
        return result;
    }

    private static enum Effect {
        PIXELIZE,
        BLUR,
        SHARPEN,
        GLOW,
        FLIP,
        MATTE,
        MATTECOLOR,
        BRIGHTNESS,
        CONTRAST,
        CHANNELEXCHANGE,
        COLORIZE,
        FILL,
        DESATURATE,
        GAMMA,
        HSL,
        INVERT,
        COLOROVERLAY,
        CHANNELSELECT,
        CHANNELLEVEL,
        CHANNELLEVELTRUNK,
        CHANNELRGBFILTER,
        POSTERIZE,
        THRESHOLD,
        TRANSPARENCY,
        OPAQUE,
        NOISE,
        SEPIA,
        SOLARIZE,
        GRADIENTMAP,
        DISTORT,
        PAD,
        EMBOSS,
        LINEARGRADIENT,
        SATURATION,
        TEMPERATURE,
        RGBMATRIX,
        UNFINISHED_WHITEBALANCE;

    }
}

