/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.filters;

import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.HeadersReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class CorsFilter
implements Filter {
    private boolean initialized = false;
    private ServletContext context;
    private RequestProcessorSettings settings = null;
    private String token = null;
    private HeadersReader headers = null;
    private final Collection<String> allowedOrigins = new HashSet<String>();
    private boolean anyOriginAllowed;
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean decorateRequest;
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String REQUEST_HEADER_ORIGIN = "Origin";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HTTP_REQUEST_ATTRIBUTE_PREFIX = "cors.";
    private static final String HTTP_REQUEST_ATTRIBUTE_ORIGIN = "cors.request.origin";
    private static final String HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST = "cors.isCorsRequest";
    private static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE = "cors.request.type";
    private static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS = "cors.request.headers";
    private static final Collection<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain"));

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    private void postInit() throws ServletException {
        this.parseAndStore();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.initialized) {
            String requestprocessortoken;
            if (this.headers == null) {
                this.headers = (HeadersReader)this.context.getAttribute("headers");
            }
            if ((requestprocessortoken = (String)this.context.getAttribute("requestprocessortoken")) != null) {
                this.token = requestprocessortoken;
            }
            if (this.settings == null) {
                MainProcessor engine = (MainProcessor)this.context.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
                this.settings = engine.getRequestProcessorSettings();
            }
            if (this.settings != null) {
                this.postInit();
                this.initialized = true;
            }
        }
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("CORS doesn't support non-HTTP request or response");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        this.handleToken(request, response);
        CORSRequestType requestType = this.checkRequestType(request);
        if (this.decorateRequest) {
            CorsFilter.decorateCORSProperties(request, requestType);
        }
        switch (requestType) {
            case SIMPLE: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case ACTUAL: {
                this.handleSimpleCORS(request, response, filterChain);
                break;
            }
            case PRE_FLIGHT: {
                this.handlePreflightCORS(request, response, filterChain);
                break;
            }
            case NOT_CORS: {
                this.handleNonCORS(request, response, filterChain);
                break;
            }
            default: {
                this.handleInvalidCORS(request, response, filterChain);
            }
        }
    }

    private void handleToken(HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> customHeaders;
        String headersParam = request.getParameter("headers");
        if (headersParam != null && this.headers != null && (customHeaders = this.headers.getHeaderSet(headersParam)) != null) {
            for (Map.Entry<String, String> ch : customHeaders.entrySet()) {
                response.setHeader(ch.getKey(), ch.getValue());
            }
        }
        if (this.token != null) {
            response.setHeader("X-Software", this.token);
        }
    }

    private void handleSimpleCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.SIMPLE && requestType != CORSRequestType.ACTUAL) {
            throw new IllegalArgumentException("Expects a HttpServletRequest object of type SIMPLE or ACTUAL");
        }
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        if (!this.isOriginAllowed(origin)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (!this.allowedHttpMethods.contains(method)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (this.anyOriginAllowed && !this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (this.exposedHeaders != null && this.exposedHeaders.size() > 0) {
            String exposedHeadersString = CorsFilter.join(this.exposedHeaders, ",");
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, exposedHeadersString);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handlePreflightCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException("Expects a HttpServletRequest object of type " + CORSRequestType.PRE_FLIGHT.name().toLowerCase(Locale.ENGLISH));
        }
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (!this.isOriginAllowed(origin)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        String accessControlRequestMethod = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (accessControlRequestMethod == null) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        accessControlRequestMethod = accessControlRequestMethod.trim();
        String accessControlRequestHeadersHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        LinkedList<String> accessControlRequestHeaders = new LinkedList<String>();
        if (accessControlRequestHeadersHeader != null && !accessControlRequestHeadersHeader.trim().isEmpty()) {
            String[] headers;
            for (String header : headers = accessControlRequestHeadersHeader.trim().split(",")) {
                accessControlRequestHeaders.add(header.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        if (!this.allowedHttpMethods.contains(accessControlRequestMethod)) {
            this.handleInvalidCORS(request, response, filterChain);
            return;
        }
        if (!accessControlRequestHeaders.isEmpty()) {
            for (String header : accessControlRequestHeaders) {
                if (this.allowedHttpHeaders.contains(header)) continue;
                this.handleInvalidCORS(request, response, filterChain);
                return;
            }
        }
        if (this.supportsCredentials) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else if (this.anyOriginAllowed) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        if (this.preflightMaxAge > 0L) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(this.preflightMaxAge));
        }
        response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, accessControlRequestMethod);
        if (this.allowedHttpHeaders != null && !this.allowedHttpHeaders.isEmpty()) {
            response.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CorsFilter.join(this.allowedHttpHeaders, ","));
        }
    }

    private void handleNonCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handleInvalidCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
    }

    public void destroy() {
    }

    private static void decorateCORSProperties(HttpServletRequest request, CORSRequestType corsRequestType) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        if (corsRequestType == null) {
            throw new IllegalArgumentException("CORSRequestType object is null");
        }
        switch (corsRequestType) {
            case SIMPLE: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase(Locale.ENGLISH));
                break;
            }
            case ACTUAL: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase(Locale.ENGLISH));
                break;
            }
            case PRE_FLIGHT: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)request.getHeader(REQUEST_HEADER_ORIGIN));
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)corsRequestType.name().toLowerCase(Locale.ENGLISH));
                String headers = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
                if (headers == null) {
                    headers = "";
                }
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS, (Object)headers);
                break;
            }
            case NOT_CORS: {
                request.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.FALSE);
                break;
            }
        }
    }

    private static String join(Collection<String> elements, String joinSeparator) {
        String separator = ",";
        if (elements == null) {
            return null;
        }
        if (joinSeparator != null) {
            separator = joinSeparator;
        }
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (String element : elements) {
            if (!isFirst) {
                buffer.append(separator);
            } else {
                isFirst = false;
            }
            if (element == null) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    private CORSRequestType checkRequestType(HttpServletRequest request) {
        CORSRequestType requestType = CORSRequestType.INVALID_CORS;
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        String originHeader = request.getHeader(REQUEST_HEADER_ORIGIN);
        if (originHeader != null) {
            if (originHeader.isEmpty()) {
                requestType = CORSRequestType.INVALID_CORS;
            } else if (!CorsFilter.isValidOrigin(originHeader)) {
                requestType = CORSRequestType.INVALID_CORS;
            } else {
                if (this.isLocalOrigin(request, originHeader)) {
                    return CORSRequestType.NOT_CORS;
                }
                String method = request.getMethod();
                if (method != null) {
                    if ("OPTIONS".equals(method)) {
                        String accessControlRequestMethodHeader = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
                        requestType = accessControlRequestMethodHeader != null && !accessControlRequestMethodHeader.isEmpty() ? CORSRequestType.PRE_FLIGHT : (accessControlRequestMethodHeader != null && accessControlRequestMethodHeader.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.ACTUAL);
                    } else if ("GET".equals(method) || "HEAD".equals(method)) {
                        requestType = CORSRequestType.SIMPLE;
                    } else if ("POST".equals(method)) {
                        String mediaType = this.getMediaType(request.getContentType());
                        if (mediaType != null) {
                            requestType = SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(mediaType) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
                        }
                    } else {
                        requestType = CORSRequestType.ACTUAL;
                    }
                }
            }
        } else {
            requestType = CORSRequestType.NOT_CORS;
        }
        return requestType;
    }

    private boolean isLocalOrigin(HttpServletRequest request, String origin) {
        StringBuilder target = new StringBuilder();
        String scheme = request.getScheme();
        if (scheme == null) {
            return false;
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        target.append(scheme);
        target.append("://");
        String host = request.getServerName();
        if (host == null) {
            return false;
        }
        target.append(host);
        int port = request.getServerPort();
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            target.append(':');
            target.append(port);
        }
        return origin.equalsIgnoreCase(target.toString());
    }

    private String getMediaType(String contentType) {
        if (contentType == null) {
            return null;
        }
        String result = contentType.toLowerCase(Locale.ENGLISH);
        int firstSemiColonIndex = result.indexOf(59);
        if (firstSemiColonIndex > -1) {
            result = result.substring(0, firstSemiColonIndex);
        }
        result = result.trim();
        return result;
    }

    private boolean isOriginAllowed(String origin) {
        if (this.anyOriginAllowed) {
            return true;
        }
        return this.allowedOrigins.contains(origin);
    }

    private void parseAndStore() throws ServletException {
        String decorateRequestVal;
        String preflightMaxAgeVal;
        String supportsCredentialsVal;
        String exposedHeadersVal;
        String allowedHttpHeadersVal;
        String allowedHttpMethodsVal;
        String allowedOriginsVal = this.settings.getPrefsString("application", "corsAllowedOrigins");
        if (allowedOriginsVal != null) {
            if (allowedOriginsVal.trim().equals("*")) {
                this.anyOriginAllowed = true;
            } else {
                this.anyOriginAllowed = false;
                Set<String> setAllowedOrigins = this.parseStringToSet(allowedOriginsVal);
                this.allowedOrigins.clear();
                this.allowedOrigins.addAll(setAllowedOrigins);
            }
        }
        if ((allowedHttpMethodsVal = this.settings.getPrefsString("application", "corsAllowedMethods")) != null) {
            Set<String> setAllowedHttpMethods = this.parseStringToSet(allowedHttpMethodsVal);
            this.allowedHttpMethods.clear();
            this.allowedHttpMethods.addAll(setAllowedHttpMethods);
        }
        if ((allowedHttpHeadersVal = this.settings.getPrefsString("application", "corsAllowedHeaders")) != null) {
            Set<String> setAllowedHttpHeaders = this.parseStringToSet(allowedHttpHeadersVal);
            HashSet<String> lowerCaseHeaders = new HashSet<String>();
            for (String header : setAllowedHttpHeaders) {
                String lowerCase = header.toLowerCase(Locale.ENGLISH);
                lowerCaseHeaders.add(lowerCase);
            }
            this.allowedHttpHeaders.clear();
            this.allowedHttpHeaders.addAll(lowerCaseHeaders);
        }
        if ((exposedHeadersVal = this.settings.getPrefsString("application", "corsExposedHeaders")) != null) {
            Set<String> setExposedHeaders = this.parseStringToSet(exposedHeadersVal);
            this.exposedHeaders.clear();
            this.exposedHeaders.addAll(setExposedHeaders);
        }
        if ((supportsCredentialsVal = this.settings.getPrefsString("application", "corsSupportCredentials")) != null) {
            this.supportsCredentials = Boolean.parseBoolean(supportsCredentialsVal);
        }
        if ((preflightMaxAgeVal = this.settings.getPrefsString("application", "corsPreflightMaxage")) != null) {
            try {
                this.preflightMaxAge = !preflightMaxAgeVal.isEmpty() ? Long.parseLong(preflightMaxAgeVal) : 0L;
            }
            catch (NumberFormatException e) {
                throw new ServletException("Unable to parse preflightMaxAge", (Throwable)e);
            }
        }
        if ((decorateRequestVal = this.settings.getPrefsString("application", "corsRequestDecorate")) != null) {
            this.decorateRequest = Boolean.parseBoolean(decorateRequestVal);
        }
    }

    private Set<String> parseStringToSet(String data) {
        String[] splits = data != null && data.length() > 0 ? data.split(",") : new String[]{};
        HashSet<String> set = new HashSet<String>();
        if (splits.length > 0) {
            for (String split : splits) {
                set.add(split.trim());
            }
        }
        return set;
    }

    private static boolean isValidOrigin(String origin) {
        URI originURI;
        if (origin.contains("%")) {
            return false;
        }
        if ("null".equals(origin)) {
            return true;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }

    private static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

