/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.filters;

import com.neptunelabs.fsiservletframework.servletfilters.GZipResponseWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class InterfaceFilter
implements Filter {
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\/interface\\/v[\\d\\.]*\\/", 2);
    private ServletContext context;
    private String token = null;

    public InterfaceFilter(ServletContext context) {
        this.context = context;
    }

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI;
        String requestprocessortoken;
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        if (this.token == null && (requestprocessortoken = (String)this.context.getAttribute("requestprocessortoken")) != null) {
            this.token = requestprocessortoken;
        }
        if (this.token != null) {
            httpresponse.setHeader("X-Software", this.token);
        }
        if ((requestURI = httprequest.getRequestURI()).endsWith("/") || requestURI.endsWith("index.html") || requestURI.endsWith("config.js") || requestURI.endsWith("js/base.js") || requestURI.endsWith("pictureview.html")) {
            httpresponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        } else {
            httpresponse.setHeader("Cache-Control", "public, max-age=604800");
        }
        if (requestURI.endsWith("/") || requestURI.endsWith("index.html")) {
            httpresponse.setHeader("Content-Type", "text/html; charset=UTF-8");
        }
        GZipResponseWrapper.CompressionType compressionType = InterfaceFilter.getCompressionEncoding(httprequest);
        boolean supported = InterfaceFilter.isSupportedContentType(httprequest);
        httpresponse.setHeader("Vary", "Accept-Encoding");
        if (supported && compressionType != GZipResponseWrapper.CompressionType.NONE) {
            Path reqFile = Paths.get(InterfaceFilter.stripVersionNumberFromInterfacePath(httprequest.getServletPath()), new String[0]);
            GZipResponseWrapper wrappedResponse = new GZipResponseWrapper(httpresponse, reqFile, compressionType, 300000, true);
            chain.doFilter((ServletRequest)new VersionPathRequest(httprequest), (ServletResponse)wrappedResponse);
            wrappedResponse.finishResponse();
        } else {
            String strippedInterfacePath = InterfaceFilter.stripVersionNumberFromInterfacePath(httprequest.getServletPath());
            httprequest.getRequestDispatcher(strippedInterfacePath).forward((ServletRequest)httprequest, (ServletResponse)httpresponse);
        }
    }

    private static String stripVersionNumberFromInterfacePath(String input) {
        Matcher matcher = VERSION_PATTERN.matcher(input);
        String output = matcher.replaceAll("/interface/");
        return output;
    }

    public void destroy() {
    }

    private static GZipResponseWrapper.CompressionType getCompressionEncoding(HttpServletRequest request) {
        GZipResponseWrapper.CompressionType result = GZipResponseWrapper.CompressionType.NONE;
        Enumeration acceptEncodingEnum = request.getHeaders("Accept-Encoding");
        while (acceptEncodingEnum.hasMoreElements()) {
            String[] encodings;
            String rawEncoding = (String)acceptEncodingEnum.nextElement();
            for (String encoding : encodings = rawEncoding.split(",")) {
                if (encoding.equalsIgnoreCase("gzip")) {
                    result = GZipResponseWrapper.CompressionType.GZIP;
                    break;
                }
                if (!encoding.equalsIgnoreCase("deflate")) continue;
                result = GZipResponseWrapper.CompressionType.DEFLATE;
                break;
            }
            if (result == GZipResponseWrapper.CompressionType.NONE) continue;
            break;
        }
        return result;
    }

    private static boolean isSupportedContentType(HttpServletRequest request) {
        boolean result = false;
        String filepath = request.getServletPath();
        if (filepath != null && (filepath.endsWith("js") || filepath.endsWith("html") || filepath.endsWith("json") || filepath.endsWith("css") || filepath.endsWith("xml"))) {
            result = true;
        }
        return result;
    }

    private class VersionPathRequest
    extends HttpServletRequestWrapper {
        public VersionPathRequest(HttpServletRequest request) {
            super(request);
        }

        public String getServletPath() {
            String orgPath = super.getServletPath();
            return InterfaceFilter.stripVersionNumberFromInterfacePath(orgPath);
        }
    }
}

