/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.filters;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestFilter
implements Filter {
    private boolean initialized = false;
    private boolean cacheResponses = false;
    private ServletContext context;
    private MainProcessor engine = null;
    private SystemMonitor sysmon = null;
    private CacheManager cacheManager = null;
    private String token = null;
    private AtomicInteger concurrentRequests = new AtomicInteger(0);
    private static final int CHUNKLENGTH = 8192;

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.initialized) {
            String requestprocessortoken;
            if (this.engine == null) {
                this.engine = (MainProcessor)this.context.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
            }
            if (this.token == null && (requestprocessortoken = (String)this.context.getAttribute("requestprocessortoken")) != null) {
                this.token = requestprocessortoken;
            }
            if (this.sysmon == null) {
                this.sysmon = (SystemMonitor)this.context.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
            }
            if (this.cacheManager == null) {
                this.cacheManager = this.engine.getRequestProcessorSettings().getCacheManager();
                this.cacheResponses = this.cacheManager.cacheReponses();
            }
            this.initialized = true;
        }
        long startTime = System.currentTimeMillis();
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        if (!this.engine.acceptsRequests()) {
            this.engine.writeInitErrorResponse((HttpServletResponse)response);
            return;
        }
        try {
            this.sysmon.setConcurrentRequests(this.concurrentRequests.incrementAndGet());
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
            Parameters parameters = new Parameters(httprequest);
            httprequest.setAttribute("parameters", (Object)parameters);
            httpresponse.setHeader("X-Software", this.token);
            CacheableHttpServletResponse cachedResponse = null;
            boolean notModified = false;
            if (this.cacheResponses) {
                CacheLoad cl;
                String query;
                String assetURLPath = httprequest.getParameter("source");
                CacheKey cacheKey = assetURLPath != null ? ((query = httprequest.getQueryString()) != null ? this.engine.calculateRequestCacheKey(assetURLPath, parameters, httprequest.getSession(false), httprequest.getMethod()) : null) : null;
                if (cacheKey != null && (cl = this.cacheManager.get(cacheKey, CacheType.RESPONSE)) != null) {
                    cachedResponse = cl.requestedL1Object != null ? (CacheableHttpServletResponse)cl.requestedL1Object : CacheableHttpServletResponse.unpack(cl.data, httpresponse);
                }
                Enumeration headerNameEnumeration = httprequest.getHeaderNames();
                HashSet headerNames = new HashSet();
                while (headerNameEnumeration.hasMoreElements()) {
                    headerNames.add(headerNameEnumeration.nextElement());
                }
                if (cachedResponse != null && cachedResponse.getStatus() == 304 && !headerNames.contains("If-Modified-Since") && !headerNames.contains("If-None-Match")) {
                    cachedResponse = null;
                }
                if (headerNames.contains("If-Modified-Since")) {
                    long imsRound;
                    try {
                        imsRound = httprequest.getDateHeader("If-Modified-Since");
                        if (imsRound > 0L) {
                            imsRound = imsRound / 1000L * 1000L;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        imsRound = 0L;
                    }
                    if (cachedResponse != null && imsRound > 0L) {
                        if (cachedResponse.getLastModified() != imsRound) {
                            cachedResponse = null;
                        } else {
                            notModified = true;
                        }
                    }
                }
                String ifNoneMatch = httprequest.getHeader("If-None-Match");
                if (cachedResponse != null && ifNoneMatch != null && cachedResponse.getETag() != null) {
                    if (!ifNoneMatch.equals(cachedResponse.getETag().getStrongTag(cachedResponse.getAssetURLHash(), cachedResponse.getQueryHash()))) {
                        cachedResponse = null;
                    } else {
                        notModified = true;
                    }
                }
            }
            if (cachedResponse != null) {
                this.sysmon.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_CACHE);
                if (notModified) {
                    this.transferCachedHeader(cachedResponse, (HttpServletResponse)response, false);
                    httpresponse.sendError(304);
                    this.sysmon.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_304);
                } else {
                    this.transferCachedHeader(cachedResponse, (HttpServletResponse)response, true);
                    boolean isHeadRequest = httprequest.getMethod() != null && httprequest.getMethod().equals("HEAD");
                    long runtime = System.currentTimeMillis() - startTime;
                    this.sysmon.setTTFB(runtime);
                    int traffic = this.transferCachedData(cachedResponse, (HttpServletResponse)response, isHeadRequest);
                    this.sysmon.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_200);
                    this.sysmon.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_CACHE, traffic);
                }
            } else {
                httprequest.getRequestDispatcher(httprequest.getServletPath()).forward((ServletRequest)httprequest, (ServletResponse)httpresponse);
            }
            this.sysmon.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_ALL);
            this.sysmon.setTTLB(System.currentTimeMillis() - startTime);
        }
        catch (IllegalArgumentException e) {
            httpresponse.setStatus(400);
        }
        finally {
            if (this.sysmon != null) {
                this.sysmon.setConcurrentRequests(this.concurrentRequests.decrementAndGet());
            }
        }
    }

    public void destroy() {
    }

    private int transferCachedData(CacheableHttpServletResponse cachedResponse, HttpServletResponse response, boolean headRequest) throws IOException {
        int transferedBytes = 0;
        if (!headRequest && cachedResponse.getContent() != null) {
            try (ServletOutputStream os = response.getOutputStream();){
                byte[] content = cachedResponse.getContent();
                int chunkes = (int)Math.ceil((float)content.length / 8192.0f);
                for (int c = 0; c < chunkes; ++c) {
                    int len = c + 1 == chunkes ? content.length - c * 8192 : 8192;
                    try {
                        os.write(content, c * 8192, len);
                    }
                    catch (IOException e) {
                        break;
                    }
                    transferedBytes += len;
                }
            }
        }
        return transferedBytes;
    }

    private void transferCachedHeader(CacheableHttpServletResponse cachedResponse, HttpServletResponse response, boolean setLengthHeader) {
        if (cachedResponse.getDateHeaderMap().size() > 0) {
            for (Map.Entry<String, Long> entry : cachedResponse.getDateHeaderMap().entrySet()) {
                response.setDateHeader(entry.getKey(), entry.getValue().longValue());
            }
        }
        if (cachedResponse.getHeaderMap().size() > 0) {
            for (Map.Entry<String, Object> entry : cachedResponse.getHeaderMap().entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("X-")) continue;
                response.setHeader(key, (String)entry.getValue());
            }
        }
        if (setLengthHeader && cachedResponse.getContentLength() > 0) {
            response.setContentLength(cachedResponse.getContentLength());
        }
        if (cachedResponse.getContentType() != null) {
            response.setContentType(cachedResponse.getContentType());
        }
        if (cachedResponse.getEncoding() != null) {
            response.setCharacterEncoding(cachedResponse.getEncoding());
        }
    }
}

