/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.security.Base64;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.gif.GIFEncoder;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;

public class GIFCompressor
extends OutputCompressor {
    public GIFCompressor(RequestProcessorSettings settings) {
        super(settings);
        this.multiImageSupport = true;
    }

    @Override
    public OutputCompressorResponse compressImageData(int priority, FSIImage image, Renderer renderer, Parameters parameters, String copyrightNotice) {
        FSIImage[] imageArray = new FSIImage[]{image};
        return this.compressImageData(priority, imageArray, renderer, parameters, copyrightNotice);
    }

    @Override
    public OutputCompressorResponse compressImageData(int priority, FSIImage[] images, Renderer renderer, Parameters parameters, String copyrightNotice) {
        OutputCompressorResponse response = new OutputCompressorResponse();
        StringBuilder eTagModifier = new StringBuilder("GIF");
        OutputParameters configParameters = renderer.getOutputParameters();
        GIFEncoder encoder = new GIFEncoder(this.settings.getFSILogger(), this.settings.getExecutorPool(), priority);
        encoder.setCopyright(copyrightNotice);
        encoder.setSoftware(SoftwareVersion.getSoftware(false));
        encoder.setPalette(ImageEncoderUtils.PaletteMode.EUCLIDEANSQUARERGB);
        encoder.setMatteColor(this.getParameterBackgroundColor(parameters, configParameters));
        encoder.setMaxColors(this.getParameterMaxColors(parameters, configParameters));
        encoder.setDitherer(this.getParameterDithererMode(parameters, configParameters));
        encoder.setQuantizer(this.getParameterQuantizerMode(parameters, configParameters));
        encoder.setQuantizerSampleDepth(configParameters.quantizerSampleDepth);
        if (images.length == 1) {
            encoder.setImage(images[0]);
        } else {
            encoder.setAnimationDelay(this.getParameterDelay(parameters, configParameters));
            encoder.setAnimationFramePalette(configParameters.gifFramePalette);
            encoder.setAnimationLoop(this.getParameterLoop(parameters, configParameters));
            for (FSIImage image : images) {
                encoder.addImage(image);
            }
        }
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(1024);){
            encoder.setOutputStream(baos);
            encoder.encode();
            encoder.dispose();
            OutputParameters.Encoding encoding = this.getEncodingFromRequestParameters(parameters);
            if (encoding == OutputParameters.Encoding.UNSET) {
                encoding = configParameters.encoding;
            }
            if (encoding == OutputParameters.Encoding.BASE64) {
                response.setMimeType("text/plain");
                response.setImageData(Base64.encodeToByte(baos.toByteArray(), false));
                eTagModifier.append("b64");
            } else {
                response.setMimeType("image/gif");
                response.setImageData(baos.toByteArray());
            }
            response.setETagModifer(eTagModifier.toString());
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().log(3040, ioe.getLocalizedMessage());
            response.setError(true);
        }
        return response;
    }
}

