/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.security.Base64;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGEncoder;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class JPEGCompressor
extends OutputCompressor {
    public JPEGCompressor(RequestProcessorSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputCompressorResponse compressImageData(int priority, FSIImage image, Renderer renderer, Parameters parameters, String copyrightNotice) {
        OutputParameters configParameters = renderer.getOutputParameters();
        OutputCompressorResponse response = new OutputCompressorResponse();
        int q = configParameters.quality;
        int qual = this.getQualityFromRequestParameters(parameters);
        if (qual != -1) {
            q = qual;
        }
        if (q < 0) {
            q = 0;
        } else if (q > 100) {
            q = 100;
        }
        boolean error = false;
        int dpi = this.getParameterDPI(parameters, configParameters);
        boolean embedICC = configParameters.embedicc;
        String cacheKey = Integer.toString(q) + configParameters.optimizeHuffman + configParameters.chromaSubsampling.toString() + copyrightNotice + dpi + embedICC;
        JPEGPreparation jpegPrep = (JPEGPreparation)this.jpegCache.get(cacheKey);
        if (jpegPrep == null) {
            byte[] iccData = embedICC ? this.sRGBICCData : null;
            try {
                jpegPrep = new JPEGPreparation((float)q / 100.0f, configParameters.optimizeHuffman, configParameters.chromaSubsampling, SoftwareVersion.getSoftware(false), copyrightNotice, dpi, iccData, true);
                this.jpegCache.put(cacheKey, jpegPrep);
            }
            catch (UnsupportedEncodingException e) {
                error = true;
            }
        }
        if (!error) {
            JPEGEncoder encoder = new JPEGEncoder(this.settings.getFSILogger(), jpegPrep);
            try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(1024);){
                try (MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(baos);){
                    encoder.setImage(image);
                    encoder.setImageOutputStream(mcios);
                    encoder.encode();
                }
                OutputParameters.Encoding encoding = this.getEncodingFromRequestParameters(parameters);
                if (encoding == OutputParameters.Encoding.UNSET) {
                    encoding = configParameters.encoding;
                }
                if (encoding == OutputParameters.Encoding.BASE64) {
                    response.setMimeType("text/plain");
                    response.setImageData(Base64.encodeToByte(baos.toByteArray(), false));
                    response.setETagModifer("JPG" + cacheKey + "b64");
                }
                response.setMimeType("image/jpeg");
                response.setImageData(baos.toByteArray());
                response.setETagModifer("JPG" + cacheKey);
            }
            catch (IOException ioe) {
                this.settings.getFSILogger().logException(ioe, 3040, ioe.getLocalizedMessage());
                response.setError(true);
            }
            finally {
                encoder.dispose();
            }
        } else {
            response.setError(true);
        }
        return response;
    }
}

