/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.helper.ICCDefaultReader;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OutputCompressor {
    final RequestProcessorSettings settings;
    private static final String defaultICCProfile = "com/neptunelabs/imagereader/resources/defaultsRGB.icc";
    ConcurrentHashMap<String, JPEGPreparation> jpegCache = new ConcurrentHashMap();
    byte[] sRGBICCData = null;
    protected boolean multiImageSupport = false;

    OutputCompressor(RequestProcessorSettings settings) {
        this.settings = settings;
        try (InputStream iccstream2 = new ICCDefaultReader().getClass().getClassLoader().getResourceAsStream(defaultICCProfile);){
            ICC_Profile sRGBProfile = ICC_Profile.getInstance(iccstream2);
            this.sRGBICCData = sRGBProfile.getData();
        }
        catch (IOException e) {
            settings.getFSILogger().logException(e, 2060, defaultICCProfile);
        }
    }

    public abstract OutputCompressorResponse compressImageData(int var1, FSIImage var2, Renderer var3, Parameters var4, String var5);

    public OutputCompressorResponse compressImageData(int priority, FSIImage[] images, Renderer renderer, Parameters parameters, String copyrightNotice) {
        return this.compressImageData(priority, images[0], renderer, parameters, copyrightNotice);
    }

    int getQualityFromRequestParameters(Parameters parameters) {
        int result = -1;
        if (parameters.contains(Parameters.GeneralImage.quality)) {
            try {
                int requestQualityParam = Integer.valueOf(parameters.get(Parameters.GeneralImage.quality));
                if (requestQualityParam >= 0 && requestQualityParam <= 100) {
                    result = requestQualityParam;
                } else {
                    this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.quality), "quality");
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.quality), "quality");
            }
        }
        return result;
    }

    OutputParameters.Encoding getEncodingFromRequestParameters(Parameters parameters) {
        OutputParameters.Encoding result = OutputParameters.Encoding.UNSET;
        if (parameters.contains(Parameters.GeneralImage.encoding)) {
            String encodingStr = parameters.get(Parameters.GeneralImage.encoding);
            try {
                result = OutputParameters.Encoding.valueOf(encodingStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.encoding), "encoding");
            }
        }
        return result;
    }

    OutputParameters.Colorspace getColorSpaceFromRequestParameters(Parameters parameters) {
        OutputParameters.Colorspace result = OutputParameters.Colorspace.UNSET;
        if (parameters.contains(Parameters.FileImage.colorspace)) {
            try {
                result = OutputParameters.Colorspace.valueOf(parameters.get(Parameters.FileImage.colorspace).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.FileImage.colorspace), "colorspace");
            }
        }
        return result;
    }

    int getParameterMaxColors(Parameters parameters, OutputParameters configParameters) {
        int result = -1;
        if (parameters.contains(Parameters.GeneralImage.maxcolors)) {
            boolean error = false;
            try {
                int requestParam = Integer.valueOf(parameters.get(Parameters.GeneralImage.maxcolors));
                if (requestParam >= 2 && requestParam <= 256) {
                    result = requestParam;
                } else {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.maxcolors), "maxcolors");
            }
        } else if (configParameters.maxIndexedColors > 0) {
            result = configParameters.maxIndexedColors;
        }
        return result;
    }

    int getParameterDelay(Parameters parameters, OutputParameters configParameters) {
        int result = -1;
        String parmVal = parameters.get(Parameters.DirectoryImage.delay);
        if (parmVal != null) {
            boolean error = false;
            try {
                int requestParam = Integer.valueOf(parmVal);
                if (requestParam >= 0 && requestParam <= 16000) {
                    result = requestParam;
                } else {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.DirectoryImage.delay), "delay");
            }
        } else if (configParameters.gifDelay > 0) {
            result = configParameters.gifDelay;
        }
        return result;
    }

    int getParameterLoop(Parameters parameters, OutputParameters configParameters) {
        int result = -1;
        String parmVal = parameters.get(Parameters.DirectoryImage.loop);
        if (parmVal != null) {
            boolean error = false;
            try {
                int requestParam = Integer.valueOf(parmVal);
                if (requestParam >= 0 && requestParam < 65536) {
                    result = requestParam;
                } else {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.DirectoryImage.loop), "loop");
            }
        } else if (configParameters.gifLoopCount > 0) {
            result = configParameters.gifLoopCount;
        }
        return result;
    }

    int getParameterBackgroundColor(Parameters parameters, OutputParameters configParameters) {
        int result = -1;
        if (parameters.contains(Parameters.GeneralImage.backgroundcolor)) {
            boolean error = false;
            try {
                int requestParam = ColorParser.parseColor(parameters.get(Parameters.GeneralImage.backgroundcolor));
                if (requestParam != -1) {
                    result = requestParam;
                } else {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.backgroundcolor), "backgroundcolor");
            }
        } else if (configParameters.backgroundColor > -1) {
            result = configParameters.backgroundColor;
        }
        return result;
    }

    ImageEncoderUtils.DithererMode getParameterDithererMode(Parameters parameters, OutputParameters configParameters) {
        ImageEncoderUtils.DithererMode result = ImageEncoderUtils.DithererMode.FLOYDSTEINBERG;
        if (parameters.contains(Parameters.GeneralImage.ditherer)) {
            boolean error = false;
            try {
                result = ImageEncoderUtils.DithererMode.valueOf(parameters.get(Parameters.GeneralImage.ditherer).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.GeneralImage.ditherer), "ditherer");
            }
        } else {
            result = configParameters.ditherer;
        }
        return result;
    }

    ImageEncoderUtils.QuantizerMode getParameterQuantizerMode(Parameters parameters, OutputParameters configParameters) {
        ImageEncoderUtils.QuantizerMode result = ImageEncoderUtils.QuantizerMode.NEUQUANT;
        String parmVal = parameters.get(Parameters.GeneralImage.quantizer);
        if (parmVal != null) {
            boolean error = false;
            try {
                result = ImageEncoderUtils.QuantizerMode.valueOf(parmVal.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parmVal, "quantizer");
            }
        } else {
            result = configParameters.quantizer;
        }
        return result;
    }

    int getParameterDPI(Parameters parameters, OutputParameters configParameters) {
        int result = -1;
        String parmVal = parameters.get(Parameters.FileImage.dpi);
        if (parmVal != null) {
            boolean error = false;
            try {
                int requestParam = Integer.valueOf(parmVal);
                if (requestParam >= 0 && requestParam < Integer.MAX_VALUE) {
                    result = requestParam;
                } else {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                this.settings.getFSILogger().log(3042, parameters.get(Parameters.FileImage.dpi), "dpi");
            }
        } else if (configParameters.dpi > 0) {
            result = configParameters.dpi;
        }
        return result;
    }

    public boolean hasMultiImageSupport() {
        return this.multiImageSupport;
    }
}

