/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.security.Base64;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.png.PNGEncoder;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;

public class PNGCompressor
extends OutputCompressor {
    public PNGCompressor(RequestProcessorSettings settings) {
        super(settings);
    }

    @Override
    public OutputCompressorResponse compressImageData(int priority, FSIImage image, Renderer renderer, Parameters parameters, String copyrightNotice) {
        OutputCompressorResponse response = new OutputCompressorResponse();
        StringBuilder eTagModifier = new StringBuilder("PNG");
        eTagModifier.append(copyrightNotice);
        PNGEncoder encoder = new PNGEncoder(this.settings.getFSILogger(), this.settings.getExecutorPool(), priority);
        encoder.setImage(image);
        encoder.setCopyright(copyrightNotice);
        encoder.setSoftware(SoftwareVersion.getSoftware(false));
        Pair<byte[], byte[]> cChunk = image.getCustomData();
        if (cChunk != null) {
            encoder.setCustomPNGChunk(cChunk.getItem1(), cChunk.getItem2());
        }
        OutputParameters configParameters = renderer.getOutputParameters();
        if (configParameters.compressionLevel != -1) {
            encoder.setCompressionLevel(configParameters.compressionLevel);
            eTagModifier.append(configParameters.compressionLevel);
        }
        if (configParameters.compressionFilter != -1) {
            encoder.setFilter(configParameters.compressionFilter);
            eTagModifier.append(configParameters.compressionFilter);
        }
        if (configParameters.embedicc) {
            encoder.setICCProfile(this.sRGBICCData);
            eTagModifier.append("embedicc");
        }
        encoder.setPalette(ImageEncoderUtils.PaletteMode.EUCLIDEANSQUARERGB);
        encoder.setMatteColor(this.getParameterBackgroundColor(parameters, configParameters));
        encoder.setMaxColors(this.getParameterMaxColors(parameters, configParameters));
        encoder.setDitherer(this.getParameterDithererMode(parameters, configParameters));
        encoder.setQuantizer(this.getParameterQuantizerMode(parameters, configParameters));
        encoder.setQuantizerSampleDepth(configParameters.quantizerSampleDepth);
        int dpi = this.getParameterDPI(parameters, configParameters);
        encoder.setDPI(dpi);
        encoder.setEncodeAlpha(image.hasAlpha());
        OutputParameters.Colorspace cs = this.getColorSpaceFromRequestParameters(parameters);
        if (cs == OutputParameters.Colorspace.GRAY) {
            encoder.setEncodeGray(true);
            eTagModifier.append("gray");
        } else if (cs == OutputParameters.Colorspace.UNSET && (cs = configParameters.colorspace) == OutputParameters.Colorspace.GRAY) {
            encoder.setEncodeGray(true);
            eTagModifier.append("gray");
        }
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(1024);){
            encoder.setOutputStream(baos);
            encoder.encode();
            encoder.dispose();
            OutputParameters.Encoding encoding = this.getEncodingFromRequestParameters(parameters);
            if (encoding == OutputParameters.Encoding.UNSET) {
                encoding = configParameters.encoding;
            }
            if (encoding == OutputParameters.Encoding.BASE64) {
                response.setMimeType("text/plain");
                response.setImageData(Base64.encodeToByte(baos.toByteArray(), false));
                eTagModifier.append("b64");
            } else {
                response.setMimeType("image/png");
                response.setImageData(baos.toByteArray());
            }
            response.setETagModifer(eTagModifier.toString());
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().log(3040, ioe.getLocalizedMessage());
            response.setError(true);
        }
        return response;
    }
}

