/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagemanipulator.encoder.swf.SWFEncoder;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SWFCompressor
extends OutputCompressor {
    public SWFCompressor(RequestProcessorSettings settings) {
        super(settings);
    }

    @Override
    public OutputCompressorResponse compressImageData(int priority, FSIImage image, Renderer renderer, Parameters parameters, String copyrightNotice) {
        OutputParameters configParameters = renderer.getOutputParameters();
        OutputCompressorResponse response = new OutputCompressorResponse();
        int q = configParameters.quality;
        int qual = this.getQualityFromRequestParameters(parameters);
        if (qual != -1) {
            q = qual;
        }
        if (q < 0) {
            q = 0;
        } else if (q > 100) {
            q = 100;
        }
        boolean error = false;
        String cacheKey = Integer.toString(q) + configParameters.optimizeHuffman + configParameters.chromaSubsampling.toString();
        JPEGPreparation jpegPrep = (JPEGPreparation)this.jpegCache.get(cacheKey);
        if (jpegPrep == null) {
            try {
                jpegPrep = new JPEGPreparation((float)q / 100.0f, configParameters.optimizeHuffman, configParameters.chromaSubsampling, null, null, 0, null, false);
                this.jpegCache.put(cacheKey, jpegPrep);
            }
            catch (UnsupportedEncodingException e) {
                error = true;
            }
        }
        if (!error) {
            ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(1024);
            SWFEncoder encoder = new SWFEncoder(this.settings.getFSILogger(), jpegPrep);
            encoder.setEncodeAlpha(image.hasAlpha());
            encoder.setImage(image);
            encoder.setVersion(6);
            encoder.setCompressionLevel(7);
            encoder.setCopyright(copyrightNotice);
            encoder.setSoftware(SoftwareVersion.getSoftware(false));
            encoder.setOutputStream(baos);
            try {
                encoder.encode();
                encoder.dispose();
                response.setMimeType("application/x-shockwave-flash");
                response.setImageData(baos.toByteArray());
                response.setETagModifer("SWF" + cacheKey + copyrightNotice);
            }
            catch (IOException ioe) {
                this.settings.getFSILogger().logException(ioe, 3040, ioe.getLocalizedMessage());
                response.setError(true);
            }
        } else {
            response.setError(true);
        }
        return response;
    }
}

