/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.ContactSheetImageRenderingParameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.area.Crop;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;

public abstract class AbstractContactSheetRenderer
extends RendererAbstract {
    private int defaultRows = 1;
    private Crop.CropPadPosition defaultAlignment = Crop.CropPadPosition.CC;
    private int defaultBackgroundColor = 0;
    protected int maxImages = 24;

    public AbstractContactSheetRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    protected void doWork(Parameters parameters, String[] sources, int priority, RendererImageResponse response, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        FSIImage resultImage = null;
        try {
            int iHeight;
            int iWidth;
            int bgcolor = this.determineBackgroundColor(parameters);
            Crop.CropPadPosition alignment = this.determineAlignment(parameters);
            Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
            Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
            Pair<Integer, Integer> grid = this.getRowsAndColumns(parameters, sources.length);
            ContactSheetImageRenderingParameters renderingParams = new ContactSheetImageRenderingParameters();
            AbstractContactSheetRenderer.determineSpacing(renderingParams, parameters);
            AbstractContactSheetRenderer.determinePadding(renderingParams, parameters);
            List<ImageMetaData> metadatalist = this.getMetaDataList(sources, session);
            int columns = grid.getItem2();
            int rows = grid.getItem1();
            if (!widthPair.getItem2().booleanValue() && heightPair.getItem2().booleanValue()) {
                renderingParams.targetWidth = widthPair.getItem1();
                if (renderingParams.spacingPix == -1) {
                    renderingParams.spacingPix = (int)(renderingParams.spacing * (double)renderingParams.targetWidth);
                }
                if (renderingParams.paddingPix == -1) {
                    renderingParams.paddingPix = (int)(renderingParams.padding * (double)renderingParams.targetHeight);
                }
                renderingParams.singleImageWidth = (renderingParams.targetWidth - (columns - 1) * renderingParams.spacingPix - 2 * renderingParams.paddingPix) / columns;
                renderingParams.singleImageHeight = 0;
                for (ImageMetaData imd : metadatalist) {
                    iWidth = imd.getWidth();
                    iHeight = imd.getHeight();
                    int scaledHeight = iHeight * renderingParams.singleImageWidth / iWidth;
                    if (scaledHeight <= renderingParams.singleImageHeight) continue;
                    renderingParams.singleImageHeight = scaledHeight;
                }
                renderingParams.targetHeight = rows * renderingParams.singleImageHeight + (rows - 1) * renderingParams.spacingPix + 2 * renderingParams.paddingPix;
            } else if (widthPair.getItem2().booleanValue() && !heightPair.getItem2().booleanValue()) {
                renderingParams.targetHeight = heightPair.getItem1();
                if (renderingParams.spacingPix == -1) {
                    renderingParams.spacingPix = (int)(renderingParams.spacing * (double)renderingParams.targetHeight);
                }
                if (renderingParams.paddingPix == -1) {
                    renderingParams.paddingPix = (int)(renderingParams.padding * (double)renderingParams.targetHeight);
                }
                renderingParams.singleImageHeight = (renderingParams.targetHeight - (rows - 1) * renderingParams.spacingPix - 2 * renderingParams.paddingPix) / rows;
                for (ImageMetaData imd : metadatalist) {
                    iWidth = imd.getWidth();
                    int scaledWidth = iWidth * renderingParams.singleImageHeight / (iHeight = imd.getHeight());
                    if (scaledWidth <= renderingParams.singleImageWidth) continue;
                    renderingParams.singleImageWidth = scaledWidth;
                }
                renderingParams.targetWidth = columns * renderingParams.singleImageWidth + (columns - 1) * renderingParams.spacingPix + 2 * renderingParams.paddingPix;
            } else {
                renderingParams.targetWidth = widthPair.getItem1();
                renderingParams.targetHeight = heightPair.getItem1();
                if (renderingParams.spacingPix == -1) {
                    renderingParams.spacingPix = (int)(renderingParams.spacing * (double)renderingParams.targetWidth);
                }
                if (renderingParams.paddingPix == -1) {
                    renderingParams.paddingPix = (int)(renderingParams.padding * (double)renderingParams.targetWidth);
                }
                renderingParams.singleImageWidth = (renderingParams.targetWidth - (columns - 1) * renderingParams.spacingPix - 2 * renderingParams.paddingPix) / columns;
                renderingParams.singleImageHeight = (renderingParams.targetHeight - (rows - 1) * renderingParams.spacingPix - 2 * renderingParams.paddingPix) / rows;
            }
            int imageCounter = 0;
            for (ImageMetaData imd : metadatalist) {
                SourceConnectorReader assetConnector = this.settings.getSourceConnectorFromAssetURLPath(imd.getAssetURLPath());
                FSIImageLimited singleImage = this.settings.getImageBuilder().getImage(null, assetConnector, priority, imd.getAssetURLPath(), new Pair<Integer, Boolean>(renderingParams.singleImageWidth, false), new Pair<Integer, Boolean>(renderingParams.singleImageHeight, false), 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.LANCZOS);
                ExecutorPool ep = this.settings.getExecutorPool();
                LayerBlend blend = new LayerBlend(this.settings.getFSILogger(), ep, priority);
                int currentColumn = imageCounter % columns;
                int currentRow = imageCounter / columns;
                int offsetX = renderingParams.paddingPix + currentColumn * (renderingParams.singleImageWidth + renderingParams.spacingPix);
                int offsetY = renderingParams.paddingPix + currentRow * (renderingParams.singleImageHeight + renderingParams.spacingPix);
                if (singleImage.getWidth() != renderingParams.singleImageWidth && alignment != Crop.CropPadPosition.TL && alignment != Crop.CropPadPosition.CL && alignment != Crop.CropPadPosition.BL) {
                    if (alignment == Crop.CropPadPosition.TC || alignment == Crop.CropPadPosition.CC || alignment == Crop.CropPadPosition.BC) {
                        offsetX += (renderingParams.singleImageWidth - singleImage.getWidth()) / 2;
                    } else if (alignment == Crop.CropPadPosition.TR || alignment == Crop.CropPadPosition.CR || alignment == Crop.CropPadPosition.BR) {
                        offsetX += renderingParams.singleImageWidth - singleImage.getWidth();
                    }
                }
                if (singleImage.getHeight() != renderingParams.singleImageHeight && alignment != Crop.CropPadPosition.TL && alignment != Crop.CropPadPosition.TC && alignment != Crop.CropPadPosition.TR) {
                    if (alignment == Crop.CropPadPosition.CC || alignment == Crop.CropPadPosition.CL || alignment == Crop.CropPadPosition.CR) {
                        offsetY += (renderingParams.singleImageHeight - singleImage.getHeight()) / 2;
                    } else if (alignment == Crop.CropPadPosition.BL || alignment == Crop.CropPadPosition.BC || alignment == Crop.CropPadPosition.BR) {
                        offsetY += renderingParams.singleImageHeight - singleImage.getHeight();
                    }
                }
                resultImage = resultImage != null ? blend.transform(resultImage, singleImage, offsetX, offsetY, BlendMode.NORMAL, AlphaMode.BASE, 100.0f, false) : Crop.transform(singleImage, 0, 0, renderingParams.targetWidth, renderingParams.targetHeight, bgcolor, Crop.CropPadPosition.TL, offsetX, offsetY, false);
                ++imageCounter;
            }
            if (widthPair.getItem2().booleanValue()) {
                parameters.put(Parameters.GeneralImage.width, String.valueOf(renderingParams.targetWidth));
            }
            if (heightPair.getItem2().booleanValue()) {
                parameters.put(Parameters.GeneralImage.height, String.valueOf(renderingParams.targetHeight));
            }
            response.setStatus(200);
            response.setResponseImage((FSIImageLimited)resultImage);
            response.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(metadatalist));
        }
        catch (ProcessingException e) {
            if (resultImage != null) {
                resultImage.dispose();
            }
            throw e;
        }
    }

    protected static void determinePadding(ContactSheetImageRenderingParameters renderingParams, Parameters parameters) {
        if (parameters.contains(Parameters.GeneralImage.padding)) {
            String paddingStr = parameters.get(Parameters.GeneralImage.padding);
            if (paddingStr.contains(".")) {
                renderingParams.padding = FloatingParser.parseDouble(paddingStr);
            } else {
                renderingParams.paddingPix = Integer.parseInt(paddingStr);
            }
        } else {
            renderingParams.paddingPix = 0;
        }
    }

    protected static void determineSpacing(ContactSheetImageRenderingParameters renderingParams, Parameters parameters) {
        if (parameters.contains(Parameters.GeneralImage.spacing)) {
            String spacingStr = parameters.get(Parameters.GeneralImage.spacing);
            if (spacingStr.contains(".")) {
                renderingParams.spacing = FloatingParser.parseDouble(spacingStr);
            } else {
                renderingParams.spacingPix = Integer.parseInt(spacingStr);
            }
        } else {
            renderingParams.spacingPix = 0;
        }
    }

    protected Crop.CropPadPosition determineAlignment(Parameters parameters) {
        Crop.CropPadPosition alignment = this.defaultAlignment;
        if (parameters.contains(Parameters.FileImage.align)) {
            try {
                alignment = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.align).toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return alignment;
    }

    protected int determineBackgroundColor(Parameters parameters) {
        int bgcolor = this.defaultBackgroundColor;
        if (parameters.contains(Parameters.GeneralImage.backgroundcolor)) {
            bgcolor = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.backgroundcolor), bgcolor);
        }
        return bgcolor;
    }

    protected List<ImageMetaData> getMetaDataList(String[] sources, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        ArrayList<ImageMetaData> metadatalist = new ArrayList<ImageMetaData>();
        for (String imagesource : sources) {
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(imagesource);
            MetaData imd = this.settings.getImageBuilder().getImageMetaData(connector, imagesource, 0, true, session);
            if (!(imd instanceof ImageMetaData)) continue;
            metadatalist.add((ImageMetaData)imd);
        }
        return metadatalist;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        } else if (name.equalsIgnoreCase("backgroundcolor")) {
            result = String.valueOf(this.defaultBackgroundColor);
        } else if (name.equalsIgnoreCase("defaultAlignment")) {
            result = String.valueOf((Object)this.defaultAlignment);
        } else if (name.equalsIgnoreCase("defaultRows")) {
            result = String.valueOf(this.defaultRows);
        } else if (name.equalsIgnoreCase("maxImages")) {
            result = String.valueOf(this.maxImages);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("backgroundcolor");
        result.add("defaultRows");
        result.add("maxImages");
        result.add("defaultAlignment");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase("backgroundColor")) {
            try {
                this.defaultBackgroundColor = ColorParser.parseColor(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase("defaultRows")) {
            try {
                this.defaultRows = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase("defaultAlignment")) {
            try {
                this.defaultAlignment = Crop.CropPadPosition.valueOf(value.toUpperCase());
            }
            catch (Exception exception) {}
        } else if (name.equalsIgnoreCase("maxImages")) {
            try {
                this.maxImages = Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected Pair<Integer, Integer> getRowsAndColumns(Parameters parameters, int numberOfImages) {
        if (parameters.contains(Parameters.GeneralImage.rows)) {
            return this.getRowsAndColumnsFromRowsParam(parameters.get(Parameters.GeneralImage.rows), numberOfImages);
        }
        if (parameters.contains(Parameters.GeneralImage.columns)) {
            return this.getRowsAndColumnsFromColsParam(parameters.get(Parameters.GeneralImage.columns), numberOfImages);
        }
        return new Pair<Integer, Integer>(this.defaultRows, AbstractContactSheetRenderer.calculateColsFromRows(this.defaultRows, numberOfImages));
    }

    private Pair<Integer, Integer> getRowsAndColumnsFromColsParam(String colStr, int numberOfImages) {
        int rows;
        int columns;
        try {
            columns = Integer.parseInt(colStr);
        }
        catch (NumberFormatException e) {
            columns = 0;
        }
        if (columns <= 0) {
            rows = this.defaultRows;
            columns = AbstractContactSheetRenderer.calculateColsFromRows(rows, numberOfImages);
        } else {
            rows = AbstractContactSheetRenderer.calculateRowsFromCols(columns, numberOfImages);
        }
        return new Pair<Integer, Integer>(rows, columns);
    }

    private Pair<Integer, Integer> getRowsAndColumnsFromRowsParam(String rowsStr, int numberOfImages) {
        int rows;
        try {
            rows = Integer.parseInt(rowsStr);
        }
        catch (NumberFormatException e) {
            rows = 0;
        }
        if (rows <= 0) {
            rows = this.defaultRows;
        }
        return new Pair<Integer, Integer>(rows, AbstractContactSheetRenderer.calculateColsFromRows(rows, numberOfImages));
    }

    protected static int calculateColsFromRows(int rows, int numberOfImages) {
        return (int)Math.ceil((double)numberOfImages / (double)rows);
    }

    protected static int calculateRowsFromCols(int cols, int numberOfImages) {
        return (int)Math.ceil((double)numberOfImages / (double)cols);
    }
}

