/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagemanipulator.anaglyph.AnaglyphMode;
import com.neptunelabs.imagemanipulator.anaglyph.AnaglyphRenderer;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class AnaglyphImageRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;

    public AnaglyphImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("defaultWidth");
        result.add("defaultWidth");
        result.add("maxWidth");
        result.add("maxHeight");
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws IllegalArgumentException, ProcessingException, InterruptedException {
        HttpSession session = req.getSession(false);
        RendererImageResponse response = new RendererImageResponse();
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String sourceParameter = parameters.get(Parameters.General.source);
        String assetURLPathLeft = null;
        String assetURLPathRight = null;
        if (sourceParameter == null) throw new IllegalArgumentException("source required");
        String[] sources = sourceParameter.split(",", 2);
        if (sources == null || sources.length != 2) {
            throw new IllegalArgumentException("source invalid - require 2 comma separated sources");
        }
        assetURLPathLeft = URL.cleanUpSourceParameter(sources[0]);
        assetURLPathRight = URL.cleanUpSourceParameter(sources[1]);
        int colorLeft = 0xFFFFFF;
        int colorRight = 0xFFFFFF;
        String effectsLeftString = parameters.get(Parameters.FileImage.lefteffects);
        String effectsRightString = parameters.get(Parameters.FileImage.righteffects);
        String colormode = parameters.get(Parameters.FileImage.colormode);
        if (colormode != null) {
            String[] colors = colormode.split(",", 2);
            if (colors == null || colors.length != 2) throw new IllegalArgumentException("colormode " + colormode + " invalid - require 2 comma separated values");
            colorLeft = this.evaluateColorMode(colors[0]);
            if (colorLeft == -1) {
                throw new IllegalArgumentException("colormode " + colors[0] + " invalid");
            }
            colorRight = this.evaluateColorMode(colors[1]);
            if (colorRight == -1) {
                throw new IllegalArgumentException("colormode " + colors[1] + " invalid");
            }
        } else if (effectsLeftString == null || effectsRightString == null) {
            throw new IllegalArgumentException("colormode or lefteffects and righteffects required");
        }
        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
        if (widthPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
        }
        if (heightPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
        }
        try {
            void var30_48;
            void var29_40;
            String effectsString;
            void var30_44;
            void var29_36;
            SourceConnectorReader sourceConnectorLeft = this.settings.getSourceConnectorFromAssetURLPath(assetURLPathLeft);
            SourceConnectorReader sourceConnectorRight = this.settings.getSourceConnectorFromAssetURLPath(assetURLPathRight);
            MetaData mdLeft = this.standardImagebuilder.getImageMetaData(sourceConnectorLeft, assetURLPathLeft, 64, true, session);
            MetaData mdRight = this.standardImagebuilder.getImageMetaData(sourceConnectorRight, assetURLPathRight, 64, true, session);
            if (!(mdLeft instanceof ImageMetaData) || !(mdRight instanceof ImageMetaData)) {
                throw new IllegalArgumentException("two valid sources required");
            }
            ImageMetaData imdLeft = (ImageMetaData)mdLeft;
            ImageMetaData imdRight = (ImageMetaData)mdRight;
            if (imdLeft.getImportStatus() != 1 || imdRight.getImportStatus() != 1) throw new IllegalArgumentException("two valid sources required");
            double[] relativeRangeLeft = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
            double[] relativeRangeRight = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
            int[] pixelRangeLeft = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
            int[] pixelRangeRight = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
            int[] referenceDimensions = null;
            boolean pixelBased = false;
            if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
                AnaglyphImageRenderer.getRelativeRangeFromParameters(parameters, relativeRangeLeft);
                AnaglyphImageRenderer.getRelativeRangeFromParameters(parameters, relativeRangeRight);
            } else if (parameters.contains(Parameters.GeneralImage.pixelrange) || parameters.contains(Parameters.GeneralImage.pixeltop) || parameters.contains(Parameters.GeneralImage.pixelleft) || parameters.contains(Parameters.GeneralImage.pixelright) || parameters.contains(Parameters.GeneralImage.pixelbottom)) {
                referenceDimensions = AnaglyphImageRenderer.getReferenceDimensions(parameters);
                pixelBased = true;
                this.getPixelRangeFromParameters(parameters, pixelRangeLeft);
                this.getPixelRangeFromParameters(parameters, pixelRangeRight);
            }
            Object var29_33 = null;
            Object var30_41 = null;
            try {
                if (pixelBased && referenceDimensions != null) {
                    FSIImageLimited fSIImageLimited = this.standardImagebuilder.getImagePixelBased(null, sourceConnectorLeft, priority, assetURLPathLeft, referenceDimensions[0], referenceDimensions[1], pixelRangeLeft[0], pixelRangeLeft[1], pixelRangeLeft[2], pixelRangeLeft[3], true, FSIInterpolation.LANCZOS);
                    FSIImageLimited fSIImageLimited2 = this.standardImagebuilder.getImagePixelBased(null, sourceConnectorRight, priority, assetURLPathRight, referenceDimensions[0], referenceDimensions[1], pixelRangeRight[0], pixelRangeRight[1], pixelRangeRight[2], pixelRangeRight[3], true, FSIInterpolation.LANCZOS);
                } else {
                    FSIImageLimited fSIImageLimited = this.standardImagebuilder.getImage(null, sourceConnectorLeft, priority, assetURLPathLeft, widthPair, heightPair, relativeRangeLeft[0], relativeRangeLeft[1], relativeRangeLeft[2], relativeRangeLeft[3], true, FSIInterpolation.LANCZOS);
                    FSIImageLimited fSIImageLimited3 = this.standardImagebuilder.getImage(null, sourceConnectorRight, priority, assetURLPathRight, widthPair, heightPair, relativeRangeRight[0], relativeRangeRight[1], relativeRangeRight[2], relativeRangeRight[3], true, FSIInterpolation.LANCZOS);
                }
            }
            catch (FSIImageException e) {
                this.settings.getFSILogger().log(2504, assetURLPathRight, e.getLocalizedMessage());
                AnaglyphImageRenderer.disposeImages(var29_33, var30_41);
                throw e;
            }
            catch (ProcessingException e) {
                AnaglyphImageRenderer.disposeImages(var29_33, var30_41);
                throw e;
            }
            if (var29_36 == null || var30_44 == null) return response;
            if (parameters.contains(Parameters.FileImage.preeffects)) {
                effectsString = parameters.get(Parameters.FileImage.preeffects);
                FSIImage fSIImage = this.applyEffects(priority, (FSIImage)var29_36, imdLeft.getSelections(), parameters, effectsString);
                FSIImage fSIImage2 = this.applyEffects(priority, (FSIImage)var30_44, imdRight.getSelections(), parameters, effectsString);
            }
            if (parameters.contains(Parameters.FileImage.lefteffects)) {
                void var29_38;
                effectsString = parameters.get(Parameters.FileImage.lefteffects);
                FSIImage fSIImage = this.applyEffects(priority, (FSIImage)var29_38, imdLeft.getSelections(), parameters, effectsString);
            }
            if (parameters.contains(Parameters.FileImage.righteffects)) {
                void var30_46;
                effectsString = parameters.get(Parameters.FileImage.righteffects);
                FSIImage fSIImage = this.applyEffects(priority, (FSIImage)var30_46, imdRight.getSelections(), parameters, effectsString);
            }
            AnaglyphRenderer ar = new AnaglyphRenderer(this.settings.getFSILogger(), this.settings.getExecutorPool());
            ar.setImages((FSIImage)var29_40, (FSIImage)var30_48);
            ar.setLeftColor(colorLeft);
            ar.setRightColor(colorRight);
            FSIImageLimited newImage = (FSIImageLimited)ar.render(priority, false);
            response.setResponseImage(newImage);
            response.setStatus(200);
            return response;
        }
        catch (NoSuchFileException e) {
            throw new IllegalArgumentException("two valid sources required");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("two valid sources required");
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        }
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        }
        return result;
    }

    private FSIImage applyEffects(int priority, FSIImage image, byte[] selectionsRaw, Parameters parameters, String effectsString) throws ProcessingException {
        try {
            image = this.settings.getEffectsManager().applyEffects(priority, image, selectionsRaw, effectsString, parameters);
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(3153, null, effectsString, "");
        }
        return image;
    }

    private int evaluateColorMode(String strMode) {
        int color = -1;
        try {
            AnaglyphMode mode = AnaglyphMode.valueOf(strMode.toUpperCase());
            switch (mode) {
                case BLUE: {
                    color = 255;
                    break;
                }
                case CYAN: {
                    color = 65535;
                    break;
                }
                case GREEN: {
                    color = 65280;
                    break;
                }
                case MAGENTA: {
                    color = 0xFF00FF;
                    break;
                }
                case RED: {
                    color = 0xFF0000;
                    break;
                }
                case YELLOW: {
                    color = 0xFFFF00;
                }
            }
        }
        catch (IllegalArgumentException e) {
            try {
                color = ColorParser.parseColor(strMode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }
}

