/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.AbstractContactSheetRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DirectoryImageRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ContactSheetDirectoryRenderer
extends AbstractContactSheetRenderer {
    private SortingParameters sortingParameters = new SortingParameters();

    public ContactSheetDirectoryRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.sortingParameters.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.sortingParameters.defaultSortOrder = RendererEnvironment.DEFAULT_SORT_ORDER;
        this.sortingParameters.defaultSortMethod = RendererEnvironment.DEFAULT_SORT_METHOD;
        this.sortingParameters.defaultSortLanguage = this.environment.getDefaultSortLanguage();
        this.sortingParameters.defaultSortCountry = this.environment.getDefaultSortCountry();
        this.sortingParameters.defaultSortCaseSensitive = false;
    }

    public String[] getSourcesList(Parameters parameters, String assetURLPath, HttpSession session) throws IOException, NotConfiguredException {
        PoolFileEntryComparator pfec = DirectoryImageRendererUtils.getComparator(parameters, this.sortingParameters);
        int offset = 0;
        int count = this.maxImages;
        if (parameters.contains(Parameters.DirectoryImage.limit)) {
            try {
                String limitval = parameters.get(Parameters.DirectoryImage.limit);
                String[] values = limitval.split(",", 2);
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException limitval) {
                // empty catch block
            }
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        PoolList list = this.settings.getImageBuilder().getPoolList(connector, assetURLPath, session);
        List<PoolFileEntry> filelist = list.getFilesAsList();
        Collections.sort(filelist, pfec);
        filelist = this.limitList(filelist, offset, count);
        int targetlength = filelist.size() - offset;
        if (targetlength > count) {
            targetlength = count;
        }
        String[] sources = new String[targetlength];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = assetURLPath + "/" + filelist.get((int)(i + offset)).name;
        }
        return sources;
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        RendererImageResponse response = new RendererImageResponse();
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            throw new IllegalArgumentException("source required");
        }
        try {
            HttpSession session = req.getSession(false);
            String[] sources = this.getSourcesList(parameters, assetURLPath, session);
            this.doWork(parameters, sources, priority, response, session);
        }
        catch (NoSuchFileException e) {
            response.setStatus(404);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public String getOption(String name) {
        if (name.equalsIgnoreCase("defaultsortfield") && this.sortingParameters.defaultSortField != null) {
            return this.sortingParameters.defaultSortField.name();
        }
        if (name.equalsIgnoreCase("forcesortfield") && this.sortingParameters.forceSortField != null) {
            return this.sortingParameters.forceSortField.name();
        }
        if (name.equalsIgnoreCase("defaultsortorder") && this.sortingParameters.defaultSortOrder != null) {
            return this.sortingParameters.defaultSortOrder.name();
        }
        if (name.equalsIgnoreCase("forcesortorder") && this.sortingParameters.forceSortOrder != null) {
            return this.sortingParameters.forceSortOrder.name();
        }
        if (name.equalsIgnoreCase("defaultsortmethod") && this.sortingParameters.defaultSortMethod != null) {
            return this.sortingParameters.defaultSortMethod.name();
        }
        if (name.equalsIgnoreCase("forcesortmethod") && this.sortingParameters.forceSortMethod != null) {
            return this.sortingParameters.forceSortMethod.name();
        }
        if (name.equalsIgnoreCase("defaultsortlanguage")) {
            return this.sortingParameters.defaultSortLanguage;
        }
        if (name.equalsIgnoreCase("forcesortlanguage")) {
            return this.sortingParameters.forceSortLanguage;
        }
        if (name.equalsIgnoreCase("defaultsortcountry")) {
            return this.sortingParameters.defaultSortCountry;
        }
        if (name.equalsIgnoreCase("forcesortcountry")) {
            return this.sortingParameters.forceSortCountry;
        }
        if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            return Boolean.toString(this.sortingParameters.defaultSortCaseSensitive);
        }
        if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            return Boolean.toString(this.sortingParameters.forceSortCaseSensitive);
        }
        return super.getOption(name);
    }

    @Override
    public Set<String> getSupportedOptions() {
        Set<String> result = super.getSupportedOptions();
        result.add("defaultSortField");
        result.add("forceSortField");
        result.add("defaultSortOrder");
        result.add("forceSortOrder");
        result.add("defaultSortMethod");
        result.add("forceSortMethod");
        result.add("defaultSortLanguage");
        result.add("forceSortLanguage");
        result.add("defaultSortCountry");
        result.add("forceSortCountry");
        result.add("defaultSortCaseSensitive");
        result.add("forceSortCaseSensitive");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("defaultsortfield")) {
            this.sortingParameters.defaultSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortfield")) {
            this.sortingParameters.forceSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortorder")) {
            this.sortingParameters.defaultSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortorder")) {
            this.sortingParameters.forceSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortmethod")) {
            this.sortingParameters.defaultSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortmethod")) {
            this.sortingParameters.forceSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            this.sortingParameters.defaultSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            this.sortingParameters.forceSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            this.sortingParameters.defaultSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            this.sortingParameters.forceSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            this.sortingParameters.defaultSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            this.sortingParameters.forceSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
            this.sortingParameters.forceSortCaseSensitiveSet = true;
        } else {
            super.setOption(name, value);
        }
    }
}

