/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.AbstractContactSheetRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ContactSheetImageRenderer
extends AbstractContactSheetRenderer {
    public ContactSheetImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        RendererImageResponse response = new RendererImageResponse();
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            throw new IllegalArgumentException("source required");
        }
        String[] sources = this.extractSourcesFromParameter(assetURLPath);
        try {
            this.doWork(parameters, sources, priority, response, req.getSession(false));
        }
        catch (NoSuchFileException e) {
            response.setStatus(404);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    private String[] extractSourcesFromParameter(String source) {
        String[] sources = source.split(",");
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = URL.cleanUpSourceParameter(sources[i]);
        }
        if (sources.length > this.maxImages) {
            String[] newSources = new String[this.maxImages];
            for (int i = 0; i < this.maxImages; ++i) {
                newSources[i] = sources[i];
            }
            sources = newSources;
        }
        return sources;
    }
}

