/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DoublePageImageRenderingParameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagemanipulator.area.Crop;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.combine.Join;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DoublePageImageRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;
    private Crop.CropPadPosition defaultAlignment = Crop.CropPadPosition.CC;
    private int defaultBackgroundColor = 0;

    public DoublePageImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            throw new IllegalArgumentException("source required");
        }
        String[] sources = this.extractSourcesFromParameter(assetURLPath);
        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
        FSIImage leftImage = null;
        FSIImage rightImage = null;
        try {
            HttpSession session = req.getSession(false);
            for (String s : sources) {
                PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(s, session, true);
                if (ps != null && ps.read.renderedImages.booleanValue()) continue;
                return DoublePageImageRenderer.generateNotAuthorizedResponse();
            }
            List<ImageMetaData> metadatalist = this.getMetaDataList(sources, session);
            RendererImageResponse response = new RendererImageResponse();
            if (metadatalist.size() > 1) {
                DoublePageImageRenderingParameters renderingParams = new DoublePageImageRenderingParameters();
                short importStatus = this.checkImageStatus(metadatalist);
                if (importStatus != 1) {
                    this.createFallbackResponse(assetURLPath, parameters, importStatus, response);
                    return response;
                }
                this.calculateRenderingParameters(parameters, widthPair, heightPair, metadatalist, renderingParams);
                leftImage = this.getLeftPage(priority, metadatalist.get(0).getAssetURLPath(), renderingParams);
                rightImage = this.getRightPage(priority, metadatalist.get(1).getAssetURLPath(), renderingParams);
                FSIImage resultImage = this.joinImages(leftImage, rightImage, renderingParams);
                if (resultImage.hasAlpha()) {
                    ExecutorPool ep = this.settings.getExecutorPool();
                    ParallelColorOperation colorOperation = new ParallelColorOperation(this.settings.getFSILogger(), ep, priority);
                    resultImage = colorOperation.transform(resultImage, new MatteTransparent(renderingParams.backgroundColor, false), false);
                }
                parameters.put(Parameters.GeneralImage.width, String.valueOf(resultImage.getWidth()));
                parameters.put(Parameters.GeneralImage.height, String.valueOf(resultImage.getHeight()));
                response.setStatus(200);
                response.setResponseImage((FSIImageLimited)resultImage);
                response.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(metadatalist));
            } else {
                response.setStatus(404);
            }
            return response;
        }
        catch (NoSuchFileException e) {
            DoublePageImageRenderer.disposeImages(leftImage, rightImage);
            return DoublePageImageRenderer.generateNotFoundResponse();
        }
        catch (IOException e) {
            DoublePageImageRenderer.disposeImages(leftImage, rightImage);
            return DoublePageImageRenderer.generateErrorResponse();
        }
        catch (NotConfiguredException e) {
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            return DoublePageImageRenderer.generateUnavailableResponse();
        }
        catch (ProcessingException e) {
            DoublePageImageRenderer.disposeImages(leftImage, rightImage);
            throw e;
        }
    }

    private short checkImageStatus(List<ImageMetaData> metadatalist) {
        ImageMetaData metadataentry = metadatalist.get(0);
        if (metadataentry.getImportStatus() != 1 && metadataentry.getImportStatus() != 4) {
            return metadataentry.getImportStatus();
        }
        metadataentry = metadatalist.get(1);
        if (metadataentry.getImportStatus() != 1 && metadataentry.getImportStatus() != 4) {
            return metadataentry.getImportStatus();
        }
        return 1;
    }

    private void calculateRenderingParameters(Parameters requestParameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, List<ImageMetaData> metadatalist, DoublePageImageRenderingParameters renderingParams) {
        renderingParams.pageWidth = widthPair.getItem1() / 2;
        this.parseAlignmentParameters(requestParameters, renderingParams);
        this.parseCropParameters(requestParameters, renderingParams);
        this.parseBackgroundColor(requestParameters, renderingParams);
        if (!widthPair.getItem2().booleanValue() && heightPair.getItem2().booleanValue()) {
            this.calculateRenderingParamsFromGivenWidth(requestParameters, metadatalist, renderingParams);
        } else if (widthPair.getItem2().booleanValue() && !heightPair.getItem2().booleanValue()) {
            this.calculateRenderingParamsFromGivenHeight(requestParameters, heightPair, metadatalist, renderingParams);
        } else {
            this.calculateRenderingParamsFromGivenWidthAndHeight(requestParameters, heightPair, metadatalist, renderingParams);
        }
    }

    private void calculateRenderingParamsFromGivenWidth(Parameters parameters, List<ImageMetaData> metadatalist, DoublePageImageRenderingParameters renderingParams) {
        int leftSrcWidth = metadatalist.get(0).getWidth();
        int leftSrcHeight = metadatalist.get(0).getHeight();
        int leftInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.leftinnergap), leftSrcWidth);
        renderingParams.leftBoundingBoxWidth = this.calculateBoundingBoxWidth(leftSrcWidth, renderingParams.leftImageCrop[2], leftInnerGapAbsoluteSize, renderingParams.pageWidth);
        renderingParams.resultingLeftInnerGap = renderingParams.pageWidth - renderingParams.leftBoundingBoxWidth;
        int rightSrcWidth = metadatalist.get(1).getWidth();
        int rightSrcHeight = metadatalist.get(1).getHeight();
        int rightInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.rightinnergap), rightSrcWidth);
        renderingParams.rightBoundingBoxWidth = this.calculateBoundingBoxWidth(rightSrcWidth, renderingParams.rightImageCrop[2], rightInnerGapAbsoluteSize, renderingParams.pageWidth);
        renderingParams.resultingRightInnerGap = renderingParams.pageWidth - renderingParams.rightBoundingBoxWidth;
        int optimalLeftPageHeight = this.calcOptimalPageHeight(leftSrcWidth, leftSrcHeight, renderingParams.leftImageCrop[2], renderingParams.leftImageCrop[3], renderingParams.leftBoundingBoxWidth);
        int optimalRightPageHeight = this.calcOptimalPageHeight(rightSrcWidth, rightSrcHeight, renderingParams.rightImageCrop[2], renderingParams.rightImageCrop[3], renderingParams.rightBoundingBoxWidth);
        renderingParams.pageHeight = Math.max(optimalLeftPageHeight, optimalRightPageHeight);
    }

    private void calculateRenderingParamsFromGivenHeight(Parameters parameters, Pair<Integer, Boolean> heightPair, List<ImageMetaData> metadatalist, DoublePageImageRenderingParameters renderingParams) {
        int leftSrcWidth = metadatalist.get(0).getWidth();
        int leftSrcHeight = metadatalist.get(0).getHeight();
        renderingParams.pageHeight = heightPair.getItem1();
        int leftInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.leftinnergap), leftSrcWidth);
        int leftOptimalBoundingBoxWidth = this.calculateOptimalBoundingBoxWidth(leftSrcWidth, leftSrcHeight, renderingParams.leftImageCrop[2], renderingParams.leftImageCrop[3], heightPair.getItem1());
        renderingParams.resultingLeftInnerGap = (int)((double)(leftOptimalBoundingBoxWidth * leftInnerGapAbsoluteSize) / (double)leftSrcWidth);
        int leftOptimalPageWidth = leftOptimalBoundingBoxWidth + renderingParams.resultingLeftInnerGap;
        int rightSrcWidth = metadatalist.get(1).getWidth();
        int rightSrcHeight = metadatalist.get(1).getHeight();
        int rightInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.rightinnergap), rightSrcWidth);
        int rightOptimalBoundingBoxWidth = this.calculateOptimalBoundingBoxWidth(rightSrcWidth, rightSrcHeight, renderingParams.rightImageCrop[2], renderingParams.rightImageCrop[3], heightPair.getItem1());
        renderingParams.resultingRightInnerGap = (int)((double)(rightOptimalBoundingBoxWidth * rightInnerGapAbsoluteSize) / (double)rightSrcWidth);
        int rightOptimalPageWidth = rightOptimalBoundingBoxWidth + renderingParams.resultingRightInnerGap;
        if (leftOptimalPageWidth > rightOptimalPageWidth) {
            renderingParams.pageWidth = leftOptimalPageWidth;
            renderingParams.leftBoundingBoxWidth = leftOptimalBoundingBoxWidth;
            renderingParams.rightBoundingBoxWidth = rightOptimalBoundingBoxWidth + leftOptimalPageWidth - rightOptimalPageWidth;
        } else {
            renderingParams.pageWidth = rightOptimalPageWidth;
            renderingParams.leftBoundingBoxWidth = leftOptimalBoundingBoxWidth + rightOptimalPageWidth - leftOptimalPageWidth;
            renderingParams.rightBoundingBoxWidth = rightOptimalBoundingBoxWidth;
        }
    }

    private void calculateRenderingParamsFromGivenWidthAndHeight(Parameters parameters, Pair<Integer, Boolean> heightPair, List<ImageMetaData> metadatalist, DoublePageImageRenderingParameters renderingParams) {
        renderingParams.pageHeight = heightPair.getItem1();
        int leftSrcWidth = metadatalist.get(0).getWidth();
        int leftInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.leftinnergap), leftSrcWidth);
        renderingParams.leftBoundingBoxWidth = this.calculateBoundingBoxWidth(leftSrcWidth, renderingParams.leftImageCrop[2], leftInnerGapAbsoluteSize, renderingParams.pageWidth);
        renderingParams.resultingLeftInnerGap = renderingParams.pageWidth - renderingParams.leftBoundingBoxWidth;
        int rightSrcWidth = metadatalist.get(1).getWidth();
        int rightInnerGapAbsoluteSize = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.rightinnergap), rightSrcWidth);
        renderingParams.rightBoundingBoxWidth = this.calculateBoundingBoxWidth(rightSrcWidth, renderingParams.rightImageCrop[2], rightInnerGapAbsoluteSize, renderingParams.pageWidth);
        renderingParams.resultingRightInnerGap = renderingParams.pageWidth - renderingParams.rightBoundingBoxWidth;
    }

    private FSIImage getLeftPage(int priority, String source, DoublePageImageRenderingParameters renderingParams) throws NotImportedException, NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        double left = renderingParams.leftImageCrop[0];
        double top = renderingParams.leftImageCrop[1];
        double width = renderingParams.leftImageCrop[2];
        double height = renderingParams.leftImageCrop[3];
        Pair<Integer, Boolean> targetWidth = new Pair<Integer, Boolean>(renderingParams.leftBoundingBoxWidth, false);
        Pair<Integer, Boolean> targetHeight = new Pair<Integer, Boolean>(renderingParams.pageHeight, false);
        SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(source);
        FSIImage leftPage = this.standardImagebuilder.getImage(null, importerProfile, priority, source, targetWidth, targetHeight, left, top, width, height, true, FSIInterpolation.LANCZOS);
        if (leftPage.getWidth() != renderingParams.leftBoundingBoxWidth || leftPage.getHeight() != renderingParams.pageHeight) {
            leftPage = Crop.transform(leftPage, 0, 0, renderingParams.leftBoundingBoxWidth, renderingParams.pageHeight, renderingParams.backgroundColor, renderingParams.leftAlignment, 0.0f, 0.0f, false);
        }
        return leftPage;
    }

    private FSIImage getRightPage(int priority, String source, DoublePageImageRenderingParameters renderingParams) throws NotImportedException, NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        double left = renderingParams.rightImageCrop[0];
        double top = renderingParams.rightImageCrop[1];
        double width = renderingParams.rightImageCrop[2];
        double height = renderingParams.rightImageCrop[3];
        Pair<Integer, Boolean> targetWidth = new Pair<Integer, Boolean>(renderingParams.rightBoundingBoxWidth, false);
        Pair<Integer, Boolean> targetHeight = new Pair<Integer, Boolean>(renderingParams.pageHeight, false);
        SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(source);
        FSIImage rightPage = this.standardImagebuilder.getImage(null, importerProfile, priority, source, targetWidth, targetHeight, left, top, width, height, true, FSIInterpolation.LANCZOS);
        if (rightPage.getWidth() != renderingParams.rightBoundingBoxWidth || rightPage.getHeight() != renderingParams.pageHeight) {
            rightPage = Crop.transform(rightPage, 0, 0, renderingParams.rightBoundingBoxWidth, renderingParams.pageHeight, renderingParams.backgroundColor, renderingParams.rightAlignment, 0.0f, 0.0f, false);
        }
        return rightPage;
    }

    private FSIImage joinImages(FSIImage leftImage, FSIImage rightImage, DoublePageImageRenderingParameters renderingParams) {
        if (renderingParams.resultingLeftInnerGap > 0) {
            leftImage = Crop.transform(leftImage, 0, 0, leftImage.getWidth() + renderingParams.resultingLeftInnerGap, leftImage.getHeight(), renderingParams.backgroundColor, Crop.CropPadPosition.CL, 0.0f, 0.0f, false);
        }
        if (renderingParams.resultingRightInnerGap > 0) {
            rightImage = Crop.transform(rightImage, 0, 0, rightImage.getWidth() + renderingParams.resultingRightInnerGap, rightImage.getHeight(), renderingParams.backgroundColor, Crop.CropPadPosition.CR, 0.0f, 0.0f, false);
        }
        if (leftImage.hasAlpha() && !rightImage.hasAlpha()) {
            rightImage.addAlpha();
        } else if (!leftImage.hasAlpha() && rightImage.hasAlpha()) {
            leftImage.addAlpha();
        }
        return Join.transform(leftImage, rightImage, Join.JoinPosition.RIGHT, false);
    }

    private void parseAlignmentParameters(Parameters parameters, DoublePageImageRenderingParameters renderingParams) {
        if (parameters.contains(Parameters.FileImage.leftalignment)) {
            renderingParams.leftAlignment = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.leftalignment).toUpperCase());
        }
        if (parameters.contains(Parameters.FileImage.rightalignment)) {
            renderingParams.rightAlignment = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.rightalignment).toUpperCase());
        }
    }

    private void parseCropParameters(Parameters parameters, DoublePageImageRenderingParameters renderingParameters) {
        if (parameters.contains(Parameters.FileImage.leftimagecrop)) {
            double[] leftCropValues = DoublePageImageRenderer.parseRangeParameterValue(parameters.get(Parameters.FileImage.leftimagecrop));
            renderingParameters.leftImageCrop = leftCropValues;
        }
        if (parameters.contains(Parameters.FileImage.rightimagecrop)) {
            double[] rightCropValues = DoublePageImageRenderer.parseRangeParameterValue(parameters.get(Parameters.FileImage.rightimagecrop));
            renderingParameters.rightImageCrop = rightCropValues;
        }
    }

    private int calcOptimalPageHeight(int srcWidth, int srcHeight, double rangeWidth, double rangeHeight, int boundingBoxWidth) {
        int rangeWidthInSrcResolution = (int)((double)srcWidth * rangeWidth);
        int rangeHeightInSrcResolution = (int)((double)srcHeight * rangeHeight);
        int optimalPageHeight = (int)((double)boundingBoxWidth * (double)rangeHeightInSrcResolution / (double)rangeWidthInSrcResolution);
        return optimalPageHeight;
    }

    private int calculateOptimalBoundingBoxWidth(int srcWidth, int srcHeight, double rangeWidth, double rangeHeight, int pageHeight) {
        int rangeWidthInSrcResolution = (int)((double)srcWidth * rangeWidth);
        int rangeHeightInSrcResolution = (int)((double)srcHeight * rangeHeight);
        int optimalBoundingBoxWidth = (int)((double)pageHeight * (double)rangeWidthInSrcResolution / (double)rangeHeightInSrcResolution);
        return optimalBoundingBoxWidth;
    }

    private int parseInnerGapParameter(String parameterValue, int srcWidth) {
        int result = 0;
        if (parameterValue != null) {
            try {
                Double d = FloatingParser.parseDouble(parameterValue);
                result = (int)Math.ceil((double)srcWidth * d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private int calculateBoundingBoxWidth(int srcWidth, double rangeWidth, int innerGap, int targetWidth) {
        int baseWidth = (int)Math.ceil(rangeWidth * (double)srcWidth);
        double optimalWidthScaleFactor = (double)targetWidth / (double)(baseWidth + innerGap);
        return (int)(optimalWidthScaleFactor * (double)baseWidth);
    }

    private void parseBackgroundColor(Parameters parameters, DoublePageImageRenderingParameters renderingParameters) {
        int bgcolor = this.defaultBackgroundColor;
        if (parameters.contains(Parameters.GeneralImage.backgroundcolor)) {
            bgcolor = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.backgroundcolor), bgcolor);
        }
        renderingParameters.backgroundColor = bgcolor;
    }

    private String[] extractSourcesFromParameter(String source) {
        String[] sources = source.split(",");
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = URL.cleanUpSourceParameter(sources[i]);
        }
        if (sources.length > 2) {
            String[] newSources = new String[2];
            for (int i = 0; i < 2; ++i) {
                newSources[i] = sources[i];
            }
            sources = newSources;
        }
        return sources;
    }

    private List<ImageMetaData> getMetaDataList(String[] sources, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        ArrayList<ImageMetaData> metadatalist = new ArrayList<ImageMetaData>();
        for (String imagesource : sources) {
            SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(imagesource);
            MetaData imd = this.settings.getImageBuilder().getImageMetaData(importerProfile, imagesource, 0, true, session);
            if (!(imd instanceof ImageMetaData)) {
                throw new IllegalArgumentException("two valid sources required");
            }
            imd.setAssetURLPath(imagesource);
            metadatalist.add((ImageMetaData)imd);
        }
        return metadatalist;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        } else if (name.equalsIgnoreCase("backgroundcolor")) {
            result = String.valueOf(this.defaultBackgroundColor);
        } else if (name.equalsIgnoreCase("defaultAlignment")) {
            result = String.valueOf((Object)this.defaultAlignment);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("backgroundcolor");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        try {
            if (name.equalsIgnoreCase("maxWidth")) {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            } else if (name.equalsIgnoreCase("maxHeight")) {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            } else if (name.equalsIgnoreCase("defaultWidth")) {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            } else if (name.equalsIgnoreCase("defaultHeight")) {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            } else if (name.equalsIgnoreCase("backgroundColor")) {
                this.defaultBackgroundColor = ColorParser.parseColor(value);
            } else if (name.equalsIgnoreCase("defaultAlignment")) {
                this.defaultAlignment = Crop.CropPadPosition.valueOf(value.toUpperCase());
            }
        }
        catch (NumberFormatException e) {
            this.settings.getFSILogger().log(2035, this.rendererName + ".xml", value, name);
        }
    }
}

