/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DirectoryImageRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.FreemarkerEntityFixer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FirstAssetInfoRenderer
extends RendererAbstract {
    private final SortingParameters sortingParameters = new SortingParameters();
    private final ImageBuilder standardImagebuilder;
    private int maxImages = 32;

    public FirstAssetInfoRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
        this.sortingParameters.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.sortingParameters.defaultSortOrder = RendererEnvironment.DEFAULT_SORT_ORDER;
        this.sortingParameters.defaultSortMethod = RendererEnvironment.DEFAULT_SORT_METHOD;
        this.sortingParameters.defaultSortLanguage = this.environment.getDefaultSortLanguage();
        this.sortingParameters.defaultSortCountry = this.environment.getDefaultSortCountry();
        this.sortingParameters.defaultSortCaseSensitive = false;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxImages")) {
            result = String.valueOf(this.maxImages);
        } else if (name.equalsIgnoreCase("defaultsortfield")) {
            result = this.sortingParameters.defaultSortField.name();
        } else if (name.equalsIgnoreCase("forcesortfield") && this.sortingParameters.forceSortField != null) {
            result = this.sortingParameters.forceSortField.name();
        } else if (name.equalsIgnoreCase("defaultsortorder")) {
            result = this.sortingParameters.defaultSortOrder.name();
        } else if (name.equalsIgnoreCase("forcesortorder") && this.sortingParameters.forceSortOrder != null) {
            result = this.sortingParameters.forceSortOrder.name();
        } else if (name.equalsIgnoreCase("defaultsortmethod")) {
            result = this.sortingParameters.defaultSortMethod.name();
        } else if (name.equalsIgnoreCase("forcesortmethod") && this.sortingParameters.forceSortMethod != null) {
            result = this.sortingParameters.forceSortMethod.name();
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            result = this.sortingParameters.defaultSortLanguage;
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            result = this.sortingParameters.forceSortLanguage;
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            result = this.sortingParameters.defaultSortCountry;
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            result = this.sortingParameters.forceSortCountry;
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            result = Boolean.toString(this.sortingParameters.defaultSortCaseSensitive);
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            result = Boolean.toString(this.sortingParameters.forceSortCaseSensitive);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException {
        RendererTextResponse response = new RendererTextResponse();
        try {
            this.processRequest1(req, response);
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
        catch (TemplateException e) {
            response.setStatus(500);
        }
        return response;
    }

    private RendererResponse processRequest1(HttpServletRequest req, RendererTextResponse response) throws NotConfiguredException, IOException, TemplateException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        HttpSession session = req.getSession(false);
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
        String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info";
        Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
        TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
        if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
            return FirstAssetInfoRenderer.generateNotAuthorizedResponse();
        }
        PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
        if (ps == null || !ps.read.basicMetadata.booleanValue()) {
            return FirstAssetInfoRenderer.generateNotAuthorizedResponse();
        }
        String firstAssetURLPath = this.getFirstAsset(parameters, connector, assetURLPath, session);
        if (firstAssetURLPath != null) {
            Escaper.EscaperType staticEscape = templateAttrs.getStaticEscape();
            int readFlag = templateAttrs.getReadFlag();
            SimpleHash templateData = new SimpleHash();
            templateData.put("query", (Object)parameters);
            MetaData imageMetaData = this.standardImagebuilder.getImageMetaData(connector, firstAssetURLPath, readFlag, true, session);
            SimpleHash infoHash = this.getSimpleHashFromMetaData(imageMetaData, staticEscape, ps.read);
            templateAttrs.setRendererResponseContentType(response);
            response.setDateHeader("Last-Modified", imageMetaData.getLastModified());
            if (imageMetaData instanceof ImageMetaData && ((ImageMetaData)imageMetaData).getImportStatus() != 1) {
                response.setDateHeader("Expires", 1000L);
                response.setHeader("Pragma", "no-cache, no-store");
                response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
            }
            templateData.put("info", (Object)infoHash);
            templateData.put("entityFixer", (Object)new FreemarkerEntityFixer());
            try (StringWriterFast sw = new StringWriterFast();){
                Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
                env.process();
                response.setBody(sw.toString());
                String eTagModifier = String.valueOf(imageMetaData.hashCode()) + template.getCustomAttribute("checksum");
                response.setETagModifier(eTagModifier);
                response.setStatus(200);
            }
        } else {
            response.setStatus(404);
        }
        return response;
    }

    private String getFirstAsset(Parameters parameters, SourceConnectorReader connector, String dirAssetURLPath, HttpSession session) throws IOException, NotConfiguredException {
        PoolList list;
        List<PoolFileEntry> filelist;
        PoolFileEntryComparator pfec = DirectoryImageRendererUtils.getComparator(parameters, this.sortingParameters);
        int offset = 0;
        int count = this.maxImages;
        if (parameters.contains(Parameters.DirectoryImage.limit)) {
            try {
                String limitval = parameters.get(Parameters.DirectoryImage.limit);
                String[] values = limitval.split(",", 2);
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException limitval) {
                // empty catch block
            }
        }
        if ((filelist = (list = this.standardImagebuilder.getPoolList(connector, dirAssetURLPath, session)).getFilesAsList()).size() > 0) {
            Collections.sort(filelist, pfec);
            return dirAssetURLPath + "/" + filelist.get((int)0).name;
        }
        return null;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("defaultSortField");
        result.add("forceSortField");
        result.add("defaultSortOrder");
        result.add("forceSortOrder");
        result.add("defaultSortMethod");
        result.add("forceSortMethod");
        result.add("defaultSortLanguage");
        result.add("forceSortLanguage");
        result.add("defaultSortCountry");
        result.add("forceSortCountry");
        result.add("defaultSortCaseSensitive");
        result.add("forceSortCaseSensitive");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxImages")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 1) {
                    this.maxImages = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultsortfield")) {
            this.sortingParameters.defaultSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortfield")) {
            this.sortingParameters.forceSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortorder")) {
            this.sortingParameters.defaultSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortorder")) {
            this.sortingParameters.forceSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortmethod")) {
            this.sortingParameters.defaultSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortmethod")) {
            this.sortingParameters.forceSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            this.sortingParameters.defaultSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            this.sortingParameters.forceSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            this.sortingParameters.defaultSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            this.sortingParameters.forceSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            this.sortingParameters.defaultSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            this.sortingParameters.forceSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
            this.sortingParameters.forceSortCaseSensitiveSet = true;
        }
    }
}

