/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ICCInfoRenderer
extends RendererAbstract {
    private static final int DESC = 1684370275;
    private static final int MLUC = 1835824483;

    public ICCInfoRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public String getOption(String name) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        HttpSession session = req.getSession(false);
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            return ICCInfoRenderer.generateMissingParameterResponse("source");
        }
        RendererTextResponse response = new RendererTextResponse();
        try {
            byte[] bXYZBytes;
            SimpleSequence blueCol;
            byte[] gXYZBytes;
            SimpleSequence greenCol;
            byte[] rXYZBytes;
            SimpleSequence redCol;
            byte[] blackPointBytes;
            SimpleSequence bps;
            byte[] whitePointBytes;
            SimpleSequence wps;
            byte[] description;
            String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info";
            Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
            TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
            templateAttrs.setRendererResponseContentType(response);
            if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
                return ICCInfoRenderer.generateNotAuthorizedResponse();
            }
            Escaper.EscaperType staticEscape = templateAttrs.getStaticEscape();
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
            if (ps == null || !ps.read.iccProfiles.booleanValue()) {
                return ICCInfoRenderer.generateNotAuthorizedResponse();
            }
            MetaData md = this.settings.getImageBuilder().getImageMetaData(connector, assetURLPath, 2, true, session);
            if (md == null || !(md instanceof ImageMetaData)) throw new IllegalArgumentException("ICC requests not supported for non-image files.");
            ImageMetaData imd = (ImageMetaData)md;
            if (imd.getImportStatus() != 1) {
                response.setDateHeader("Expires", 1000L);
                response.setHeader("Pragma", "no-cache, no-store");
                response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
            }
            response.setDateHeader("Last-Modified", md.getLastModified());
            byte[] iccBytes = null;
            ICCProfileWrap ipw = imd.getICC();
            if (ipw != null) {
                iccBytes = ipw.getBytes();
            }
            if (iccBytes == null || iccBytes.length <= 0) throw new IllegalArgumentException("No ICC profile found.");
            ICC_Profile icc = ICC_Profile.getInstance(iccBytes);
            SimpleHash templateData = new SimpleHash();
            HashMap<String, String> header = new HashMap<String, String>();
            HashMap<String, String> tags = new HashMap<String, String>();
            header.put("size", Long.toString(iccBytes.length));
            header.put("version", icc.getMajorVersion() + "." + icc.getMinorVersion());
            header.put("components", Integer.toString(icc.getNumComponents()));
            header.put("type", this.getProfileClass(icc));
            icc.getPCSType();
            icc.getColorSpaceType();
            byte[] copyright = icc.getData(1668313716);
            if (copyright != null) {
                tags.put("copyright", this.readSimpleString(copyright));
            }
            if ((description = icc.getData(1684370275)) != null) {
                tags.put("description", this.readSimpleString(description));
            }
            if ((wps = this.getXYZSequence(whitePointBytes = icc.getData(0x77747074), staticEscape)) != null) {
                templateData.put("whitePoint", (Object)wps);
            }
            if ((bps = this.getXYZSequence(blackPointBytes = icc.getData(1651208308), staticEscape)) != null) {
                templateData.put("blackPoint", (Object)bps);
            }
            if ((redCol = this.getXYZSequence(rXYZBytes = icc.getData(1918392666), staticEscape)) != null) {
                templateData.put("redColorant", (Object)redCol);
            }
            if ((greenCol = this.getXYZSequence(gXYZBytes = icc.getData(1733843290), staticEscape)) != null) {
                templateData.put("greenColorant", (Object)greenCol);
            }
            if ((blueCol = this.getXYZSequence(bXYZBytes = icc.getData(1649957210), staticEscape)) != null) {
                templateData.put("blueColorant", (Object)blueCol);
            }
            byte[] headBytes = icc.getData(1751474532);
            ByteArrayWalker head = ByteArrayWalker.wrap(headBytes, ByteOrder.BIG_ENDIAN);
            int intent = head.getInt(64);
            header.put("intent", this.getIntent(intent));
            header.put("cmm", ICCInfoRenderer.escapeString(this.toSignatureString(head.getInt(4)), staticEscape));
            header.put("manufacturer", ICCInfoRenderer.escapeString(this.toSignatureString(head.getInt(48)), staticEscape));
            header.put("creator", ICCInfoRenderer.escapeString(this.toSignatureString(head.getInt(80)), staticEscape));
            byte[] iccDate = new byte[12];
            head.position(24);
            head.get(iccDate);
            header.put("date", ICCInfoRenderer.escapeString(Long.toString(this.getDate(iccDate)), staticEscape));
            templateData.put("header", (Object)this.getSimpleHeaderSequence(header, staticEscape));
            templateData.put("tags", (Object)this.getSimpleHeaderSequence(tags, staticEscape));
            templateData.put("query", (Object)parameters);
            try (StringWriterFast sw = new StringWriterFast();){
                Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
                env.process();
                response.setBody(sw.toString());
            }
            response.setStatus(200);
            return response;
        }
        catch (NoSuchFileException e) {
            return ICCInfoRenderer.generateNotFoundResponse();
        }
        catch (IOException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            return response;
        }
        catch (TemplateException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
            return response;
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    private SimpleSequence getSimpleHeaderSequence(Map<String, String> map, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)ICCInfoRenderer.escapeString(entry.getKey(), escapeString));
            kp.put("name", (Object)ICCInfoRenderer.escapeString(entry.getValue(), escapeString));
            result.add((Object)kp);
        }
        return result;
    }

    private SimpleSequence getSimpleFloatSequence(Map<String, Float> map, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)ICCInfoRenderer.escapeString(entry.getKey(), escapeString));
            kp.put("name", (Object)entry.getValue());
            result.add((Object)kp);
        }
        return result;
    }

    private String getProfileClass(ICC_Profile icc) {
        int classTypeInt = icc.getProfileClass();
        String classTypeStr = classTypeInt == 0 ? "Input" : (classTypeInt == 1 ? "Display" : (classTypeInt == 2 ? "Output" : (classTypeInt == 3 ? "Device" : (classTypeInt == 4 ? "Conversion" : (classTypeInt == 5 ? "Abstract" : (classTypeInt == 6 ? "Named Color" : "Unknown"))))));
        return classTypeStr;
    }

    private SimpleSequence getXYZSequence(byte[] bytes, Escaper.EscaperType staticEscape) {
        if (bytes != null) {
            float[] f = this.getXYZ(bytes);
            HashMap<String, Float> xyz = new HashMap<String, Float>();
            xyz.put("X", Float.valueOf(f[0]));
            xyz.put("Y", Float.valueOf(f[1]));
            xyz.put("Z", Float.valueOf(f[2]));
            return this.getSimpleFloatSequence(xyz, staticEscape);
        }
        return null;
    }

    private String getIntent(int value) {
        switch (value) {
            case 0: {
                return "Perceptual";
            }
            case 1: {
                return "Relative";
            }
            case 3: {
                return "Absolute";
            }
            case 2: {
                return "Saturation";
            }
        }
        return "unknown indent";
    }

    private float[] getXYZ(byte[] data) {
        float[] theXYZNumber = new float[3];
        int i1 = 0;
        int i2 = 8;
        while (i1 < 3) {
            int theS15Fixed16 = this.intFromBigEndian(data, i2);
            theXYZNumber[i1] = (float)theS15Fixed16 / 65536.0f;
            ++i1;
            i2 += 4;
        }
        return theXYZNumber;
    }

    private int intFromBigEndian(byte[] array, int index) {
        return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | array[index + 3] & 0xFF;
    }

    private String readSimpleString(byte[] data) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        int sig = bb.getInt();
        if (sig == 1684370275) {
            return this.readDESC(bb);
        }
        if (sig == 1835824483) {
            return this.readMLUC(bb);
        }
        return null;
    }

    private String readDESC(ByteArrayWalker bb) {
        bb.position(bb.position() + 4);
        int length = bb.getInt();
        byte[] utf16 = new byte[length];
        bb.get(utf16);
        return new String(utf16, FileOperations.charsetASCII);
    }

    private String readMLUC(ByteArrayWalker bb) {
        bb.position(bb.position() + 4);
        int firstOffset = bb.getInt();
        bb.position(bb.position() + firstOffset - 8);
        int nLen = bb.getInt();
        bb.getInt();
        byte[] utf16 = new byte[nLen];
        bb.get(utf16);
        return new String(utf16, FileOperations.charsetUTF16BE);
    }

    private String toSignatureString(int sig) {
        StringBuffer sb = new StringBuffer();
        sb.append((char)(sig >> 24 & 0xFF));
        sb.append((char)(sig >> 16 & 0xFF));
        sb.append((char)(sig >> 8 & 0xFF));
        sb.append((char)(sig & 0xFF));
        return sb.toString();
    }

    private long getDate(byte[] iccDate) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(iccDate, ByteOrder.BIG_ENDIAN);
        short year = bb.getShort();
        short month = bb.getShort();
        short day = bb.getShort();
        short hrs = bb.getShort();
        short min = bb.getShort();
        short sec = bb.getShort();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC_TIME"));
        cal.set(year, month, day, hrs, min, sec);
        Date date = cal.getTime();
        long result = date.getTime() / 1000L;
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String name, String value) {
    }
}

