/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiframework.security.RC4;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.converter.ColorConverterCache;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.reader.ImageIOHelper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public class ImageLicenceRenderer
extends RendererAbstract {
    private final ResourceHelper rh;
    private final HashMap<Integer, Pair<FSIImageLimited, FSIImageLimited>> imageCache = new HashMap();
    private final byte[] jsKey = new byte[]{64, 89, 12, 0, 78, 19, 73, 42, 86, 2, 5};

    public ImageLicenceRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.rh = new ResourceHelper();
        this.addAllowedGroup("public");
    }

    @Override
    public String getOption(String name) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        Pair<FSIImageLimited, FSIImageLimited> imagePair;
        RendererImageResponse response = new RendererImageResponse();
        response.setIsLicenceImage(true);
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        if (parameters.getType() != Parameters.Type.IMAGE) throw new IllegalArgumentException("invalid type");
        int id = 0;
        int version = 0;
        String action = "";
        boolean pass = true;
        if (!parameters.contains(Parameters.FileImage.cmd)) {
            pass = false;
        } else {
            String cmdraw = parameters.get(Parameters.FileImage.cmd);
            byte[] code64 = Base64.decodeBase64((String)cmdraw);
            byte[] decrypted = RC4.encode(this.jsKey, code64);
            String cmdline = new String(decrypted, FileOperations.charsetUTF8);
            String[] cmds = cmdline.split("&");
            for (String cmd : cmds) {
                String[] cmdPair = cmd.split("=", 2);
                if (cmdPair.length != 2) continue;
                try {
                    if (cmdPair[0].equals("id")) {
                        id = Integer.valueOf(cmdPair[1]);
                        continue;
                    }
                    if (cmdPair[0].equals("version")) {
                        version = Integer.valueOf(cmdPair[1]);
                        continue;
                    }
                    if (!cmdPair[0].equals("action")) continue;
                    action = cmdPair[1];
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (id == 0 || version == 0) {
            pass = false;
        }
        if (!pass) throw new IllegalArgumentException("missing parameter");
        boolean hasValidLicence = false;
        Licence licence = this.settings.getLicence();
        FSIServerSettings.LicenceState licState = this.settings.isLicensed(licence);
        Map<String, String> modules = this.settings.getLicence().getModules();
        for (Map.Entry entry : modules.entrySet()) {
            char[] testChars = new char[((String)entry.getKey()).length()];
            ((String)entry.getKey()).getChars(0, testChars.length, testChars, 0);
            if (!Arrays.equals(testChars, Defines.PAGESMOBILE)) continue;
            hasValidLicence = Boolean.valueOf((String)entry.getValue());
            break;
        }
        if ((imagePair = this.getImage(priority, id, licence)) != null) {
            if (licState == FSIServerSettings.LicenceState.VALID && action.equals("pass") && hasValidLicence) {
                response.setResponseImage(imagePair.getItem2().createCopy());
            } else {
                response.setResponseImage(imagePair.getItem1().createCopy());
            }
            response.setStatus(200);
            if (licence == null) return response;
            if (licence.getFileLastModified() > 0L) {
                response.setDateHeader("Last-Modified", licence.getFileLastModified());
            } else {
                response.setCacheable(false);
                response.setHeader("Pragma", "no-cache, no-store");
                response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
            }
            response.setETagModifier(Integer.toString(licence.hashCode()));
            return response;
        } else {
            response.setStatus(500);
        }
        return response;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return null;
    }

    @Override
    public void setOption(String name, String value) {
    }

    private Pair<FSIImageLimited, FSIImageLimited> getImage(int priority, int id, Licence licence) {
        Pair<FSIImageLimited, FSIImageLimited> images = this.imageCache.get(id);
        if (images == null) {
            try {
                String licensee = null;
                if (licence != null) {
                    licensee = licence.getLicensee();
                }
                FSIImageLimited orgImage = this.loadImage(id, priority);
                FSIImageLimited licImage = this.makeLicencePNG(orgImage, licensee);
                images = new Pair<FSIImageLimited, FSIImageLimited>(orgImage, licImage);
                this.imageCache.put(id, images);
            }
            catch (InterruptedException licensee) {
            }
            catch (IOException ioe) {
                this.settings.getFSILogger().logException(ioe, 3262, new Object[0]);
            }
        }
        return images;
    }

    private BufferedImage getBufferedImageFromResource(String resourceLocation) throws IOException {
        BufferedImage result;
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast();
             InputStream iccstream2 = this.rh.getResourceAsStream(resourceLocation);){
            int i;
            while ((i = iccstream2.read()) != -1) {
                baos.write(i);
            }
            iccstream2.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            try (MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bais);){
                ImageReader imgReader = ImageIOHelper.getReader("com.sun", "png");
                imgReader.setInput(iis);
                result = imgReader.read(0);
                imgReader.dispose();
                imgReader = null;
            }
        }
        return result;
    }

    private FSIImageLimited loadImage(int id, int priority) throws IOException, InterruptedException {
        FSIImageLimited image = null;
        BufferedImage bufferedImage = this.getBufferedImageFromResource("/com/neptunelabs/fsiserver/resources/img/about" + id + ".png");
        ColorConverterCache ccc = new ColorConverterCache(1);
        BufferedImageConverterThreaded converter = new BufferedImageConverterThreaded(this.settings.getFSILogger(), this.settings.getExecutorPool(), ccc);
        BufferedImageWrap biw = new BufferedImageWrap(bufferedImage, converter.getClutCache());
        biw.initColorConverter(ColorType.RGB24);
        image = new FSIImageLimited(this.settings.getFSILogger(), this.settings.getSwapPool(), this.settings.getByteOrder(), biw.width, biw.height, null, FSIImageMode.RGB);
        converter.convert(priority, 1, ExecutorPool.Type.RENDERER_CPU, biw, image, 0, 0);
        return image;
    }

    private FSIImageLimited makeLicencePNG(FSIImageLimited orgImage, String licensee) {
        byte[] licName;
        FSIImageLimited newImage = orgImage.createCopy();
        if (licensee != null && (licName = ImageLicenceRenderer.incXOR(licensee.getBytes(FileOperations.charsetUTF8))) != null) {
            byte[] key = new byte[]{116, 107, 76, 122};
            newImage.setCustomData(key, licName);
        }
        return newImage;
    }

    private static byte[] incXOR(byte[] data) {
        int xor = 98;
        int i = 0;
        while (i < data.length) {
            byte nxor = (byte)(data[i] ^ xor);
            int n = i++;
            data[n] = (byte)(data[n] ^ xor);
            xor = nxor;
        }
        return data;
    }

    private static final class ResourceHelper {
        public InputStream getResourceAsStream(String resource) {
            return this.getClass().getResourceAsStream(resource);
        }
    }
}

