/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.metrics.HistogramRenderer;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class MetricsImageRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;

    public MetricsImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new HashSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws IllegalArgumentException {
        RendererImageResponse response;
        block10: {
            HttpSession session = req.getSession(false);
            Parameters parameters = (Parameters)req.getAttribute("parameters");
            String assetURLPath = parameters.getAssetURLPath();
            String channel = parameters.get(Parameters.FileImage.channel);
            if (assetURLPath == null) {
                return MetricsImageRenderer.generateMissingParameterResponse("source");
            }
            if (channel == null) {
                return MetricsImageRenderer.generateMissingParameterResponse("channel");
            }
            response = new RendererImageResponse();
            try {
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                PermissionSet permissions = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (permissions == null || !permissions.read.renderedImages.booleanValue() || !permissions.read.extendedMetadata.booleanValue()) {
                    return MetricsImageRenderer.generateNotAuthorizedResponse();
                }
                HistogramRenderer.HistogramChannel c = HistogramRenderer.HistogramChannel.valueOf(channel.toUpperCase());
                MetaData md = this.standardImagebuilder.getImageMetaData(connector, assetURLPath, 32, true, session);
                if (md != null && md instanceof ImageMetaData) {
                    ImageMetaData imd = (ImageMetaData)md;
                    Histogram histogram = imd.getHistogram();
                    if (histogram != null) {
                        HistogramRenderer hr = new HistogramRenderer(this.settings.getFSILogger(), this.settings.getSwapPool(), this.settings.getExecutorPool(), histogram);
                        FSIImageLimited histogramImage = hr.drawHistogram(priority, c);
                        response.setResponseImage(histogramImage);
                        response.setStatus(200);
                    }
                    break block10;
                }
                throw new IllegalArgumentException("Histogram requests not supported for non-image files.");
            }
            catch (NoSuchFileException e) {
                this.settings.getFSILogger().log(3190, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                this.settings.getFSILogger().log(3190, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid channel value.");
            }
            catch (NotConfiguredException e) {
                response.setStatus(503);
                this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
        }
        return response;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String name, String value) {
    }

    @Override
    public String getOption(String name) {
        return null;
    }
}

