/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.imagereader.metrics.Histogram;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MetricsInfoRenderer
extends RendererAbstract {
    public MetricsInfoRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public String getOption(String name) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        RendererTextResponse response;
        block30: {
            HttpSession session = req.getSession(false);
            Parameters parameters = (Parameters)req.getAttribute("parameters");
            String assetURLPath = parameters.getAssetURLPath();
            if (assetURLPath == null) {
                return MetricsInfoRenderer.generateMissingParameterResponse("source");
            }
            response = new RendererTextResponse();
            try {
                String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info";
                Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
                TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
                templateAttrs.setRendererResponseContentType(response);
                Escaper.EscaperType staticEscape = templateAttrs.getStaticEscape();
                if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
                    return MetricsInfoRenderer.generateNotAuthorizedResponse();
                }
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (ps == null || !ps.read.basicMetadata.booleanValue() || !ps.read.extendedMetadata.booleanValue()) {
                    return MetricsInfoRenderer.generateNotAuthorizedResponse();
                }
                MetaData md = this.settings.getImageBuilder().getImageMetaData(connector, assetURLPath, 32, true, session);
                if (md != null && md instanceof ImageMetaData) {
                    ImageMetaData imd = (ImageMetaData)md;
                    if (imd.getImportStatus() != 1) {
                        response.setDateHeader("Expires", 1000L);
                        response.setHeader("Pragma", "no-cache, no-store");
                        response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
                    }
                    response.setDateHeader("Last-Modified", md.getLastModified());
                    Histogram histogram = imd.getHistogram();
                    if (histogram != null) {
                        SimpleHash templateData = new SimpleHash();
                        templateData.put("pixels", (Object)histogram.pixel);
                        HashMap<String, Float> fraction = new HashMap<String, Float>();
                        fraction.put("redFraction", Float.valueOf(histogram.redFraction));
                        fraction.put("greenFraction", Float.valueOf(histogram.greenFraction));
                        fraction.put("blueFraction", Float.valueOf(histogram.blueFraction));
                        templateData.put("fraction", (Object)this.getSimpleFloatSequence(fraction, staticEscape));
                        HashMap<String, Integer> min = new HashMap<String, Integer>();
                        min.put("redMin", histogram.redMin & 0xFF);
                        min.put("greenMin", histogram.greenMin & 0xFF);
                        min.put("blueMin", histogram.blueMin & 0xFF);
                        min.put("saturationMin", histogram.saturationMin & 0xFF);
                        min.put("brightnessMin", histogram.brightnessMin & 0xFF);
                        templateData.put("min", (Object)this.getSimpleIntegerSequence(min, staticEscape));
                        HashMap<String, Integer> max = new HashMap<String, Integer>();
                        max.put("redMax", histogram.redMax & 0xFF);
                        max.put("greenMax", histogram.greenMax & 0xFF);
                        max.put("blueMax", histogram.blueMax & 0xFF);
                        max.put("saturationMax", histogram.saturationMax & 0xFF);
                        max.put("brightnessMax", histogram.brightnessMax & 0xFF);
                        templateData.put("max", (Object)this.getSimpleIntegerSequence(max, staticEscape));
                        SimpleSequence statRed = new SimpleSequence();
                        for (float s : histogram.statisticRed) {
                            statRed.add((Object)Float.valueOf(s));
                        }
                        templateData.put("redHistogram", (Object)statRed);
                        SimpleSequence statGreen = new SimpleSequence();
                        for (float s : histogram.statisticGreen) {
                            statGreen.add((Object)Float.valueOf(s));
                        }
                        templateData.put("greenHistogram", (Object)statGreen);
                        SimpleSequence statBlue = new SimpleSequence();
                        for (float s : histogram.statisticBlue) {
                            statBlue.add((Object)Float.valueOf(s));
                        }
                        templateData.put("blueHistogram", (Object)statBlue);
                        SimpleSequence statHue = new SimpleSequence();
                        for (float s : histogram.statisticHue) {
                            statHue.add((Object)Float.valueOf(s));
                        }
                        templateData.put("hueHistogram", (Object)statHue);
                        SimpleSequence statSat = new SimpleSequence();
                        for (float s : histogram.statisticSaturation) {
                            statSat.add((Object)Float.valueOf(s));
                        }
                        templateData.put("saturationHistogram", (Object)statSat);
                        SimpleSequence statBri = new SimpleSequence();
                        for (float s : histogram.statisticBrightness) {
                            statBri.add((Object)Float.valueOf(s));
                        }
                        templateData.put("brightnessHistogram", (Object)statBri);
                        templateData.put("query", (Object)parameters);
                        try (StringWriterFast sw = new StringWriterFast();){
                            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
                            env.process();
                            response.setBody(sw.toString());
                        }
                        response.setStatus(200);
                        break block30;
                    }
                    response.setStatus(404);
                    break block30;
                }
                throw new IllegalArgumentException("Histogram requests not supported for non-image files.");
            }
            catch (NoSuchFileException e) {
                return MetricsInfoRenderer.generateNotFoundResponse();
            }
            catch (IOException e) {
                response.setStatus(500);
                this.settings.getFSILogger().logException(e, 3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (TemplateException e) {
                response.setStatus(500);
                this.settings.getFSILogger().logException((Exception)((Object)e), 3191, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (NotConfiguredException e) {
                response.setStatus(503);
                this.settings.getFSILogger().logException(e, 3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
        }
        return response;
    }

    private SimpleSequence getSimpleFloatSequence(Map<String, Float> map, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)MetricsInfoRenderer.escapeString(entry.getKey(), escapeString));
            kp.put("name", (Object)entry.getValue());
            result.add((Object)kp);
        }
        return result;
    }

    private SimpleSequence getSimpleIntegerSequence(Map<String, Integer> map, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)MetricsInfoRenderer.escapeString(entry.getKey(), escapeString));
            kp.put("name", (Object)entry.getValue());
            result.add((Object)kp);
        }
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String name, String value) {
    }
}

