/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DirectoryImageRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.pyramidreader.FlatImageException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MultiImageRenderer
extends RendererAbstract {
    private SortingParameters sortingParameters = new SortingParameters();
    private final ImageBuilder standardImagebuilder;
    private int maxImages = 32;
    private boolean keepAspectRatio = true;
    private String errorFallback = null;
    private String importingFallback = null;

    public MultiImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        int i2;
        String s;
        this.standardImagebuilder = settings.getImageBuilder();
        this.sortingParameters.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.sortingParameters.defaultSortOrder = RendererEnvironment.DEFAULT_SORT_ORDER;
        this.sortingParameters.defaultSortMethod = RendererEnvironment.DEFAULT_SORT_METHOD;
        this.sortingParameters.defaultSortLanguage = this.environment.getDefaultSortLanguage();
        this.sortingParameters.defaultSortCountry = this.environment.getDefaultSortCountry();
        this.sortingParameters.defaultSortCaseSensitive = false;
        int l = settings.getPrefsInt("limits", "maxwidth");
        if (l > 0) {
            this.maxWidth = l;
        }
        if ((l = settings.getPrefsInt("limits", "maxheight")) > 0) {
            this.maxHeight = l;
        }
        if ((s = settings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.defaultWidth = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultWidth = i2;
                }
            }
            catch (NumberFormatException i2) {
                // empty catch block
            }
        }
        s = settings.getPrefsString("limits", "defaultheight");
        if (s.equalsIgnoreCase("source")) {
            this.defaultHeight = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultHeight = i2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            result = String.valueOf(this.keepAspectRatio);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            result = this.errorFallback;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            result = this.importingFallback;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        } else if (name.equalsIgnoreCase("maxImages")) {
            result = String.valueOf(this.maxImages);
        } else if (name.equalsIgnoreCase("defaultsortfield")) {
            result = this.sortingParameters.defaultSortField.name();
        } else if (name.equalsIgnoreCase("forcesortfield") && this.sortingParameters.forceSortField != null) {
            result = this.sortingParameters.forceSortField.name();
        } else if (name.equalsIgnoreCase("defaultsortorder")) {
            result = this.sortingParameters.defaultSortOrder.name();
        } else if (name.equalsIgnoreCase("forcesortorder") && this.sortingParameters.forceSortOrder != null) {
            result = this.sortingParameters.forceSortOrder.name();
        } else if (name.equalsIgnoreCase("defaultsortmethod")) {
            result = this.sortingParameters.defaultSortMethod.name();
        } else if (name.equalsIgnoreCase("forcesortmethod") && this.sortingParameters.forceSortMethod != null) {
            result = this.sortingParameters.forceSortMethod.name();
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            result = this.sortingParameters.defaultSortLanguage;
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            result = this.sortingParameters.forceSortLanguage;
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            result = this.sortingParameters.defaultSortCountry;
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            result = this.sortingParameters.forceSortCountry;
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            result = Boolean.toString(this.sortingParameters.defaultSortCaseSensitive);
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            result = Boolean.toString(this.sortingParameters.forceSortCaseSensitive);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        RendererResponse result = this.checkStandardImageRequestParameters(parameters);
        if (result != null) {
            return result;
        }
        if (parameters.getType() != Parameters.Type.DIRECTORYIMAGE) {
            throw new IllegalArgumentException("invalid type");
        }
        result = this.processImageRequest(priority, this.standardImagebuilder, req);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("keepaspectratio");
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("defaultSortField");
        result.add("forceSortField");
        result.add("defaultSortOrder");
        result.add("forceSortOrder");
        result.add("defaultSortMethod");
        result.add("forceSortMethod");
        result.add("defaultSortLanguage");
        result.add("forceSortLanguage");
        result.add("defaultSortCountry");
        result.add("forceSortCountry");
        result.add("defaultSortCaseSensitive");
        result.add("forceSortCaseSensitive");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            this.keepAspectRatio = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            this.errorFallback = value;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            this.importingFallback = value;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultWidth = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultWidth = i;
                    }
                }
                catch (NumberFormatException e) {
                    this.settings.getFSILogger().log(3043, value, name, this.rendererName);
                }
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultHeight = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultHeight = i;
                    }
                }
                catch (NumberFormatException e) {
                    this.settings.getFSILogger().log(3043, value, name, this.rendererName);
                }
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxImages")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 1) {
                    this.maxImages = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultsortfield")) {
            this.sortingParameters.defaultSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortfield")) {
            this.sortingParameters.forceSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortorder")) {
            this.sortingParameters.defaultSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortorder")) {
            this.sortingParameters.forceSortOrder = SortDirection.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortmethod")) {
            this.sortingParameters.defaultSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("forcesortmethod")) {
            this.sortingParameters.forceSortMethod = SortMethod.valueOf(value.toUpperCase());
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            this.sortingParameters.defaultSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            this.sortingParameters.forceSortLanguage = value.toLowerCase();
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            this.sortingParameters.defaultSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            this.sortingParameters.forceSortCountry = value.toUpperCase();
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            this.sortingParameters.defaultSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            this.sortingParameters.forceSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
            this.sortingParameters.forceSortCaseSensitiveSet = true;
        }
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        RendererTextResponse errorResponse = null;
        if (parameters.contains(Parameters.GeneralImage.width)) {
            int width = -1;
            try {
                width = Integer.parseInt(parameters.get(Parameters.GeneralImage.width));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width <= 0) {
                errorResponse = MultiImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.width));
            }
        }
        if (errorResponse == null && parameters.contains(Parameters.GeneralImage.height)) {
            int height = -1;
            try {
                height = Integer.parseInt(parameters.get(Parameters.GeneralImage.height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (height <= 0) {
                errorResponse = MultiImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.height));
            }
        }
        return errorResponse;
    }

    private RendererResponse processImageRequest(int priority, ImageBuilder imageBuilder, HttpServletRequest request) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse response;
        block11: {
            response = new RendererImageResponse();
            Parameters parameters = (Parameters)request.getAttribute("parameters");
            String assetURLPath = parameters.getAssetURLPath();
            HttpSession session = request.getSession(false);
            boolean parameterCombinationValid = this.checkParameterCombinationForImageRequest(parameters);
            if (!parameterCombinationValid) {
                response.setStatus(400);
            } else {
                try {
                    SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
                    PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                    if (ps != null && ps.read.renderedImages.booleanValue()) {
                        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
                        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
                        if (widthPair.getItem2().booleanValue()) {
                            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
                        }
                        if (heightPair.getItem2().booleanValue()) {
                            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
                        }
                        try {
                            this.processFileImageRequest(connector, priority, imageBuilder, assetURLPath, parameters, widthPair, heightPair, request, response);
                            break block11;
                        }
                        catch (NoSuchFileException e) {
                            response.setStatus(404);
                            break block11;
                        }
                        catch (IOException e) {
                            response.setStatus(500);
                            break block11;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid range value");
                        }
                    }
                    return MultiImageRenderer.generateNotAuthorizedResponse();
                }
                catch (NotConfiguredException e) {
                    this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
                    return MultiImageRenderer.generateUnavailableResponse();
                }
            }
        }
        return response;
    }

    private void processFileImageRequest(SourceConnectorReader sourceConnector, int priority, ImageBuilder imagebuilder, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnector == null || sourceConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
            this.processDynamicFileImageRequest(sourceConnector, priority, imagebuilder, assetURLPath, parameters, widthPair, heightPair, request, response);
        } else {
            this.processMimeTypeImageRequest(priority, assetURLPath, parameters, widthPair, heightPair, request, response);
        }
    }

    private void processMimeTypeImageRequest(int priority, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        String suffix = this.getSuffixFromAssetURLPath(assetURLPath);
        String imageFilename = MimeTypeImageMapping.getImageFilename(suffix);
        String mimeImageURLPath = "mime/" + imageFilename;
        parameters.put(Parameters.General.renderer, "_private");
        request.setAttribute("mimeImageRequest", (Object)true);
        this.processDynamicFileImageRequest(null, priority, this.standardImagebuilder, mimeImageURLPath, parameters, widthPair, heightPair, request, response);
    }

    private String getSuffixFromAssetURLPath(String assetURLPath) {
        try {
            int suffixStart = assetURLPath.lastIndexOf(".") + 1;
            String suffix = assetURLPath.substring(suffixStart);
            if (suffix.equals("gz") || suffix.equals("bz2")) {
                suffixStart = assetURLPath.lastIndexOf(".", suffixStart - 2);
                suffix = assetURLPath.substring(suffixStart);
            }
            return suffix;
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    private boolean checkParameterCombinationForImageRequest(Parameters parameters) {
        return !parameters.contains(Parameters.GeneralImage.pixelrange) && !parameters.contains(Parameters.GeneralImage.pixeltop) && !parameters.contains(Parameters.GeneralImage.pixelleft) && !parameters.contains(Parameters.GeneralImage.pixelright) && !parameters.contains(Parameters.GeneralImage.pixelbottom) || !parameters.contains(Parameters.GeneralImage.rect) && !parameters.contains(Parameters.GeneralImage.top) && !parameters.contains(Parameters.GeneralImage.left) && !parameters.contains(Parameters.GeneralImage.right) && !parameters.contains(Parameters.GeneralImage.bottom) && !parameters.contains(Parameters.GeneralImage.width) && !parameters.contains(Parameters.GeneralImage.height);
    }

    private void processDynamicFileImageRequest(SourceConnectorReader sourceConnector, int priority, ImageBuilder imagebuilder, String dirAssetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        ArrayList<FSIImageLimited> resultImages = new ArrayList<FSIImageLimited>();
        PoolFileEntryComparator pfec = DirectoryImageRendererUtils.getComparator(parameters, this.sortingParameters);
        int offset = 0;
        int count = this.maxImages;
        if (parameters.contains(Parameters.DirectoryImage.limit)) {
            try {
                String limitval = parameters.get(Parameters.DirectoryImage.limit);
                String[] values = limitval.split(",", 2);
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException limitval) {
                // empty catch block
            }
        }
        HttpSession session = request.getSession(false);
        PoolList list = imagebuilder.getPoolList(sourceConnector, dirAssetURLPath, session);
        List<PoolFileEntry> filelist = list.getFilesAsList();
        Collections.sort(filelist, pfec);
        this.limitList(filelist, offset, count);
        for (PoolFileEntry pfe : filelist) {
            boolean isMimeImageRequest;
            short importStatus;
            String assetURLPath = dirAssetURLPath + "/" + pfe.name;
            MetaData metadata = imagebuilder.getImageMetaData(sourceConnector, assetURLPath, 0, true, session);
            if (metadata == null) {
                response.setStatus(404);
                return;
            }
            if (!(metadata instanceof ImageMetaData)) {
                throw new IllegalArgumentException("processDynamicFileImageRequest called for non-image profile.");
            }
            ImageMetaData imagemetadata = (ImageMetaData)metadata;
            if (widthPair.getItem1() == 0) {
                widthPair.setItem1(Math.min(imagemetadata.getWidth(), this.maxWidth));
            }
            if (heightPair.getItem1() == 0) {
                heightPair.setItem1(Math.min(imagemetadata.getHeight(), this.maxHeight));
            }
            if ((importStatus = (short)imagemetadata.getImportStatus()) != 1 && importStatus != 4) {
                this.createFallbackResponse(assetURLPath, parameters, importStatus, response);
                return;
            }
            boolean isPrivateConnector = parameters.get(Parameters.General.renderer) != null && parameters.get(Parameters.General.renderer).equals("_private");
            boolean bl = isMimeImageRequest = request.getAttribute("mimeImageRequest") != null && (Boolean)request.getAttribute("mimeImageRequest") != false;
            if (isMimeImageRequest || isPrivateConnector) {
                sourceConnector = null;
            }
            if (isPrivateConnector && !isMimeImageRequest) {
                response.setDateHeader("Expires", 1000L);
                response.setHeader("Pragma", "no-cache, no-store");
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            } else {
                long lmdate = imagemetadata.getLastModified();
                response.setDateHeader("Last-Modified", lmdate);
            }
            FSIImageLimited image = null;
            double[] relativeRange = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
            int[] pixelRange = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
            boolean pixelBased = false;
            if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
                MultiImageRenderer.getRelativeRangeFromParameters(parameters, relativeRange);
            } else if (parameters.contains(Parameters.GeneralImage.pixelrange) || parameters.contains(Parameters.GeneralImage.pixeltop) || parameters.contains(Parameters.GeneralImage.pixelleft) || parameters.contains(Parameters.GeneralImage.pixelright) || parameters.contains(Parameters.GeneralImage.pixelbottom)) {
                pixelBased = true;
                this.getPixelRangeFromParameters(parameters, pixelRange);
            }
            try {
                if (pixelBased) {
                    int[] referenceDimensions = MultiImageRenderer.getReferenceDimensions(parameters);
                    image = imagebuilder.getImagePixelBased(null, sourceConnector, priority, assetURLPath, referenceDimensions[0], referenceDimensions[1], pixelRange[0], pixelRange[1], pixelRange[2], pixelRange[3], this.keepAspectRatio, FSIInterpolation.LANCZOS);
                } else {
                    image = imagebuilder.getImage(null, sourceConnector, priority, assetURLPath, widthPair, heightPair, relativeRange[0], relativeRange[1], relativeRange[2], relativeRange[3], this.keepAspectRatio, FSIInterpolation.LANCZOS);
                }
            }
            catch (FlatImageException e) {
                this.createFallbackResponse(assetURLPath, parameters, (short)5, response);
                return;
            }
            if (image != null) {
                String profilename = parameters.get(Parameters.General.renderer);
                if (profilename != null && profilename.equals("_private")) {
                    ExecutorPool ep = this.settings.getExecutorPool();
                    ParallelColorOperation colorOperation = new ParallelColorOperation(this.settings.getFSILogger(), ep, priority);
                    image = (FSIImageLimited)colorOperation.transform((FSIImage)image, new MatteTransparent(0xFFFFFF, false), false);
                }
                resultImages.add(image);
                continue;
            }
            response.setStatus(500);
        }
        response.setMultiImageResponse(true);
        response.setResponseImages(resultImages.toArray(new FSIImageLimited[resultImages.size()]));
        response.setStatus(200);
    }
}

