/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class OverlayImageRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;
    private boolean keepAspectRatio = true;
    private boolean applyRangeToOverlays = true;
    private final List<LayerProperties> profileLayers = new ArrayList<LayerProperties>();
    private final Pattern overlayPattern = Pattern.compile("(.*?)\\(([0-9]*)(?:,(TL|TC|TR|CL|CC|CR|BL|BC|BR))?+(?:,([0-9\\.]*))?+(?:,([0-9\\.]*))?+\\),?");
    private String errorFallback = null;
    private String importingFallback = null;
    private String overlayString = "";

    public OverlayImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
        int l = settings.getPrefsInt("limits", "maxwidth");
        if (l > 0) {
            this.maxWidth = l;
        }
        if ((l = settings.getPrefsInt("limits", "maxheight")) > 0) {
            this.maxHeight = l;
        }
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        RendererResponse result = this.checkStandardImageRequestParameters(parameters);
        if (result != null) {
            return result;
        }
        if (parameters.getType() != Parameters.Type.IMAGE) {
            throw new IllegalArgumentException("invalid type");
        }
        result = this.processImageRequest(priority, this.standardImagebuilder, parameters);
        return result;
    }

    private LayerProperties extractLayerProperties(Matcher m, boolean log) {
        LayerProperties lp;
        block11: {
            block10: {
                block9: {
                    lp = new LayerProperties();
                    lp.assetURLPath = m.group(1);
                    try {
                        lp.opacity = Integer.parseInt(m.group(2));
                    }
                    catch (NumberFormatException e) {
                        if (!log) break block9;
                        this.settings.getFSILogger().log(3043, m.group(2), "opacity", this.rendererName);
                    }
                }
                if (m.group(3) != null) {
                    lp.quadrant = m.group(3);
                }
                if (m.group(4) != null) {
                    try {
                        lp.pos1 = Float.parseFloat(m.group(4));
                    }
                    catch (NumberFormatException e) {
                        if (!log) break block10;
                        this.settings.getFSILogger().log(3043, m.group(2), "pos1", this.rendererName);
                    }
                }
            }
            if (m.group(5) != null) {
                try {
                    lp.pos2 = Float.parseFloat(m.group(5));
                }
                catch (NumberFormatException e) {
                    if (!log) break block11;
                    this.settings.getFSILogger().log(3043, m.group(2), "pos2", this.rendererName);
                }
            }
        }
        return lp;
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        RendererTextResponse errorResponse = null;
        if (!parameters.contains(Parameters.GeneralImage.width) && !parameters.contains(Parameters.GeneralImage.height)) {
            errorResponse = OverlayImageRenderer.generateMissingParameterResponse("width or height");
        } else if (parameters.getAssetURLPath() == null) {
            errorResponse = OverlayImageRenderer.generateMissingParameterResponse("source");
        }
        if (errorResponse == null && parameters.contains(Parameters.GeneralImage.width)) {
            int width = -1;
            try {
                width = Integer.parseInt(parameters.get(Parameters.GeneralImage.width));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width <= 0) {
                errorResponse = OverlayImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.width));
            }
        }
        if (errorResponse == null && parameters.contains(Parameters.GeneralImage.height)) {
            int height = -1;
            try {
                height = Integer.parseInt(parameters.get(Parameters.GeneralImage.height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (height <= 0) {
                errorResponse = OverlayImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.height));
            }
        }
        return errorResponse;
    }

    private RendererImageResponse processImageRequest(int priority, ImageBuilder imageBuilder, Parameters parameters) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse response = new RendererImageResponse();
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            throw new IllegalArgumentException("source required");
        }
        ArrayList<LayerProperties> layers = new ArrayList<LayerProperties>();
        LayerProperties bg = new LayerProperties();
        bg.assetURLPath = URL.cleanUpSourceParameter(assetURLPath);
        layers.add(bg);
        layers.addAll(this.profileLayers);
        String overlaysStr = parameters.get(Parameters.FileImage.overlays);
        if (overlaysStr != null && overlaysStr.length() > 0) {
            Matcher m = this.overlayPattern.matcher(overlaysStr);
            while (m.find()) {
                LayerProperties lp = this.extractLayerProperties(m, false);
                layers.add(lp);
            }
        }
        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
        if (widthPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
        }
        if (heightPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
        }
        try {
            this.processFileImageRequest(priority, imageBuilder, layers, parameters, widthPair, heightPair, response);
        }
        catch (NoSuchFileException e) {
            response.setStatus(404);
        }
        catch (IOException e) {
            response.setStatus(500);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range value");
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    private void processFileImageRequest(int priority, ImageBuilder imagebuilder, List<LayerProperties> layers, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        String[] parts;
        double[] relativeRange = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
        int[] pixelRange = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
        double[] relativeInitialRange = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
        int[] pixelInitialRange = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
        double initialRangeWidthCorrection = 0.0;
        double initialRangeHeightCorrection = 0.0;
        boolean useRelativeInitialRange = false;
        boolean usePixelInitialRange = false;
        boolean pixelBased = false;
        if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
            OverlayImageRenderer.getRelativeRangeFromParameters(parameters, relativeRange);
        } else if (parameters.contains(Parameters.GeneralImage.pixelrange) || parameters.contains(Parameters.GeneralImage.pixeltop) || parameters.contains(Parameters.GeneralImage.pixelleft) || parameters.contains(Parameters.GeneralImage.pixelright) || parameters.contains(Parameters.GeneralImage.pixelbottom)) {
            pixelBased = true;
            this.getPixelRangeFromParameters(parameters, pixelRange);
        }
        if (parameters.contains(Parameters.FileImage.initialrect)) {
            parts = parameters.get(Parameters.FileImage.initialrect).split(",", 5);
            relativeInitialRange[0] = FloatingParser.parseDouble(parts[0]);
            relativeInitialRange[1] = FloatingParser.parseDouble(parts[1]);
            relativeInitialRange[2] = FloatingParser.parseDouble(parts[2]);
            relativeInitialRange[3] = FloatingParser.parseDouble(parts[3]);
            initialRangeWidthCorrection = relativeInitialRange[2];
            initialRangeHeightCorrection = relativeInitialRange[3];
            useRelativeInitialRange = true;
        } else if (parameters.contains(Parameters.FileImage.initialrectpix)) {
            parts = parameters.get(Parameters.FileImage.initialrectpix).split(",", 5);
            pixelInitialRange[0] = Integer.parseInt(parts[0]);
            pixelInitialRange[1] = Integer.parseInt(parts[1]);
            pixelInitialRange[2] = Integer.parseInt(parts[2]);
            pixelInitialRange[3] = Integer.parseInt(parts[3]);
            usePixelInitialRange = true;
        }
        FSIImage result = null;
        try {
            for (int i = 0; i < layers.size(); ++i) {
                LayerProperties layer = layers.get(i);
                result = this.loadAndBlendLayer(result, imagebuilder, layer, priority, widthPair, heightPair, relativeRange, pixelRange, relativeInitialRange, pixelInitialRange, initialRangeWidthCorrection, initialRangeHeightCorrection, useRelativeInitialRange, usePixelInitialRange, pixelBased);
            }
        }
        catch (ProcessingException e) {
            if (result != null) {
                result.dispose();
            }
            throw e;
        }
        response.setStatus(200);
        response.setResponseImage((FSIImageLimited)result);
        response.setDateHeader("Last-Modified", System.currentTimeMillis());
    }

    private FSIImage loadAndBlendLayer(FSIImage result, ImageBuilder imagebuilder, LayerProperties layer, int priority, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, double[] relativeRange, int[] pixelRange, double[] relativeInitialRange, int[] pixelInitialRange, double initialRangeWidthCorrection, double initialRangeHeightCorrection, boolean useRelativeInitialRange, boolean usePixelInitialRange, boolean pixelBased) throws NoSuchFileException, IOException, NotImportedException, NotConfiguredException, ProcessingException, InterruptedException {
        boolean isBackground = result == null;
        FSIImageLimited image = null;
        try {
            SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(layer.assetURLPath);
            if (isBackground || this.applyRangeToOverlays) {
                if (pixelBased || usePixelInitialRange && isBackground) {
                    int prheight;
                    int prwidth;
                    int prtop;
                    int prleft;
                    if (pixelBased) {
                        prleft = pixelRange[0];
                        prtop = pixelRange[1];
                        prwidth = pixelRange[2];
                        prheight = pixelRange[3];
                    } else {
                        prleft = pixelInitialRange[0] + (int)(relativeRange[0] * (double)pixelInitialRange[2]);
                        prtop = pixelInitialRange[1] + (int)(relativeRange[1] * (double)pixelInitialRange[3]);
                        prwidth = (int)(relativeRange[2] * (double)pixelInitialRange[2]);
                        prheight = (int)(relativeRange[3] * (double)pixelInitialRange[3]);
                    }
                    image = imagebuilder.getImage(null, importerProfile, priority, layer.assetURLPath, widthPair, heightPair, prleft, prtop, prwidth, prheight, this.keepAspectRatio, FSIInterpolation.LANCZOS);
                } else {
                    double rheight;
                    double rwidth;
                    double rtop;
                    double rleft;
                    if (useRelativeInitialRange && isBackground) {
                        rleft = relativeInitialRange[0] + relativeRange[0] * initialRangeWidthCorrection;
                        rtop = relativeInitialRange[1] + relativeRange[1] * initialRangeHeightCorrection;
                        rwidth = initialRangeWidthCorrection * relativeRange[2];
                        rheight = initialRangeHeightCorrection * relativeRange[3];
                    } else if (usePixelInitialRange && isBackground) {
                        rleft = 0.0;
                        rtop = 0.0;
                        rwidth = 0.0;
                        rheight = 0.0;
                    } else {
                        rleft = relativeRange[0];
                        rtop = relativeRange[1];
                        rwidth = relativeRange[2];
                        rheight = relativeRange[3];
                    }
                    image = imagebuilder.getImage(null, importerProfile, priority, layer.assetURLPath, widthPair, heightPair, rleft, rtop, rwidth, rheight, this.keepAspectRatio, FSIInterpolation.LANCZOS);
                }
            } else {
                image = imagebuilder.getImage(null, importerProfile, priority, layer.assetURLPath, widthPair, heightPair, 0.0, 0.0, 1.0, 1.0, this.keepAspectRatio, FSIInterpolation.LANCZOS);
            }
            if (isBackground) {
                result = image;
            } else if (result != null) {
                Pair<Integer, Integer> offset = this.calculateOffset(layer, image, result.getWidth(), result.getHeight());
                ExecutorPool ep = this.settings.getExecutorPool();
                LayerBlend blend = new LayerBlend(this.settings.getFSILogger(), ep, priority);
                result = blend.transform(result, image, offset.getItem1(), offset.getItem2(), BlendMode.NORMAL, AlphaMode.BASE, layer.opacity, false);
            }
        }
        catch (FSIImageException e) {
            this.settings.getFSILogger().log(2504, layer.assetURLPath, e.getLocalizedMessage());
            if (image != null) {
                image.dispose();
            }
        }
        catch (ProcessingException e) {
            OverlayImageRenderer.disposeImages(image);
            throw e;
        }
        return result;
    }

    private Pair<Integer, Integer> calculateOffset(LayerProperties layer, FSIImageLimited image, int bgWidth, int bgHeight) {
        int x = 0;
        int y = 0;
        if (layer.quadrant.equals("TL")) {
            x = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            y = layer.pos2 < 1.0f ? (int)(layer.pos2 * (float)bgHeight) : (int)layer.pos2;
        } else if (layer.quadrant.equals("TC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f);
            y = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgHeight) : (int)layer.pos1;
        } else if (layer.quadrant.equals("TR")) {
            int t = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            x = bgWidth - t - image.getWidth();
            y = layer.pos2 < 1.0f ? (int)(layer.pos2 * (float)bgHeight) : (int)layer.pos2;
        } else if (layer.quadrant.equals("CL")) {
            x = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f);
        } else if (layer.quadrant.equals("CC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f);
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f);
        } else if (layer.quadrant.equals("CR")) {
            int t = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            x = bgWidth - t - image.getWidth();
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f);
        } else if (layer.quadrant.equals("BL")) {
            x = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            int t = layer.pos2 < 1.0f ? (int)(layer.pos2 * (float)bgHeight) : (int)layer.pos2;
            y = bgHeight - t - image.getHeight();
        } else if (layer.quadrant.equals("BC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f);
            int t = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgHeight) : (int)layer.pos1;
            y = bgHeight - t - image.getHeight();
        } else if (layer.quadrant.equals("BR")) {
            int t1 = layer.pos1 < 1.0f ? (int)(layer.pos1 * (float)bgWidth) : (int)layer.pos1;
            x = bgWidth - t1 - image.getWidth();
            int t2 = layer.pos2 < 1.0f ? (int)(layer.pos2 * (float)bgHeight) : (int)layer.pos2;
            y = bgHeight - t2 - image.getHeight();
        }
        Pair<Integer, Integer> offset = new Pair<Integer, Integer>(x, y);
        return offset;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("keepaspectratio");
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("overlay");
        result.add("applyrangetooverlays");
        return result;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            result = String.valueOf(this.keepAspectRatio);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            result = this.errorFallback;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            result = this.importingFallback;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("applyRangeToOverlays")) {
            result = String.valueOf(this.applyRangeToOverlays);
        } else if (name.equalsIgnoreCase("overlay")) {
            result = this.overlayString;
        }
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            this.keepAspectRatio = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            this.errorFallback = value;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            this.importingFallback = value;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("overlay")) {
            Matcher m = this.overlayPattern.matcher(value);
            while (m.find()) {
                LayerProperties lp = this.extractLayerProperties(m, true);
                this.profileLayers.add(lp);
            }
            this.overlayString = value;
        } else if (name.equalsIgnoreCase("applyRangeToOverlays")) {
            this.applyRangeToOverlays = Boolean.parseBoolean(value);
        }
    }

    private static class LayerProperties {
        String assetURLPath;
        String quadrant = "CC";
        int opacity = 100;
        float pos1 = 0.0f;
        float pos2 = 0.0f;
    }
}

