/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.utils.URL;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class OverviewListRenderer
extends RendererAbstract {
    private PoolEntrySortingField defaultSortField;
    private SortDirection defaultSortOrder;
    private SortMethod defaultSortMethod;
    private String defaultSortLanguage = null;
    private String defaultSortCountry = null;
    private boolean defaultSortCaseSensitive = false;
    private PoolEntrySortingField forceSortField = null;
    private SortDirection forceSortOrder = null;
    private SortMethod forceSortMethod = null;
    private String forceSortLanguage = null;
    private String forceSortCountry = null;
    private boolean forceSortCaseSensitiveSet = false;
    private boolean forceSortCaseSensitive = false;
    private int maxEntries = 50;
    private final ImageBuilder standardImagebuilder;

    public OverviewListRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
        this.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.defaultSortOrder = RendererEnvironment.DEFAULT_SORT_ORDER;
        this.defaultSortMethod = RendererEnvironment.DEFAULT_SORT_METHOD;
        this.defaultSortLanguage = this.environment.getDefaultSortLanguage();
        this.defaultSortCountry = this.environment.getDefaultSortCountry();
        this.defaultSortCaseSensitive = false;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        HttpSession session = req.getSession(false);
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        if (parameters.getAssetURLPath() == null) {
            return OverviewListRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.LIST) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererResponse result = this.processListRequest(this.standardImagebuilder, parameters, metadata, session);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("defaultSortField");
        result.add("forceSortField");
        result.add("defaultSortOrder");
        result.add("forceSortOrder");
        result.add("defaultSortMethod");
        result.add("forceSortMethod");
        result.add("defaultSortLanguage");
        result.add("forceSortLanguage");
        result.add("defaultSortCountry");
        result.add("forceSortCountry");
        result.add("defaultSortCaseSensitive");
        result.add("forceSortCaseSensitive");
        return result;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("defaultsortfield") && this.defaultSortField != null) {
            result = this.defaultSortField.name();
        } else if (name.equalsIgnoreCase("forcesortfield") && this.forceSortField != null) {
            result = this.forceSortField.name();
        } else if (name.equalsIgnoreCase("defaultsortorder") && this.defaultSortOrder != null) {
            result = this.defaultSortOrder.name();
        } else if (name.equalsIgnoreCase("forcesortorder") && this.forceSortOrder != null) {
            result = this.forceSortOrder.name();
        } else if (name.equalsIgnoreCase("defaultsortmethod") && this.defaultSortMethod != null) {
            result = this.defaultSortMethod.name();
        } else if (name.equalsIgnoreCase("forcesortmethod") && this.forceSortMethod != null) {
            result = this.forceSortMethod.name();
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            result = this.defaultSortLanguage;
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            result = this.forceSortLanguage;
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            result = this.defaultSortCountry;
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            result = this.forceSortCountry;
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            result = Boolean.toString(this.defaultSortCaseSensitive);
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            result = Boolean.toString(this.forceSortCaseSensitive);
        } else if (name.equalsIgnoreCase("maxEntries")) {
            result = Integer.toString(this.maxEntries);
        }
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        try {
            if (name.equalsIgnoreCase("defaultsortfield")) {
                this.defaultSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortfield")) {
                this.forceSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortorder")) {
                this.defaultSortOrder = SortDirection.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortorder")) {
                this.forceSortOrder = SortDirection.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortmethod")) {
                this.defaultSortMethod = SortMethod.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortmethod")) {
                this.forceSortMethod = SortMethod.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
                this.defaultSortLanguage = value.toLowerCase();
            } else if (name.equalsIgnoreCase("forcesortlanguage")) {
                this.forceSortLanguage = value.toLowerCase();
            } else if (name.equalsIgnoreCase("defaultsortcountry")) {
                this.defaultSortCountry = value.toUpperCase();
            } else if (name.equalsIgnoreCase("forcesortcountry")) {
                this.forceSortCountry = value.toUpperCase();
            } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
                this.defaultSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
            } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
                this.forceSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
                this.forceSortCaseSensitiveSet = true;
            } else if (name.equalsIgnoreCase("maxEntries")) {
                this.maxEntries = Integer.valueOf(value);
            }
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(2035, this.rendererName + ".xml", value, name);
        }
    }

    private String[] extractSourcesFromParameter(String source) {
        String[] sources = source.split(",");
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = URL.cleanUpSourceParameter(sources[i]);
        }
        if (sources.length > this.maxEntries) {
            String[] newSources = new String[this.maxEntries];
            for (int i = 0; i < this.maxEntries; ++i) {
                newSources[i] = sources[i];
            }
            sources = newSources;
        }
        return sources;
    }

    private RendererResponse processListRequest(ImageBuilder imagebuilder, Parameters parameters, Map<String, Object> metadata, HttpSession session) {
        RendererTextResponse response = new RendererTextResponse();
        String assetURLPath = parameters.getAssetURLPath();
        if (assetURLPath == null) {
            throw new IllegalArgumentException("source required");
        }
        try {
            Template template = this.determineListTemplate(parameters);
            TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
            templateAttrs.setRendererResponseContentType(response);
            SimpleHash templateData = new SimpleHash();
            templateData.put("query", (Object)parameters);
            String[] sources = this.extractSourcesFromParameter(assetURLPath);
            if (!this.checkPermissions(session, sources)) {
                response.setStatus(403);
                return response;
            }
            SortDirection sortOrder = this.determineSortOrder(parameters);
            FSIStringComparator comparator = this.determineSortComparator(parameters);
            PoolEntrySortingField usedSortField = this.determineSortField(parameters);
            long lastModified = 0L;
            SimpleSequence resultlist = new SimpleSequence();
            for (String sourceDir : sources) {
                SimpleHash entry = new SimpleHash();
                try {
                    SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(sourceDir);
                    PoolList list = imagebuilder.getPoolList(importerProfile, sourceDir, session);
                    int imageCount = 0;
                    if (list != null) {
                        lastModified = Math.max(lastModified, list.lastmodified);
                        imageCount = list.getFileCount();
                        if (imageCount > 0) {
                            List<PoolFileEntry> imageList = list.getFilesAsList();
                            if (!imageList.isEmpty()) {
                                this.sortingPoolList(imageList, usedSortField, comparator, sortOrder);
                            }
                            String src = sourceDir + "/" + imageList.get((int)0).name;
                            entry.put("src", (Object)src);
                            MetaData md = imagebuilder.getImageMetaData(importerProfile, src, 0, true, session);
                            if (md instanceof ImageMetaData) {
                                ImageMetaData imd = (ImageMetaData)md;
                                entry.put("width", (Object)imd.getWidth());
                                entry.put("height", (Object)imd.getHeight());
                            }
                        }
                    }
                    entry.put("imageCount", (Object)imageCount);
                    entry.put("exists", true);
                }
                catch (NoSuchFileException e) {
                    entry.put("exists", false);
                }
                resultlist.add((Object)entry);
            }
            templateData.put("ilist", (Object)resultlist);
            this.renderTemplate(template, templateData, response);
            response.setDateHeader("Last-Modified", lastModified);
            response.setStatus(200);
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(3158, e.getLocalizedMessage());
            response.setBody(this.getTemplateErrorBody(e.getLocalizedMessage()));
            response.setStatus(500);
            response.setStatusMessage(e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            this.settings.getFSILogger().log(3158, e.getLocalizedMessage());
            response.setBody(this.getTemplateErrorBody(e.getLocalizedMessage()));
            response.setStatus(500);
            response.setStatusMessage(e.getLocalizedMessage());
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    private boolean checkPermissions(HttpSession session, String[] sources) throws NotConfiguredException {
        for (String singleDir : sources) {
            PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(singleDir, session, true);
            if (ps != null && (ps.list.files.booleanValue() || ps.list.directories.booleanValue())) continue;
            return false;
        }
        return true;
    }

    private PoolEntrySortingField determineSortField(Parameters parameters) throws IOException {
        PoolEntrySortingField usedSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        if (this.forceSortField != null) {
            usedSortField = this.forceSortField;
        } else if (parameters.contains(Parameters.Sorting.sortfield) && parameters.get(Parameters.Sorting.sortfield).trim().length() > 0) {
            try {
                usedSortField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.sortfield).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sort field");
            }
        } else {
            usedSortField = this.defaultSortField;
        }
        return usedSortField;
    }

    private void renderTemplate(Template template, SimpleHash templateData, RendererTextResponse response) throws IOException, TemplateException {
        try (StringWriterFast sw = new StringWriterFast();){
            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
            env.process();
            response.setBody(sw.toString());
        }
    }

    private Template determineListTemplate(Parameters parameters) throws IOException {
        String listTemplate = "json_overview";
        if (parameters.contains(Parameters.General.template)) {
            listTemplate = parameters.get(Parameters.General.template);
        }
        Template result = this.settings.getTemplateCache().getTemplate(TemplateType.LIST, listTemplate + ".ftl");
        return result;
    }

    private FSIStringComparator determineSortComparator(Parameters parameters) throws IOException {
        SortMethod usedSortMethod;
        SortDirection usedSortOrder;
        if (this.forceSortOrder != null) {
            usedSortOrder = this.forceSortOrder;
        } else if (parameters.contains(Parameters.Sorting.sortorder)) {
            try {
                usedSortOrder = SortDirection.valueOf(parameters.get(Parameters.Sorting.sortorder).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            usedSortOrder = this.defaultSortOrder;
        }
        if (this.forceSortMethod != null) {
            usedSortMethod = this.forceSortMethod;
        } else if (parameters.contains(Parameters.Sorting.sortmethod)) {
            try {
                usedSortMethod = SortMethod.valueOf(parameters.get(Parameters.Sorting.sortmethod).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            usedSortMethod = this.defaultSortMethod;
        }
        String usedSortLanguage = this.forceSortLanguage != null ? this.forceSortLanguage : (parameters.contains(Parameters.Sorting.sortlanguage) ? parameters.get(Parameters.Sorting.sortlanguage) : this.defaultSortLanguage);
        String usedSortCountry = this.forceSortCountry != null ? this.forceSortCountry : (parameters.contains(Parameters.Sorting.sortcountry) ? parameters.get(Parameters.Sorting.sortcountry) : this.defaultSortCountry);
        boolean usedSortCaseSensitive = this.forceSortCaseSensitiveSet ? this.forceSortCaseSensitive : (parameters.contains(Parameters.Sorting.sortcasesensitive) ? Boolean.valueOf(parameters.get(Parameters.Sorting.sortcasesensitive)) : this.defaultSortCaseSensitive);
        return this.environment.getFSIStringComparator(usedSortOrder, usedSortMethod, usedSortLanguage, usedSortCountry, usedSortCaseSensitive);
    }

    private SortDirection determineSortOrder(Parameters parameters) throws IOException {
        SortDirection usedSortOrder;
        if (this.forceSortOrder != null) {
            usedSortOrder = this.forceSortOrder;
        } else if (parameters.contains(Parameters.Sorting.sortorder)) {
            try {
                usedSortOrder = SortDirection.valueOf(parameters.get(Parameters.Sorting.sortorder).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            usedSortOrder = this.defaultSortOrder;
        }
        return usedSortOrder;
    }

    private String getTemplateErrorBody(String cause) {
        return cause;
    }
}

