/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.RequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashList;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.Decode8BIM;
import com.neptunelabs.imagereader.image.FSIImage;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class RendererAbstract
extends RequestHandler {
    static final int LEFT = 0;
    static final int TOP = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    static final double[] DEFAULT_RELATIVE_RANGE = new double[]{0.0, 0.0, 1.0, 1.0};
    static final int[] DEFAULT_PIXEL_RANGE = new int[]{-1, -1, -1, -1};
    int defaultWidth = 400;
    int defaultHeight = 300;
    int maxWidth = 5120;
    int maxHeight = 2880;
    final String rendererName;
    private final Map<String, PoolFileEntryComparator> poolEntryComparatorCache = new HashMap<String, PoolFileEntryComparator>();
    final RendererEnvironment environment;
    private Set<String> allowedGroups = null;
    String rendererChecksum = null;

    RendererAbstract(RequestProcessorSettings settings, String rendererName) {
        super(settings);
        this.rendererName = rendererName;
        this.environment = settings.getRenderEnvironment();
    }

    public void addAllowedGroup(String groupname) {
        if (this.allowedGroups == null) {
            this.allowedGroups = new HashSet<String>();
        }
        this.allowedGroups.add(groupname);
    }

    public Set<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    void calculateRendererChecksum() {
        StringBuilder checksumBuilder = new StringBuilder();
        ArrayList<String> optionNames = new ArrayList<String>(this.getSupportedOptions());
        Collections.sort(optionNames);
        for (String optionName : optionNames) {
            checksumBuilder.append(this.getOption(optionName));
        }
        this.rendererChecksum = checksumBuilder.toString();
    }

    static void disposeImages(FSIImage ... images) {
        for (FSIImage image : images) {
            if (image == null) continue;
            image.dispose();
        }
    }

    public abstract Set<String> getRequiredMetaData();

    public abstract RendererResponse processRequest(int var1, HttpServletRequest var2, Map<String, Object> var3) throws ProcessingException, InterruptedException;

    public abstract void setOption(String var1, String var2);

    public abstract String getOption(String var1);

    public abstract Set<String> getSupportedOptions();

    static void getRelativeRangeFromParameters(Parameters parameters, double[] relativeRange) {
        if (parameters.contains(Parameters.GeneralImage.rect)) {
            double[] parsedValues = RendererAbstract.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.rect));
            for (int i = 0; i < parsedValues.length; ++i) {
                relativeRange[i] = parsedValues[i];
            }
        } else {
            if (parameters.contains(Parameters.GeneralImage.left)) {
                relativeRange[0] = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.left));
            }
            if (parameters.contains(Parameters.GeneralImage.top)) {
                relativeRange[1] = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.top));
            }
            double bottom = 1.0;
            if (parameters.contains(Parameters.GeneralImage.bottom)) {
                bottom = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.bottom));
            }
            double right = 1.0;
            if (parameters.contains(Parameters.GeneralImage.right)) {
                right = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.right));
            }
            relativeRange[2] = right - relativeRange[0];
            relativeRange[3] = bottom - relativeRange[1];
        }
        if (!(relativeRange[2] > 0.0 && relativeRange[2] <= 1.0 && relativeRange[3] > 0.0 && relativeRange[3] <= 1.0)) {
            throw new IllegalArgumentException("Invalid Range in request");
        }
    }

    static double[] parseRangeParameterValue(String parameterValue) {
        double[] result = new double[4];
        if (parameterValue != null) {
            String[] parts = parameterValue.split(",", 5);
            result[0] = FloatingParser.parseDouble(parts[0]);
            result[1] = FloatingParser.parseDouble(parts[1]);
            result[2] = FloatingParser.parseDouble(parts[2]);
            result[3] = FloatingParser.parseDouble(parts[3]);
        } else {
            result[0] = 0.0;
            result[1] = 0.0;
            result[2] = 1.0;
            result[3] = 1.0;
        }
        return result;
    }

    void getPixelRangeFromParameters(Parameters parameters, int[] pixelRange) {
        if (parameters.contains(Parameters.GeneralImage.pixelrange)) {
            String[] parts = parameters.get(Parameters.GeneralImage.pixelrange).split(",", 5);
            pixelRange[0] = Integer.parseInt(parts[0]);
            pixelRange[1] = Integer.parseInt(parts[1]);
            pixelRange[2] = Integer.parseInt(parts[2]);
            pixelRange[3] = Integer.parseInt(parts[3]);
        } else {
            this.getPixelRangeFromSeparatedParameters(parameters, pixelRange);
        }
    }

    static int[] getReferenceDimensions(Parameters parameters) {
        String refHeightString;
        int refWidth = -1;
        int refHeight = -1;
        String refWidthString = parameters.get(Parameters.GeneralImage.referencewidth);
        if (refWidthString != null) {
            refWidth = Integer.parseInt(refWidthString);
        }
        if ((refHeightString = parameters.get(Parameters.GeneralImage.referenceheight)) != null) {
            refHeight = Integer.parseInt(refHeightString);
        }
        return new int[]{refWidth, refHeight};
    }

    private void getPixelRangeFromSeparatedParameters(Parameters parameters, int[] pixelRange) {
        if (parameters.contains(Parameters.GeneralImage.pixelleft)) {
            pixelRange[0] = Integer.parseInt(parameters.get(Parameters.GeneralImage.pixelleft));
        }
        if (parameters.contains(Parameters.GeneralImage.pixeltop)) {
            pixelRange[1] = Integer.parseInt(parameters.get(Parameters.GeneralImage.pixeltop));
        }
        int bottomPix = -1;
        if (parameters.contains(Parameters.GeneralImage.pixelbottom)) {
            bottomPix = Integer.parseInt(parameters.get(Parameters.GeneralImage.pixelbottom));
        }
        int rightPix = -1;
        if (parameters.contains(Parameters.GeneralImage.pixelright)) {
            rightPix = Integer.parseInt(parameters.get(Parameters.GeneralImage.pixelright));
        }
        if (pixelRange[0] != -1 && rightPix != -1) {
            pixelRange[2] = rightPix - pixelRange[0];
        }
        if (pixelRange[1] != -1 && bottomPix != -1) {
            pixelRange[3] = bottomPix - pixelRange[1];
        }
    }

    protected static String escapeString(String str, Escaper.EscaperType type) {
        if (str == null) {
            return "";
        }
        switch (type) {
            case XML: {
                return Escaper.escapeForXML(str);
            }
            case XMLURI: {
                return Escaper.escapeForXMLURI(str);
            }
            case URIXML: {
                return Escaper.escapeForURIXML(str);
            }
            case JSON: {
                return Escaper.escapeForJSON(str);
            }
        }
        return str;
    }

    protected static RendererTextResponse generateInvalidParameterValueResponse(String parameter, String value) {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(400);
        result.setContentType("text/plain");
        result.setStatusMessage("Bad Request: Invalid Parameter value " + value + " for parameter " + parameter);
        return result;
    }

    protected static RendererTextResponse generateMissingParameterResponse(String missingParameter) {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(400);
        result.setContentType("text/plain");
        result.setStatusMessage("Bad Request.");
        result.setBody("Bad Request: Missing Parameter " + missingParameter);
        return result;
    }

    protected static RendererTextResponse generateNotAuthorizedResponse() {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(403);
        result.setContentType("text/plain");
        result.setStatusMessage("Forbidden");
        result.setBody("Access to one or more of the requested resources denied");
        result.setCacheable(false);
        return result;
    }

    protected static RendererTextResponse generateNotFoundResponse() {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(404);
        result.setContentType("text/plain");
        result.setStatusMessage("Not Found.");
        result.setBody("One or more of the requested resources could not be found.");
        return result;
    }

    protected static RendererTextResponse generateErrorResponse() {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(500);
        result.setContentType("text/plain");
        result.setStatusMessage("Internal Server Error.");
        result.setBody("The server encountered an error processing your request.");
        return result;
    }

    protected static RendererTextResponse generateUnavailableResponse() {
        RendererTextResponse result = new RendererTextResponse();
        result.setStatus(503);
        result.setContentType("text/plain");
        result.setStatusMessage("Service unavailable.");
        result.setBody("This service is currently unavailable.");
        return result;
    }

    protected boolean checkTemplateAccessRestrictions(TemplateAttributes templateAttrs, HttpSession session) throws NotConfiguredException {
        Set<String> groupsAllowedInTemplate = templateAttrs.getAllowedGroups();
        if (groupsAllowedInTemplate != null) {
            if (groupsAllowedInTemplate.contains("public")) {
                return true;
            }
            if (session != null) {
                String sessionid = (String)session.getAttribute("id");
                String username = this.settings.getUserAuthenticationInterface().getUser(sessionid);
                Set<String> userGroups = this.settings.getUserAuthenticationInterface().getGroupNamesForUser(username);
                for (String group : userGroups) {
                    if (!groupsAllowedInTemplate.contains(group)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Pair<Integer, Boolean> getWidth(String widthStr) {
        int width = -1;
        boolean useDefault = false;
        if (widthStr == null) {
            width = this.defaultWidth;
            useDefault = true;
        } else {
            try {
                int i = Integer.valueOf(widthStr);
                width = i < 1 ? 1 : (i > this.maxWidth ? this.maxWidth : i);
            }
            catch (NumberFormatException e) {
                width = this.defaultWidth;
                if (width > this.maxWidth) {
                    width = this.maxWidth;
                }
                useDefault = true;
            }
        }
        return new Pair<Integer, Boolean>(width, useDefault);
    }

    protected Pair<Integer, Boolean> getHeight(String heightStr) {
        int height = -1;
        boolean useDefault = false;
        if (heightStr == null) {
            height = this.defaultHeight;
            useDefault = true;
        } else {
            try {
                int i = Integer.valueOf(heightStr);
                height = i < 1 ? 1 : (i > this.maxHeight ? this.maxHeight : i);
            }
            catch (NumberFormatException e) {
                height = this.defaultHeight;
                if (height > this.maxHeight) {
                    height = this.maxHeight;
                }
                useDefault = true;
            }
        }
        return new Pair<Integer, Boolean>(height, useDefault);
    }

    void pingSourceManager(String assetURLPath) throws MalformedURLException, IOException {
        assetURLPath = URL.cleanUpSourceParameter(assetURLPath);
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        int profilePathSep = assetURLPath.indexOf("/", 1);
        if (profilePathSep != -1) {
            String path = assetURLPath.substring(connector.getPrefix().length());
            String sourceManager = this.settings.getPrefsString("application", "sourcemanager");
            if (sourceManager != null && sourceManager.length() > 0) {
                String pingurl = sourceManager + "/ping?profile=" + connector.getPrefix() + "&path=" + path;
                this.settings.getFSILogger().log(3039, pingurl);
                java.net.URL url = new java.net.URL(pingurl);
                URLConnection conn = url.openConnection();
                conn.getContentLength();
            } else {
                Object o = this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
                if (o != null) {
                    MainManager sourceManagerInstance = (MainManager)o;
                    sourceManagerInstance.handlePingRequest(path, connector.getPrefix());
                }
            }
        }
    }

    protected static boolean multiSources(String source) {
        return source.contains(",");
    }

    protected void sortingPoolList(List<PoolFileEntry> poolEntryList, PoolEntrySortingField sortField, FSIStringComparator stringComparator, SortDirection sortOrder) {
        PoolFileEntryComparator entryComparator = this.getPoolEntryComparator(sortField, stringComparator, sortOrder);
        Collections.sort(poolEntryList, entryComparator);
    }

    private PoolFileEntryComparator getPoolEntryComparator(PoolEntrySortingField sortField, FSIStringComparator stringComparator, SortDirection sortOrder) {
        String comparatorCacheKey = sortField.name() + stringComparator.hashCode() + sortOrder.name();
        PoolFileEntryComparator result = this.poolEntryComparatorCache.get(comparatorCacheKey);
        if (result == null) {
            result = new PoolFileEntryComparator(sortField, stringComparator, sortOrder);
            this.poolEntryComparatorCache.put(comparatorCacheKey, result);
        }
        return result;
    }

    protected List<DownloadJob> getDownloadsList(HttpSession session) throws NotConfiguredException {
        ArrayList<DownloadJob> jobs = new ArrayList<DownloadJob>();
        Set<String> usergroups = this.getGroups(session);
        String username = this.getUsername(session);
        jobs.addAll(this.getFinishedDownloadJobs(username, usergroups));
        DownloadJobProcessor jobprocessor = this.settings.getJobProcessor();
        if (jobprocessor != null) {
            List<DownloadJob> currentAndEnqueuedJobs = jobprocessor.getJobs(username, usergroups);
            for (DownloadJob job : currentAndEnqueuedJobs) {
                if (jobs.contains(job)) continue;
                jobs.add(job);
            }
        }
        return jobs;
    }

    private List<DownloadJob> getFinishedDownloadJobs(String username, Set<String> usergroups) throws NotConfiguredException {
        ArrayList<DownloadJob> result = new ArrayList<DownloadJob>();
        Path downloadsFolder = this.storageHelper.getDownloadsFolder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(downloadsFolder);){
            for (Path entry : stream) {
                DownloadJob job;
                if (!Files.isRegularFile(entry, new LinkOption[0]) || !entry.getFileName().toString().endsWith(".job") || (job = DownloadJob.createFromFile(entry)) == null || !job.getUser().equals(username) && Collections.disjoint(usergroups, job.getGroups())) continue;
                result.add(job);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Set<String> getTrashConnectorsForSession(HttpSession session) throws NotConfiguredException {
        PermissionSet trashPermissions = this.settings.getUserAuthenticationInterface().getPermissions("_trash", session, true);
        if (!trashPermissions.list.files.booleanValue()) {
            return new HashSet<String>();
        }
        Set<String> connectors = this.settings.getSourceConnectorNames();
        HashSet<String> result = new HashSet<String>();
        for (String connectorName : connectors) {
            if (connectorName.equals("_downloads") || connectorName.equals("_trash") || connectorName.equals("_config")) continue;
            PermissionSet connectorPermissions = this.settings.getUserAuthenticationInterface().getPermissions(this.settings.getSourceConnector(connectorName), session, true);
            if (!connectorPermissions.list.connector.booleanValue() || !connectorPermissions.list.files.booleanValue()) continue;
            result.add(connectorName);
        }
        return result;
    }

    protected long getTrashLastModified(HttpSession session, ImageBuilder imagebuilder) throws NoSuchFileException, IOException, NotConfiguredException {
        Set<String> profileList = this.getTrashConnectorsForSession(session);
        if (profileList.size() > 0) {
            long llm = 0L;
            for (String profilename : profileList) {
                SourceConnectorReader connector = this.settings.getSourceConnector(profilename);
                Path trashFolder = this.storageHelper.getTrashFolder(connector);
                long lm = FileOperations.getSafeLastModified(trashFolder);
                if (lm <= llm) continue;
                llm = lm;
            }
            return llm;
        }
        return 0L;
    }

    protected List<TrashListEntry> getTrashList(HttpSession session) throws NotConfiguredException {
        Set<String> connectors = this.getTrashConnectorsForSession(session);
        ArrayList<TrashListEntry> trashEntries = new ArrayList<TrashListEntry>();
        for (String connectorName : connectors) {
            SourceConnectorReader connector = this.settings.getSourceConnector(connectorName);
            Path trashFolder = this.storageHelper.getTrashFolder(connector);
            TrashList profileTrashList = TrashList.getInstance(trashFolder.resolve(".trashlist"));
            for (TrashListEntry tle : profileTrashList.getList()) {
                tle.profilePrefix = connectorName;
                trashEntries.add(tle);
            }
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath("_configs", this.getUsername(session));
        if (connector != null) {
            Path trashFolder = this.storageHelper.getTrashFolder(connector);
            TrashList profileTrashList = TrashList.getInstance(trashFolder.resolve(".trashlist"));
            for (TrashListEntry tle : profileTrashList.getList()) {
                tle.profilePrefix = connector.getPrefix();
                trashEntries.add(tle);
            }
        }
        return trashEntries;
    }

    protected void createFallbackResponse(String assetURLPath, Parameters parameters, short importStatus, RendererResponse response) throws MalformedURLException, IOException {
        String fallbackImagePath = null;
        String fallbackProfile = null;
        if (importStatus == 2) {
            String importingFallback = this.getOption("importingFallback");
            if (importingFallback != null) {
                fallbackImagePath = importingFallback;
            } else {
                fallbackImagePath = "progress.eis";
                fallbackProfile = "_private";
            }
            this.pingSourceManager(assetURLPath);
        } else if (importStatus == 5) {
            fallbackImagePath = "flat.eis";
            fallbackProfile = "_private";
        } else {
            String errorFallback = this.getOption("errorFallback");
            if (errorFallback != null) {
                fallbackImagePath = errorFallback;
            } else {
                fallbackImagePath = "error.eis";
                fallbackProfile = "_private";
            }
        }
        boolean pixelBased = parameters.contains(Parameters.GeneralImage.pixelrange);
        StringBuilder locationStrBuilder = new StringBuilder("server?");
        for (Map.Entry<Parameters.Parameter, String> e : parameters.entrySet()) {
            if (e.getKey() == Parameters.General.source || fallbackProfile != null && e.getKey() == Parameters.General.renderer || pixelBased && (e.getKey() == Parameters.GeneralImage.width || e.getKey() == Parameters.GeneralImage.height) || e.getKey() == Parameters.GeneralImage.width && e.getValue().equals("0") || e.getKey() == Parameters.GeneralImage.height && e.getValue().equals("0")) continue;
            locationStrBuilder.append(e.getKey());
            locationStrBuilder.append("=");
            locationStrBuilder.append(e.getValue());
            locationStrBuilder.append("&");
        }
        locationStrBuilder.append("source=");
        locationStrBuilder.append(fallbackImagePath);
        if (fallbackProfile != null) {
            locationStrBuilder.append("&renderer=");
            locationStrBuilder.append(fallbackProfile);
        }
        if (fallbackImagePath.equals(assetURLPath)) {
            response.setStatus(500);
        } else {
            response.setStatus(307);
            response.setHeader("Location", locationStrBuilder.toString());
        }
    }

    protected SimpleHash getSimpleHashFromMetaData(MetaData metadata, Escaper.EscaperType escapeType, PermissionSet.Read readPermissions) {
        SimpleHash entry = new SimpleHash();
        entry.put("src", (Object)RendererAbstract.escapeString(metadata.getAssetURLPath(), escapeType));
        if (metadata instanceof ImageMetaData) {
            ImageMetaData imd = (ImageMetaData)metadata;
            if (readPermissions.basicMetadata.booleanValue()) {
                if (imd.getWidth() > 0) {
                    entry.put("width", (Object)imd.getWidth());
                }
                if (imd.getHeight() > 0) {
                    entry.put("height", (Object)imd.getHeight());
                }
                entry.put("alpha", (Object)Boolean.toString(imd.hasAlpha()));
            }
            if (readPermissions.storageStatus.booleanValue() && imd.getImportStatus() != 0) {
                entry.put("importstatus", (Object)imd.getImportStatus());
                if (imd.getImportTime() > 0L) {
                    entry.put("importtimestamp", (Object)imd.getImportTime());
                }
            }
            if (readPermissions.extendedMetadata.booleanValue()) {
                String[] alphaNames;
                String[] selectionNames;
                byte[] selectionsRaw;
                ICCProfileWrap ipw = imd.getICC();
                if (ipw != null) {
                    entry.put("icc", (Object)ipw.getName());
                }
                if (imd.getZoomLevels() != null && imd.getZoomLevels().length > 0) {
                    entry.put("levels", (Object)this.getZoomLevelSequence(imd.getZoomLevels()));
                }
                if ((selectionsRaw = imd.getSelections()) != null && (selectionNames = Decode8BIM.getSelectionNames(selectionsRaw)) != null) {
                    entry.put("selections", (Object)this.getSelectionsSimpleSequence(selectionNames, escapeType));
                }
                if ((alphaNames = imd.getAlphaNames()) != null && alphaNames.length == imd.getExtraAlphaCount()) {
                    entry.put("alphanames", (Object)this.getSelectionsSimpleSequence(alphaNames, escapeType));
                } else if (imd.getExtraAlphaCount() > 0) {
                    SimpleSequence seq = new SimpleSequence();
                    for (int i = 0; i < imd.getExtraAlphaCount(); ++i) {
                        seq.add((Object)"Unnamed");
                    }
                    entry.put("alphanames", (Object)seq);
                }
            }
        }
        if (metadata instanceof FileMetaData) {
            entry.put("type", (Object)"file");
            if (readPermissions.basicMetadata.booleanValue()) {
                FileMetaData fmd = (FileMetaData)metadata;
                entry.put("size", (Object)fmd.getSourceFileSize());
            }
        } else if (metadata instanceof DirectoryMetaData) {
            entry.put("type", (Object)"directory");
            if (readPermissions.basicMetadata.booleanValue()) {
                DirectoryMetaData dmd = (DirectoryMetaData)metadata;
                entry.put("files", (Object)dmd.getFiles());
                entry.put("directories", (Object)dmd.getSubdirectories());
            }
        }
        if (readPermissions.basicMetadata.booleanValue() && metadata.getLastModified() > 0L) {
            entry.put("lastmodified", (Object)metadata.getLastModified());
        }
        if (readPermissions.extendedMetadata.booleanValue()) {
            List<Pair<String, String>> fsi;
            Map<Integer, Pair<String, String>> exif;
            List<Pair<String, String>> iptc = metadata.getSortedIPTCList();
            if (!iptc.isEmpty()) {
                SimpleHash sh;
                SimpleSequence ss = this.getFieldnamesFromList(iptc, escapeType);
                if (ss.size() > 0) {
                    entry.put("iptclist", (Object)ss);
                }
                if ((sh = this.getSimpleHashFromList(iptc, escapeType)).size() > 0) {
                    entry.put("iptc", (Object)sh);
                }
            }
            if (!(exif = metadata.getExifSortedMap(this.settings.getFSILogger(), metadata.getAssetURLPath(), true)).isEmpty()) {
                SimpleHash sh;
                SimpleSequence ss = this.getExifSimpleSequence(exif, escapeType);
                if (ss.size() > 0) {
                    entry.put("exiflist", (Object)ss);
                }
                if ((sh = this.getExifSimpleHash(exif, escapeType)).size() > 0) {
                    entry.put("exif", (Object)sh);
                }
            }
            if (!(fsi = metadata.getSortedFSIList()).isEmpty()) {
                SimpleHash sh;
                SimpleSequence ss = this.getFieldnamesFromList(fsi, escapeType);
                if (ss.size() > 0) {
                    entry.put("fsilist", (Object)ss);
                }
                if ((sh = this.getSimpleHashFromList(fsi, escapeType)).size() > 0) {
                    entry.put("fsi", (Object)sh);
                }
            }
        }
        return entry;
    }

    protected List<PoolFileEntry> limitList(List<PoolFileEntry> list, int offset, int count) {
        LinkedList<PoolFileEntry> result = new LinkedList<PoolFileEntry>();
        if (count == -1) {
            count = list.size();
        }
        int mmax = Math.min(offset + count, list.size());
        for (int i = offset; i < mmax; ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    private SimpleSequence getFieldnamesFromList(List<Pair<String, String>> list, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Pair<String, String> entry : list) {
            if (entry.getItem1() == null || entry.getItem2() == null || entry.getItem1().equalsIgnoreCase("directory version")) continue;
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)RendererAbstract.escapeString(entry.getItem1(), escapeString));
            kp.put("name", (Object)RendererAbstract.escapeString(entry.getItem2(), escapeString));
            result.add((Object)kp);
        }
        return result;
    }

    private SimpleHash getSimpleHashFromList(List<Pair<String, String>> list, Escaper.EscaperType escapeString) {
        SimpleHash result = new SimpleHash();
        for (Pair<String, String> entry : list) {
            if (entry.getItem1() == null || entry.getItem2() == null || entry.getItem1().equalsIgnoreCase("directory version")) continue;
            result.put(RendererAbstract.escapeString(entry.getItem1(), escapeString), (Object)RendererAbstract.escapeString(entry.getItem2(), escapeString));
        }
        return result;
    }

    private SimpleSequence getExifSimpleSequence(Map<Integer, Pair<String, String>> exifdata, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (Map.Entry<Integer, Pair<String, String>> entry : exifdata.entrySet()) {
            SimpleHash kp = new SimpleHash();
            kp.put("key", (Object)RendererAbstract.escapeString(entry.getValue().getItem1(), escapeString));
            kp.put("name", (Object)RendererAbstract.escapeString(entry.getValue().getItem2(), escapeString));
            result.add((Object)kp);
        }
        return result;
    }

    private SimpleHash getExifSimpleHash(Map<Integer, Pair<String, String>> exifdata, Escaper.EscaperType escapeString) {
        SimpleHash result = new SimpleHash();
        for (Map.Entry<Integer, Pair<String, String>> entry : exifdata.entrySet()) {
            result.put(RendererAbstract.escapeString(entry.getValue().getItem1(), escapeString), (Object)RendererAbstract.escapeString(entry.getValue().getItem2(), escapeString));
        }
        return result;
    }

    private SimpleSequence getSelectionsSimpleSequence(String[] selectionNames, Escaper.EscaperType escapeString) {
        SimpleSequence result = new SimpleSequence();
        for (int i = 0; i < selectionNames.length; ++i) {
            result.add((Object)RendererAbstract.escapeString(selectionNames[i], escapeString));
        }
        return result;
    }

    private SimpleSequence getZoomLevelSequence(Level[] levels) {
        SimpleSequence result = new SimpleSequence();
        for (Level l : levels) {
            SimpleHash level = new SimpleHash();
            level.put("width", (Object)l.width);
            level.put("height", (Object)l.height);
            level.put("tilewidth", (Object)l.tileSizeX);
            level.put("tileheight", (Object)l.tileSizeY);
            result.add((Object)level);
        }
        return result;
    }
}

