/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiframework.comparator.LexicalStringComparator;
import com.neptunelabs.fsiframework.comparator.LogicalStringComparator;
import com.neptunelabs.fsiframework.comparator.NaturalStringComparator;
import com.neptunelabs.fsiframework.comparator.NumericalStringComparator;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class RendererEnvironment {
    public static final PoolEntrySortingField DEFAULT_SORT_FIELD = PoolEntrySortingField.FILENAME;
    public static final SortDirection DEFAULT_SORT_ORDER = SortDirection.ASC;
    public static final SortMethod DEFAULT_SORT_METHOD = SortMethod.NATURAL;
    public static final boolean DEFAULT_SORT_CASE_SENSITIVE = false;
    public static final String DEFAULT_LIST_TEMPLATE = "image_list.xml";
    private String defaultSortLanguage;
    private String defaultSortCountry;
    private final Map<String, FSIStringComparator> stringComparatorCache = new HashMap<String, FSIStringComparator>();
    private static RendererEnvironment instance = null;

    public static RendererEnvironment getInstance(Locale locale) {
        if (instance == null) {
            instance = new RendererEnvironment(locale);
        }
        return instance;
    }

    private RendererEnvironment(Locale defLocale) {
        if (defLocale != null) {
            this.defaultSortLanguage = defLocale.getLanguage();
            this.defaultSortCountry = defLocale.getCountry();
        }
    }

    public FSIStringComparator selectStringComparator(SortMethod method, String language, String country, boolean ignoreCase, boolean ascending) {
        FSIStringComparator result;
        if (method == SortMethod.NATURAL) {
            result = new NaturalStringComparator(language, country, ignoreCase);
            result.setAscendingOrder(ascending);
        } else if (method == SortMethod.LOGICAL) {
            result = new LogicalStringComparator(language, country, ignoreCase);
            result.setAscendingOrder(ascending);
        } else if (method == SortMethod.LEXICAL) {
            result = new LexicalStringComparator(language, country, ignoreCase);
            result.setAscendingOrder(ascending);
        } else {
            result = new NumericalStringComparator(ascending, ignoreCase);
        }
        return result;
    }

    public String getDefaultSortLanguage() {
        return this.defaultSortLanguage;
    }

    public String getDefaultSortCountry() {
        return this.defaultSortCountry;
    }

    public FSIStringComparator getFSIStringComparator(SortDirection sortOrder, SortMethod sortMethod, String language, String country, boolean caseSensitive) {
        String hashKey = sortOrder.name() + sortMethod.name() + language + country + caseSensitive;
        FSIStringComparator comparator = this.stringComparatorCache.get(hashKey);
        if (comparator == null) {
            comparator = this.selectStringComparator(sortMethod, language, country, !caseSensitive, sortOrder == SortDirection.ASC);
            this.stringComparatorCache.put(hashKey, comparator);
        }
        return comparator;
    }
}

