/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SimpleWatermarkRenderer
extends RendererAbstract {
    private static final boolean KEEP_ASPECT_RATIO = true;
    private static final Pattern overlayPattern = Pattern.compile("(.*?)\\(([0-9]*)(?:,(TL|TC|TR|CL|CC|CR|BL|BC|BR))?+(?:,([0-9\\.\\-]*))?+(?:,([0-9\\.\\-]*))?+\\),?");
    private final StandardImageRenderer standardRenderer;
    private final ImageBuilder standardImagebuilder;
    private final List<LayerProperties> profileLayers = new ArrayList<LayerProperties>();
    private String overlayString = "";

    public SimpleWatermarkRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardRenderer = new StandardImageRenderer(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        RendererImageResponse rr = (RendererImageResponse)this.standardRenderer.processRequest(priority, req, metadata);
        if (rr.getStatus() == 200) {
            try {
                this.renderOverlays(priority, rr, req);
            }
            catch (NotConfiguredException e) {
                rr.setStatus(503);
                this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (ProcessingException e) {
                SimpleWatermarkRenderer.disposeImages(rr.getImage());
                throw e;
            }
        }
        return rr;
    }

    private void renderOverlays(int priority, RendererImageResponse rr, HttpServletRequest req) throws NotConfiguredException, ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        ArrayList<LayerProperties> layers = new ArrayList<LayerProperties>();
        layers.addAll(this.profileLayers);
        String overlaysStr = parameters.get(Parameters.FileImage.overlays);
        if (overlaysStr != null && overlaysStr.length() > 0) {
            Matcher m = overlayPattern.matcher(overlaysStr);
            while (m.find()) {
                LayerProperties lp = this.extractLayerProperties(m);
                layers.add(lp);
            }
        }
        for (LayerProperties pl : layers) {
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(pl.assetURLPath);
            try {
                MetaData md = this.standardImagebuilder.getImageMetaData(connector, pl.assetURLPath, 0, true, req.getSession(false));
                if (md instanceof ImageMetaData) {
                    pl.metadata = (ImageMetaData)md;
                    continue;
                }
                throw new IllegalArgumentException("Overlays not supported for non-image files.");
            }
            catch (IOException iOException) {
            }
        }
        FSIImage image = rr.getImage();
        try {
            for (int i = 0; i < layers.size(); ++i) {
                LayerProperties layer = (LayerProperties)layers.get(i);
                image = this.loadAndBlendLayer(priority, image, layer);
            }
            rr.setResponseImage((FSIImageLimited)image);
        }
        catch (IOException i) {
            // empty catch block
        }
        long lastmodified = rr.getDateHeader("Last-Modified");
        for (LayerProperties pl : layers) {
            lastmodified += pl.metadata.getLastModified();
        }
        rr.setDateHeader("Last-Modified", lastmodified /= (long)(layers.size() + 1));
    }

    private LayerProperties extractLayerProperties(Matcher m) {
        LayerProperties lp = new LayerProperties();
        lp.assetURLPath = m.group(1);
        try {
            lp.opacity = Integer.parseInt(m.group(2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (m.group(3) != null) {
            lp.quadrant = m.group(3);
        }
        if (m.group(4) != null) {
            try {
                lp.pos1 = Float.parseFloat(m.group(4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (m.group(5) != null) {
            try {
                lp.pos2 = Float.parseFloat(m.group(5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lp;
    }

    private FSIImage loadAndBlendLayer(int priority, FSIImage result, LayerProperties layer) throws NoSuchFileException, IOException, NotImportedException, NotConfiguredException, ProcessingException, InterruptedException {
        FSIImageLimited image = null;
        try {
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(layer.assetURLPath);
            image = this.standardImagebuilder.getImage(null, connector, priority, layer.assetURLPath, new Pair<Integer, Boolean>(layer.metadata.getWidth(), false), new Pair<Integer, Boolean>(layer.metadata.getHeight(), false), 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.LANCZOS);
            Pair<Integer, Integer> offset = this.calculateOffset(layer, image, result.getWidth(), result.getHeight());
            ExecutorPool ep = this.settings.getExecutorPool();
            LayerBlend blend = new LayerBlend(this.settings.getFSILogger(), ep, priority);
            result = blend.transform(result, image, offset.getItem1(), offset.getItem2(), BlendMode.NORMAL, AlphaMode.NORMAL, layer.opacity, false);
        }
        catch (FSIImageException e) {
            if (image != null) {
                image.dispose();
            }
            this.settings.getFSILogger().log(2504, layer.assetURLPath, e.getLocalizedMessage());
        }
        catch (ProcessingException e) {
            SimpleWatermarkRenderer.disposeImages(image);
            throw e;
        }
        return result;
    }

    private Pair<Integer, Integer> calculateOffset(LayerProperties layer, FSIImageLimited image, int bgWidth, int bgHeight) {
        int x = 0;
        int y = 0;
        if (layer.quadrant.equals("TL")) {
            x = (int)layer.pos1;
            y = (int)layer.pos2;
        } else if (layer.quadrant.equals("TC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f + layer.pos1);
            y = (int)layer.pos2;
        } else if (layer.quadrant.equals("TR")) {
            x = (int)((float)(bgWidth - image.getWidth()) + layer.pos1);
            y = (int)layer.pos2;
        } else if (layer.quadrant.equals("CL")) {
            x = (int)layer.pos1;
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f + layer.pos2);
        } else if (layer.quadrant.equals("CC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f + layer.pos1);
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f + layer.pos2);
        } else if (layer.quadrant.equals("CR")) {
            x = (int)((float)(bgWidth - image.getWidth()) + layer.pos1);
            y = (int)((float)bgHeight / 2.0f - (float)image.getHeight() / 2.0f + layer.pos2);
        } else if (layer.quadrant.equals("BL")) {
            x = (int)layer.pos1;
            y = (int)((float)(bgHeight - image.getHeight()) + layer.pos2);
        } else if (layer.quadrant.equals("BC")) {
            x = (int)((float)bgWidth / 2.0f - (float)image.getWidth() / 2.0f + layer.pos1);
            y = (int)((float)(bgHeight - image.getHeight()) + layer.pos2);
        } else if (layer.quadrant.equals("BR")) {
            x = (int)((float)(bgWidth - image.getWidth()) + layer.pos1);
            y = (int)((float)(bgHeight - image.getHeight()) + layer.pos2);
        }
        Pair<Integer, Integer> offset = new Pair<Integer, Integer>(x, y);
        return offset;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("keepaspectratio");
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("overlay");
        result.add("applyrangetooverlays");
        return result;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        result = name.equalsIgnoreCase("overlay") ? this.overlayString : this.standardRenderer.getOption(name);
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("overlay")) {
            Matcher m = overlayPattern.matcher(value);
            while (m.find()) {
                LayerProperties lp = this.extractLayerProperties(m);
                this.profileLayers.add(lp);
            }
            this.overlayString = value;
        } else {
            this.standardRenderer.setOption(name, value);
        }
    }

    private static class LayerProperties {
        String assetURLPath;
        String quadrant = "CC";
        int opacity = 100;
        float pos1 = 0.0f;
        float pos2 = 0.0f;
        ImageMetaData metadata = null;
    }
}

