/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.cache.CacheableArrayList;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.area.SimpleBorder;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StandardDirectoryImageRenderer
extends RendererAbstract {
    private final ImageBuilder imageBuilder;
    private final PoolEntrySortingField defaultSortField;
    private final Comparator<String> comparator;
    private static final float FOLDER_MAX_WIDTH_FACTOR = 0.85714287f;
    private static final float FOLDER_MAX_HEIGHT_FACTOR = 0.7222222f;
    private static final float FOLDER_TOP_START = 0.16190477f;

    public StandardDirectoryImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        int i2;
        String s;
        this.imageBuilder = settings.getImageBuilder();
        int l = settings.getPrefsInt("limits", "maxwidth");
        if (l > 0) {
            this.maxWidth = l;
        }
        if ((l = settings.getPrefsInt("limits", "maxheight")) > 0) {
            this.maxHeight = l;
        }
        if ((s = settings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.defaultWidth = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultWidth = i2;
                }
            }
            catch (NumberFormatException i2) {
                // empty catch block
            }
        }
        s = settings.getPrefsString("limits", "defaultheight");
        if (s.equalsIgnoreCase("source")) {
            this.defaultHeight = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultHeight = i2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.comparator = settings.getDefaultStringComparator();
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        RendererResponse result = this.checkStandardImageRequestParameters(parameters);
        if (result != null) {
            return result;
        }
        if (parameters.getType() != Parameters.Type.DIRECTORYIMAGE) {
            throw new IllegalArgumentException("invalid type");
        }
        result = this.processImageRequest(priority, req);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("keepaspectratio");
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultWidth = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultWidth = i;
                    }
                }
                catch (NumberFormatException i) {}
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultHeight = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultHeight = i;
                    }
                }
                catch (NumberFormatException i) {}
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        RendererTextResponse errorResponse = null;
        if (parameters.contains(Parameters.GeneralImage.width)) {
            int width = -1;
            try {
                width = Integer.parseInt(parameters.get(Parameters.GeneralImage.width));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width <= 0) {
                errorResponse = StandardDirectoryImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.width));
            }
        }
        if (errorResponse == null && parameters.contains(Parameters.GeneralImage.height)) {
            int height = -1;
            try {
                height = Integer.parseInt(parameters.get(Parameters.GeneralImage.height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (height <= 0) {
                errorResponse = StandardDirectoryImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.height));
            }
        }
        return errorResponse;
    }

    private RendererResponse processImageRequest(int priority, HttpServletRequest request) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse response;
        block9: {
            response = new RendererImageResponse();
            Parameters parameters = (Parameters)request.getAttribute("parameters");
            String assetURLPath = parameters.getAssetURLPath();
            HttpSession session = request.getSession(false);
            try {
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
                PermissionSet permissions = this.settings.getUserAuthenticationInterface().getPermissions(assetURLPath, session, true);
                if (permissions != null && permissions.read.renderedImages.booleanValue()) {
                    Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
                    Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
                    if (widthPair.getItem2().booleanValue()) {
                        parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
                    }
                    if (heightPair.getItem2().booleanValue()) {
                        parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
                    }
                    try {
                        this.processDirectoryImageRequest(connector, permissions, priority, assetURLPath, parameters, widthPair, heightPair, session, response);
                        break block9;
                    }
                    catch (NoSuchFileException e) {
                        response.setStatus(404);
                        break block9;
                    }
                    catch (IOException e) {
                        response.setStatus(500);
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid range value");
                    }
                }
                response.setStatus(403);
            }
            catch (NotConfiguredException e) {
                response.setStatus(503);
                this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
        }
        return response;
    }

    private void processDirectoryImageRequest(SourceConnectorReader sourceConnector, PermissionSet permissions, int priority, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpSession session, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnector == null && assetURLPath.equals("_trash")) {
            this.handleTrashDirImageRequest(priority, widthPair, heightPair, session, response);
        } else if (assetURLPath.equals("_downloads")) {
            this.handleDownloadsDirImageRequest(priority, widthPair, heightPair, session, response);
        } else {
            this.handleDefaultDirImageRequest(sourceConnector, permissions, priority, this.imageBuilder, assetURLPath, parameters, widthPair, heightPair, session, response);
        }
    }

    private void handleTrashDirImageRequest(int priority, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpSession session, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        List<TrashListEntry> trashList = this.getTrashList(session);
        String icon = trashList.size() > 0 ? "trashfull.eis" : "trash.eis";
        long lastMod = 0L;
        for (TrashListEntry tle : trashList) {
            lastMod = Math.max(tle.deletedDate, lastMod);
        }
        if (lastMod == 0L) {
            lastMod = System.currentTimeMillis();
        }
        FSIImageLimited background = null;
        try {
            background = this.imageBuilder.getImage(null, null, priority, icon, widthPair, heightPair, 0.0, 0.0, 1.0, 1.0, false, FSIInterpolation.LANCZOS);
        }
        catch (ProcessingException e) {
            StandardDirectoryImageRenderer.disposeImages(background);
            throw e;
        }
        response.setDateHeader("Last-Modified", lastMod);
        response.setETagModifier(icon);
        response.setResponseImage(background);
        response.setStatus(200);
    }

    private void handleDownloadsDirImageRequest(int priority, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpSession session, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        List<DownloadJob> jobs = this.getDownloadsList(session);
        String icon = jobs.size() > 0 ? "downloadfull.eis" : "download.eis";
        long lastMod = 0L;
        for (DownloadJob job : jobs) {
            lastMod = Math.max(job.getCreationTime(), lastMod);
        }
        if (lastMod == 0L) {
            lastMod = System.currentTimeMillis();
        }
        FSIImageLimited background = null;
        try {
            background = this.imageBuilder.getImage(null, null, priority, icon, widthPair, heightPair, 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.LANCZOS);
        }
        catch (ProcessingException e) {
            StandardDirectoryImageRenderer.disposeImages(background);
            throw e;
        }
        response.setDateHeader("Last-Modified", lastMod);
        response.setResponseImage(background);
        response.setStatus(200);
    }

    private void handleDefaultDirImageRequest(SourceConnectorReader sourceConnector, PermissionSet permissions, int priority, ImageBuilder imagebuilder, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpSession session, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        FSIImage canvas;
        block20: {
            long lmDate;
            List<Object> imageList = null;
            boolean useCache = !assetURLPath.startsWith("_configs") && !assetURLPath.startsWith("_viewers");
            CacheKey cacheKey = null;
            if (useCache) {
                cacheKey = CacheKey.getInstance(assetURLPath, 'D', "dirImageList");
                CacheLoad cl = this.settings.getCacheManager().get(cacheKey, CacheType.LIST);
                if (cl != null) {
                    imageList = cl.requestedL1Object != null ? (CacheableArrayList)cl.requestedL1Object : CacheableArrayList.unpack(cl.data);
                }
            }
            int maxImages = 3;
            if (imageList == null) {
                PoolList list = imagebuilder.getPoolList(sourceConnector, assetURLPath, session);
                imageList = list.getFilesAsList();
                if (imageList.size() < 1000) {
                    PoolFileEntryComparator entryComparator = new PoolFileEntryComparator(this.defaultSortField, this.comparator, SortDirection.ASC);
                    Collections.sort(imageList, entryComparator);
                }
                imageList = this.limitList((List<PoolFileEntry>)imageList, 0, 3);
                if (useCache) {
                    this.settings.getCacheManager().put(cacheKey, new CacheableArrayList(imageList), true);
                }
                lmDate = list.lastmodified;
            } else {
                PoolListSummary summary = imagebuilder.getPoolListSummary(sourceConnector, assetURLPath, session);
                lmDate = summary.lastmodified;
            }
            if (sourceConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
                Iterator<PoolFileEntry> pit = imageList.iterator();
                while (pit.hasNext()) {
                    PoolFileEntry pfe = pit.next();
                    if (pfe.importStatus == 1) continue;
                    pit.remove();
                }
            }
            response.setDateHeader("Last-Modified", lmDate);
            ExecutorPool ep = this.settings.getExecutorPool();
            canvas = null;
            FSIImage image = null;
            try {
                canvas = this.imageBuilder.getImage(null, null, priority, "folder.eis", widthPair, heightPair, 0.0, 0.0, 1.0, 1.0, false, FSIInterpolation.LANCZOS);
                float smallFactor = 0.1f;
                int w = canvas.getWidth();
                int h = canvas.getHeight();
                int yOff = Math.round((float)canvas.getHeight() * 0.033333335f);
                if (permissions.read.renderedImages.booleanValue() && permissions.list.files.booleanValue() && imageList.size() > 0) {
                    int imageToRenderCount = imageList.size();
                    int posCounter = 3 - imageToRenderCount;
                    SourceConnectorReader assetSourceConnector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                    LayerBlend blend = new LayerBlend(this.settings.getFSILogger(), ep, priority);
                    ParallelColorOperation colorOperation = new ParallelColorOperation(this.settings.getFSILogger(), ep, priority);
                    SimpleBorder simpleBorder = new SimpleBorder(this.settings.getFSILogger(), ep, priority);
                    for (int i = 0; i < imageToRenderCount; ++i) {
                        PoolEntry poolEntry = (PoolEntry)imageList.get(imageToRenderCount - i - 1);
                        image = null;
                        try {
                            PoolFileEntry fileEntry = (PoolFileEntry)poolEntry;
                            FSIInterpolation interpolation = fileEntry.width < w && fileEntry.height < h ? FSIInterpolation.NEAREST : FSIInterpolation.LANCZOS;
                            float f = 1.0f - (float)(3 - posCounter - 1) * 0.1f;
                            Pair<Integer, Boolean> subWPair = new Pair<Integer, Boolean>(Math.round((float)w * 0.85714287f * f), false);
                            Pair<Integer, Boolean> subHPair = new Pair<Integer, Boolean>(Math.round((float)h * 0.7222222f * f), false);
                            if (sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
                                String suffix = this.getSuffixFromAssetURLPath(fileEntry.name);
                                String mimeImageURLPath = "mime/" + MimeTypeImageMapping.getImageFilename(suffix);
                                image = this.imageBuilder.getImage(null, null, priority, mimeImageURLPath, subWPair, subHPair, 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.LANCZOS);
                            } else {
                                image = this.imageBuilder.getImage(null, assetSourceConnector, priority, assetURLPath + '/' + fileEntry.name, subWPair, subHPair, 0.0, 0.0, 1.0, 1.0, true, interpolation);
                            }
                        }
                        catch (NoSuchFileException fileEntry) {
                        }
                        catch (Exception e) {
                            this.settings.getFSILogger().log(2504, assetURLPath + '/' + poolEntry.name, e.getLocalizedMessage());
                        }
                        if (image != null) {
                            if (sourceConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
                                if (image.hasAlpha()) {
                                    image = colorOperation.transform(image, new MatteTransparent(0xFFFFFF, false), false);
                                }
                                image = simpleBorder.transform(image, -6710887, 1, false);
                            }
                            int yTopStart = Math.round((float)canvas.getHeight() * 0.16190477f);
                            int topPos = yTopStart + posCounter * yOff;
                            int leftPos = Math.round((float)(canvas.getWidth() - image.getWidth()) / 2.0f);
                            canvas = blend.transform(canvas, image, leftPos, topPos, BlendMode.NORMAL, 100.0f, false);
                        }
                        ++posCounter;
                    }
                    break block20;
                }
                canvas = this.imageBuilder.getImage(null, null, priority, "folder.eis", widthPair, heightPair, 0.0, 0.0, 1.0, 1.0, false, FSIInterpolation.LANCZOS);
            }
            catch (ProcessingException e) {
                StandardDirectoryImageRenderer.disposeImages(canvas, image);
                throw e;
            }
        }
        response.setResponseImage((FSIImageLimited)canvas);
        response.setStatus(200);
    }

    private String getSuffixFromAssetURLPath(String assetURLPath) {
        try {
            int suffixStart = assetURLPath.lastIndexOf(".") + 1;
            String suffix = assetURLPath.substring(suffixStart);
            if (suffix.equals("gz") || suffix.equals("bz2")) {
                suffixStart = assetURLPath.lastIndexOf(".", suffixStart - 2);
                suffix = assetURLPath.substring(suffixStart);
            }
            return suffix;
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }
}

