/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.pyramidreader.FlatImageException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StandardImageRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;
    private boolean keepAspectRatio = true;
    private String errorFallback = null;
    private String importingFallback = null;
    private boolean noredirect = false;

    public StandardImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        int i2;
        String s;
        this.standardImagebuilder = settings.getImageBuilder();
        int l = settings.getPrefsInt("limits", "maxwidth");
        if (l > 0) {
            this.maxWidth = l;
        }
        if ((l = settings.getPrefsInt("limits", "maxheight")) > 0) {
            this.maxHeight = l;
        }
        if ((s = settings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.defaultWidth = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultWidth = i2;
                }
            }
            catch (NumberFormatException i2) {
                // empty catch block
            }
        }
        s = settings.getPrefsString("limits", "defaultheight");
        if (s.equalsIgnoreCase("source")) {
            this.defaultHeight = 0;
        } else {
            try {
                i2 = Integer.parseInt(s);
                if (i2 > 0) {
                    this.defaultHeight = i2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.calculateRendererChecksum();
    }

    @Override
    public void calculateRendererChecksum() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.defaultWidth);
        builder.append(this.defaultHeight);
        builder.append(this.maxWidth);
        builder.append(this.maxHeight);
        builder.append(this.keepAspectRatio);
        builder.append(this.noredirect);
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            result = String.valueOf(this.keepAspectRatio);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            result = this.errorFallback;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            result = this.importingFallback;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        RendererResponse result = this.checkStandardImageRequestParameters(parameters);
        if (result != null) {
            return result;
        }
        if (parameters.getType() != Parameters.Type.IMAGE) {
            throw new IllegalArgumentException("invalid type");
        }
        result = this.processImageRequest(priority, this.standardImagebuilder, req);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("keepaspectratio");
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("noredirect");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("keepAspectRatio")) {
            this.keepAspectRatio = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("errorFallback")) {
            this.errorFallback = value;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            this.importingFallback = value;
        } else if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultWidth = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultWidth = i;
                    }
                }
                catch (NumberFormatException i) {}
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            if (value.equalsIgnoreCase("source")) {
                this.defaultHeight = 0;
            } else {
                try {
                    int i = Integer.parseInt(value);
                    if (i > 0) {
                        this.defaultHeight = i;
                    }
                }
                catch (NumberFormatException i) {}
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase("noredirect")) {
            this.noredirect = Boolean.parseBoolean(value);
        }
        this.calculateRendererChecksum();
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        RendererTextResponse errorResponse = null;
        if (parameters.contains(Parameters.GeneralImage.width)) {
            int width = -1;
            try {
                width = Integer.parseInt(parameters.get(Parameters.GeneralImage.width));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width <= 0) {
                errorResponse = StandardImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.width));
            }
        }
        if (errorResponse == null && parameters.contains(Parameters.GeneralImage.height)) {
            int height = -1;
            try {
                height = Integer.parseInt(parameters.get(Parameters.GeneralImage.height));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (height <= 0) {
                errorResponse = StandardImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.height));
            }
        }
        if (errorResponse == null && !parameters.contains(Parameters.General.source)) {
            errorResponse = StandardImageRenderer.generateInvalidParameterValueResponse("source", "empty");
        }
        return errorResponse;
    }

    private RendererResponse processImageRequest(int priority, ImageBuilder imageBuilder, HttpServletRequest request) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse response;
        block11: {
            response = new RendererImageResponse();
            Parameters parameters = (Parameters)request.getAttribute("parameters");
            boolean parameterCombinationValid = this.checkParameterCombinationForImageRequest(parameters);
            if (!parameterCombinationValid) {
                response.setStatus(400);
            } else {
                try {
                    HttpSession session = request.getSession(false);
                    String assetURLPath = parameters.getAssetURLPath();
                    SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
                    PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                    if (ps != null && ps.read.renderedImages.booleanValue()) {
                        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
                        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
                        if (widthPair.getItem2().booleanValue()) {
                            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
                        }
                        if (heightPair.getItem2().booleanValue()) {
                            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
                        }
                        try {
                            this.processFileImageRequest(connector, priority, imageBuilder, assetURLPath, parameters, widthPair, heightPair, request, response);
                            break block11;
                        }
                        catch (NoSuchFileException e) {
                            response.setStatus(404);
                            break block11;
                        }
                        catch (IOException e) {
                            response.setStatus(500);
                            e.printStackTrace();
                            break block11;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid range value");
                        }
                    }
                    response.setStatus(403);
                }
                catch (NotConfiguredException e) {
                    response.setStatus(503);
                    this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
                }
            }
        }
        return response;
    }

    private void processFileImageRequest(SourceConnectorReader sourceConnector, int priority, ImageBuilder imagebuilder, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnector == null || sourceConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
            boolean selectionRequired = parameters.contains(Parameters.GeneralImage.effects);
            this.processDynamicFileImageRequest(sourceConnector, priority, imagebuilder, assetURLPath, parameters, widthPair, heightPair, request, response, selectionRequired);
        } else {
            this.processMimeTypeImageRequest(priority, assetURLPath, parameters, widthPair, heightPair, request, response);
        }
    }

    private void processMimeTypeImageRequest(int priority, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        String suffix = this.getSuffixFromAssetURLPath(assetURLPath);
        String imageFilename = MimeTypeImageMapping.getImageFilename(suffix);
        String mimeImageURLPath = "mime/" + imageFilename;
        parameters.put(Parameters.General.renderer, "_private");
        request.setAttribute("mimeImageRequest", (Object)true);
        this.processDynamicFileImageRequest(null, priority, this.standardImagebuilder, mimeImageURLPath, parameters, widthPair, heightPair, request, response, false);
    }

    private String getSuffixFromAssetURLPath(String assetURLPath) {
        try {
            int suffixStart = assetURLPath.lastIndexOf(".") + 1;
            String suffix = assetURLPath.substring(suffixStart);
            if (suffix.equals("gz") || suffix.equals("bz2")) {
                suffixStart = assetURLPath.lastIndexOf(".", suffixStart - 2);
                suffix = assetURLPath.substring(suffixStart);
            }
            return suffix;
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    private boolean checkParameterCombinationForImageRequest(Parameters parameters) {
        return !parameters.contains(Parameters.GeneralImage.pixelrange) && !parameters.contains(Parameters.GeneralImage.pixeltop) && !parameters.contains(Parameters.GeneralImage.pixelleft) && !parameters.contains(Parameters.GeneralImage.pixelright) && !parameters.contains(Parameters.GeneralImage.pixelbottom) || !parameters.contains(Parameters.GeneralImage.rect) && !parameters.contains(Parameters.GeneralImage.top) && !parameters.contains(Parameters.GeneralImage.left) && !parameters.contains(Parameters.GeneralImage.right) && !parameters.contains(Parameters.GeneralImage.bottom) && !parameters.contains(Parameters.GeneralImage.width) && !parameters.contains(Parameters.GeneralImage.height);
    }

    /*
     * Loose catch block
     */
    private void processDynamicFileImageRequest(SourceConnectorReader sourceConnector, int priority, ImageBuilder imagebuilder, String assetURLPath, Parameters parameters, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair, HttpServletRequest request, RendererImageResponse response, boolean selectionsRequired) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        block50: {
            MetaData metadata;
            int flags = 0;
            if (selectionsRequired) {
                flags |= 0x40;
            }
            if ((metadata = imagebuilder.getImageMetaData(sourceConnector, assetURLPath, flags, false, request.getSession(false))) == null) {
                response.setStatus(404);
                return;
            }
            if (!(metadata instanceof ImageMetaData)) {
                throw new IllegalArgumentException("processDynamicFileImageRequest called for non-image connector:" + metadata);
            }
            ImageMetaData imagemetadata = (ImageMetaData)metadata;
            Throwable throwable = null;
            try (EISReader preUsedReader = imagemetadata.getEISReaderHook();){
                FSIImageLimited image;
                boolean notmodified;
                block53: {
                    boolean isMimeImageRequest;
                    short importStatus;
                    if (widthPair.getItem1() == 0) {
                        widthPair.setItem1(Math.min(imagemetadata.getWidth(), this.maxWidth));
                    }
                    if (heightPair.getItem1() == 0) {
                        heightPair.setItem1(Math.min(imagemetadata.getHeight(), this.maxHeight));
                    }
                    if ((importStatus = (short)imagemetadata.getImportStatus()) != 1 && importStatus != 4) {
                        if (this.noredirect) {
                            if (importStatus != 3 || importStatus != 5) {
                                response.setStatus(500);
                            } else if (importStatus != 2) {
                                response.setStatus(503);
                                response.setHeader("Retry-After", "30");
                            }
                        } else {
                            this.createFallbackResponse(assetURLPath, parameters, importStatus, response);
                        }
                        break block50;
                    }
                    notmodified = false;
                    boolean isPrivateRenderer = parameters.get(Parameters.General.renderer) != null && parameters.get(Parameters.General.renderer).equals("_private");
                    boolean bl = isMimeImageRequest = request.getAttribute("mimeImageRequest") != null && (Boolean)request.getAttribute("mimeImageRequest") != false;
                    if (isMimeImageRequest || isPrivateRenderer) {
                        sourceConnector = null;
                    }
                    if (isPrivateRenderer && !isMimeImageRequest) {
                        response.setDateHeader("Expires", 1000L);
                        response.setHeader("Pragma", "no-cache, no-store");
                        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                    } else {
                        long imsRound = request.getDateHeader("If-Modified-Since") / 1000L * 1000L;
                        long lmdate = imagemetadata.getLastModified();
                        if (lmdate == imsRound) {
                            notmodified = true;
                        }
                        response.setDateHeader("Last-Modified", lmdate);
                    }
                    image = null;
                    String eTagModifier = this.rendererChecksum + parameters.hashCode64() + imagemetadata.hashCode();
                    response.setETagModifier(eTagModifier);
                    if (notmodified) break block53;
                    double[] relativeRange = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
                    int[] pixelRange = Arrays.copyOf(DEFAULT_PIXEL_RANGE, 4);
                    boolean pixelBased = false;
                    if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
                        StandardImageRenderer.getRelativeRangeFromParameters(parameters, relativeRange);
                    } else if (parameters.contains(Parameters.GeneralImage.pixelrange) || parameters.contains(Parameters.GeneralImage.pixeltop) || parameters.contains(Parameters.GeneralImage.pixelleft) || parameters.contains(Parameters.GeneralImage.pixelright) || parameters.contains(Parameters.GeneralImage.pixelbottom)) {
                        pixelBased = true;
                        this.getPixelRangeFromParameters(parameters, pixelRange);
                    }
                    try {
                        if (pixelBased) {
                            int[] referenceDimensions = StandardImageRenderer.getReferenceDimensions(parameters);
                            image = imagebuilder.getImagePixelBased(preUsedReader, sourceConnector, priority, assetURLPath, referenceDimensions[0], referenceDimensions[1], pixelRange[0], pixelRange[1], pixelRange[2], pixelRange[3], this.keepAspectRatio, FSIInterpolation.LANCZOS);
                        } else {
                            image = imagebuilder.getImage(preUsedReader, sourceConnector, priority, assetURLPath, widthPair, heightPair, relativeRange[0], relativeRange[1], relativeRange[2], relativeRange[3], this.keepAspectRatio, FSIInterpolation.LANCZOS);
                        }
                    }
                    catch (FlatImageException e) {
                        this.createFallbackResponse(assetURLPath, parameters, (short)5, response);
                        if (preUsedReader != null) {
                            if (throwable != null) {
                                try {
                                    preUsedReader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                preUsedReader.close();
                            }
                        }
                        return;
                    }
                    catch (Exception e) {
                        block51: {
                            block52: {
                                e.printStackTrace();
                                this.createFallbackResponse(assetURLPath, parameters, (short)3, response);
                                if (preUsedReader == null) break block51;
                                if (throwable == null) break block52;
                                try {
                                    preUsedReader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block51;
                            }
                            preUsedReader.close();
                        }
                        return;
                    }
                }
                if (image != null) {
                    String profilename = parameters.get(Parameters.General.renderer);
                    if (profilename != null && profilename.equals("_private")) {
                        ExecutorPool ep = this.settings.getExecutorPool();
                        ParallelColorOperation colorOperation = new ParallelColorOperation(this.settings.getFSILogger(), ep, priority);
                        try {
                            image = (FSIImageLimited)colorOperation.transform(image, new MatteTransparent(0xFFFFFF, false), false);
                        }
                        catch (ProcessingException e) {
                            StandardImageRenderer.disposeImages(image);
                            throw e;
                        }
                    }
                    response.setResponseImage(image);
                    response.setSelectionsRaw(imagemetadata.getSelections());
                    response.setStatus(200);
                    break block50;
                }
                if (notmodified) {
                    response.setStatus(304);
                } else {
                    response.setStatus(500);
                }
                break block50;
                {
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
            }
        }
    }
}

