/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.FreemarkerEntityFixer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class StandardInfoRenderer
extends RendererAbstract {
    private final ImageBuilder standardImagebuilder;
    private String errorFallback = null;
    private String importingFallback = null;
    private boolean noredirect = false;

    public StandardInfoRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("errorFallback")) {
            result = this.errorFallback;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            result = this.importingFallback;
        } else if (name.equalsIgnoreCase("noredirect")) {
            result = String.valueOf(this.noredirect);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        HttpSession session = req.getSession(false);
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        if (parameters.getAssetURLPath() == null) {
            return StandardInfoRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.INFO) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererTextResponse result = this.processInfoRequest(this.standardImagebuilder, parameters, session);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("errorfallback");
        result.add("importingfallback");
        result.add("noredirect");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if ("noredirect".equals(name) && "true".equals(value)) {
            this.noredirect = true;
        } else if (name.equalsIgnoreCase("errorFallback")) {
            this.errorFallback = value;
        } else if (name.equalsIgnoreCase("importingFallback")) {
            this.importingFallback = value;
        }
    }

    private RendererTextResponse processInfoRequest(ImageBuilder imagebuilder, Parameters parameters, HttpSession session) throws IllegalArgumentException {
        RendererTextResponse response;
        block10: {
            try {
                String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info.xml";
                Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
                TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
                if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
                    response = StandardInfoRenderer.generateNotAuthorizedResponse();
                    break block10;
                }
                Escaper.EscaperType staticEscape = templateAttrs.getStaticEscape();
                int readFlag = templateAttrs.getReadFlag();
                SimpleHash templateData = new SimpleHash();
                templateData.put("query", (Object)parameters);
                try {
                    response = this.handleSingleSource(parameters, session, imagebuilder, template, templateData, staticEscape, readFlag);
                }
                catch (NoSuchFileException e) {
                    if (StandardInfoRenderer.multiSources(parameters.get(Parameters.General.source))) {
                        response = this.handleMultiSource(parameters.get(Parameters.General.source), session, imagebuilder, template, templateData, readFlag);
                    }
                    throw e;
                }
                templateAttrs.setRendererResponseContentType(response);
            }
            catch (NoSuchFileException e) {
                response = StandardInfoRenderer.generateNotFoundResponse();
            }
            catch (IOException e) {
                response = StandardInfoRenderer.generateErrorResponse();
                this.settings.getFSILogger().logException(e, 3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (TemplateException e) {
                response = StandardInfoRenderer.generateErrorResponse();
                this.settings.getFSILogger().logException((Exception)((Object)e), 3191, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (NotConfiguredException e) {
                response = StandardInfoRenderer.generateUnavailableResponse();
                this.settings.getFSILogger().logException(e, 3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (Exception e) {
                response = StandardInfoRenderer.generateErrorResponse();
                this.settings.getFSILogger().logException(e, 3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
        }
        return response;
    }

    private boolean isURLPathDirectory(String assetURLPath, HttpSession session) throws NotConfiguredException {
        if (assetURLPath != null && (assetURLPath.equals("_trash") || assetURLPath.equals("_downloads") || assetURLPath.equals("_viewers") || assetURLPath.equals("_configs"))) {
            return true;
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
        if (connector == null) {
            return false;
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            return this.isStorageDirectory(assetURLPath);
        }
        PathCached sourceFile = connector.getSourceFileFromAssetURLPath(assetURLPath);
        return sourceFile.isDirectory();
    }

    private boolean isStorageDirectory(String assetURLPath) throws NotConfiguredException {
        StorageHelperV1002 storageHelperV1002 = this.settings.getStorageHelper();
        return storageHelperV1002.isStorageDirectory(assetURLPath) || StorageHelperV1001.isStorageDirectory(this.settings.getStorageLocation(), assetURLPath);
    }

    private RendererTextResponse handleSingleSource(Parameters parameters, HttpSession session, ImageBuilder imagebuilder, Template template, SimpleHash templateData, Escaper.EscaperType staticEscape, int readFlag) throws IOException, TemplateException, NotConfiguredException {
        SourceConnectorReader connector;
        MetaData assetMetaData;
        String assetURLPath = parameters.getAssetURLPath();
        PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(assetURLPath, session, true);
        if (ps == null) {
            return StandardInfoRenderer.generateNotAuthorizedResponse();
        }
        RendererTextResponse response = new RendererTextResponse();
        SimpleHash infoHash = null;
        if (assetURLPath.equals("_downloads") || assetURLPath.equals("_trash")) {
            assetMetaData = new MetaData();
            assetMetaData.setAssetURLPath(assetURLPath);
            assetMetaData.setLastModified(System.currentTimeMillis());
            infoHash = this.getSimpleHashFromMetaData(assetMetaData, staticEscape, ps.read);
        } else if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
            connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
            assetMetaData = imagebuilder.getImageMetaData(connector, assetURLPath, readFlag, true, session);
            infoHash = this.getSimpleHashFromMetaData(assetMetaData, staticEscape, ps.read);
        } else {
            connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
            Path eisFile = this.storageHelper.getRealEisFile(assetURLPath, this.settings.getFileLockHandler());
            if (Files.exists(eisFile, new LinkOption[0])) {
                short importStatus;
                assetMetaData = imagebuilder.getImageMetaData(connector, assetURLPath, readFlag, true, session);
                if (!this.noredirect && assetMetaData instanceof ImageMetaData && ((importStatus = (short)((ImageMetaData)assetMetaData).getImportStatus()) == 3 || importStatus == 2 || importStatus == 5)) {
                    this.createFallbackResponse(assetURLPath, parameters, importStatus, response);
                    return response;
                }
            } else if (this.isURLPathDirectory(assetURLPath, session)) {
                PathCached sourceFile = connector.getSourceFileFromAssetURLPath(assetURLPath);
                assetMetaData = imagebuilder.getDirectoryMetaData(connector, assetURLPath, sourceFile, readFlag);
            } else {
                assetMetaData = null;
            }
            infoHash = this.getSimpleHashFromMetaData(assetMetaData, staticEscape, ps.read);
            if (connector != null && assetURLPath.equals(connector.getPrefix())) {
                SourceManagerSettings is;
                SourceConnectorReader iprofile;
                infoHash.put("connectortype", (Object)connector.getMountType().name());
                Object importer = this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
                if (importer != null && (iprofile = (is = ((MainManager)importer).getSourceManagerSettings()).getSourceConnector(connector.getPrefix())) != null) {
                    infoHash.put("connectorTotalContent", (Object)iprofile.getCurrentImageCount());
                }
            }
        }
        if (ps.read.basicMetadata.booleanValue() || assetURLPath.equals("_trash")) {
            response.setDateHeader("Last-Modified", assetMetaData.getLastModified());
        }
        if (assetMetaData instanceof ImageMetaData && ((ImageMetaData)assetMetaData).getImportStatus() != 1) {
            response.setDateHeader("Expires", 1000L);
            response.setHeader("Pragma", "no-cache, no-store");
            response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
        }
        templateData.put("info", (Object)infoHash);
        templateData.put("entityFixer", (Object)new FreemarkerEntityFixer());
        try (StringWriterFast sw = new StringWriterFast();){
            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
            env.process();
            String eTagModifier = String.valueOf(assetMetaData.hashCode()) + template.getCustomAttribute("checksum");
            response.setETagModifier(eTagModifier);
            response.setBody(sw.toString());
        }
        response.setStatus(200);
        return response;
    }

    private RendererTextResponse handleMultiSource(String multiSource, HttpSession session, ImageBuilder imagebuilder, Template template, SimpleHash templateData, int readFlag) throws IOException, TemplateException, NotConfiguredException {
        String[] sources = multiSource.split(",", 2);
        SourceConnectorReader[] connectors = new SourceConnectorReader[sources.length];
        PermissionSet.Read[] readPermissions = new PermissionSet.Read[sources.length];
        HashMap<String, PermissionSet> cachedPermissions = new HashMap<String, PermissionSet>();
        for (int s = 0; s < sources.length; ++s) {
            String assetURLPath = URL.cleanUpSourceParameter(sources[s]);
            connectors[s] = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            PermissionSet ps = (PermissionSet)cachedPermissions.get(connectors[s].getPrefix());
            if (ps == null) {
                ps = this.settings.getUserAuthenticationInterface().getPermissions(connectors[s], session, true);
                cachedPermissions.put(connectors[s].getPrefix(), ps);
            }
            if (ps == null) {
                return StandardInfoRenderer.generateNotAuthorizedResponse();
            }
            readPermissions[s] = ps.read;
        }
        long lastModified = 0L;
        boolean finished = true;
        MetaData[] metaData = new MetaData[sources.length];
        for (int s = 0; s < sources.length; ++s) {
            metaData[s] = imagebuilder.getImageMetaData(connectors[s], sources[s], readFlag, true, session);
            lastModified = Math.max(lastModified, metaData[s].getLastModified());
            if (!(metaData[s] instanceof ImageMetaData) || ((ImageMetaData)metaData[s]).getImportStatus() == 1) continue;
            finished = false;
        }
        templateData.put("info", (Object)this.getMultiHashFromMetaData(metaData, readPermissions));
        templateData.put("entityFixer", (Object)new FreemarkerEntityFixer());
        RendererTextResponse response = new RendererTextResponse();
        response.setDateHeader("Last-Modified", lastModified);
        if (!finished) {
            response.setDateHeader("Expires", 1000L);
            response.setHeader("Pragma", "no-cache, no-store");
            response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
        }
        try (StringWriterFast sw = new StringWriterFast();){
            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
            env.process();
            sw.close();
            response.setBody(sw.toString());
        }
        response.setStatus(200);
        return response;
    }

    private SimpleHash getMultiHashFromMetaData(MetaData[] metadata, PermissionSet.Read[] readPermissions) {
        boolean invalid = false;
        SimpleHash entry = new SimpleHash();
        entry.put("type", (Object)"file");
        if (metadata[0] instanceof ImageMetaData) {
            ImageMetaData imd0 = (ImageMetaData)metadata[0];
            int width = imd0.getWidth();
            int height = imd0.getHeight();
            boolean alpha = imd0.hasAlpha();
            long lastModified = imd0.getLastModified();
            short status = imd0.getImportStatus();
            ICCProfileWrap ipw = imd0.getICC();
            String icc_name = ipw != null ? ipw.getName() : null;
            for (int m = 1; m < metadata.length; ++m) {
                ImageMetaData imdM;
                if (metadata[m] instanceof ImageMetaData) {
                    imdM = (ImageMetaData)metadata[m];
                    if (imdM.getWidth() != width) {
                        invalid = true;
                        break;
                    }
                    if (imdM.getHeight() != height) {
                        invalid = true;
                        break;
                    }
                    alpha |= imdM.hasAlpha();
                } else {
                    invalid = true;
                    break;
                }
                lastModified = Math.max(lastModified, imdM.getLastModified());
            }
            if (width > 0) {
                entry.put("width", (Object)width);
            }
            if (height > 0) {
                entry.put("height", (Object)height);
            }
            if (icc_name != null) {
                entry.put("icc", (Object)icc_name);
            }
            entry.put("alpha", (Object)Boolean.toString(alpha));
            entry.put("lastmodified", (Object)lastModified);
            entry.put("importstatus", (Object)status);
        } else {
            invalid = true;
        }
        if (invalid) {
            entry = null;
        }
        return entry;
    }
}

