/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobComparator;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntryComparator;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.cache.CacheableArrayList;
import com.neptunelabs.fsiserver.utils.comparators.PoolDirectoryEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.utils.URL;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class StandardListRenderer
extends RendererAbstract {
    private PoolEntrySortingField defaultSortField;
    private SortDirection defaultSortOrder;
    private SortMethod defaultSortMethod;
    private String defaultSortLanguage = null;
    private String defaultSortCountry = null;
    private boolean defaultSortCaseSensitive = false;
    private PoolEntrySortingField forceSortField = null;
    private SortDirection forceSortOrder = null;
    private SortMethod forceSortMethod = null;
    private String forceSortLanguage = null;
    private String forceSortCountry = null;
    private boolean forceSortCaseSensitiveSet = false;
    private boolean forceSortCaseSensitive = false;
    private final ImageBuilder standardImagebuilder;
    private final CacheManager cacheManager;

    public StandardListRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
        this.standardImagebuilder = settings.getImageBuilder();
        this.defaultSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        this.defaultSortOrder = RendererEnvironment.DEFAULT_SORT_ORDER;
        this.defaultSortMethod = RendererEnvironment.DEFAULT_SORT_METHOD;
        this.defaultSortLanguage = this.environment.getDefaultSortLanguage();
        this.defaultSortCountry = this.environment.getDefaultSortCountry();
        this.defaultSortCaseSensitive = false;
        this.cacheManager = settings.getCacheManager();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        HttpSession session = req.getSession(false);
        if (parameters.getAssetURLPath() == null) {
            return StandardListRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.LIST) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererResponse result = this.processListRequest(this.standardImagebuilder, parameters, metadata, session);
        return result;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("defaultSortField");
        result.add("forceSortField");
        result.add("defaultSortOrder");
        result.add("forceSortOrder");
        result.add("defaultSortMethod");
        result.add("forceSortMethod");
        result.add("defaultSortLanguage");
        result.add("forceSortLanguage");
        result.add("defaultSortCountry");
        result.add("forceSortCountry");
        result.add("defaultSortCaseSensitive");
        result.add("forceSortCaseSensitive");
        return result;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("defaultsortfield") && this.defaultSortField != null) {
            result = this.defaultSortField.name();
        } else if (name.equalsIgnoreCase("forcesortfield") && this.forceSortField != null) {
            result = this.forceSortField.name();
        } else if (name.equalsIgnoreCase("defaultsortorder") && this.defaultSortOrder != null) {
            result = this.defaultSortOrder.name();
        } else if (name.equalsIgnoreCase("forcesortorder") && this.forceSortOrder != null) {
            result = this.forceSortOrder.name();
        } else if (name.equalsIgnoreCase("defaultsortmethod") && this.defaultSortMethod != null) {
            result = this.defaultSortMethod.name();
        } else if (name.equalsIgnoreCase("forcesortmethod") && this.forceSortMethod != null) {
            result = this.forceSortMethod.name();
        } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
            result = this.defaultSortLanguage;
        } else if (name.equalsIgnoreCase("forcesortlanguage")) {
            result = this.forceSortLanguage;
        } else if (name.equalsIgnoreCase("defaultsortcountry")) {
            result = this.defaultSortCountry;
        } else if (name.equalsIgnoreCase("forcesortcountry")) {
            result = this.forceSortCountry;
        } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
            result = Boolean.toString(this.defaultSortCaseSensitive);
        } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
            result = Boolean.toString(this.forceSortCaseSensitive);
        }
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        try {
            if (name.equalsIgnoreCase("defaultsortfield")) {
                this.defaultSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortfield")) {
                this.forceSortField = PoolEntrySortingField.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortorder")) {
                this.defaultSortOrder = SortDirection.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortorder")) {
                this.forceSortOrder = SortDirection.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortmethod")) {
                this.defaultSortMethod = SortMethod.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("forcesortmethod")) {
                this.forceSortMethod = SortMethod.valueOf(value.toUpperCase());
            } else if (name.equalsIgnoreCase("defaultsortlanguage")) {
                this.defaultSortLanguage = value.toLowerCase();
            } else if (name.equalsIgnoreCase("forcesortlanguage")) {
                this.forceSortLanguage = value.toLowerCase();
            } else if (name.equalsIgnoreCase("defaultsortcountry")) {
                this.defaultSortCountry = value.toUpperCase();
            } else if (name.equalsIgnoreCase("forcesortcountry")) {
                this.forceSortCountry = value.toUpperCase();
            } else if (name.equalsIgnoreCase("defaultsortcasesensitive")) {
                this.defaultSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
            } else if (name.equalsIgnoreCase("forcesortcasesensitive")) {
                this.forceSortCaseSensitive = Boolean.valueOf(value.toLowerCase());
                this.forceSortCaseSensitiveSet = true;
            }
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(2035, this.rendererName + ".xml", value, name);
        }
    }

    private RendererResponse processListRequest(ImageBuilder imagebuilder, Parameters parameters, Map<String, Object> metadata, HttpSession session) {
        RendererTextResponse response;
        try {
            Template template = this.determineListTemplate(parameters);
            TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
            String staticTypeFilter = templateAttrs.getStaticTypeFilter();
            Escaper.EscaperType staticEscape = templateAttrs.getStaticEscape();
            if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
                response = StandardListRenderer.generateNotAuthorizedResponse();
            } else {
                SimpleHash templateData = new SimpleHash();
                templateData.put("query", (Object)parameters);
                String assetURLPath = parameters.getAssetURLPath();
                if (assetURLPath.equals("/")) {
                    response = this.processRootListRequest(imagebuilder, parameters, session, template, staticEscape, templateData);
                } else if (assetURLPath.equals("_trash")) {
                    response = this.processTrashListRequest(imagebuilder, parameters, session, template, staticEscape, templateData);
                    response.setCacheable(false);
                } else if (assetURLPath.equals("_downloads")) {
                    response = this.processDownloadsListRequest(parameters, session, template, templateData);
                    response.setCacheable(false);
                } else {
                    response = StandardListRenderer.multiSources(parameters.get(Parameters.General.source)) ? this.processMultiListRequest(imagebuilder, parameters, session, template, staticTypeFilter, staticEscape, templateData, parameters.get(Parameters.General.source)) : this.processNormalListRequest(imagebuilder, parameters, session, template, staticTypeFilter, staticEscape, templateData, assetURLPath);
                }
                templateAttrs.setRendererResponseContentType(response);
            }
        }
        catch (NoSuchFileException e) {
            response = StandardListRenderer.generateNotFoundResponse();
        }
        catch (NotConfiguredException e) {
            response = StandardListRenderer.generateUnavailableResponse();
        }
        catch (IOException e) {
            response = StandardListRenderer.generateErrorResponse();
            this.settings.getFSILogger().logException(e, 3158, e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            response = StandardListRenderer.generateErrorResponse();
            this.settings.getFSILogger().logException((Exception)((Object)e), 3158, e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            response = StandardListRenderer.generateErrorResponse();
        }
        return response;
    }

    private RendererTextResponse processNormalListRequest(ImageBuilder imagebuilder, Parameters parameters, HttpSession session, Template template, String staticTypeFilter, Escaper.EscaperType staticEscape, SimpleHash templateData, String assetURLPath) throws NoSuchFileException, IOException, TemplateException, NotConfiguredException {
        long t0 = System.currentTimeMillis();
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
        if (connector == null) {
            return StandardListRenderer.generateNotAuthorizedResponse();
        }
        PermissionSet permissions = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
        if (permissions == null || !permissions.list.files.booleanValue() && !permissions.list.directories.booleanValue()) {
            return StandardListRenderer.generateNotAuthorizedResponse();
        }
        templateData.put("currentDir", (Object)StandardListRenderer.escapeString(assetURLPath + "/", staticEscape));
        int offset = 0;
        int count = -1;
        if (parameters.contains(Parameters.List.limit)) {
            try {
                String limitval = parameters.get(Parameters.List.limit);
                String[] values = limitval.split(",", 2);
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException limitval) {
                // empty catch block
            }
        }
        ArrayList<String> typefilter = new ArrayList<String>();
        boolean typefilterset = this.setTypeFilters(parameters, staticTypeFilter, typefilter);
        int imageCount = 0;
        int dirCount = 0;
        boolean completeCount = false;
        SortDirection sortOrder = this.determineSortOrder(parameters);
        FSIStringComparator comparator = this.determineSortComparator(parameters, sortOrder);
        PoolEntrySortingField usedSortField = this.determineSortField(parameters);
        PoolFileEntryComparator pfec = new PoolFileEntryComparator(usedSortField, comparator, sortOrder);
        PoolDirectoryEntryComparator pdec = new PoolDirectoryEntryComparator(usedSortField, comparator, sortOrder);
        Set<String> itemsSet = this.evaluateItemsParameter(parameters);
        PoolList pl = null;
        long t1 = System.currentTimeMillis();
        pl = imagebuilder.getPoolList(connector, assetURLPath, session);
        long t2 = System.currentTimeMillis();
        RendererTextResponse response = new RendererTextResponse();
        long lmdate = 0L;
        if (pl != null) {
            lmdate = pl.lastmodified;
            response.setDateHeader("Last-Modified", lmdate);
        }
        boolean useCache = !assetURLPath.startsWith("_configs") && !assetURLPath.startsWith("_viewers");
        List<Object> imageList = null;
        if (pl != null && permissions.list.files.booleanValue() && (!typefilterset || typefilterset && typefilter.contains("file"))) {
            CacheLoad cl;
            CacheKey cacheKey = null;
            if (useCache && (cl = this.cacheManager.get(cacheKey = CacheKey.getInstance(assetURLPath, 'D', "sortedImageList:" + lmdate + "_" + (Object)((Object)sortOrder) + "_" + (Object)((Object)usedSortField) + (itemsSet != null ? parameters.get(Parameters.List.items) : "")), CacheType.LIST)) != null) {
                imageList = cl.requestedL1Object != null ? (CacheableArrayList)cl.requestedL1Object : CacheableArrayList.unpack(cl.data);
            }
            if (imageList == null) {
                imageList = pl.getFilesAsList();
                if (!(imageList = this.applyItemsFilterToPoolFileEntryList(imageList, itemsSet)).isEmpty()) {
                    this.sortingPoolList(imageList, usedSortField, comparator, sortOrder);
                    if (useCache) {
                        this.cacheManager.put(cacheKey, new CacheableArrayList<PoolFileEntry>((Collection<PoolFileEntry>)imageList), true);
                    }
                }
            }
            imageCount = imageList.size();
        }
        long t3 = System.currentTimeMillis();
        List<Object> directoryList = null;
        if (permissions.list.directories.booleanValue() && (!typefilterset || typefilterset && typefilter.contains("directory"))) {
            CacheLoad cl;
            CacheKey cacheKey = null;
            if (useCache && (cl = this.cacheManager.get(cacheKey = CacheKey.getInstance(assetURLPath, 'D', "sortedDirList:" + lmdate + "_" + (Object)((Object)sortOrder) + "_" + (Object)((Object)usedSortField) + (itemsSet != null ? parameters.get(Parameters.List.items) : "")), CacheType.LIST)) != null) {
                directoryList = cl.requestedL1Object != null ? (CacheableArrayList)cl.requestedL1Object : CacheableArrayList.unpack(cl.data);
            }
            if (directoryList == null && pl != null && !(directoryList = pl.getDirectoriesAsList()).isEmpty()) {
                Collections.sort(directoryList, pdec);
                if (useCache) {
                    this.cacheManager.put(cacheKey, new CacheableArrayList<PoolDirectoryEntry>((Collection<PoolDirectoryEntry>)directoryList), true);
                }
            }
            if (directoryList != null) {
                dirCount = directoryList.size();
            }
        }
        long t4 = System.currentTimeMillis();
        SimpleHash summary = new SimpleHash();
        summary.put("entryCount", (Object)(imageCount + dirCount));
        summary.put("imageCount", (Object)imageCount);
        summary.put("directoryCount", (Object)dirCount);
        summary.put("completeCount", (Object)0);
        summary.put("lastModified", (Object)lmdate);
        summary.put("connectorType", (Object)connector.getMountType());
        templateData.put("summary", (Object)summary);
        offset = this.ensureValidListOffset(offset, imageCount + dirCount);
        if (count < 0) {
            count = imageCount + dirCount - offset;
        }
        RangeDefinition rangedef = new RangeDefinition(offset, count, dirCount, imageCount);
        if (parameters.contains(Parameters.List.range)) {
            this.applyListRangeParameter(pfec, pdec, parameters.get(Parameters.List.range), directoryList, imageList, rangedef);
        }
        long t5 = System.currentTimeMillis();
        StringBuilder eTagModifier = new StringBuilder();
        eTagModifier.append(template.getCustomAttribute("checksum"));
        eTagModifier.append(assetURLPath);
        eTagModifier.append(lmdate);
        eTagModifier.append((Object)sortOrder);
        eTagModifier.append((Object)usedSortField);
        eTagModifier.append(comparator);
        SimpleSequence finallist = this.buildFinalList(directoryList, imageList, rangedef, staticEscape, assetURLPath, session, false, eTagModifier);
        templateData.put("ilist", (Object)finallist);
        this.renderTemplate(template, templateData, response);
        long t6 = System.currentTimeMillis();
        this.settings.getFSILogger().log(3001, t1 - t0, t2 - t1, t3 - t2, t4 - t3, t5 - t4, t6 - t5);
        response.setETagModifier(eTagModifier.toString());
        response.setStatus(200);
        return response;
    }

    private Set<String> evaluateItemsParameter(Parameters parameters) {
        HashSet<String> itemsSet = null;
        if (parameters.contains(Parameters.List.items)) {
            String[] items;
            itemsSet = new HashSet<String>();
            for (String item : items = parameters.get(Parameters.List.items).split(",")) {
                itemsSet.add(item);
            }
        }
        return itemsSet;
    }

    private List<PoolFileEntry> applyItemsFilterToPoolFileEntryList(List<PoolFileEntry> poolEntryList, Set<String> itemsSet) {
        if (itemsSet != null) {
            ArrayList<PoolFileEntry> filteredList = new ArrayList<PoolFileEntry>();
            for (PoolFileEntry pe : poolEntryList) {
                if (!itemsSet.contains(pe.name)) continue;
                filteredList.add(pe);
            }
            return filteredList;
        }
        return poolEntryList;
    }

    private List<PoolDirectoryEntry> applyItemsFilterToPoolDirectoryEntryList(List<PoolDirectoryEntry> poolEntryList, Set<String> itemsSet) {
        if (itemsSet != null) {
            ArrayList<PoolDirectoryEntry> filteredList = new ArrayList<PoolDirectoryEntry>();
            for (PoolDirectoryEntry pe : poolEntryList) {
                if (!itemsSet.contains(pe.name)) continue;
                filteredList.add(pe);
            }
            return filteredList;
        }
        return poolEntryList;
    }

    private PoolEntrySortingField determineSortField(Parameters parameters) throws IOException {
        PoolEntrySortingField usedSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        if (this.forceSortField != null) {
            usedSortField = this.forceSortField;
        } else if (parameters.contains(Parameters.Sorting.sortfield) && parameters.get(Parameters.Sorting.sortfield).trim().length() > 0) {
            try {
                usedSortField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.sortfield).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sort field");
            }
        } else {
            usedSortField = this.defaultSortField;
        }
        return usedSortField;
    }

    private void renderTemplate(Template template, SimpleHash templateData, RendererTextResponse response) throws IOException, TemplateException {
        try (StringWriterFast sw = new StringWriterFast();){
            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
            env.process();
            response.setBody(sw.toString());
        }
    }

    private RendererTextResponse processMultiListRequest(ImageBuilder imagebuilder, Parameters parameters, HttpSession session, Template template, String staticTypeFilter, Escaper.EscaperType staticEscape, SimpleHash templateData, String multiSource) throws NoSuchFileException, IOException, TemplateException, NotConfiguredException {
        String[] assetURLPaths = multiSource.split(",", 2);
        PermissionSet[] permissionSets = new PermissionSet[assetURLPaths.length];
        for (int i = 0; i < assetURLPaths.length; ++i) {
            String assetURLPath = URL.cleanUpSourceParameter(assetURLPaths[i], "/");
            PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(assetURLPath, session, true);
            if (ps == null || !ps.list.files.booleanValue() && !ps.list.directories.booleanValue()) {
                return StandardListRenderer.generateNotAuthorizedResponse();
            }
            permissionSets[i] = ps;
        }
        long lastModified = 0L;
        List[] imageLists = new List[assetURLPaths.length];
        List[] directoryLists = new List[assetURLPaths.length];
        RangeDefinition[] rangeDefs = new RangeDefinition[assetURLPaths.length];
        SortDirection sortOrder = this.determineSortOrder(parameters);
        FSIStringComparator comparator = this.determineSortComparator(parameters, sortOrder);
        PoolEntrySortingField usedSortField = this.determineSortField(parameters);
        PoolFileEntryComparator pfec = new PoolFileEntryComparator(usedSortField, comparator, sortOrder);
        PoolDirectoryEntryComparator pdec = new PoolDirectoryEntryComparator(usedSortField, comparator, sortOrder);
        ArrayList<String> typefilter = new ArrayList<String>();
        boolean typefilterset = this.setTypeFilters(parameters, staticTypeFilter, typefilter);
        for (int s = 0; s < assetURLPaths.length; ++s) {
            String assetURLPath = URL.cleanUpSourceParameter(assetURLPaths[s], "/");
            templateData.put("currentDir" + (s + 1), (Object)StandardListRenderer.escapeString(assetURLPath, staticEscape));
            PermissionSet ps = permissionSets[s];
            SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            PoolList list = imagebuilder.getPoolList(importerProfile, assetURLPath, session);
            if (list != null) {
                lastModified = Math.max(lastModified, list.lastmodified);
            }
            int offset = 0;
            int count = -1;
            if (parameters.contains(Parameters.List.limit)) {
                try {
                    String limitval = parameters.get(Parameters.List.limit);
                    String[] values = limitval.split(",");
                    if (values.length == 1) {
                        count = Integer.parseInt(values[0]);
                    } else if (values.length == 2) {
                        count = Integer.parseInt(values[1]);
                        offset = Integer.parseInt(values[0]);
                    }
                }
                catch (NumberFormatException limitval) {
                    // empty catch block
                }
            }
            int imageCount = 0;
            int dirCount = 0;
            boolean completeCount = false;
            PoolList pl = imagebuilder.getPoolList(importerProfile, assetURLPath, session);
            if (ps.list.files.booleanValue() && (!typefilterset || typefilterset && typefilter.contains("file"))) {
                imageLists[s] = pl.getFilesAsList();
                if (!imageLists[s].isEmpty()) {
                    this.sortingPoolList(imageLists[s], usedSortField, comparator, sortOrder);
                }
                imageCount = pl.getFileCount();
            }
            if (ps.list.directories.booleanValue() && (!typefilterset || typefilterset && typefilter.contains("directory"))) {
                List<String> dirnames = pl.getDirectoryNamesAsList();
                directoryLists[s] = new ArrayList();
                for (String dirname : dirnames) {
                    PoolListSummary pls = imagebuilder.getPoolListSummary(importerProfile, assetURLPath + dirname, session);
                    PoolDirectoryEntry directoryEntry = new PoolDirectoryEntry(dirname, pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount());
                    directoryLists[s].add(directoryEntry);
                }
                if (!directoryLists[s].isEmpty()) {
                    Collections.sort(directoryLists[s], pdec);
                }
                dirCount = pl.getDirectoryCount();
            }
            SimpleHash summary = new SimpleHash();
            summary.put("entryCount", (Object)(imageCount + dirCount));
            summary.put("imageCount", (Object)imageCount);
            summary.put("directoryCount", (Object)dirCount);
            summary.put("completeCount", (Object)0);
            if (list != null) {
                summary.put("lastModified", (Object)list.lastmodified);
            }
            templateData.put("summary" + (s + 1), (Object)summary);
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            if (connector == null) {
                throw new NoSuchFileException(assetURLPath);
            }
            offset = this.ensureValidListOffset(offset, imageCount + dirCount);
            if (count < 0) {
                count = imageCount + dirCount - offset;
            }
            rangeDefs[s] = new RangeDefinition(offset, count, dirCount, imageCount);
            if (!parameters.contains(Parameters.List.range)) continue;
            this.applyListRangeParameter(pfec, pdec, parameters.get(Parameters.List.range), directoryLists[s], imageLists[s], rangeDefs[s]);
        }
        boolean diff = false;
        if (directoryLists[0] != null) {
            int dlen = directoryLists[0].size();
            for (int n = 1; n < directoryLists.length; ++n) {
                if (directoryLists[n].size() == dlen) continue;
                diff = true;
                break;
            }
        }
        if (imageLists[0] != null) {
            int flen = imageLists[0].size();
            for (int n = 1; n < imageLists.length; ++n) {
                if (imageLists[n].size() == flen) continue;
                diff = true;
                break;
            }
        }
        if (diff) {
            throw new IOException("Different source directory counts");
        }
        SimpleSequence finallist = this.buildFinalMultiList(directoryLists, imageLists, rangeDefs, staticEscape, imagebuilder, assetURLPaths, session);
        templateData.put("ilist", (Object)finallist);
        RendererTextResponse response = new RendererTextResponse();
        this.renderTemplate(template, templateData, response);
        response.setDateHeader("Last-Modified", lastModified);
        response.setStatus(200);
        return response;
    }

    private SimpleHash getSimpleHashFromDownloadJob(DownloadJob job) {
        StringBuilder eTagModifier = new StringBuilder();
        SimpleHash sh = new SimpleHash();
        sh.put("src", (Object)job.getID());
        eTagModifier.append(job.getID());
        sh.put("fileName", (Object)job.getName());
        sh.put("size", (Object)job.getArchiveSize());
        sh.put("status", (Object)job.getStatus().ordinal());
        eTagModifier.append(job.getStatus().ordinal());
        sh.put("createdBy", (Object)job.getUser());
        sh.put("creationDate", (Object)job.getCreationTime());
        sh.put("lastmodified", (Object)job.getLastModified());
        eTagModifier.append(job.getLastModified());
        if (job.getScheduledStart() > 0L) {
            sh.put("scheduleDate", (Object)job.getScheduledStart());
        }
        if (job.getStartTime() > 0L) {
            sh.put("startDate", (Object)job.getStartTime());
        }
        int progress = 0;
        if (job.getStatus() == DownloadJob.JobState.COMPLETE) {
            sh.put("duration", (Object)(job.getFinishedTime() - job.getStartTime()));
            progress = 100;
        } else {
            progress = job.getProgressCount() * 100 / job.getFileCount();
            if (job.getStatus() == DownloadJob.JobState.QUEUED && job.getQueuePos() > 0) {
                sh.put("queuePos", (Object)job.getQueuePos());
            }
        }
        sh.put("progress", (Object)progress);
        eTagModifier.append(progress);
        sh.put("eTagModificationHash", (Object)eTagModifier.toString());
        return sh;
    }

    private RendererTextResponse processDownloadsListRequest(Parameters parameters, HttpSession session, Template template, SimpleHash templateData) throws NoSuchFileException, IOException, TemplateException, NotConfiguredException {
        String sortfield;
        List<DownloadJob> jobs = this.getDownloadsList(session);
        if (parameters.contains(Parameters.List.items)) {
            ArrayList<DownloadJob> filteredJobs = new ArrayList<DownloadJob>();
            String items = parameters.get(Parameters.List.items);
            HashSet<String> itemsSet = new HashSet<String>();
            for (String item : items.split(",")) {
                itemsSet.add(item);
            }
            for (DownloadJob job : jobs) {
                if (!itemsSet.contains(job.getID())) continue;
                filteredJobs.add(job);
            }
            jobs = filteredJobs;
        }
        if ((sortfield = parameters.get(Parameters.Sorting.sortfield)) != null) {
            SortDirection sortOrder = this.determineSortOrder(parameters);
            FSIStringComparator stringComparator = this.determineSortComparator(parameters, sortOrder);
            DownloadJobComparator downloadJobComparator = new DownloadJobComparator(sortfield, sortOrder, stringComparator);
            Collections.sort(jobs, downloadJobComparator);
        }
        SimpleSequence sequence = new SimpleSequence();
        int idCounter = 0;
        Path downloadsFolder = this.storageHelper.getDownloadsFolder();
        long lmdate = FileOperations.getSafeLastModified(downloadsFolder);
        StringBuilder eTagModifier = new StringBuilder();
        Pair<Integer, Integer> limitParam = this.parseLimitParameter(parameters);
        int offset = limitParam.getItem1();
        int count = limitParam.getItem2();
        int i = 0;
        for (DownloadJob job : jobs) {
            SimpleHash sh;
            if (job.getLastModified() > lmdate) {
                lmdate = job.getLastModified();
            }
            if (count >= 0) {
                if (i >= offset && i < offset + count) {
                    sh = this.getSimpleHashFromDownloadJob(job);
                    eTagModifier.append(sh.get("eTagModificationHash"));
                    sh.put("id", (Object)idCounter++);
                    sequence.add((Object)sh);
                }
            } else {
                sh = this.getSimpleHashFromDownloadJob(job);
                eTagModifier.append(sh.get("eTagModificationHash"));
                sh.put("id", (Object)idCounter++);
                sequence.add((Object)sh);
            }
            ++i;
        }
        eTagModifier.append(lmdate);
        templateData.put("currentDir", (Object)"_downloads/");
        SimpleHash summary = new SimpleHash();
        summary.put("entryCount", (Object)sequence.size());
        summary.put("imageCount", (Object)sequence.size());
        summary.put("directoryCount", (Object)0);
        summary.put("completeCount", (Object)sequence.size());
        summary.put("lastModified", (Object)lmdate);
        summary.put("connectorType", (Object)"DOWNLOAD");
        templateData.put("summary", (Object)summary);
        SimpleHash restrictions = new SimpleHash();
        restrictions.put("readOnly", (Object)"false");
        restrictions.put("writeEnabled", (Object)"false");
        restrictions.put("downloadOrigin", (Object)"true");
        restrictions.put("publicFileAccess", (Object)"false");
        restrictions.put("publicFileMetaAccess", (Object)"false");
        restrictions.put("publicFileListAccess", (Object)"false");
        restrictions.put("publicDirListAccess", (Object)"false");
        templateData.put("restrictions", (Object)restrictions);
        templateData.put("ilist", (Object)sequence);
        RendererTextResponse response = new RendererTextResponse();
        this.renderTemplate(template, templateData, response);
        response.setETagModifier(eTagModifier.toString());
        response.setDateHeader("Last-Modified", lmdate);
        response.setStatus(200);
        return response;
    }

    private RendererTextResponse processTrashListRequest(ImageBuilder imagebuilder, Parameters parameters, HttpSession session, Template template, Escaper.EscaperType staticEscape, SimpleHash templateData) throws NoSuchFileException, IOException, TemplateException, NotConfiguredException {
        List<TrashListEntry> trashEntries = this.getTrashList(session);
        long trashLMDate = this.getTrashLastModified(session, imagebuilder);
        Pair<Integer, Integer> limitParam = this.parseLimitParameter(parameters);
        int offset = limitParam.getItem1();
        int count = limitParam.getItem2();
        SortDirection sortOrder = this.determineSortOrder(parameters);
        FSIStringComparator stringComparator = this.determineSortComparator(parameters, sortOrder);
        TrashListEntryComparator comparator = new TrashListEntryComparator(parameters.get(Parameters.Sorting.sortfield), stringComparator, sortOrder);
        Collections.sort(trashEntries, comparator);
        int entryCount = trashEntries.size();
        offset = this.ensureValidListOffset(offset, entryCount);
        SimpleHash summary = new SimpleHash();
        summary.put("entryCount", (Object)entryCount);
        summary.put("imageCount", (Object)entryCount);
        summary.put("directoryCount", (Object)0);
        summary.put("completeCount", (Object)entryCount);
        summary.put("lastModified", (Object)trashLMDate);
        templateData.put("summary", (Object)summary);
        templateData.put("currentDir", (Object)"_trash/");
        RangeDefinition rangedef = new RangeDefinition(offset, count, 0, entryCount);
        StringBuilder eTagModifier = new StringBuilder();
        SimpleSequence finallist = this.buildTrashList(trashEntries, rangedef, staticEscape, eTagModifier);
        templateData.put("ilist", (Object)finallist);
        StringWriter sw = new StringWriter();
        Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
        env.process();
        sw.flush();
        RendererTextResponse response = new RendererTextResponse();
        response.setBody(sw.toString());
        response.setStatus(200);
        response.setETagModifier(eTagModifier.toString());
        return response;
    }

    private Pair<Integer, Integer> parseLimitParameter(Parameters parameters) {
        int offset = 0;
        int count = -1;
        if (parameters.contains(Parameters.List.limit)) {
            try {
                String limitval = parameters.get(Parameters.List.limit);
                String[] values = limitval.split(",");
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Pair<Integer, Integer>(offset, count);
    }

    private SimpleSequence buildTrashList(List<TrashListEntry> trashEntries, RangeDefinition rangedef, Escaper.EscaperType staticEscape, StringBuilder eTagModifier) {
        SimpleSequence finallist = new SimpleSequence();
        int pos = 0;
        if (rangedef.startFiles >= 0) {
            for (int p = rangedef.startFiles; p < rangedef.stopFiles; ++p) {
                TrashListEntry tle = trashEntries.get(p);
                SimpleHash entry = new SimpleHash();
                entry.put("id", (Object)pos++);
                entry.put("src", (Object)StandardListRenderer.escapeString("_trash/" + tle.profilePrefix + "/" + tle.trashID, staticEscape));
                entry.put("sourcePath", (Object)StandardListRenderer.escapeString(tle.originalDir, staticEscape));
                entry.put("fileName", (Object)StandardListRenderer.escapeString(tle.originalFilename, staticEscape));
                entry.put("lastmodified", (Object)tle.originalLMDate);
                entry.put("deletionDate", (Object)tle.deletedDate);
                entry.put("size", (Object)tle.sourceFileSize);
                finallist.add((Object)entry);
                eTagModifier.append(tle.originalDir);
                eTagModifier.append(tle.originalLMDate);
                eTagModifier.append(tle.deletedDate);
            }
        }
        return finallist;
    }

    private RendererTextResponse processRootListRequest(ImageBuilder imagebuilder, Parameters parameters, HttpSession session, Template template, Escaper.EscaperType staticEscape, SimpleHash templateData) throws NoSuchFileException, IOException, TemplateException, NotConfiguredException {
        PermissionSet downloadsPermissions;
        templateData.put("currentDir", (Object)"/");
        PoolList list = imagebuilder.getPoolList(null, "/", session);
        if (list == null) {
            throw new NoSuchFileException("/");
        }
        long lmdate = list.lastmodified;
        int offset = 0;
        int count = -1;
        if (parameters.contains(Parameters.List.limit)) {
            try {
                String limitval = parameters.get(Parameters.List.limit);
                String[] values = limitval.split(",");
                if (values.length == 1) {
                    count = Integer.parseInt(values[0]);
                } else if (values.length == 2) {
                    count = Integer.parseInt(values[1]);
                    offset = Integer.parseInt(values[0]);
                }
            }
            catch (NumberFormatException limitval) {
                // empty catch block
            }
        }
        SortDirection sortOrder = this.determineSortOrder(parameters);
        FSIStringComparator stringComparator = this.determineSortComparator(parameters, sortOrder);
        PoolEntrySortingField usedSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        if (this.forceSortField != null) {
            usedSortField = this.forceSortField;
        } else if (parameters.contains(Parameters.Sorting.sortfield)) {
            try {
                usedSortField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.sortfield).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Illegal sort field");
            }
        } else {
            usedSortField = this.defaultSortField;
        }
        boolean imageCount = false;
        int dirCount = 0;
        boolean completeCount = false;
        List<PoolFileEntry> imageList = null;
        Set<String> directoryNames = list.getDirectoryNameSet();
        List<PoolDirectoryEntry> directoryList = new ArrayList<PoolDirectoryEntry>();
        boolean showTrashConnector = false;
        boolean downloadConnectorAdded = false;
        try {
            for (String dirname : directoryNames) {
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath("/" + dirname);
                if (connector == null || !connector.isEnabled()) continue;
                if ("_downloads".equals(connector.getPrefix())) {
                    PoolDirectoryEntry directoryEntry = new PoolDirectoryEntry(dirname, Files.getLastModifiedTime(this.storageHelper.getDownloadsFolder(), new LinkOption[0]).toMillis(), -1L, -1L);
                    directoryList.add(directoryEntry);
                    downloadConnectorAdded = true;
                    continue;
                }
                PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (ps == null || !ps.list.connector.booleanValue()) continue;
                try {
                    PoolListSummary pls = imagebuilder.getPoolListSummary(connector, "/" + dirname, session);
                    long lm = ps.read.basicMetadata != false ? pls.lastmodified : 0L;
                    long fileCount = ps.read.basicMetadata != false ? pls.getFileCount() : 0L;
                    long directoryCount = ps.read.basicMetadata != false ? pls.getDirectoryCount() : 0L;
                    PoolDirectoryEntry directoryEntry = new PoolDirectoryEntry(dirname, lm, fileCount, directoryCount);
                    directoryList.add(directoryEntry);
                    showTrashConnector |= ps.write.moveToTrash.booleanValue();
                }
                catch (NoSuchFileException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PoolFileEntryComparator pec = new PoolFileEntryComparator(usedSortField, stringComparator, sortOrder);
        PoolDirectoryEntryComparator pdec = new PoolDirectoryEntryComparator(usedSortField, stringComparator, sortOrder);
        Collections.sort(directoryList, pdec);
        SourceConnectorReader configsConnector = this.settings.getSourceConnectorFromAssetURLPath("_configs", session);
        if (configsConnector != null) {
            PoolListSummary pls = imagebuilder.getPoolListSummary(configsConnector, "_configs", session);
            directoryList.add(0, new PoolDirectoryEntry("_configs", pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
        }
        if (!downloadConnectorAdded && (downloadsPermissions = this.settings.getUserAuthenticationInterface().getPermissions("_downloads", session, true)) != null && downloadsPermissions.list.files.booleanValue()) {
            directoryList.add(0, new PoolDirectoryEntry("_downloads", System.currentTimeMillis(), 0L, 0L));
        }
        if (showTrashConnector) {
            directoryList.add(0, new PoolDirectoryEntry("_trash", System.currentTimeMillis(), 0L, 0L));
        }
        Set<String> itemsSet = this.evaluateItemsParameter(parameters);
        directoryList = this.applyItemsFilterToPoolDirectoryEntryList(directoryList, itemsSet);
        dirCount = directoryList.size();
        SimpleHash summary = new SimpleHash();
        summary.put("entryCount", (Object)(0 + dirCount));
        summary.put("imageCount", (Object)0);
        summary.put("directoryCount", (Object)dirCount);
        summary.put("completeCount", (Object)0);
        summary.put("lastModified", (Object)lmdate);
        templateData.put("summary", (Object)summary);
        offset = this.ensureValidListOffset(offset, 0 + dirCount);
        if (count < 0) {
            count = 0 + dirCount - offset;
        }
        RangeDefinition rangedef = new RangeDefinition(offset, count, dirCount, 0);
        if (parameters.contains(Parameters.List.range)) {
            this.applyListRangeParameter(pec, pdec, parameters.get(Parameters.List.range), directoryList, imageList, rangedef);
        }
        StringBuilder eTagModifier = new StringBuilder();
        SimpleSequence finallist = this.buildFinalList(directoryList, imageList, rangedef, staticEscape, "/", session, true, eTagModifier);
        templateData.put("ilist", (Object)finallist);
        StringWriter sw = new StringWriter();
        Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
        env.process();
        sw.flush();
        RendererTextResponse response = new RendererTextResponse();
        response.setBody(sw.toString());
        response.setStatus(200);
        response.setETagModifier(eTagModifier.toString());
        return response;
    }

    private Template determineListTemplate(Parameters parameters) throws IOException {
        String listTemplate = "image_list.xml";
        if (parameters.contains(Parameters.General.template)) {
            listTemplate = parameters.get(Parameters.General.template);
        }
        Template result = this.settings.getTemplateCache().getTemplate(TemplateType.LIST, listTemplate + ".ftl");
        return result;
    }

    private boolean setTypeFilters(Parameters parameters, String staticTypeFilter, List<String> typefilter) {
        boolean typefilterset = false;
        if (staticTypeFilter == null || staticTypeFilter.trim().length() == 0) {
            String typefilterraw = parameters.get(Parameters.List.typefilter);
            if (typefilterraw != null) {
                StringTokenizer st = new StringTokenizer(typefilterraw, ",");
                int max = 10;
                while (st.hasMoreElements() && max-- > 0) {
                    String val = (String)st.nextElement();
                    typefilter.add(val.toLowerCase());
                }
                typefilterset = true;
            }
        } else {
            typefilter.add(staticTypeFilter.toLowerCase());
            typefilterset = true;
        }
        return typefilterset;
    }

    private SortDirection determineSortOrder(Parameters parameters) {
        SortDirection usedSortOrder = this.forceSortOrder != null ? this.forceSortOrder : SortingUtils.extractSortOrderFromParameters(parameters, this.defaultSortOrder);
        return usedSortOrder;
    }

    private FSIStringComparator determineSortComparator(Parameters parameters, SortDirection usedSortOrder) throws IOException {
        SortMethod usedSortMethod = this.forceSortMethod != null ? this.forceSortMethod : SortingUtils.extractSortMethodFromParameters(parameters, this.defaultSortMethod);
        String usedSortLanguage = this.forceSortLanguage != null ? this.forceSortLanguage : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.sortlanguage, this.defaultSortLanguage);
        String usedSortCountry = this.forceSortCountry != null ? this.forceSortCountry : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.sortcountry, this.defaultSortCountry);
        boolean usedSortCaseSensitive = this.forceSortCaseSensitiveSet ? this.forceSortCaseSensitive : (parameters.contains(Parameters.Sorting.sortcasesensitive) ? Boolean.valueOf(parameters.get(Parameters.Sorting.sortcasesensitive)) : this.defaultSortCaseSensitive);
        return this.environment.getFSIStringComparator(usedSortOrder, usedSortMethod, usedSortLanguage, usedSortCountry, usedSortCaseSensitive);
    }

    private int ensureValidListOffset(int offset, int totalLength) {
        if (offset < 0) {
            offset = 0;
        }
        if (offset > totalLength) {
            offset = totalLength;
        }
        return offset;
    }

    private void applyListRangeParameter(PoolFileEntryComparator pfec, PoolDirectoryEntryComparator pdec, String rangeParameter, List<PoolDirectoryEntry> directoryList, List<PoolFileEntry> imageList, RangeDefinition rangedef) {
        String[] nr = rangeParameter.split(",", 2);
        if (nr.length == 2) {
            String[] from = nr[0].split(";", 5);
            PoolFileEntry pstart = new PoolFileEntry("", 0L, 0L, -1, -1, 0);
            if (from.length >= 1) {
                pstart.name = from[0];
            }
            try {
                if (from.length >= 2) {
                    pstart.lastmodified = Long.parseLong(from[1]);
                }
                if (from.length >= 3) {
                    pstart.filesize = Long.parseLong(from[2]);
                }
                if (from.length >= 4) {
                    pstart.width = Integer.parseInt(from[3]);
                }
                if (from.length >= 5) {
                    pstart.height = Integer.parseInt(from[4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] to = nr[1].split(";", 5);
            PoolFileEntry pstop = new PoolFileEntry("", 0L, 0L, -1, -1, 0);
            if (from.length >= 1) {
                pstop.name = to[0];
            }
            try {
                if (from.length >= 2) {
                    pstop.lastmodified = Long.parseLong(to[1]);
                }
                if (from.length >= 3) {
                    pstop.filesize = Long.parseLong(to[2]);
                }
                if (from.length >= 4) {
                    pstop.width = Integer.parseInt(to[3]);
                }
                if (from.length >= 5) {
                    pstop.height = Integer.parseInt(to[4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (from[0].equals("directory")) {
                rangedef.startDirs = this.findNearestDirectoryEntry(pdec, directoryList, new PoolDirectoryEntry(pstart.name, pstart.lastmodified, 0L, 0L));
                rangedef.startFiles = 0;
            } else {
                rangedef.startDirs = directoryList.size();
                rangedef.startFiles = this.findNearestListEntry(pfec, imageList, pstart);
            }
            if (to[0].equals("directory")) {
                rangedef.stopDirs = this.findNearestDirectoryEntry(pdec, directoryList, new PoolDirectoryEntry(pstop.name, pstop.lastmodified, 0L, 0L)) + 1;
                rangedef.stopFiles = 0;
            } else {
                rangedef.stopDirs = directoryList.size();
                rangedef.stopFiles = this.findNearestListEntry(pfec, imageList, pstop) + 1;
            }
        }
    }

    private int findNearestDirectoryEntry(PoolDirectoryEntryComparator comparator, List<PoolDirectoryEntry> poolList, PoolDirectoryEntry pe) {
        int comp;
        int result;
        for (result = 0; result < poolList.size() && (comp = comparator.compare(pe, poolList.get(result))) < 0; ++result) {
        }
        return result;
    }

    private int findNearestListEntry(PoolFileEntryComparator comparator, List<PoolFileEntry> poolList, PoolFileEntry pe) {
        PoolFileEntry entry;
        int result;
        for (result = 0; result < poolList.size() && comparator.compare(pe, entry = poolList.get(result)) < 0; ++result) {
        }
        return result;
    }

    private SimpleHash getSimpleHashFromPropertySet(PropertySet ps) {
        if (ps == null) {
            return null;
        }
        SimpleHash result = new SimpleHash();
        if (ps.general.size() > 0) {
            result.put("general", (Object)this.getSimpleSequenceFromItemList(ps.general));
        }
        if (ps.custommetadatafields.size() > 0) {
            result.put("customMetadataFields", (Object)this.getSimpleSequenceFromItemList(ps.custommetadatafields));
        }
        if (ps.publishingsets.size() > 0) {
            result.put("publishingSets", (Object)this.getSimpleSequenceFromItemList(ps.publishingsets));
        }
        if (ps.hideApps.size() > 0) {
            result.put("hideApps", (Object)this.getSimpleSequenceFromItemList(ps.hideApps));
        }
        if (ps.hidePublishingTabs.size() > 0) {
            result.put("hidePublishingTabs", (Object)this.getSimpleSequenceFromItemList(ps.hidePublishingTabs));
        }
        if (ps.custom.size() > 0) {
            result.put("custom", (Object)this.getSimpleSequenceFromItemList(ps.custom));
        }
        return result;
    }

    private SimpleSequence getSimpleSequenceFromItemList(List<PropertySet.ItemType> list) {
        SimpleSequence result = new SimpleSequence();
        for (PropertySet.ItemType item : list) {
            if (!item.value) continue;
            result.add((Object)item.name);
        }
        return result;
    }

    private SimpleHash getSimpleHashFromPermissionSet(PermissionSet ps) {
        SimpleHash result = new SimpleHash();
        SimpleHash read = new SimpleHash();
        read.put("renderedImages", (Object)ps.read.renderedImages);
        read.put("files", (Object)ps.read.files);
        read.put("downloadSource", (Object)ps.read.downloadSource);
        read.put("copy", (Object)ps.read.copy);
        read.put("basicMetadata", (Object)ps.read.basicMetadata);
        read.put("extendedMetadata", (Object)ps.read.extendedMetadata);
        read.put("iccProfiles", (Object)ps.read.iccProfiles);
        read.put("totalAssetsCount", (Object)ps.read.totalAssetsCount);
        read.put("storageStatus", (Object)ps.read.storageStatus);
        result.put("read", (Object)read);
        SimpleHash list = new SimpleHash();
        list.put("files", (Object)ps.list.files);
        list.put("directories", (Object)ps.list.directories);
        list.put("connector", (Object)ps.list.connector);
        list.put("searchResults", (Object)ps.list.searchResults);
        result.put("list", (Object)list);
        SimpleHash write = new SimpleHash();
        write.put("createDirectory", (Object)ps.write.createDirectory);
        write.put("upload", (Object)ps.write.upload);
        write.put("paste", (Object)ps.write.paste);
        write.put("delete", (Object)ps.write.delete);
        write.put("moveToTrash", (Object)ps.write.moveToTrash);
        write.put("rename", (Object)ps.write.rename);
        write.put("overwrite", (Object)ps.write.overwrite);
        write.put("moveWithinConnector", (Object)ps.write.moveWithinConnector);
        write.put("extendedMetadata", (Object)ps.write.extendedMetadata);
        result.put("write", (Object)write);
        SimpleHash tasks = new SimpleHash();
        tasks.put("batchRendering", (Object)ps.tasks.batchRendering);
        tasks.put("createArchive", (Object)ps.tasks.createArchive);
        tasks.put("reimportFiles", (Object)ps.tasks.reimportFiles);
        result.put("tasks", (Object)tasks);
        return result;
    }

    private SimpleSequence buildFinalList(List<PoolDirectoryEntry> directoryList, List<PoolFileEntry> imageList, RangeDefinition rangedef, Escaper.EscaperType staticEscape, String assetURLPath, HttpSession session, boolean includeRestrictionsAndStats, StringBuilder eTagModifier) throws NotConfiguredException {
        int p;
        SimpleSequence finallist = new SimpleSequence();
        int pos = 1;
        StringBuilder eTagModificationBuilder = new StringBuilder();
        if (rangedef.startDirs >= 0) {
            for (p = rangedef.startDirs; p < rangedef.stopDirs; ++p) {
                SimpleHash publicPermissionsHash;
                PermissionSet publicPermissions;
                SimpleHash permissionsHash;
                PermissionSet permissions;
                SimpleHash sh;
                PoolDirectoryEntry dir = directoryList.get(p);
                eTagModificationBuilder.append(pos + dir.name);
                if (assetURLPath.equals("/") && dir.name.equals("_trash")) {
                    sh = new SimpleHash();
                    sh.put("id", (Object)pos++);
                    sh.put("type", (Object)"directory");
                    sh.put("src", (Object)StandardListRenderer.escapeString(dir.name, staticEscape));
                    sh.put("connectorType", (Object)"TRASH");
                    if (includeRestrictionsAndStats) {
                        permissions = this.settings.getUserAuthenticationInterface().getPermissions("_trash", session, true);
                        permissionsHash = this.getSimpleHashFromPermissionSet(permissions);
                        sh.put("userpermissions", (Object)permissionsHash);
                        publicPermissions = this.settings.getUserAuthenticationInterface().getPermissions("_trash", null, true);
                        publicPermissionsHash = this.getSimpleHashFromPermissionSet(publicPermissions);
                        sh.put("publicpermissions", (Object)publicPermissionsHash);
                    }
                    finallist.add((Object)sh);
                    continue;
                }
                if (assetURLPath.equals("/") && dir.name.equals("_downloads")) {
                    sh = new SimpleHash();
                    sh.put("id", (Object)pos++);
                    sh.put("type", (Object)"directory");
                    sh.put("src", (Object)StandardListRenderer.escapeString(dir.name, staticEscape));
                    sh.put("connectorType", (Object)"DOWNLOADS");
                    if (includeRestrictionsAndStats) {
                        permissions = this.settings.getUserAuthenticationInterface().getPermissions("_downloads", session, true);
                        if (permissions == null) {
                            permissions = PermissionSet.getAllForbiddenPermissionSet();
                        }
                        permissionsHash = this.getSimpleHashFromPermissionSet(permissions);
                        sh.put("userpermissions", (Object)permissionsHash);
                        publicPermissions = this.settings.getUserAuthenticationInterface().getPermissions("_downloads", null, true);
                        if (publicPermissions == null) {
                            publicPermissions = PermissionSet.getAllForbiddenPermissionSet();
                        }
                        publicPermissionsHash = this.getSimpleHashFromPermissionSet(publicPermissions);
                        sh.put("publicpermissions", (Object)publicPermissionsHash);
                    }
                    finallist.add((Object)sh);
                    continue;
                }
                if (assetURLPath.startsWith("_config") || assetURLPath.startsWith("_viewers")) {
                    sh = new SimpleHash();
                    sh.put("id", (Object)pos++);
                    sh.put("type", (Object)"directory");
                    sh.put("src", (Object)StandardListRenderer.escapeString(dir.name, staticEscape));
                    sh.put("connectorType", (Object)"STATIC");
                    sh.put("lastmodified", (Object)dir.lastmodified);
                    if (dir.subdirectories > 0L) {
                        sh.put("hasSub", true);
                        sh.put("dirs", (Object)dir.subdirectories);
                    } else {
                        sh.put("hasSub", false);
                        sh.put("dirs", (Object)0);
                    }
                    sh.put("images", (Object)dir.files);
                    finallist.add((Object)sh);
                    continue;
                }
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath + "/" + dir.name, session);
                if (connector == null) continue;
                SimpleHash sh2 = new SimpleHash();
                sh2.put("id", (Object)pos++);
                sh2.put("type", (Object)"directory");
                sh2.put("src", (Object)StandardListRenderer.escapeString(dir.name, staticEscape));
                sh2.put("size", (Object)0);
                if (includeRestrictionsAndStats) {
                    SourceManagerSettings is;
                    SourceConnectorReader iprofile;
                    Object sourcemanager;
                    if (connector.getComment() != null) {
                        sh2.put("comment", (Object)StandardListRenderer.escapeString(connector.getComment(), staticEscape));
                    }
                    sh2.put("connectorType", (Object)connector.getMountType());
                    PermissionSet permissions2 = this.settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                    SimpleHash permissionsHash2 = this.getSimpleHashFromPermissionSet(permissions2);
                    sh2.put("userpermissions", (Object)permissionsHash2);
                    PermissionSet publicPermissions2 = this.settings.getUserAuthenticationInterface().getPermissions(connector, null, true);
                    SimpleHash publicPermissionsHash2 = this.getSimpleHashFromPermissionSet(publicPermissions2);
                    sh2.put("publicpermissions", (Object)publicPermissionsHash2);
                    PropertySet properties = this.settings.getUserAuthenticationInterface().getProperties(connector, session);
                    SimpleHash propertiesHash = this.getSimpleHashFromPropertySet(properties);
                    sh2.put("properties", (Object)propertiesHash);
                    eTagModificationBuilder.append(permissions2.hashCode());
                    eTagModificationBuilder.append(publicPermissions2.hashCode());
                    eTagModificationBuilder.append(properties.hashCode());
                    if (permissions2.read.totalAssetsCount.booleanValue() && (sourcemanager = this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager")) != null && (iprofile = (is = ((MainManager)sourcemanager).getSourceManagerSettings()).getSourceConnector(connector.getPrefix())) != null) {
                        sh2.put("connectorTotalContent", (Object)iprofile.getCurrentImageCount());
                        eTagModificationBuilder.append(iprofile.getCurrentImageCount());
                    }
                }
                eTagModificationBuilder.append(dir.lastmodified);
                sh2.put("lastmodified", (Object)dir.lastmodified);
                if (dir.subdirectories > 0L) {
                    sh2.put("hasSub", true);
                    sh2.put("dirs", (Object)dir.subdirectories);
                } else {
                    sh2.put("hasSub", false);
                    sh2.put("dirs", (Object)0);
                }
                sh2.put("images", (Object)dir.files);
                finallist.add((Object)sh2);
            }
        }
        if (rangedef.startFiles >= 0) {
            for (p = rangedef.startFiles; p < rangedef.stopFiles; ++p) {
                PoolFileEntry poolEntry = imageList.get(p);
                SimpleHash entry = new SimpleHash();
                entry.put("id", (Object)pos++);
                entry.put("type", (Object)"file");
                entry.put("src", (Object)StandardListRenderer.escapeString(poolEntry.name, staticEscape));
                if (poolEntry.width > 0) {
                    entry.put("width", (Object)poolEntry.width);
                }
                if (poolEntry.height > 0) {
                    entry.put("height", (Object)poolEntry.height);
                }
                entry.put("lastmodified", (Object)poolEntry.lastmodified);
                entry.put("size", (Object)poolEntry.filesize);
                if (poolEntry.importStatus != 0) {
                    entry.put("importstatus", (Object)poolEntry.importStatus);
                }
                eTagModificationBuilder.append(pos + poolEntry.name + poolEntry.lastmodified + poolEntry.filesize + poolEntry.importStatus);
                finallist.add((Object)entry);
            }
        }
        eTagModifier.append(eTagModificationBuilder.toString().hashCode());
        return finallist;
    }

    private SimpleSequence buildFinalMultiList(List<PoolDirectoryEntry>[] directoryLists, List<PoolFileEntry>[] imageList, RangeDefinition[] rangedef, Escaper.EscaperType staticEscape, ImageBuilder imagebuilder, String[] assetURLPaths, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        int s;
        int n;
        int p;
        SimpleSequence finallist = new SimpleSequence();
        int pos = 1;
        if (rangedef[0].startDirs >= 0) {
            for (p = rangedef[0].startDirs; p < rangedef[0].stopDirs; ++p) {
                SimpleHash sh = new SimpleHash();
                n = 0;
                s = 1;
                while (n < assetURLPaths.length) {
                    String dir = directoryLists[n].get((int)p).name;
                    sh.put("id" + s, (Object)pos++);
                    sh.put("type" + s, (Object)"directory");
                    sh.put("src" + s, (Object)StandardListRenderer.escapeString(dir, staticEscape));
                    sh.put("importstatus" + s, (Object)0);
                    sh.put("size" + s, (Object)0);
                    SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPaths[n]);
                    PoolListSummary pls = imagebuilder.getPoolListSummary(connector, assetURLPaths[n] + dir, session);
                    sh.put("lastmodified" + s, (Object)pls.lastmodified);
                    if (pls.getDirectoryCount() > 0L) {
                        sh.put("hasSub" + s, true);
                        sh.put("dirs" + s, (Object)pls.getDirectoryCount());
                    } else {
                        sh.put("hasSub" + s, false);
                        sh.put("dirs" + s, (Object)0);
                    }
                    sh.put("images" + s, (Object)pls.getFileCount());
                    ++n;
                    ++s;
                }
                finallist.add((Object)sh);
            }
        }
        if (rangedef[0].startFiles >= 0) {
            for (p = rangedef[0].startFiles; p < rangedef[0].stopFiles; ++p) {
                SimpleHash entry = new SimpleHash();
                n = 0;
                s = 1;
                while (n < assetURLPaths.length) {
                    PoolFileEntry poolEntry = imageList[n].get(p);
                    entry.put("id" + s, (Object)pos++);
                    entry.put("type" + s, (Object)"file");
                    entry.put("src" + s, (Object)StandardListRenderer.escapeString(poolEntry.name, staticEscape));
                    if (poolEntry.width > 0) {
                        entry.put("width" + s, (Object)poolEntry.width);
                    }
                    if (poolEntry.height > 0) {
                        entry.put("height" + s, (Object)poolEntry.height);
                    }
                    entry.put("lastmodified" + s, (Object)poolEntry.lastmodified);
                    entry.put("size" + s, (Object)poolEntry.filesize);
                    entry.put("importstatus" + s, (Object)poolEntry.importStatus);
                    ++n;
                    ++s;
                }
                finallist.add((Object)entry);
            }
        }
        return finallist;
    }

    private static final class RangeDefinition {
        int startDirs;
        int stopDirs;
        int startFiles;
        int stopFiles;

        RangeDefinition(int offset, int count, int dirCount, int fileCount) {
            this.startDirs = Math.max(0, offset);
            this.stopDirs = Math.min(dirCount, this.startDirs + count);
            this.startFiles = Math.max(0, offset - dirCount);
            this.stopFiles = Math.min(fileCount, offset + count - dirCount);
        }

        public String toString() {
            return "Range Definition: startDirs: " + this.startDirs + " stopDirs: " + this.stopDirs + " startFiles: " + this.startFiles + " stopFiles: " + this.stopFiles;
        }
    }
}

