/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagemanipulator.area.Crop;
import com.neptunelabs.imagemanipulator.combine.Join;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class StitchImageRenderer
extends RendererAbstract {
    private int backgroundColor = 0;

    public StitchImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws ProcessingException, InterruptedException {
        String sourceParam;
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        RendererImageResponse response = new RendererImageResponse();
        if (req.getAttribute("cacheable") != null) {
            response.setCacheable((Boolean)req.getAttribute("cacheable"));
        }
        if ((sourceParam = parameters.get(Parameters.General.source)) == null) {
            throw new IllegalArgumentException("source required");
        }
        String[] assetURLPaths = sourceParam.split(",");
        for (int i = 0; i < assetURLPaths.length; ++i) {
            assetURLPaths[i] = URL.cleanUpSourceParameter(assetURLPaths[i]);
        }
        int bgcolor = this.backgroundColor;
        if (parameters.contains(Parameters.GeneralImage.backgroundcolor)) {
            bgcolor = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.backgroundcolor), bgcolor);
        }
        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
        if (widthPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
        }
        if (heightPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
        }
        double[] relativeRangeInTotal = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
        if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
            StitchImageRenderer.getRelativeRangeFromParameters(parameters, relativeRangeInTotal);
        }
        ArrayList<ImageMetaData> metadatalist = new ArrayList<ImageMetaData>();
        FSIImage result = null;
        FSIImageLimited partImage = null;
        try {
            for (String assetURLPath : assetURLPaths) {
                SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                MetaData md = this.settings.getImageBuilder().getImageMetaData(importerProfile, assetURLPath, 0, true, req.getSession(false));
                if (md == null || !(md instanceof ImageMetaData)) continue;
                md.setAssetURLPath(assetURLPath);
                metadatalist.add((ImageMetaData)md);
            }
            Pair<Integer, Integer> totalSize = StitchRendererUtils.getTotalDimensions(metadatalist, parameters);
            int totalUnscaledWidth = totalSize.getItem1();
            int totalUnscaledHeight = totalSize.getItem2();
            double x = (double)totalUnscaledWidth * relativeRangeInTotal[2];
            double y = (double)totalUnscaledHeight * relativeRangeInTotal[3];
            int targetWidth = widthPair.getItem1();
            int targetHeight = heightPair.getItem1();
            if (widthPair.getItem2().booleanValue()) {
                targetWidth = (int)(x * (double)targetHeight / y);
            } else if (heightPair.getItem2().booleanValue()) {
                targetHeight = (int)((double)targetWidth * y / x);
            }
            StitchRendererUtils.Position pos = StitchRendererUtils.getPosition(parameters);
            Crop.CropPadPosition alignment = StitchRendererUtils.getAlignment(parameters);
            int xpos = 0;
            int ypos = 0;
            Iterator iterator = metadatalist.iterator();
            while (iterator.hasNext()) {
                double[] backCoords;
                double[] inImageCoords;
                double b2;
                double b1;
                double a1 = (double)xpos / (double)totalUnscaledWidth;
                ImageMetaData imd = (ImageMetaData)iterator.next();
                double a2 = (double)(xpos + imd.getWidth()) / (double)totalUnscaledWidth;
                inImageCoords = new double[]{(relativeRangeInTotal[0] - a1) / (a2 - a1), (relativeRangeInTotal[1] - (b1 = (double)ypos / (double)totalUnscaledHeight)) / ((b2 = (double)(ypos + imd.getHeight()) / (double)totalUnscaledHeight) - b1), (relativeRangeInTotal[0] + relativeRangeInTotal[2] - a1) / (a2 - a1) - inImageCoords[0], (relativeRangeInTotal[1] + relativeRangeInTotal[3] - b1) / (b2 - b1) - inImageCoords[1]};
                if (inImageCoords[0] < 0.0) {
                    inImageCoords[2] = inImageCoords[2] + inImageCoords[0];
                    inImageCoords[0] = 0.0;
                }
                if (inImageCoords[1] < 0.0) {
                    inImageCoords[3] = inImageCoords[3] + inImageCoords[1];
                    inImageCoords[1] = 0.0;
                }
                if (inImageCoords[0] + inImageCoords[2] > 1.0) {
                    inImageCoords[2] = 1.0 - inImageCoords[0];
                }
                if (inImageCoords[1] + inImageCoords[3] > 1.0) {
                    inImageCoords[3] = 1.0 - inImageCoords[1];
                }
                backCoords = new double[]{inImageCoords[0] * (a2 - a1) + a1, inImageCoords[1] * (b2 - b1) + b1, (inImageCoords[2] + inImageCoords[0]) * (a2 - a1) - backCoords[0] + a1, (inImageCoords[3] + inImageCoords[1]) * (b2 - b1) - backCoords[1] + b1};
                int partWidth = (int)Math.ceil((double)targetWidth * backCoords[2] / relativeRangeInTotal[2]);
                int partHeight = (int)Math.ceil((double)targetHeight * backCoords[3] / relativeRangeInTotal[3]);
                if (partWidth > 0 && partHeight > 0) {
                    String assetURLPath = imd.getAssetURLPath();
                    SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                    partImage = this.settings.getImageBuilder().getImage(null, importerProfile, priority, assetURLPath, new Pair<Integer, Boolean>(partWidth, false), new Pair<Integer, Boolean>(partHeight, false), inImageCoords[0], inImageCoords[1], inImageCoords[2], inImageCoords[3], false, FSIInterpolation.LANCZOS);
                    result = result == null ? partImage : this.joinParts(bgcolor, pos, alignment, result, partImage);
                }
                if (pos == StitchRendererUtils.Position.RIGHT) {
                    xpos += imd.getWidth();
                    continue;
                }
                if (pos != StitchRendererUtils.Position.BOTTOM) continue;
                ypos += imd.getHeight();
            }
            if (result != null && (result.getWidth() > targetWidth || result.getHeight() > targetHeight)) {
                result = Crop.transform(result, (result.getWidth() - targetWidth) / 2, (result.getHeight() - targetHeight) / 2, targetWidth, targetHeight, 0, null, 0.0f, 0.0f, false);
            }
            response.setStatus(200);
            response.setResponseImage((FSIImageLimited)result);
            response.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(metadatalist));
        }
        catch (NoSuchFileException e) {
            StitchImageRenderer.disposeImages(result, partImage);
            response.setStatus(404);
        }
        catch (IOException e) {
            StitchImageRenderer.disposeImages(result, partImage);
            response.setStatus(500);
            response.setStatusMessage(e.getLocalizedMessage());
        }
        catch (NotConfiguredException e) {
            StitchImageRenderer.disposeImages(result, partImage);
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (ProcessingException e) {
            StitchImageRenderer.disposeImages(result, partImage);
            throw e;
        }
        return response;
    }

    private FSIImage joinParts(int bgcolor, StitchRendererUtils.Position pos, Crop.CropPadPosition alignment, FSIImage result, FSIImage partImage) {
        if (pos == StitchRendererUtils.Position.RIGHT) {
            if (result.getHeight() < partImage.getHeight()) {
                result = Crop.transform(result, 0, 0, result.getWidth(), partImage.getHeight(), bgcolor, alignment, 0.0f, 0.0f, false);
            } else if (result.getHeight() > partImage.getHeight()) {
                partImage = Crop.transform(partImage, 0, 0, partImage.getWidth(), result.getHeight(), bgcolor, alignment, 0.0f, 0.0f, false);
            }
            result = Join.transform(result, partImage, Join.JoinPosition.RIGHT);
        } else if (pos == StitchRendererUtils.Position.BOTTOM) {
            if (result.getWidth() < partImage.getWidth()) {
                result = Crop.transform(result, 0, 0, partImage.getWidth(), result.getHeight(), bgcolor, alignment, 0.0f, 0.0f, false);
            } else if (result.getWidth() > partImage.getWidth()) {
                partImage = Crop.transform(partImage, 0, 0, result.getWidth(), partImage.getHeight(), bgcolor, alignment, 0.0f, 0.0f, false);
            }
            result = Join.transform(result, partImage, Join.JoinPosition.BOTTOM);
        }
        return result;
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        } else if (name.equalsIgnoreCase("backgroundcolor")) {
            result = String.valueOf(this.backgroundColor);
        }
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("maxwidth");
        result.add("maxheight");
        result.add("defaultwidth");
        result.add("defaultheight");
        result.add("backgroundcolor");
        return result;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException i) {}
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase("backgroundColor")) {
            try {
                this.backgroundColor = ColorParser.parseColor(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

