/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.utils.URL;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StitchInfoRenderer
extends RendererAbstract {
    public StitchInfoRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public String getOption(String name) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) {
        HttpSession session = req.getSession(false);
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        if (!parameters.contains(Parameters.General.source)) {
            return StitchInfoRenderer.generateMissingParameterResponse("source");
        }
        String[] assetURLPaths = parameters.get(Parameters.General.source).split(",");
        for (int i = 0; i < assetURLPaths.length; ++i) {
            assetURLPaths[i] = URL.cleanUpSourceParameter(assetURLPaths[i]);
        }
        RendererTextResponse response = new RendererTextResponse();
        ArrayList<ImageMetaData> metadatalist = new ArrayList<ImageMetaData>();
        try {
            String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info";
            Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
            TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
            if (!this.checkTemplateAccessRestrictions(templateAttrs, session)) {
                return StitchInfoRenderer.generateNotAuthorizedResponse();
            }
            for (String assetURLPath : assetURLPaths) {
                PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(assetURLPath, session, true);
                if (ps != null && ps.read.basicMetadata.booleanValue() && ps.read.extendedMetadata.booleanValue()) continue;
                return StitchInfoRenderer.generateNotAuthorizedResponse();
            }
            for (String assetURLPath : assetURLPaths) {
                SourceConnectorReader importerProfile = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                MetaData md = this.settings.getImageBuilder().getImageMetaData(importerProfile, assetURLPath, 0, true, req.getSession(false));
                md.setAssetURLPath(assetURLPath);
                if (!(md instanceof ImageMetaData)) continue;
                metadatalist.add((ImageMetaData)md);
            }
            templateAttrs.setRendererResponseContentType(response);
            boolean nocacheheaderset = false;
            for (ImageMetaData imd : metadatalist) {
                if (imd.getImportStatus() == 1 || nocacheheaderset) continue;
                nocacheheaderset = true;
                response.setDateHeader("Expires", 1000L);
                response.setHeader("Pragma", "no-cache, no-store");
                response.setHeader("Cache-Control", "must-revalidate, max-age=0, post-check=0, pre-check=0");
            }
            response.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(metadatalist));
            SimpleHash entry = new SimpleHash();
            entry.put("type", (Object)"file");
            Pair<Integer, Integer> totalSize = StitchRendererUtils.getTotalDimensions(metadatalist, parameters);
            entry.put("width", (Object)totalSize.getItem1());
            entry.put("height", (Object)totalSize.getItem2());
            SimpleHash templateData = new SimpleHash();
            templateData.put("info", (Object)entry);
            templateData.put("query", (Object)parameters);
            try (StringWriterFast sw = new StringWriterFast();){
                Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
                env.process();
                response.setBody(sw.toString());
                response.setStatus(200);
            }
        }
        catch (NoSuchFileException e) {
            return StitchInfoRenderer.generateNotFoundResponse();
        }
        catch (IOException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (NotConfiguredException e) {
            response.setStatus(503);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String name, String value) {
    }
}

