/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.imagemanipulator.combine.TestPattern;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public final class TestPatternImageRenderer
extends RendererAbstract {
    int maxDepth = 30000;

    public TestPatternImageRenderer(RequestProcessorSettings settings, String rendererName) {
        super(settings, rendererName);
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("defaultWidth");
        result.add("defaultWidth");
        result.add("maxWidth");
        result.add("maxHeight");
        result.add("maxDepth");
        return result;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(int priority, HttpServletRequest req, Map<String, Object> metadata) throws IllegalArgumentException, ProcessingException {
        Parameters parameters = (Parameters)req.getAttribute("parameters");
        TestPattern testpattern = new TestPattern(this.settings.getFSILogger(), this.settings.getExecutorPool(), this.settings.getSwapPool(), this.settings.getByteOrder());
        RendererResponse response = parameters.getType() == Parameters.Type.IMAGE ? this.renderImage(priority, parameters, testpattern) : (parameters.getType() == Parameters.Type.INFO ? this.renderInfo(parameters) : null);
        return response;
    }

    private void convertPixelRangeToRelative(Parameters parameters, int referenceWidth, int referenceHeight) {
        int[] pixelRange = new int[4];
        this.getPixelRangeFromParameters(parameters, pixelRange);
        double left = (double)pixelRange[0] / (double)referenceWidth;
        double top = (double)pixelRange[1] / (double)referenceHeight;
        double rangeWidth = (double)pixelRange[2] / (double)referenceWidth;
        double rangeHeight = (double)pixelRange[3] / (double)referenceHeight;
        parameters.put(Parameters.GeneralImage.rect, left + "," + top + "," + rangeWidth + "," + rangeHeight);
        parameters.put(Parameters.GeneralImage.width, String.valueOf(pixelRange[2]));
        parameters.put(Parameters.GeneralImage.height, String.valueOf(pixelRange[3]));
    }

    private RendererResponse renderImage(int priority, Parameters parameters, TestPattern testpattern) throws ProcessingException {
        RendererImageResponse response = new RendererImageResponse();
        if (parameters.contains(Parameters.GeneralImage.pixelrange) || parameters.contains(Parameters.GeneralImage.pixelleft) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.bottom)) {
            int[] referenceDimensions = TestPatternImageRenderer.getReferenceDimensions(parameters);
            this.convertPixelRangeToRelative(parameters, referenceDimensions[0], referenceDimensions[1]);
        }
        Pair<Integer, Boolean> widthPair = this.getWidth(parameters.get(Parameters.GeneralImage.width));
        Pair<Integer, Boolean> heightPair = this.getHeight(parameters.get(Parameters.GeneralImage.height));
        if (widthPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.width, String.valueOf(widthPair.getItem1()));
        }
        if (heightPair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.height, String.valueOf(heightPair.getItem1()));
        }
        TestPattern.Modes defaultmode = TestPattern.Modes.CIRCLES;
        if (parameters.contains(Parameters.FileImage.mode)) {
            String mode = parameters.get(Parameters.FileImage.mode).toUpperCase();
            try {
                defaultmode = TestPattern.Modes.valueOf(mode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        testpattern.setMode(defaultmode);
        int defaultdistance = 2;
        if (parameters.contains(Parameters.FileImage.distance)) {
            String distanceStr = parameters.get(Parameters.FileImage.distance);
            try {
                defaultdistance = Integer.parseInt(distanceStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        testpattern.setDistance(defaultdistance);
        if (parameters.contains(Parameters.FileImage.color)) {
            String colorStr = parameters.get(Parameters.FileImage.color);
            String[] multiColor = colorStr.split(",", 2);
            try {
                if (multiColor.length == 1) {
                    int co = ColorParser.parseColor(multiColor[0]);
                    testpattern.setColor(co);
                } else {
                    int co1 = ColorParser.parseColor(multiColor[0]);
                    int co2 = ColorParser.parseColor(multiColor[0]);
                    testpattern.setMultiColor(co1, co2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parameters.contains(Parameters.GeneralImage.backgroundcolor)) {
            String backgroundcolorStr = parameters.get(Parameters.GeneralImage.backgroundcolor);
            try {
                int bg = ColorParser.parseColor(backgroundcolorStr);
                testpattern.setBackgroundColor(bg);
            }
            catch (NumberFormatException bg) {
                // empty catch block
            }
        }
        if (parameters.contains(Parameters.GeneralImage.rect) || parameters.contains(Parameters.GeneralImage.top) || parameters.contains(Parameters.GeneralImage.left) || parameters.contains(Parameters.GeneralImage.right) || parameters.contains(Parameters.GeneralImage.bottom)) {
            double[] relativeRangeLeft = Arrays.copyOf(DEFAULT_RELATIVE_RANGE, 4);
            TestPatternImageRenderer.getRelativeRangeFromParameters(parameters, relativeRangeLeft);
            testpattern.setRange(relativeRangeLeft[0], relativeRangeLeft[1], relativeRangeLeft[2], relativeRangeLeft[3]);
        } else {
            testpattern.setRange(0.0, 0.0, 1.0, 1.0);
        }
        FSIImageLimited image = (FSIImageLimited)testpattern.render(priority, widthPair, heightPair);
        if (image != null) {
            if (parameters.contains(Parameters.GeneralImage.effects)) {
                try {
                    image = (FSIImageLimited)this.applyEffects(priority, image, response.getSelectionsRaw(), parameters);
                }
                catch (ProcessingException e) {
                    TestPatternImageRenderer.disposeImages(image);
                    throw e;
                }
            }
            response.setResponseImage(image);
            response.setStatus(200);
        }
        return response;
    }

    private RendererResponse renderInfo(Parameters parameters) {
        RendererTextResponse response = new RendererTextResponse();
        try {
            String infotemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "info";
            Template template = this.settings.getTemplateCache().getTemplate(TemplateType.INFO, infotemplate + ".ftl");
            TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
            templateAttrs.setRendererResponseContentType(response);
            SimpleHash entry = new SimpleHash();
            entry.put("type", (Object)"file");
            entry.put("width", (Object)this.maxDepth);
            entry.put("height", (Object)this.maxDepth);
            SimpleHash templateData = new SimpleHash();
            templateData.put("info", (Object)entry);
            try (StringWriterFast sw = new StringWriterFast();){
                Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
                env.process();
                response.setBody(sw.toString());
                response.setStatus(200);
            }
        }
        catch (NoSuchFileException e) {
            return TestPatternImageRenderer.generateNotFoundResponse();
        }
        catch (IOException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            response.setStatus(500);
            this.settings.getFSILogger().log(3191, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public void setOption(String name, String value) {
        if (name.equalsIgnoreCase("maxWidth")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxHeight")) {
            try {
                int i = Integer.valueOf(value);
                if (i > 0) {
                    this.maxHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultWidth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.defaultHeight = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        } else if (name.equalsIgnoreCase("maxDepth")) {
            try {
                int i = Integer.parseInt(value);
                if (i > 0) {
                    this.maxDepth = i;
                }
            }
            catch (NumberFormatException e) {
                this.settings.getFSILogger().log(3043, value, name, this.rendererName);
            }
        }
    }

    @Override
    public String getOption(String name) {
        String result = null;
        if (name.equalsIgnoreCase("maxWidth")) {
            result = String.valueOf(this.maxWidth);
        } else if (name.equalsIgnoreCase("maxHeight")) {
            result = String.valueOf(this.maxHeight);
        } else if (name.equalsIgnoreCase("defaultWidth")) {
            result = String.valueOf(this.defaultWidth);
        } else if (name.equalsIgnoreCase("defaultHeight")) {
            result = String.valueOf(this.defaultHeight);
        } else if (name.equalsIgnoreCase("maxDepth")) {
            result = String.valueOf(this.maxDepth);
        }
        return result;
    }

    private FSIImage applyEffects(int priority, FSIImage image, byte[] selectionsRaw, Parameters parameters) throws ProcessingException {
        String effectsString = parameters.get(Parameters.GeneralImage.effects);
        try {
            image = this.settings.getEffectsManager().applyEffects(priority, image, selectionsRaw, effectsString, parameters);
        }
        catch (IllegalArgumentException e) {
            this.settings.getFSILogger().log(3153, null, effectsString, "");
        }
        return image;
    }
}

