/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers.utils;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingUtils;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;

public final class DirectoryImageRendererUtils {
    public static PoolFileEntryComparator getComparator(Parameters requestParams, SortingParameters sortingParams) {
        SortDirection order = DirectoryImageRendererUtils.determineSortOrder(requestParams, sortingParams);
        FSIStringComparator comparator = DirectoryImageRendererUtils.determineSortComparator(requestParams, sortingParams, order);
        PoolEntrySortingField usedSortField = DirectoryImageRendererUtils.determineSortField(requestParams, sortingParams);
        return new PoolFileEntryComparator(usedSortField, comparator, order);
    }

    private static SortDirection determineSortOrder(Parameters parameters, SortingParameters sortingParams) {
        if (sortingParams.forceSortOrder != null) {
            return sortingParams.forceSortOrder;
        }
        return SortingUtils.extractSortOrderFromParameters(parameters, sortingParams.defaultSortOrder);
    }

    private static FSIStringComparator determineSortComparator(Parameters parameters, SortingParameters sortingParams, SortDirection usedSortOrder) {
        SortMethod usedSortMethod = sortingParams.forceSortMethod != null ? sortingParams.forceSortMethod : SortingUtils.extractSortMethodFromParameters(parameters, sortingParams.defaultSortMethod);
        String usedSortLanguage = sortingParams.forceSortLanguage != null ? sortingParams.forceSortLanguage : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.sortlanguage, sortingParams.defaultSortLanguage);
        String usedSortCountry = sortingParams.forceSortCountry != null ? sortingParams.forceSortCountry : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.sortcountry, sortingParams.defaultSortCountry);
        boolean usedSortCaseSensitive = sortingParams.forceSortCaseSensitiveSet ? sortingParams.forceSortCaseSensitive : (parameters.contains(Parameters.Sorting.sortcasesensitive) ? Boolean.valueOf(parameters.get(Parameters.Sorting.sortcasesensitive)) : sortingParams.defaultSortCaseSensitive);
        return RendererEnvironment.getInstance(null).getFSIStringComparator(usedSortOrder, usedSortMethod, usedSortLanguage, usedSortCountry, usedSortCaseSensitive);
    }

    private static PoolEntrySortingField determineSortField(Parameters parameters, SortingParameters sortingParams) {
        PoolEntrySortingField usedSortField = RendererEnvironment.DEFAULT_SORT_FIELD;
        if (sortingParams.forceSortField != null) {
            usedSortField = sortingParams.forceSortField;
        } else if (parameters.contains(Parameters.Sorting.sortfield) && parameters.get(Parameters.Sorting.sortfield).trim().length() > 0) {
            try {
                usedSortField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.sortfield).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                usedSortField = sortingParams.defaultSortField;
            }
        } else {
            usedSortField = sortingParams.defaultSortField;
        }
        return usedSortField;
    }
}

