/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers.utils;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreemarkerEntityFixer
implements TemplateMethodModelEx {
    private static final Pattern pat = Pattern.compile("&([a-zA-Z]+[;]*)", 2);

    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Wrong arguments");
        }
        Object obj = args.get(0);
        String correctStr = obj instanceof SimpleScalar ? FreemarkerEntityFixer.correction(((SimpleScalar)args.get(0)).getAsString()) : (obj instanceof String ? FreemarkerEntityFixer.correction((String)args.get(0)) : null);
        if (correctStr != null) {
            return new SimpleScalar(correctStr);
        }
        return null;
    }

    private static String correction(String xml) {
        Matcher mat = pat.matcher(xml);
        StringBuffer sb = new StringBuffer();
        while (mat.find()) {
            String m = mat.group(1);
            if (m.endsWith(";")) {
                mat.appendReplacement(sb, "&" + m);
                continue;
            }
            mat.appendReplacement(sb, "&amp;" + m);
        }
        mat.appendTail(sb);
        return sb.toString();
    }
}

