/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MimeTypeImageMapping {
    private static final Map<String, String> suffixMapping = MimeTypeImageMapping.createMap();

    private static Map<String, String> createMap() {
        HashMap<String, String[]> preMap = new HashMap<String, String[]>();
        String[] map = new String[]{"ar", "cpio", "shar", "lbr", "iso", "lbr", "mar", "tar", "bz2", "f", "gz", "lz", "lzma", "lzo", "rz", "sfark", "?q?", "?z?", "xz", "z", "infl", "??_", "7z", "s7z", "ace", "afa", "alz", "apk", "arc", "arj", "b1", "ba", "bh", "cab", "cfs", "cpt", "dar", "dd", "dgc", "dmg", "ear", "gca", "ha", "hki", "ice", "jar", "kgb", "lzh", "lza", "lzx", "pak", "partimg", "paq6", "paq7", "paq8", "pea", "pim", "pit", "qda", "rar", "rk", "sda", "sea", "sen", "sfx", "sit", "sitx", "sqx", "tbz2", "tlz", "uc", "uc0", "uc2", "ucn", "ur2", "ue2", "uca", "uha", "war", "wim", "xar", "xp3", "yz1", "zip", "zipx", "zoo", "zpaq", "zz"};
        preMap.put("archive", map);
        map = new String[]{"3gp", "act", "aiff", "aac", "amr", "au", "awb", "dct", "dss", "dvf", "flac", "gsm", "iklax", "ivs", "m4a", "m4p", "mmf", "mp3", "mpc", "msv", "oga", "opus", "ra", "raw", "sln", "tta", "vox", "wav", "wma", "wv"};
        preMap.put("audio", map);
        map = new String[]{"webm", "mkv", "flv", "fli", "flc", "ogv", "ogg", "drc", "mng", "avi", "mov", "qt", "wmv", "rm", "rmvb", "asf", "mp4", "m4p", "m4v", "mpg", "mp2", "mpeg", "mpg", "mpe", "mpv", "m2v", "m4v", "svi", "3pg", "3g2", "mxf", "roq", "nsv"};
        preMap.put("video", map);
        map = new String[]{"ani", "apng", "art", "bmp", "dib", "cin", "cpc", "cpt", "dpx", "ecw", "exr", "fits", "fit", "fts", "fpx", "gif", "icns", "ico", "cur", "ics", "ids", "iff", "lbm", "jbg", "jbig", "jng", "jpg", "jpeg", "jpe", "jif", "jfif", "jfi", "jp2", "j2k", "jpf", "jpx", "jpm", "mj2", "jxr", "hdp", "wdp", "mng", "miff", "pam", "pbm", "pbm", "pgm", "ppm", "pnm", "pcx", "pgf", "png", "psd", "psb", "psp", "qtvr", "ras", "sun", "hdr", "sgi", "tga", "tif", "tiff", "fp", "ct", "lw", "hc", "mp", "bp", "bl", "sd", "wbmp", "webp", "xbm", "xcf", "xpm", "xwd"};
        preMap.put("bitmap", map);
        map = new String[]{"ai", "cdr", "cgm", "dxf", "eva", "emf", "wmf", "wmz", "emz", "gbr", "svg", "svgz", "eps", "ps", "swf", "xaml", "pict", "pct", "pic", "xaml"};
        preMap.put("vector", map);
        map = new String[]{"ada", "as", "c", "cc", "cs", "cob", "chef", "cbl", "cpp", "php", "inc", "js", "css", "java", "rb", "ml", "pl", "cxx", "asm", "go", "cu", "d", "erl", "exw", "f", "f90", "ftn", "groovy", "haml", "hxx", "lisp", "fpp", "bas", "lsp", "py", "p", "sh", "erb", "psml", "as2proj", "awk", "csx", "has", "hs", "nsi", "rpy", "tk", "gs", "sed"};
        preMap.put("program", map);
        map = new String[]{"xml", "htm", "html", "xhtm", "xhtml", "rss", "atom"};
        preMap.put("xml", map);
        map = new String[]{"txt", "doc", "docx", "docm", "dotx", "dot", "sxg", "sxw", "stw", "odt", "pages", "wri", "log", "wpt", "gdoc", "nfo", "msg", "eml", "wps", "readme", "docxml", "pdf"};
        preMap.put("document", map);
        map = new String[]{"xls", "xlsx", "xlsb", "xlsm", "xlt", "xltx", "xltm", "sxc", "stc", "csv", "prn", "dif", "odc", "otp", "ods", "numbers", "gsheet", "wks", "123"};
        preMap.put("sheet", map);
        map = new String[]{"ppt", "pptx", "pptm", "sxi", "sti", "odp", "odt", "pot", "potx", "potm", "fodp"};
        preMap.put("presentation", map);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : preMap.entrySet()) {
            String filemap = (String)entry.getKey() + ".eis";
            for (String suffix : (String[])entry.getValue()) {
                if (result.containsKey(suffix)) continue;
                result.put(suffix, filemap);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static final String getImageFilename(String suffix) {
        String result = null;
        if (suffix != null && (result = suffixMapping.get(suffix.toLowerCase())) == null) {
            result = "binary.eis";
        }
        return result;
    }
}

