/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers.utils;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagemanipulator.area.Crop;
import java.util.List;

public final class StitchRendererUtils {
    public static Position getPosition(Parameters parameters) {
        Position pos = Position.RIGHT;
        if (parameters.contains(Parameters.FileImage.position)) {
            String posstr = parameters.get(Parameters.FileImage.position);
            pos = Position.valueOf(posstr.toUpperCase());
        }
        return pos;
    }

    public static Crop.CropPadPosition getAlignment(Parameters parameters) {
        Crop.CropPadPosition result = Crop.CropPadPosition.CC;
        if (parameters.contains(Parameters.FileImage.align)) {
            String alignStr = parameters.get(Parameters.FileImage.align).toUpperCase();
            if (alignStr.equals("LEFT")) {
                result = Crop.CropPadPosition.CL;
            } else if (alignStr.equals("RIGHT")) {
                result = Crop.CropPadPosition.CR;
            } else if (alignStr.equals("TOP")) {
                result = Crop.CropPadPosition.TC;
            } else if (alignStr.equals("BOTTOM")) {
                result = Crop.CropPadPosition.BC;
            }
        }
        return result;
    }

    public static long getLatestLastModified(List<ImageMetaData> metadatalist) {
        long lm = 0L;
        for (ImageMetaData imd : metadatalist) {
            lm = Math.max(lm, imd.getLastModified());
        }
        return lm;
    }

    public static Pair<Integer, Integer> getTotalDimensions(List<ImageMetaData> metadatalist, Parameters parameters) {
        int width = 0;
        int height = 0;
        Position pos = StitchRendererUtils.getPosition(parameters);
        if (pos == Position.RIGHT) {
            for (ImageMetaData imd : metadatalist) {
                width += imd.getWidth();
                if (height >= imd.getHeight()) continue;
                height = imd.getHeight();
            }
        } else {
            for (ImageMetaData imd : metadatalist) {
                height += imd.getHeight();
                if (width >= imd.getWidth()) continue;
                width = imd.getWidth();
            }
        }
        return new Pair<Integer, Integer>(width, height);
    }

    public static enum Position {
        RIGHT,
        BOTTOM;

    }
}

