/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.requesthandlers;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;

public abstract class RequestHandler {
    protected final RequestProcessorSettings settings;
    protected final StorageHelperV1002 storageHelper;

    public RequestHandler(RequestProcessorSettings settings) {
        this.settings = settings;
        this.storageHelper = settings.getStorageHelper();
    }

    protected String getUsername(HttpSession session) throws NotConfiguredException {
        String sessionid;
        String result = null;
        UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
        if (uai != null && session != null && uai.validateSession(sessionid = (String)session.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.VALID) {
            result = uai.getUser(sessionid);
        }
        return result;
    }

    protected Set<String> getGroups(HttpSession session) throws NotConfiguredException {
        Set<Object> sessionGroups = new HashSet<Group>();
        UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
        if (uai == null) {
            return null;
        }
        if (session != null) {
            String sessionid = (String)session.getAttribute("id");
            sessionGroups = this.getGroupsForUser(uai, uai.getUser(sessionid));
        }
        sessionGroups.add(uai.getGroups().get("public"));
        HashSet<String> result = new HashSet<String>();
        for (Group group : sessionGroups) {
            result.add(group.getName());
        }
        return result;
    }

    protected PermissionSet getPublicPermissions(SourceConnectorReader connector) throws NotConfiguredException {
        UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
        if (uai == null) {
            return null;
        }
        Group publicGroup = uai.getGroups().get("public");
        PermissionSet result = connector.getAccessPermissions().get(publicGroup);
        if (result == null) {
            result = PermissionSet.getEmptyPermissionSet();
        }
        return result;
    }

    private Set<Group> getGroupsForUser(UserAuthenticationInterface uai, String username) {
        HashSet<Group> sessionGroups = new HashSet<Group>();
        Collection<Group> groups = uai.getGroups().values();
        for (Group g : groups) {
            Set<String> users = g.getUsers();
            if (!users.contains(username)) continue;
            sessionGroups.add(g);
        }
        return sessionGroups;
    }
}

