/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.requesthandlers;

import com.neptunelabs.fsiframework.helpers.URLDecoderFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.RequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class StaticFileRequestHandler
extends RequestHandler {
    public StaticFileRequestHandler(RequestProcessorSettings settings) {
        super(settings);
    }

    private void setPredefinedResponseHeaders(String assetURLPath, CacheableHttpServletResponse hsrc, String defaultHeadersname) {
        if (assetURLPath == null) {
            return;
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        if (connector == null) {
            return;
        }
        Map<String, String> forceHeaders = this.settings.getHeaderSet(connector.getForceHeadersName());
        if (forceHeaders != null) {
            this.transferHeaders(forceHeaders, hsrc);
        } else {
            String connectorHeadersName = connector.getHeadersName();
            if (connectorHeadersName == null && defaultHeadersname != null) {
                connectorHeadersName = defaultHeadersname;
            }
            Map<String, String> headers = this.settings.getHeaderSet(connectorHeadersName);
            this.transferHeaders(headers, hsrc);
        }
    }

    private void transferHeaders(Map<String, String> headerSet, CacheableHttpServletResponse hsrc) {
        if (headerSet != null) {
            for (Map.Entry<String, String> header : headerSet.entrySet()) {
                hsrc.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    public void handleRequest(HttpServletRequest request, CacheableHttpServletResponse hsrc) {
        block37: {
            hsrc.setCachable(false);
            String path = request.getPathInfo();
            try {
                String cEnc = request.getCharacterEncoding();
                if (cEnc == null) {
                    cEnc = "UTF-8";
                }
                Charset charset = Charset.forName(cEnc);
                String decodedPath = URLDecoderFast.decode(path, charset);
                PermissionSet ps = this.settings.getUserAuthenticationInterface().getPermissions(decodedPath, request.getSession(false), true);
                if (ps.read.files.booleanValue()) {
                    String[] splitPath = StorageHelperV1002.splitAssetURLPath(decodedPath);
                    String profileStr = URLDecoderFast.decode(splitPath[0], charset);
                    String urlRestStr = URLDecoderFast.decode(splitPath[1], charset);
                    SourceConnectorReader sourceConnector = this.settings.getSourceConnector(profileStr);
                    this.setPredefinedResponseHeaders(decodedPath, hsrc, "static.default");
                    if (sourceConnector != null && sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
                        Path targetFile = sourceConnector.getInboxDirectory().resolve(urlRestStr);
                        if (Files.exists(targetFile, new LinkOption[0])) {
                            if (Files.isReadable(targetFile)) {
                                int status = 0;
                                long[] range = null;
                                try {
                                    range = this.getRequestRange(request);
                                }
                                catch (NumberFormatException e) {
                                    status = 416;
                                }
                                hsrc.setHeader("Accept-Ranges", "bytes");
                                String mimeType = this.settings.getServletContext().getMimeType(targetFile.getFileName().toString().toLowerCase());
                                if (mimeType != null) {
                                    hsrc.setHeader("Content-Type", mimeType);
                                }
                                hsrc.setLastModified(FileOperations.getSafeLastModified(targetFile));
                                long targetLength = Files.size(targetFile);
                                long startPos = 0L;
                                long endPos = targetLength - 1L;
                                if (range != null) {
                                    if (range[0] > 0L && (startPos = range[0]) == -1L) {
                                        startPos = 0L;
                                    }
                                    if (range[1] != -1L && (endPos = range[1]) == -1L) {
                                        endPos = targetLength - 1L;
                                    }
                                    status = 206;
                                    if (endPos >= targetLength) {
                                        endPos = targetLength - 1L;
                                    }
                                    if (startPos > endPos) {
                                        status = 416;
                                    } else if (targetLength < Integer.MAX_VALUE) {
                                        hsrc.setHeader("Content-Range", "bytes " + startPos + "-" + endPos + "/" + targetLength);
                                    } else {
                                        hsrc.setHeader("Content-Range", "bytes " + startPos + "-" + endPos);
                                    }
                                } else if (status == 0) {
                                    status = 200;
                                }
                                hsrc.setStatus(status);
                                if (status == 416) break block37;
                                try (SeekableByteChannel fc = Files.newByteChannel(targetFile, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
                                    fc.position(startPos);
                                    long remained = endPos - startPos + 1L;
                                    if (remained < Integer.MAX_VALUE) {
                                        hsrc.setContentLength((int)remained);
                                    }
                                    byte[] outBuffer = new byte[8192];
                                    ByteBuffer bb = ByteBuffer.wrap(outBuffer);
                                    int readed = 0;
                                    while (remained > 0L && readed != -1) {
                                        readed = fc.read(bb);
                                        if (remained > (long)readed) {
                                            hsrc.write(outBuffer, false);
                                        } else {
                                            hsrc.write(outBuffer, 0, (int)remained, false);
                                        }
                                        remained -= (long)readed;
                                        bb.clear();
                                    }
                                    break block37;
                                }
                            }
                            hsrc.setStatus(403);
                            break block37;
                        }
                        hsrc.setStatus(404);
                        break block37;
                    }
                    hsrc.setStatus(404);
                    break block37;
                }
                hsrc.setStatus(403);
            }
            catch (NotConfiguredException e) {
                hsrc.setStatus(503);
            }
            catch (IOException e) {
                hsrc.setStatus(500);
                this.settings.getFSILogger().logException(e, 3256, request.getRequestURI(), e.getLocalizedMessage());
            }
        }
    }

    private long[] getRequestRange(HttpServletRequest request) {
        long[] result = null;
        String range = request.getHeader("range");
        if (range != null) {
            result = new long[]{-1L, -1L};
            String[] bs = range.split("=", 2);
            if (bs[0].equalsIgnoreCase("bytes") && bs.length == 2) {
                String rangeStr = bs[1];
                String[] rangeStrSplit = rangeStr.split("-", 2);
                if (rangeStrSplit.length == 1) {
                    result[0] = rangeStrSplit[0].startsWith("-") ? Long.parseLong(rangeStrSplit[0].substring(1)) : Long.parseLong(rangeStrSplit[0]);
                } else if (rangeStrSplit.length == 2) {
                    if (rangeStrSplit[0].length() > 0) {
                        result[0] = Long.parseLong(rangeStrSplit[0]);
                    }
                    if (rangeStrSplit[1].length() > 0) {
                        result[1] = Long.parseLong(rangeStrSplit[1]);
                    }
                }
            }
        }
        return result;
    }
}

