/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.neptunelabs.fsiframework.helpers.ColorParser;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.requestprocessor.MetaDataSource;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.renderers.ImageLicenceRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardDirectoryImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardInfoRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardListRenderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Renderer {
    private final String name;
    private final RequestProcessorSettings settings;
    private RendererAbstract imageRenderer;
    private RendererAbstract directoryImageRenderer;
    private RendererAbstract infoRenderer;
    private RendererAbstract listRenderer;
    private RendererAbstract licenceRenderer;
    private boolean imageRendererDeclarationFound = false;
    private boolean directoryImageRendererDeclarationFound = false;
    private boolean infoRendererDeclarationFound = false;
    private boolean listRendererDeclarationFound = false;
    private List<MetaDataSource> metaDataSources = new ArrayList<MetaDataSource>();
    private boolean fatalErrors = false;
    private OutputFormat outputFormat;
    private OutputParameters outputParameters;
    private final List<String> outputeffects = new ArrayList<String>();
    private String outputEffectsChecksum = null;
    private boolean enabled = true;

    protected Renderer(RequestProcessorSettings settings, boolean isLicenceRenderer) {
        this.settings = settings;
        if (!isLicenceRenderer) {
            this.name = "_private";
            this.outputFormat = OutputFormat.JPEG;
            this.imageRenderer = new StandardImageRenderer(settings, this.name);
            this.imageRenderer.addAllowedGroup("public");
            this.imageRenderer.setOption("keepAspectRatio", "true");
            this.directoryImageRenderer = new StandardDirectoryImageRenderer(settings, this.name);
            this.infoRenderer = new StandardInfoRenderer(settings, this.name);
            this.infoRenderer.addAllowedGroup("public");
            this.listRenderer = new StandardListRenderer(settings, this.name);
        } else {
            this.name = "_licence";
            this.outputFormat = OutputFormat.PNG;
            this.licenceRenderer = new ImageLicenceRenderer(settings, this.name);
        }
        this.outputParameters = new OutputParameters();
        this.enabled = true;
    }

    protected Renderer(RequestProcessorSettings settings, Path rendererFile) {
        this.settings = settings;
        String lname = rendererFile.getFileName().toString().toLowerCase();
        if (lname.endsWith(".xml")) {
            lname = lname.substring(0, lname.length() - 4);
        }
        this.name = lname;
        Document doc = FileOperations.getXMLFileContent(settings.getFSILogger(), rendererFile);
        if (doc != null) {
            Element rootnode = doc.getDocumentElement();
            NodeList nodelist = rootnode.getChildNodes();
            HashMap<String, String> imageRendererOptions = new HashMap<String, String>();
            HashMap<String, String> directoryImageRendererOptions = new HashMap<String, String>();
            HashMap<String, String> infoRendererOptions = new HashMap<String, String>();
            HashMap<String, String> listRendererOptions = new HashMap<String, String>();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node sectionNode = nodelist.item(i);
                String nodename = sectionNode.getNodeName().toLowerCase();
                if (nodename.equalsIgnoreCase("enabled")) {
                    this.enabled = Boolean.parseBoolean(sectionNode.getTextContent());
                    continue;
                }
                if (nodename.equalsIgnoreCase("renderer") || nodename.equalsIgnoreCase("imagerenderer")) {
                    this.readImageRendererNode(sectionNode, imageRendererOptions);
                    this.imageRendererDeclarationFound = true;
                    continue;
                }
                if (nodename.equalsIgnoreCase("directoryimagerenderer")) {
                    this.readImageRendererNode(sectionNode, directoryImageRendererOptions);
                    this.directoryImageRendererDeclarationFound = true;
                    continue;
                }
                if (nodename.equalsIgnoreCase("inforenderer")) {
                    this.readInfoRendererNode(sectionNode, infoRendererOptions);
                    continue;
                }
                if (nodename.equalsIgnoreCase("listrenderer")) {
                    this.readListRendererNode(sectionNode, listRendererOptions);
                    continue;
                }
                if (sectionNode.getNodeName().equalsIgnoreCase("outputcompression") || sectionNode.getNodeName().equalsIgnoreCase("output")) {
                    this.outputParameters = this.readOutputNode(sectionNode, rendererFile);
                    continue;
                }
                if (!sectionNode.getNodeName().equalsIgnoreCase("outputeffects")) continue;
                this.readOutputEffectsNode(sectionNode);
            }
            this.initImageRenderer(this.name, imageRendererOptions);
            this.initDirectoryImageRenderer(this.name, directoryImageRendererOptions);
            this.initInfoRenderer(this.name, infoRendererOptions);
            this.initListRenderer(this.name, listRendererOptions);
            if (this.outputFormat == null || this.outputParameters == null) {
                settings.getFSILogger().log(2025, this.name);
                this.fatalErrors = true;
            }
        }
        if (this.fatalErrors) {
            this.enabled = false;
        }
    }

    private void readOutputEffectsNode(Node sectionNode) {
        NodeList effectslist = sectionNode.getChildNodes();
        for (int j = 0; j < effectslist.getLength(); ++j) {
            Node effectNode = effectslist.item(j);
            if (!effectNode.getNodeName().equalsIgnoreCase("effect")) continue;
            this.outputeffects.add(effectNode.getTextContent());
        }
        this.outputEffectsChecksum = null;
    }

    private OutputParameters readOutputNode(Node sectionNode, Path rendererFile) {
        OutputParameters cp = new OutputParameters();
        NodeList compressionSettings = sectionNode.getChildNodes();
        for (int j = 0; j < compressionSettings.getLength(); ++j) {
            Node cs = compressionSettings.item(j);
            if (cs.getNodeName().equalsIgnoreCase("compressor") || cs.getNodeName().equalsIgnoreCase("format")) {
                String compressorname = cs.getTextContent().toUpperCase();
                if (compressorname.equals("JPG")) {
                    compressorname = "JPEG";
                }
                this.outputFormat = OutputFormat.valueOf(compressorname);
                continue;
            }
            boolean error = false;
            String key = cs.getNodeName().toLowerCase();
            String value = cs.getTextContent();
            if (key.equals("quality")) {
                try {
                    cp.quality = Integer.parseInt(value);
                    if (cp.quality < 0 && cp.quality > 100) {
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            } else if (key.equals("compressionlevel")) {
                try {
                    cp.compressionLevel = Integer.parseInt(value);
                    if (cp.compressionLevel < 0 && cp.compressionLevel > 9) {
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            } else if (key.equals("compressionfilter")) {
                if (value.equals("none") || value.equals("0")) {
                    cp.compressionFilter = 0;
                } else if (value.equals("sub") || value.equals("1")) {
                    cp.compressionFilter = 1;
                } else {
                    error = true;
                }
            } else if (key.equals("chromasubsampling")) {
                if (value.equals("4:2:0")) {
                    cp.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS420;
                } else if (value.equals("4:2:2")) {
                    cp.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS422;
                } else if (value.equals("4:4:4")) {
                    cp.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS444;
                } else {
                    error = true;
                }
            } else if (key.equals("optimizehuffman")) {
                cp.optimizeHuffman = Boolean.getBoolean(value);
            } else if (key.equals("dpi")) {
                try {
                    cp.dpi = Integer.parseInt(value);
                    if (cp.dpi < 0 && cp.dpi > 25600) {
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            } else if (key.equals("encoding")) {
                try {
                    cp.encoding = OutputParameters.Encoding.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("colorspace")) {
                try {
                    cp.colorspace = OutputParameters.Colorspace.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("embedicc")) {
                try {
                    cp.embedicc = Boolean.valueOf(value.toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("backgroundcolor")) {
                try {
                    cp.backgroundColor = ColorParser.parseColor(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("maxcolors")) {
                try {
                    cp.maxIndexedColors = Integer.parseInt(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("serpentine")) {
                try {
                    cp.useFloydSerpentine = Boolean.parseBoolean(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("ditherer")) {
                try {
                    cp.ditherer = ImageEncoderUtils.DithererMode.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("quantizer")) {
                try {
                    cp.quantizer = ImageEncoderUtils.QuantizerMode.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("quantizersampledepth")) {
                try {
                    cp.quantizerSampleDepth = Integer.parseInt(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("loop")) {
                try {
                    cp.gifLoopCount = Integer.parseInt(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("delay")) {
                try {
                    cp.gifDelay = Integer.parseInt(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            } else if (key.equals("framepalette")) {
                try {
                    cp.gifFramePalette = Boolean.parseBoolean(value);
                }
                catch (IllegalArgumentException e) {
                    error = true;
                }
            }
            if (!error) continue;
            this.settings.getFSILogger().log(3043, value, key, rendererFile);
            break;
        }
        return cp;
    }

    private void readListRendererNode(Node sectionNode, Map<String, String> listRendererOptions) {
        NodeList rendererDetails = sectionNode.getChildNodes();
        for (int j = 0; j < rendererDetails.getLength(); ++j) {
            this.listRendererDeclarationFound = true;
            Node rd = rendererDetails.item(j);
            listRendererOptions.put(rd.getNodeName().toLowerCase(), rd.getTextContent());
        }
    }

    private void readImageRendererNode(Node sectionNode, Map<String, String> imageRendererOptions) {
        NodeList rendererDetails = sectionNode.getChildNodes();
        for (int j = 0; j < rendererDetails.getLength(); ++j) {
            Node rd = rendererDetails.item(j);
            imageRendererOptions.put(rd.getNodeName().toLowerCase(), rd.getTextContent());
        }
    }

    private void readInfoRendererNode(Node sectionNode, Map<String, String> infoRendererOptions) {
        NodeList rendererDetails = sectionNode.getChildNodes();
        for (int j = 0; j < rendererDetails.getLength(); ++j) {
            this.infoRendererDeclarationFound = true;
            Node rd = rendererDetails.item(j);
            infoRendererOptions.put(rd.getNodeName().toLowerCase(), rd.getTextContent());
        }
    }

    private void initImageRenderer(String rendererName, Map<String, String> imageRendererOptions) {
        if (this.imageRendererDeclarationFound) {
            if (imageRendererOptions.containsKey("implementation")) {
                String implementation = "com.neptunelabs.fsiserver.requestprocessor.renderers." + imageRendererOptions.get("implementation");
                imageRendererOptions.remove("implementation");
                try {
                    Constructor<?> cst = Class.forName(implementation).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] arguments = new Object[]{this.settings, this.name};
                    this.imageRenderer = (RendererAbstract)cst.newInstance(arguments);
                }
                catch (NoSuchMethodException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (ClassNotFoundException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InvocationTargetException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InstantiationException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (IllegalAccessException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
            } else {
                this.imageRenderer = new StandardImageRenderer(this.settings, this.name);
            }
            if (!this.fatalErrors) {
                this.setupAllowedGroups(imageRendererOptions, this.imageRenderer, this.name);
                for (Map.Entry<String, String> e : imageRendererOptions.entrySet()) {
                    this.imageRenderer.setOption(e.getKey(), e.getValue());
                }
            }
        }
    }

    private void setupAllowedGroups(Map<String, String> rendererOptions, RendererAbstract renderer, String name) {
        if (rendererOptions.containsKey("allowedgroups")) {
            String[] groups;
            String groupsList = rendererOptions.get("allowedgroups");
            for (String group : groups = groupsList.split(",")) {
                renderer.addAllowedGroup(group.trim());
            }
            rendererOptions.remove("allowedgroups");
        } else {
            this.settings.getFSILogger().log(2049, name);
        }
    }

    private void initDirectoryImageRenderer(String rendererName, Map<String, String> imageRendererOptions) {
        if (this.directoryImageRendererDeclarationFound) {
            if (imageRendererOptions.containsKey("implementation")) {
                String implementation = "com.neptunelabs.fsiserver.requestprocessor.renderers." + imageRendererOptions.get("implementation");
                imageRendererOptions.remove("implementation");
                try {
                    Constructor<?> cst = Class.forName(implementation).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] arguments = new Object[]{this.settings, this.name};
                    this.directoryImageRenderer = (RendererAbstract)cst.newInstance(arguments);
                }
                catch (NoSuchMethodException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (ClassNotFoundException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InvocationTargetException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InstantiationException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (IllegalAccessException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
            } else {
                this.directoryImageRenderer = new StandardDirectoryImageRenderer(this.settings, this.name);
            }
            if (!this.fatalErrors) {
                this.setupAllowedGroups(imageRendererOptions, this.directoryImageRenderer, this.name);
                for (Map.Entry<String, String> e : imageRendererOptions.entrySet()) {
                    this.directoryImageRenderer.setOption(e.getKey(), e.getValue());
                }
            }
        }
    }

    private void initInfoRenderer(String rendererName, Map<String, String> infoRendererOptions) {
        if (this.infoRendererDeclarationFound) {
            if (infoRendererOptions.containsKey("implementation")) {
                String implementation = "com.neptunelabs.fsiserver.requestprocessor.renderers." + infoRendererOptions.get("implementation");
                infoRendererOptions.remove("implementation");
                try {
                    Constructor<?> cst = Class.forName(implementation).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] arguments = new Object[]{this.settings, this.name};
                    this.infoRenderer = (RendererAbstract)cst.newInstance(arguments);
                }
                catch (NoSuchMethodException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (ClassNotFoundException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InvocationTargetException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InstantiationException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (IllegalAccessException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
            } else {
                this.infoRenderer = new StandardInfoRenderer(this.settings, this.name);
            }
            if (!this.fatalErrors) {
                this.setupAllowedGroups(infoRendererOptions, this.infoRenderer, this.name);
                for (Map.Entry<String, String> e : infoRendererOptions.entrySet()) {
                    this.infoRenderer.setOption(e.getKey(), e.getValue());
                }
            }
        }
    }

    private void initListRenderer(String rendererName, Map<String, String> listRendererOptions) {
        if (this.listRendererDeclarationFound) {
            if (listRendererOptions.containsKey("implementation")) {
                String implementation = "com.neptunelabs.fsiserver.requestprocessor.renderers." + listRendererOptions.get("implementation");
                listRendererOptions.remove("implementation");
                try {
                    Constructor<?> cst = Class.forName(implementation).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] arguments = new Object[]{this.settings, this.name};
                    this.listRenderer = (RendererAbstract)cst.newInstance(arguments);
                }
                catch (NoSuchMethodException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (ClassNotFoundException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InvocationTargetException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (InstantiationException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
                catch (IllegalAccessException e) {
                    this.settings.getFSILogger().log(2031, implementation, rendererName);
                    this.fatalErrors = true;
                }
            } else {
                this.listRenderer = new StandardListRenderer(this.settings, this.name);
            }
            if (!this.fatalErrors) {
                this.setupAllowedGroups(listRendererOptions, this.listRenderer, this.name);
                for (Map.Entry<String, String> e : listRendererOptions.entrySet()) {
                    this.listRenderer.setOption(e.getKey(), e.getValue());
                }
            }
        }
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public OutputParameters getOutputParameters() {
        return this.outputParameters;
    }

    public String getName() {
        return this.name;
    }

    boolean hasFatalErrors() {
        return this.fatalErrors;
    }

    public List<MetaDataSource> getMetaDataSources() {
        return this.metaDataSources;
    }

    public void setMetaDataSources(List<MetaDataSource> metaDataSources) {
        this.metaDataSources = metaDataSources;
    }

    public RendererAbstract getImageRenderer() {
        return this.imageRenderer != null ? this.imageRenderer : (this.licenceRenderer != null ? this.licenceRenderer : null);
    }

    public RendererAbstract getDirectoryImageRenderer() {
        return this.directoryImageRenderer;
    }

    public RendererAbstract getLicenceRenderer() {
        return this.licenceRenderer;
    }

    public RendererAbstract getInfoRenderer() {
        return this.infoRenderer;
    }

    public RendererAbstract getListRenderer() {
        return this.listRenderer;
    }

    public List<String> getOutputEffects() {
        return this.outputeffects;
    }

    public String getOutputEffectsChecksum() {
        if (this.outputEffectsChecksum == null) {
            this.outputEffectsChecksum = String.valueOf(this.outputeffects.hashCode());
        }
        return this.outputEffectsChecksum;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

