/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorGeneral;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorLicence;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorPerformance;
import com.neptunelabs.fsiserver.requestprocessor.LogWatcher;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.ServerOnlyAccessValidation;
import com.neptunelabs.fsiserver.requestprocessor.settings.SourceConnectorWatcher;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.HeadersReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiservletframework.freemarker.TemplateCache;
import com.neptunelabs.fsiservletframework.jmx.MBeanUtils;
import com.neptunelabs.fsiservletframework.settings.Section;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServlet;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RequestProcessorSettings
extends FSIServerSettings {
    private final Map<String, Renderer> renderers = new HashMap<String, Renderer>();
    private final HeadersReader headers;
    private SwapPool swapPool;
    private EffectsManager effectsManager = null;
    private ImageBuilder imagebuilder;
    private final CopyOnWriteArrayList<String> tileProcessList = new CopyOnWriteArrayList();
    private FileLockHandler lockHandler;
    private Path workDirectory;
    private SourceConnectorWatcher sourceConnectorWatcher;
    private SolrSearcher solrSearcher;
    private SearchDatabaseSolr solr;
    private final boolean useOwnLockHandler;
    private ServerOnlyAccessValidation fallbackAuthentication;
    private static final byte[] watermark = new byte[]{-92, 7, -6, 9, 8, 34, 17, -14, 60, 68, 14, 30, 60, -126, 0, 120, -30, 7, 31, 60, -126, -7, -24, 17, 40, -126, 34, -124, 36, 38, 65, 18, 18, 36, 64, 4, 17, 32, -119, 2, 36, 72, 17, -127, 18, -120, 34, 40, 66, 66, 100, 16, 33, 34, 40, 0, 65, 2, 8, 16, 34, 68, -127, 31, -111, 68, -126, 36, 68, 36, 37, 65, 2, 19, -63, 0, 7, 14, 32, 113, -13, -60, 79, -98, -128, -89, -56, 34, 124, 66, 66, 76, 16, 33, 32, 16, 48, 64, 18, 0, -112, 36, 40, -127, 40, 10, 68, -126, 36, 68, 36, 36, -63, 18, 18, 1, 0, 4, 17, 32, -119, 2, 34, -120, 17, -8, 72, 47, -100, -126, 66, 60, 68, 14, 30, 32, 16, 0, 64, -30, 7, 31, 34, 16, -7, 16};
    private TemplateCache templateCache;
    private final Map<String, LogWatcher> logwatchers = new HashMap<String, LogWatcher>();
    private boolean updatingLicence = false;
    private boolean migrationModeEnabled = true;

    public RequestProcessorSettings(HttpServlet servlet, FSILogger logger, boolean useOwnLockHandler, ServletFileEventCursor fileEventCursor) {
        super(servlet, true, fileEventCursor, false, true);
        this.setFSILogger(logger);
        SoftwareVersion.setSoftware(logger, new Version());
        this.useOwnLockHandler = useOwnLockHandler;
        this.initBackupDirectories();
        this.initViewableDirectories();
        this.setSettingsFile(this.getConfigHome().resolve("requestprocessor.xml"));
        try {
            this.setLicenceFile(this.getLicenceLocation(), 22, 3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.headers = new HeadersReader(logger);
        this.initDefaults();
        this.initProtectedDirs();
        this.writeOutLMR();
        if (useOwnLockHandler) {
            this.initFileLockHandler();
        }
    }

    protected RequestProcessorSettings(FSILogger logger, ServletFileEventCursor fileEventCursor) {
        super(null, false, fileEventCursor, false, true);
        this.setFSILogger(logger);
        SoftwareVersion.setSoftware(logger, new Version());
        this.headers = new HeadersReader(logger);
        this.useOwnLockHandler = true;
        this.initFileLockHandler();
    }

    private void writeOutLMR() {
        String lmr = this.systemInformation.getLMR();
        int lineLen = 70;
        StringBuilder sb = new StringBuilder();
        int lines = (int)Math.ceil((float)lmr.length() / 70.0f);
        for (int l = 0; l < lines; ++l) {
            int beginIndex = l * 70;
            int endIndex = l + 1 < lines ? (l + 1) * 70 : lmr.length();
            sb.append(lmr.substring(beginIndex, endIndex));
            sb.append(System.getProperty("line.separator"));
        }
        String lmrStr = sb.toString();
        byte[] lmrBytes = lmrStr.getBytes(FileOperations.charsetUTF8);
        FileOperations.writeFile(this.logger, this.getConfigHome().resolve(Defines.LMR_FILENAME), lmrBytes);
    }

    private void initFileLockHandler() {
        this.lockHandler = new FileLockHandler();
    }

    @Override
    public FileLockHandler getFileLockHandler() {
        if (this.useOwnLockHandler) {
            return this.lockHandler;
        }
        return (FileLockHandler)this.servletContext.getAttribute("com.neptunelabs.fsiserver.utils.FileLockHandler");
    }

    private void initBackupDirectories() {
        this.addBackupDir("/viewer/", true);
        this.addBackupDir("/users/", true);
        this.addBackupDir("/js/", true);
        this.addBackupDir("/");
        this.addBackupDir("/WEB-INF/");
        this.addBackupDir("/WEB-INF/renderers");
        this.addBackupDir("/WEB-INF/config");
        this.addBackupDir("configHome", true);
    }

    private void initViewableDirectories() {
        this.addViewableDir("/viewer/", true);
        this.addViewableDir("/users/", true);
        this.addViewableDir("/js/", true);
        this.addViewableDir("/WEB-INF/");
        this.addViewableDir("/WEB-INF/renderers");
        this.addViewableDir("/WEB-INF/config");
        this.addViewableDir("/configHome/", true);
    }

    public void init() {
        this.initWorkDirectory();
        this.setupSolrSearcher();
        if (this.serverUsesOwnCacheManager) {
            this.initLogWatcher();
        }
    }

    public void initImageBuilders() {
        this.imagebuilder = new ImageBuilder(this, this.getSwapPool(), this.tileProcessList, this.getStorageLocation());
    }

    private void initWorkDirectory() {
        Path tempDir;
        Path tempDirFile;
        String tempDirStr;
        Path regularTempDir = this.getTempDirectory();
        if (Files.notExists(regularTempDir, new LinkOption[0])) {
            try {
                Files.createDirectories(regularTempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                regularTempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                this.logger.log(2010, regularTempDir);
            }
        }
        if ((tempDirStr = this.getPrefsString("application", "tempdirectory")) == null || tempDirStr.equals("") || tempDirStr.equalsIgnoreCase("auto")) {
            tempDirStr = regularTempDir.toAbsolutePath().toString();
        }
        if (Files.notExists(tempDirFile = !(tempDir = Paths.get(tempDirStr, new String[0])).isAbsolute() ? ServletUtils.getRealPath(this.servletContext, tempDir.toString()) : tempDir, new LinkOption[0])) {
            tempDirFile = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        }
        this.workDirectory = tempDirFile.resolve("requestprocessor");
        if (Files.notExists(this.workDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.workDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.log(3199, this.workDirectory);
            }
        } else {
            try {
                FileOperations.deleteDir(this.workDirectory);
                Files.createDirectories(this.workDirectory, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Path getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public boolean useOwnCacheManager() {
        return this.serverUsesOwnCacheManager;
    }

    public void setEffectsManager(EffectsManager effectsManager) {
        this.effectsManager = effectsManager;
    }

    public EffectsManager getEffectsManager() {
        return this.effectsManager;
    }

    public SwapPool getSwapPool() {
        return this.swapPool;
    }

    public void setSwapPool(SwapPool swapPool) {
        this.swapPool = swapPool;
    }

    public ImageBuilder getImageBuilder() {
        return this.imagebuilder;
    }

    public DownloadJobProcessor getJobProcessor() {
        Object o = this.servletContext.getAttribute("JobProcessor");
        if (o instanceof DownloadJobProcessor) {
            return (DownloadJobProcessor)o;
        }
        return null;
    }

    private void initDefaults() {
        HashMap<String, Section> defaultSections = new HashMap<String, Section>();
        Section application = new Section(Section.SectionTypes.valueNames);
        application.enable(true);
        application.put("storage", this.getWebInfPath() + "/storage");
        application.put("storagehasher", "crc32");
        application.put("requestprocessortokens", "prod");
        application.put("sourcemanager", "");
        application.put("copyrightnotice", SoftwareVersion.getVendor());
        application.put("cachetemplates", "true");
        application.put("maxcpu", "auto");
        application.put("maxio", Integer.toString(2));
        application.put("maxthreadsperjob", "auto");
        application.put("forcecputhreads", "");
        application.put("forceiothreads", "");
        application.put("forcethreadsperjob", "");
        application.put("tempdirectory", "auto");
        application.put("byteorder", "little_endian");
        application.put("jmx", "false");
        application.put("priority", "normal");
        application.put("corsAllowedOrigins", "*");
        application.put("corsAllowedMethods", "GET, POST, HEAD, OPTIONS");
        application.put("corsAllowedHeaders", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers");
        application.put("corsExposedHeaders", "");
        application.put("corsPreflightMaxage", "1800");
        application.put("corsSupportCredentials", "true");
        application.put("corsRequestDecorate", "true");
        defaultSections.put("application", application);
        Section cache = new Section(Section.SectionTypes.valueNames);
        cache.put("maxmemory", "auto");
        cache.put("directmemory", "false");
        cache.put("l1", "true");
        cache.put("l1size", "1000");
        cache.put("l2", "true");
        cache.put("response", "true");
        cache.put("packasync", "true");
        defaultSections.put("cache", cache);
        Section cms = new Section(Section.SectionTypes.valueNames);
        cms.enable(true);
        cms.put("defaultcmykprofile", "auto");
        cms.put("defaultrgbprofile", "auto");
        cms.put("defaultgrayprofile", "auto");
        cms.put("fallbackiccconversion", "true");
        defaultSections.put("colormanagementsystem", cms);
        Section protection = new Section(Section.SectionTypes.valueNames);
        protection.enable(true);
        protection.put("defaultrenderer", "default");
        protection.put("defaultwidth", String.valueOf(400));
        protection.put("defaultheight", String.valueOf(300));
        protection.put("maxwidth", String.valueOf(5120));
        protection.put("maxheight", String.valueOf(2880));
        protection.put("sortcollator", "auto");
        defaultSections.put("limits", protection);
        Section database = new Section(Section.SectionTypes.valueNames);
        database.enable(false);
        database.put("type", "solr");
        database.put("solrserveruri", "http://localhost/solr");
        database.put("core", "fsi-server-3");
        database.put("authentication", "false");
        database.put("authenticationtype", "basic");
        database.put("authenticationusername", "");
        database.put("authenticationpassword", "");
        database.put("proxy", "false");
        database.put("proxyhostname", "");
        database.put("proxyport", "80");
        database.put("proxyssl", "false");
        database.put("proxyauthentication", "false");
        database.put("proxyusername", "");
        database.put("proxypassword", "");
        database.put("connectionpoolmax", "500");
        defaultSections.put("search", database);
        this.setDefaultSection(defaultSections);
    }

    private void initProtectedDirs() {
        this.addProtectedDir(this.getConfigHome());
    }

    public boolean hasEnabledRenderer(String rendererName) {
        return this.getEnabledRenderer(rendererName) != null;
    }

    public Renderer getRenderer(String renderername) {
        return this.renderers.get(renderername);
    }

    public Renderer getEnabledRenderer(String renderername) {
        Renderer result = this.renderers.get(renderername);
        return result != null && result.isEnabled() ? result : null;
    }

    public Map<String, Renderer> getRenderers() {
        return this.renderers;
    }

    public String getImageCopyright() {
        return this.getPrefsString("application", "copyrightNotice");
    }

    private void initLogWatcher() {
        if (!this.hasLogWatcher(this.getStorageLocationPath())) {
            this.addLogWatcher(new LogWatcher(this));
        }
    }

    private void setupSolrSearcher() {
        String name = "FSI-Solr-Updater";
        this.solr = new SearchDatabaseSolr(this.logger, "FSI-Solr-Updater");
        this.solrSearcher = new SolrSearcher(this.solr);
        if (this.hasSectionEnabled("search")) {
            String dbType = this.getPrefsString("search", "type");
            if (dbType.equalsIgnoreCase("solr")) {
                try {
                    boolean proxy;
                    String solrServerURI = this.getPrefsString("search", "solrServerURI");
                    String core = this.getPrefsString("search", "core");
                    int maxConnections = this.getPrefsInt("search", "connectionpoolmax");
                    this.solr.setConnection(solrServerURI, core, maxConnections);
                    boolean authentication = this.getPrefsBoolean("search", "authentication");
                    if (authentication) {
                        String aType = this.getPrefsString("search", "authenticationType");
                        String aUsername = this.getPrefsString("search", "authenticationUsername");
                        String aPassword = this.getPrefsString("search", "authenticationPassword");
                        this.solr.setAuthentication(authentication, aType, aUsername, aPassword);
                    }
                    if (proxy = this.getPrefsBoolean("search", "proxy")) {
                        String proxyHostname = this.getPrefsString("search", "proxyHostname");
                        int proxyPort = this.getPrefsInt("search", "proxyPort");
                        boolean proxySSL = this.getPrefsBoolean("search", "proxySSL");
                        boolean proxyAuthentication = this.getPrefsBoolean("search", "proxyAuthentication");
                        String proxyUsername = this.getPrefsString("search", "proxyUsername");
                        String proxyPassword = this.getPrefsString("search", "proxyPassword");
                        this.solr.setProxy(proxy, proxyHostname, proxyPort, proxySSL, proxyAuthentication, proxyUsername, proxyPassword);
                    }
                    this.solr.init();
                    this.logger.log(3221, dbType);
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(3220, e.getLocalizedMessage());
                    this.solrSearcher = null;
                }
            } else {
                this.solrSearcher = null;
                this.logger.log(3210, "SearchDatabase", dbType);
            }
        } else {
            this.solrSearcher = null;
            this.logger.log(2046, new Object[0]);
        }
    }

    public SolrSearcher getSolrSearcher() {
        return this.solrSearcher;
    }

    public SearchDatabaseSolr getSearchDatabaseSolr() {
        return this.solr;
    }

    void cleanSourceConnector() {
        this.sourceConnectors.clear();
        this.fallbackAuthentication = null;
    }

    void addSourceConnector(String name, SourceConnectorReader profile) {
        this.sourceConnectors.put(name, profile);
        if (this.fallbackAuthentication != null) {
            // empty if block
        }
    }

    public void readHeadersDefinition() {
        this.headers.loadFromFile(this.getConfigHome().resolve("headers.xml"));
        this.servletContext.setAttribute("headers", (Object)this.headers);
        this.cacheManager.clearAll();
    }

    public final void initHeadersMonitor() {
        if (this.fileEventCursor != null) {
            FileEventCallback callback = new FileEventCallback(this, "readHeadersDefinition", null);
            ArrayList<FileEventCallback> callbacklist = new ArrayList<FileEventCallback>();
            callbacklist.add(callback);
            try {
                this.fileEventCursor.addPathMonitor(this.getConfigHome().resolve("headers.xml"), callbacklist);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, String> getHeaderSet(String nameOfSet) {
        if (nameOfSet != null) {
            return this.headers.getHeaderSet(nameOfSet);
        }
        return null;
    }

    public void readSourceConnectors() {
        if (this.sourceConnectorWatcher != null) {
            this.sourceConnectorWatcher.halt();
        }
        try {
            this.sourceConnectorWatcher = new SourceConnectorWatcher(this);
            this.sourceConnectorWatcher.start();
        }
        catch (NotConfiguredException e) {
            e.printStackTrace();
        }
    }

    public SourceConnectorReader getSourceConnector(String name) {
        if (name != null) {
            return (SourceConnectorReader)this.sourceConnectors.get(name);
        }
        return null;
    }

    public Set<String> getSourceConnectorNames() {
        return this.sourceConnectors.keySet();
    }

    public Path getRendererDirectory() {
        return this.getConfigHome().resolve("renderers");
    }

    public void readRenderers() {
        block13: {
            this.renderers.clear();
            Renderer builtin1 = new Renderer(this, false);
            this.renderers.put(builtin1.getName(), builtin1);
            Renderer builtin2 = new Renderer(this, true);
            this.renderers.put(builtin2.getName(), builtin2);
            Path renderersDirectory = this.getRendererDirectory();
            if (Files.isDirectory(renderersDirectory, new LinkOption[0])) {
                try {
                    List<PathCached> rendererFiles = FileOperations.listAllFiles(renderersDirectory, "*.xml");
                    if (rendererFiles != null && rendererFiles.size() > 0) {
                        for (PathCached file : rendererFiles) {
                            if (file.isRegularFile()) {
                                try {
                                    String rendererName = file.getFileName();
                                    this.logger.log(2055, rendererName);
                                    Renderer renderer = new Renderer(this, file.getPath());
                                    if (renderer.hasFatalErrors()) {
                                        this.logger.log(2027, rendererName);
                                    } else if (!renderer.isEnabled()) {
                                        this.logger.log(2033, rendererName);
                                    }
                                    if (this.renderers.containsKey(renderer.getName())) continue;
                                    this.renderers.put(renderer.getName(), renderer);
                                }
                                catch (Exception e) {
                                    this.logger.logException(e, 2042, file, e.getLocalizedMessage());
                                }
                                continue;
                            }
                            this.logger.log(2026, file);
                        }
                        break block13;
                    }
                    this.logger.log(2028, renderersDirectory);
                }
                catch (IOException e) {
                    this.logger.log(2028, renderersDirectory);
                }
            } else {
                this.logger.log(2029, renderersDirectory);
            }
        }
        CacheManager cm = this.getCacheManager();
        if (cm != null) {
            cm.clearAll();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.renderers.clear();
        for (LogWatcher l : this.logwatchers.values()) {
            l.halt();
        }
        this.logwatchers.clear();
        if (this.solr != null) {
            this.solr.halt();
        }
        if (this.sourceConnectorWatcher != null) {
            this.sourceConnectorWatcher.halt();
        }
        if (this.cacheManager != null) {
            this.cacheManager.dispose();
        }
    }

    public byte[] getWatermarkBytes() {
        return watermark;
    }

    public TemplateCache getTemplateCache() {
        return this.templateCache;
    }

    public void setTemplateCache(TemplateCache cache) {
        this.templateCache = cache;
    }

    private boolean hasLogWatcher(String location) {
        return this.logwatchers.containsKey(location);
    }

    private void addLogWatcher(LogWatcher logwatcher) {
        this.logwatchers.put(logwatcher.getStorageLocation().toAbsolutePath().toString(), logwatcher);
        logwatcher.start();
    }

    @Override
    public UserAuthenticationInterface getUserAuthenticationInterface() throws NotConfiguredException {
        Object o = this.servletContext.getAttribute("AuthenticationInterface");
        if (o instanceof UserAuthenticationInterface) {
            return (UserAuthenticationInterface)o;
        }
        if (this.fallbackAuthentication == null) {
            this.fallbackAuthentication = new ServerOnlyAccessValidation(this);
        }
        return this.fallbackAuthentication;
    }

    public Path getLicenceLocation() {
        return this.getConfigHome().resolve(Defines.LICENCE_FILENAME);
    }

    @Override
    public boolean isRestarting() {
        boolean restarting = super.isRestarting();
        if (!restarting) {
            restarting = this.updatingLicence;
        }
        return restarting;
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        this.updatingLicence = true;
        super.updateLicenceFromLicenceManager();
        if (this.servletContext != null) {
            CacheManager cm;
            if (this.useOwnCacheManager() && (cm = this.getCacheManager()) != null) {
                cm.clearAll();
            }
            this.updatingLicence = false;
        }
    }

    @Override
    public boolean isMigrationModeEnabled() {
        Object tmp;
        if (this.migrationModeEnabled && this.servletContext != null && (tmp = this.servletContext.getAttribute("V1001MigrationMode")) != null) {
            this.migrationModeEnabled = (Boolean)tmp;
        }
        return this.migrationModeEnabled;
    }

    @Override
    protected void initMBeans() {
        if (System.getProperty("com.sun.management.jmxremote") == null) {
            this.logger.log(2036, new Object[0]);
        } else if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            this.logger.log(2037, Integer.parseInt(System.getProperty("com.sun.management.jmxremote.port")));
        }
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=General", new FSIRequestProcessorGeneral(this.getSystemMonitor())));
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=Licence", new FSIRequestProcessorLicence(this)));
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=Performance", new FSIRequestProcessorPerformance(this.getSystemMonitor())));
    }

    public JSONObject getLicenceInfoAsJSON(Licence licenceValue, String containerHash) throws NotConfiguredException {
        return this.getLicenceInfoAsJSON(licenceValue, false, containerHash);
    }

    public JSONObject getLicenceInfoAsJSON(Licence licenceValue, boolean test, String containerHash) throws NotConfiguredException {
        try {
            JSONObject result = new JSONObject();
            FSIServerSettings.LicenceState ls = this.isLicensed(licenceValue, test);
            result.put("licence_state", (Object)ls.name().toLowerCase());
            result.put("hardwareid", (Object)this.systemInformation.getLMR());
            result.put("min-version", (Object)licenceValue.getNiceMinVersion());
            result.put("max-version", (Object)licenceValue.getNiceMaxVersion());
            result.put("licensee", (Object)licenceValue.getLicensee());
            result.put("pid", (Object)licenceValue.getPID());
            result.put("edition", (Object)licenceValue.getEdition());
            if (licenceValue.getFlagNFR()) {
                result.put("nfr", licenceValue.getFlagNFR());
            }
            if (licenceValue.getFlagNonProfit()) {
                result.put("non-profit", licenceValue.getFlagNonProfit());
            }
            result.put("jmx", licenceValue.isJMXEnabled());
            if (licenceValue.isStagingLicence()) {
                result.put("staging", licenceValue.isStagingLicence());
            }
            result.put("batch-processing", licenceValue.isBatchProcessingEnabled());
            result.put("mirror-licence", licenceValue.isMirrorLicence());
            result.put("trial-licence", licenceValue.isTrialLicence());
            result.put("register-date", licenceValue.getRegisterTime());
            JSONObject images = new JSONObject();
            images.put("current", this.getSystemMonitor().getAssetCount());
            images.put("max", licenceValue.getMaxImages());
            result.put("images", (Object)images);
            JSONObject connectors = new JSONObject();
            connectors.put("current", this.getSourceConnectorCount());
            connectors.put("max", licenceValue.getMaxConnectors());
            result.put("connectors", (Object)connectors);
            JSONObject groups = new JSONObject();
            groups.put("current", this.getUserAuthenticationInterface().getGroupCount());
            groups.put("max", licenceValue.getMaxUserGroups());
            result.put("groups", (Object)groups);
            if (licenceValue.getExpireTime() > 0L) {
                result.put("expires", licenceValue.getExpireTime());
            }
            JSONObject instancesObj = new JSONObject();
            instancesObj.put("current", this.getSystemMonitor().getServerInstances());
            instancesObj.put("max", licenceValue.getMaxInstances());
            result.put("instances", (Object)instancesObj);
            RawLicence rl = this.getLicenceManager().getRawLicence(101, 6);
            result.put("fsi_viewer", rl != null);
            Map<String, String> modules = licenceValue.getModules();
            if (modules.containsKey("PagesMobile") && Boolean.parseBoolean(modules.get("PagesMobile"))) {
                result.put("fsi_pages_mobile", true);
            }
            result.put("_container-hash", (Object)containerHash);
            return result;
        }
        catch (JSONException e) {
            return null;
        }
    }
}

