/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import org.w3c.dom.Document;

public class ServerOnlyAccessValidation
extends UserAuthenticationInterface {
    private final Path usersfile;
    private final Path groupsfile;

    public ServerOnlyAccessValidation(FSIServerSettings settings) throws NotConfiguredException {
        super(settings);
        Path metricsDir = this.storageHelper.getMetricsDir();
        this.usersfile = metricsDir.resolve("users.xml");
        this.groupsfile = metricsDir.resolve("groups.xml");
        this.permissionsetsDirectory = metricsDir.resolve("permissionsets");
        this.propertySetsDirectory = metricsDir.resolve("propertysets");
        this.publishingSetsDirectory = metricsDir.resolve("publishingsets");
        this.readPermissionConfig();
        this.readPropertyConfig();
        Path[] permissionRelevantFiles = new Path[]{this.usersfile, this.groupsfile};
        Path[] permissionRelevantDirectories = new Path[]{this.permissionsetsDirectory};
        this.setupMonitoring("readPermissionsConfig", permissionRelevantFiles, permissionRelevantDirectories);
        Path[] propertiesRelevantDirectories = new Path[]{this.propertySetsDirectory, this.publishingSetsDirectory};
        this.setupMonitoring("readPropertyConfig", null, propertiesRelevantDirectories);
    }

    @Override
    protected void readGroups() {
        this.groups.clear();
        Group publicgroup = new Group("public");
        this.groups.put("public", publicgroup);
        Group usersgroup = new Group("users");
        this.groups.put("users", usersgroup);
        try {
            Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), this.groupsfile);
            String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
            Groups rawgroups = XMLOperations.unmarshalJAXB(xml, Groups.class);
            for (Group group : rawgroups.getGroups()) {
                this.groups.put(group.getName(), group);
            }
        }
        catch (IOException dbe) {
            this.settings.getFSILogger().log(3240, this.groupsfile, dbe.getLocalizedMessage());
        }
    }

    @Override
    protected void readUsers() {
        this.users.clear();
        try {
            Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), this.usersfile);
            String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
            Users userlist = XMLOperations.unmarshalJAXB(xml, Users.class);
            Group usersgroup = (Group)this.groups.get("authenticated");
            if (usersgroup != null) {
                HashSet<String> authenticatedUsers = new HashSet<String>();
                for (Users.User u : userlist.users) {
                    authenticatedUsers.add(u.name);
                }
                usersgroup.setUsers(authenticatedUsers);
            }
            for (Users.User user : userlist.users) {
                this.users.add(user);
            }
        }
        catch (IOException dbe) {
            this.settings.getFSILogger().log(3241, this.usersfile, dbe.getLocalizedMessage());
        }
    }

    @Override
    protected boolean saveGroups() {
        throw new UnsupportedOperationException("Saving not permitted using this Authentication Interface.");
    }

    @Override
    protected boolean savePermissionSets() {
        throw new UnsupportedOperationException("Saving not permitted using this Authentication Interface.");
    }

    @Override
    protected boolean saveUsers() {
        throw new UnsupportedOperationException("Saving not permitted using this Authentication Interface.");
    }

    @Override
    public boolean duplicateGroup(String source, String target) {
        throw new UnsupportedOperationException("Saving not permitted using this Authentication Interface.");
    }

    @Override
    public boolean isUserModificationPossible() {
        return false;
    }
}

