/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SourceConnectorWatcher
extends Thread {
    private final RequestProcessorSettings settings;
    private final Path metricsDir;
    private volatile boolean runDaemon = true;
    private long lastCheckSum = 0L;
    private final Pattern filePattern = Pattern.compile("(.+)\\.xml\\.profile");

    SourceConnectorWatcher(RequestProcessorSettings settings) throws NotConfiguredException {
        this.settings = settings;
        this.metricsDir = settings.getStorageHelper().getMetricsDir();
        this.setDaemon(true);
        this.setName("Core Connector Watcher");
    }

    @Override
    public void run() {
        while (this.runDaemon) {
            try {
                Thread.sleep(5000L);
                try {
                    long newCheckSum = this.checkMetricsDir();
                    if (this.lastCheckSum == newCheckSum) continue;
                    this.readSourceConnectors();
                    this.lastCheckSum = newCheckSum;
                }
                catch (IOException iOException) {
                }
            }
            catch (NotConfiguredException | InterruptedException exception) {}
        }
    }

    public void halt() {
        this.runDaemon = false;
        this.interrupt();
    }

    private List<PathCached> getMetricsDirFileList() throws IOException {
        if (Files.isDirectory(this.metricsDir, new LinkOption[0])) {
            return FileOperations.listFiles(this.metricsDir);
        }
        return null;
    }

    private long checkMetricsDir() throws IOException {
        long checkSum = 0L;
        List<PathCached> files = this.getMetricsDirFileList();
        if (files != null) {
            checkSum = this.calculateFilesCheckum(files);
        }
        return checkSum;
    }

    private long calculateFilesCheckum(List<PathCached> files) throws IOException {
        long fileCheckSum = 0L;
        for (PathCached file : files) {
            Matcher mat;
            if (!file.isRegularFile() || !(mat = this.filePattern.matcher(file.getFileName().toString())).find()) continue;
            fileCheckSum ^= file.lastModified() ^ file.size() ^ (long)file.getFileName().toString().hashCode();
        }
        return fileCheckSum;
    }

    private void readSourceConnectors() throws IOException, NotConfiguredException {
        this.settings.cleanSourceConnector();
        List<PathCached> files = this.getMetricsDirFileList();
        if (files != null) {
            for (PathCached file : files) {
                String connectorName = this.getConnectorName(file);
                if (connectorName == null) continue;
                this.readSourceConnector(file, connectorName);
            }
        }
    }

    private void readSourceConnector(PathCached file, String connectorName) throws IOException, NotConfiguredException {
        SourceConnectorReader connector = new SourceConnectorReader(this.settings.getFSILogger(), connectorName, file, this.settings.getWebInfPath(), this.settings.getWorkDirectory(), this.settings.getUserAuthenticationInterface());
        if (connector.isEnabled()) {
            this.settings.addSourceConnector(connectorName, connector);
        }
    }

    private String getConnectorName(PathCached file) throws IOException {
        Matcher mat;
        if (file.isRegularFile() && (mat = this.filePattern.matcher(file.getFileName())).find()) {
            return mat.group(1);
        }
        return null;
    }
}

