/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.search.AsyncDatabaseJob;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class InsertMetadataJob
extends AsyncDatabaseJob {
    private final String assetURLPath;
    private final Map<String, String> metadata;
    private static final String stripFSIExtraTagXSLT = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output omit-xml-declaration=\"yes\"/><xsl:template match=\"/\"><xsl:copy><xsl:value-of select=\".\"/></xsl:copy></xsl:template></xsl:stylesheet>";

    public InsertMetadataJob(String assetURLPath, Map<String, String> metadata, boolean explicitLog) {
        super(explicitLog);
        this.assetURLPath = assetURLPath;
        this.metadata = new HashMap<String, String>(metadata);
        this.applyMetaDataFilters();
    }

    public String getAssetURLPath() {
        return this.assetURLPath;
    }

    public Map<String, String> getMetaData() {
        return this.metadata;
    }

    private void applyMetaDataFilters() {
        for (Map.Entry<String, String> dataset : this.metadata.entrySet()) {
            if (!dataset.getKey().equals("iptc.FSI Extra")) continue;
            try {
                Document fsiExtraDoc = XMLOperations.getXMLContent(null, dataset.getValue().getBytes(FileOperations.charsetUTF8), this.assetURLPath);
                String textTagContent = XMLOperations.performXSLTransformation(null, fsiExtraDoc, stripFSIExtraTagXSLT);
                String unEscapedHTML = Escaper.unescapeFromXML(textTagContent);
                String noHTMLString = unEscapedHTML.replaceAll("\\<.*?\\>", " ");
                dataset.setValue(noHTMLString);
            }
            catch (Exception exception) {}
        }
    }
}

