/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrException;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class SDBChecker
extends Thread {
    private static final int CHECK_INTERVAL = 10000;
    private static final int REVERSE_CHECK_CHUNK_SIZE = 5000;
    private final SolrUpdater sdb;
    private final SearchDatabaseSolr solr;
    private final SourceManagerSettings settings;
    private final ScannerDaemon scannerDaemon;
    private volatile boolean keepRunning = true;
    private final Path checkFile;
    private int newOnLastRun = 0;
    private int staleOnLastRun = 0;
    private final Set<String> assetsToForceUpdate = new HashSet<String>();
    private StatusValue status = StatusValue.idle;
    private boolean hasSDBConnection = false;

    public SDBChecker(SourceManagerSettings settings, ScannerDaemon scannerDaemon) {
        this.solr = settings.getSearchDatabaseSolr();
        this.sdb = settings.getSolrUpdater();
        this.scannerDaemon = scannerDaemon;
        this.settings = settings;
        this.checkFile = settings.getStorageLocation().resolve(".sdbcheck");
        this.setName("Search Database Rebuilder");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (this.keepRunning) {
                SDBChecker.sleep(10000L);
                if (!this.hasSDBConnection) {
                    this.hasSDBConnection = this.testSDBConnection();
                }
                if (this.hasSDBConnection && Files.exists(this.checkFile, new LinkOption[0])) {
                    this.settings.getFSILogger().log(3244, new Object[0]);
                    this.status = StatusValue.checking;
                    try {
                        if (Files.size(this.checkFile) > 0L) {
                            try {
                                ArrayList<String> checkFileContent = FileOperations.getTextFileContentAsArrayList(this.checkFile, FileOperations.charsetUTF8);
                                for (String string : checkFileContent) {
                                    if (string.isEmpty()) continue;
                                    this.assetsToForceUpdate.add(string);
                                }
                            }
                            catch (IOException e) {
                                this.settings.getFSILogger().logException(e, 3246, e.getLocalizedMessage());
                            }
                        }
                        Files.deleteIfExists(this.checkFile);
                        this.sdb.resetLoggingStatus();
                        this.newOnLastRun = 0;
                        for (String assetURLPath : this.assetsToForceUpdate) {
                            SourceConnectorReader sourceConnectorReader = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                            this.handleFile(sourceConnectorReader, assetURLPath, true);
                        }
                        Map<String, SourceConnectorReader> connectors = this.settings.getEnabledConnectors();
                        for (Map.Entry entry : connectors.entrySet()) {
                            if (!this.keepRunning) break;
                            this.recurse((SourceConnectorReader)entry.getValue(), ((SourceConnectorReader)entry.getValue()).getInboxDirectory());
                        }
                        this.reverseCheck();
                    }
                    catch (NotConfiguredException connectors) {
                    }
                    catch (SolrException e) {
                        this.settings.getFSILogger().logException(e, 3237, e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        this.settings.getFSILogger().logException(e, 3237, e.getLocalizedMessage());
                        this.hasSDBConnection = false;
                    }
                    this.settings.getFSILogger().log(3245, this.newOnLastRun, this.staleOnLastRun);
                    this.status = StatusValue.idle;
                    continue;
                }
                if (this.hasSDBConnection || !this.solr.isInitiated()) continue;
                this.settings.getFSILogger().log(3269, new Object[0]);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.status = StatusValue.halted;
    }

    private boolean testSDBConnection() {
        boolean result = false;
        SolrResponse solrResponse = this.solr.getCoreStatusJSON();
        if (solrResponse.statusCode == 200) {
            try {
                JSONObject coreJSON;
                JSONObject solrResponseJSON = new JSONObject(new String(solrResponse.responseBytes, solrResponse.encoding));
                JSONObject responseStatus = solrResponseJSON.getJSONObject("status");
                if (responseStatus != null && (coreJSON = responseStatus.getJSONObject(this.solr.getSolrCore())) != null) {
                    return true;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return false;
    }

    private void reverseCheck() throws IOException, NotConfiguredException {
        boolean hasMore = true;
        int offset = 0;
        HashSet<String> assetsToDelete = new HashSet<String>();
        while (hasMore && this.keepRunning) {
            Set<String> assetList = this.solr.getCoreAssetList(offset, 5000);
            if (assetList.size() == 0) {
                hasMore = false;
            } else {
                for (String assetURLPath : assetList) {
                    if (this.scannerDaemon.assetExists(assetURLPath)) continue;
                    assetsToDelete.add(assetURLPath);
                }
            }
            offset += 5000;
        }
        this.staleOnLastRun = assetsToDelete.size();
        if (assetsToDelete.size() > 0) {
            this.sdb.deleteAssetsAsync(assetsToDelete);
        }
    }

    private void recurse(SourceConnectorReader connector, PathCached path) throws IOException, NotConfiguredException {
        List<PathCached> children;
        if (this.keepRunning && path != null && (children = FileOperations.listAllFiles(path.getPath())) != null) {
            for (PathCached child : children) {
                if (!this.keepRunning) break;
                String assetURLPath = FileOperations.convertBackslash(connector.getPrefix() + child.getAbsoluteName().substring(connector.getInboxDirectory().getAbsolutePath().toString().length()));
                try {
                    this.handleFile(connector, assetURLPath, false);
                }
                catch (SolrException e) {
                    this.settings.getFSILogger().logException(e, 3243, assetURLPath, e.getLocalizedMessage());
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    this.settings.getFSILogger().logException(e, 3243, assetURLPath, e.getLocalizedMessage());
                }
                if (!child.isDirectory()) continue;
                this.recurse(connector, child);
            }
        }
    }

    private void handleFile(SourceConnectorReader connector, String assetURLPath, boolean force) throws NotConfiguredException, SolrException, IOException {
        if (force || !this.sdb.entryExists(assetURLPath)) {
            this.scannerDaemon.getMetaDataAndUpdateSearchDatabase(assetURLPath, false);
            ++this.newOnLastRun;
        }
    }

    public void halt() {
        this.keepRunning = false;
        this.interrupt();
    }

    public StatusValue getStatus() {
        return this.status;
    }

    public boolean isCheckScheduled() {
        return Files.exists(this.checkFile, new LinkOption[0]);
    }

    public void scheduleCheck() {
        if (!this.isCheckScheduled()) {
            try {
                Files.createFile(this.checkFile, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum StatusValue {
        idle,
        checking,
        halted;

    }
}

