/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search;

import com.neptunelabs.fsiframework.helpers.DateParser;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SearchToken {
    private final String solrizedToken;

    public SearchToken(String tokenstr) {
        if (tokenstr.contains(":<") || tokenstr.contains(":>")) {
            if (tokenstr.indexOf(":") > 0) {
                int colonPos = tokenstr.indexOf(58);
                String field = tokenstr.substring(0, colonPos);
                String value = field.equals("file.lastmodified") ? this.convertToSolrRange(this.convertDateSearchPhrase(tokenstr.substring(colonPos + 1).trim())) : this.convertToSolrRange(tokenstr.substring(colonPos + 1));
                this.solrizedToken = field + ":" + value;
            } else {
                this.solrizedToken = tokenstr;
            }
        } else {
            this.solrizedToken = tokenstr;
        }
    }

    public String getTokenForSolr() {
        return this.solrizedToken;
    }

    private String convertToSolrRange(String tokenValue) {
        if (tokenValue != null) {
            boolean inclusive;
            String searchValue;
            if (tokenValue.startsWith("<=") || tokenValue.startsWith(">=")) {
                searchValue = tokenValue.substring(2);
                inclusive = true;
            } else {
                searchValue = tokenValue.substring(1);
                inclusive = false;
            }
            try {
                int tokenValueInt = Integer.parseInt(searchValue);
                searchValue = String.valueOf(tokenValueInt);
            }
            catch (NumberFormatException e) {
                try {
                    long byteValueLong = FormatBytes.parseBytesString(searchValue);
                    searchValue = String.valueOf(byteValueLong);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (tokenValue.startsWith("<")) {
                return inclusive ? "[* TO " + searchValue + "]" : "{* TO " + searchValue + "}";
            }
            return inclusive ? "[" + searchValue + " TO *]" : "{" + searchValue + " TO *}";
        }
        return null;
    }

    private String convertDateSearchPhrase(String searchphrase) {
        String result = null;
        String prefix = "";
        String dateString = searchphrase;
        if (searchphrase.startsWith("<")) {
            prefix = "<";
            dateString = searchphrase.substring(1);
        } else if (searchphrase.startsWith(">")) {
            prefix = ">";
            dateString = searchphrase.substring(1);
        }
        try {
            long unixtime;
            if (dateString.startsWith("\"")) {
                dateString = dateString.substring(1, dateString.length() - 1);
            }
            if ((unixtime = DateParser.parseDateString(dateString)) > 0L) {
                SimpleDateFormat iso8601Formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                result = prefix + iso8601Formatter.format(new Date(unixtime));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }
}

